

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningBackups.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningBackups"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningBackups]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningBackups]
GO

delete from GXDBVersions where name = 'RunningBackups' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningBackups', '1.62.14.34', 'RunningBackups', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
  --- JMBKP_SINGLE_INSTENCE_SILO 0x100000000LL
CREATE VIEW dbo.RunningBackups
AS
	SELECT
		jobID = JMJobInfo.jobId,
		opType = CASE WHEN subOpType > 0 THEN subOpType ELSE opType END,
		userId,
		JMJobInfo.commCellId,
		APP_Application.clientId,
		APP_Application.appTypeId,
		APP_Application.instance,
		APP_Application.backupSet,
		JMBkpJobInfo.applicationId,
		bkpLevel,
		secondaryBkpLevel,
		jobIdActedOn,
		fromTime,
		toTime,
		state,
		displayState,
		clientPriority,
		opPriority,
		appPriority,
		combPriority,
		currentPhase,
		jobStartTime,
		attemptStartTime,
		elapsedTime = CASE WHEN attemptStartTime > 0 THEN DATEDIFF(second, '01/01/1970', GETUTCDATE()) - attemptStartTime + elapsedTime ELSE elapsedTime END,
		jobElapsedTime = CASE WHEN attemptStartTime > 0 THEN DATEDIFF(second, '01/01/1970', GETUTCDATE()) - attemptStartTime + jobElapsedTime ELSE jobElapsedTime END,
		startAttempts,
		runAttempts,
		initFrom,
		pendingCause,
		errorType,
		guiAlertColorLevel + (CASE
								WHEN (DATEDIFF(second, '01/01/1970', GETUTCDATE()) - jobStartTime) > 3600 AND
APPAppIdClient.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) = 0 AND
								foreCast.attributeValueInt IS NOT NULL AND foreCast.attributeValueInt > 0 AND ((forecast.attributeValueInt + (forecast.attributeValueInt * 0.05)) < (DATEDIFF(second, '01/01/1970', GETUTCDATE()) - jobStartTime)) THEN 100000
									ELSE 0 END ) as guiAlertColorLevel,
		numStreams,
		numStreamsAllocated,
		JMBkpJobInfo.maxRestarts,
		JMBkpJobInfo.restartInterval,
		currentPolicy,
		filesToXfer,
		filesXfered,
		uncompBytes,
		compBytes,
		unCompBytesToXfer,
		CASE WHEN state = 1 THEN JMJobInfo.preemptable
		WHEN state = 2 OR state = 3 OR state = 15 OR state = 16 THEN 1
		ELSE 0
		END AS isPreemptable,
		percentcomplete,
		JMBkpJobInfo.bkpOptions,
		CASE WHEN (exCurrentContext.attributeValueInt & 0x200 = 0x200) THEN (bkpattributes | 0x100000)
		ELSE bkpattributes
		END AS bkpattributes,
		scanType,
		scanFileFailures,
		scanFolderFailures,
		backupFileFailures,
		backupFolderFailures,
		oraSubLevel,
		lastUpdateFromClient,
		lastStateChangeTime,
		noOfGUIMonitors,
		isScheduledAlert,
		jobBasedAlertId,
		totalMediaUsageTime,
		currentThroughput,
		averageThroughput,
		filesIndexed,
		filesFailedToIndex,
		filesSkippedForIndex,
		contentIndexDBSize,
		timeToComplete,
		backupTaskId,
		cloudId,
		retentionFlags = (SELECT ISNULL(MAX(retentionFlags),0) from JMJobCopyInfo WITH (READUNCOMMITTED) where JMJobCopyInfo.jobId = JMJobInfo.jobId),
		snapJobID = CASE
			WHEN JMJobInfo.opType <> 60 THEN 0
			--ELSE ISNULL((SELECT processedJobId from JMJobWF WITH (READUNCOMMITTED) where JMJobWF.childJobId = JMJobInfo.jobId AND JMJobWF.commcellId = JMJobInfo.commCellId),0)
			ELSE ISNULL(jwf.processedJobId, 0)
			END,
		snapWFJobID = CASE
			WHEN JMJobInfo.opType <> 60 THEN 0
			--ELSE ISNULL((SELECT jobId from JMJobWF WITH (READUNCOMMITTED) where JMJobWF.childJobId = JMJobInfo.jobId AND JMJobWF.commcellId = JMJobInfo.commCellId), 0)
			ELSE ISNULL(jwf.jobId, 0)
			END,
		currentContext,
		nwTransBytes,
		totSkippedObjects,
		bkpAttributesEx,
		jobReferenceTime,
		sidbStoreId = ISNULL(MISC.intData, 0),
		--sidbStoreId = (ISNULL((SELECT intData FROM JMMisc MISC WITH (READUNCOMMITTED) WHERE MISC.jobId = JMJobInfo.jobId AND MISC.commcellId = JMJobInfo.commcellId AND MISC.itemType = 25), 0)),
		taskId = (ISNULL(T.taskId, 0)),
		targetClientId,
		totReadBytes,
totReadTime = CASE WHEN JMBkpJobInfo.bkpattributesEx & 0x40000000 <> 0 THEN (SELECT SUM(totReadTime) FROM JMBkpJobInfo WHERE jobId IN (SELECT childJobId FROM JMJobDataLink WHERE parentJobId = JMJobInfo.jobId)) ELSE totReadTime END,
		totPhysicalWriteBytes,
totPhysicalWriteTime = CASE WHEN JMBkpJobInfo.bkpattributesEx & 0x40000000 <> 0 THEN (SELECT SUM(totPhysicalWriteTime) FROM JMBkpJobInfo WHERE jobId IN (SELECT childJobId FROM JMJobDataLink WHERE parentJobId = JMJobInfo.jobId)) ELSE totPhysicalWriteTime END,
totNwTransTime = CASE WHEN JMBkpJobInfo.bkpattributesEx & 0x40000000 <> 0 THEN (SELECT SUM(totNwTransTime) FROM JMBkpJobInfo WHERE jobId IN (SELECT childJobId FROM JMJobDataLink WHERE parentJobId = JMJobInfo.jobId)) ELSE totNwTransTime END,
		totSidbLookups,
totSidbLookupTime = CASE WHEN JMBkpJobInfo.bkpattributesEx & 0x40000000 <> 0 THEN (SELECT SUM(totSidbLookupTime) FROM JMBkpJobInfo WHERE jobId IN (SELECT childJobId FROM JMJobDataLink WHERE parentJobId = JMJobInfo.jobId)) ELSE totSidbLookupTime END,
		readCurrentThroughput,
		readAverageThroughput,
		writeCurrentThroughput,
		writeAverageThroughput,
		networkCurrentThroughput,
		networkAverageThroughput,
		sidbCurrentLookups,
		sidbAverageLookups,
		parentJobId = CASE
WHEN JMBkpJobInfo.bkpattributesEx & 0x4000000 <> 0
THEN ISNULL((SELECT parentJobId FROM JMJobDataLink (READUNCOMMITTED) WHERE JMJobDataLink.childJobId = JMJobInfo.jobId AND JMJobDataLink.commCellId = JMJobInfo.commcellId AND JMJobDataLink.linkType = 7), 0)
			ELSE 0
			END,
		subTaskName = (ISNULL(ST.subTaskName, '')),
		taskName = (ISNULL(T.taskName, '')),
		sidbStoreName = ISNULL(MISC.data, ''),
		--sidbStoreName = ((ISNULL((SELECT data FROM JMMisc MISC WITH (READUNCOMMITTED) WHERE MISC.jobId = JMJobInfo.jobId AND MISC.commcellId = JMJobInfo.commcellId AND MISC.itemType = 25), ''))),
		currentPolicyName = CASE
			WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WITH (READUNCOMMITTED) WHERE id = currentPolicy),'Unavailable')
			WHEN currentPolicy = 0 THEN ''
			ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = currentPolicy),'Unavailable')
			END,
		ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = userId),'') AS [UserName],	-- no perf gain to table join
		alertName,
		clientName = (CASE
						WHEN JMBkpJobInfo.bkpattributes & 0x100000000 = 0x100000000 THEN AppTargetClient.name
						WHEN JMBkpJobInfo.bkpattributesEx & 0x200 = 0x200 AND JMBkpJobInfo.targetClientId > 0 THEN AppTargetClient.name
						ELSE APPAppIdClient.name END),
		appTypeName = AppIdaType.name,
		instanceName = AppInsName.name,
		backupSetName = AppBkpSetName.name,
		APP_Application.subclientName,
		libraryList,
		driveList,
		failureReason,
		--drMsg.localisedMessage DelayReason,
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache WITH (READUNCOMMITTED) where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = failureReason) AS DelayReason,
		--dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		scanTypeChangeReason AS [ScanTypeChangeReasonId],
		--stcMsg.localisedMessage scanTypeChangeReason,
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache WITH (READUNCOMMITTED) where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = scanTypeChangeReason) AS scanTypeChangeReason,
		--dbo.JMGetLocalizedMessageFunc(0,scanTypeChangeReason) AS [ScanTypeChangeReason],
		currentPhaseName,
		mediaAgentName,
		ISNULL(shortMediaAgent,'') AS shortMediaAgent,
		activeFile,
		--ISNULL(cloudCP.stringVal, '')
		cloudName = CASE
			WHEN cloudId = 0 THEN ''
			ELSE ISNULL((SELECT stringVal from app_componentProp WITH (READUNCOMMITTED) where id = cloudId and componentId=2 AND propertyTypeId=1 AND modified=0),'')
			END,
		foreignToken,
		dbo.JMGetKBArticlesForFailures(failureReason, 0) AS [failureKBArticle],
		jobDescription,
		xmlJobInfo,
		encrypted = (
					CASE
						WHEN JOBAF.encKeyType IS NULL THEN 'Unavailable'
						WHEN JOBAF.encKeyType > 0 THEN 'Yes'
						ELSE 'No'
					END
					),
		clientDisplayName = (CASE
						WHEN JMBkpJobInfo.bkpattributes & 0x100000000 = 0x100000000 THEN AppTargetClient.displayName
						WHEN JMBkpJobInfo.bkpattributesEx & 0x200 = 0x200 AND JMBkpJobInfo.targetClientId > 0 THEN AppTargetClient.displayName
						ELSE APPAppIdClient.displayName END),
		phasePercentagesList = SUBSTRING(dyProgress.attributeValue, 1, dyProgress.attributeValueInt),
		phaseTimingsList = SUBSTRING(dyProgress.attributeValue, dyProgress.attributeValueInt + 2, 10000),
		selectiveVMClient.displayName as 'selectiveVMClientDisplayName',
		currentPhaseType = phaseType
	FROM JMJobInfo WITH (READUNCOMMITTED)
		INNER JOIN JMBkpJobInfo WITH (READUNCOMMITTED) ON
			JMBkpJobInfo.jobId = JMJobInfo.jobId
		INNER JOIN APP_Application WITH (READUNCOMMITTED) ON
			JMBkpJobInfo.applicationId = APP_Application.id
		LEFT OUTER JOIN	(
					SELECT AF.jobId, AF.commCellId, encKeyType = MAX(AFC.encKeyType)
					FROM JMBkpJobInfo JM
					INNER JOIN archFile AF ON JM.jobId = AF.jobId AND JM.commCellId = AF.commCellId
					INNER JOIN archFileCopy AFC ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
					WHERE AF.isValid = 1
					GROUP BY AF.jobId, AF.commCellId
					)JOBAF ON JMBkpJobInfo.jobId = JOBAF.jobId AND JMBkpJobInfo.commCellId = JOBAF.commCellId
		LEFT OUTER JOIN TM_SubTask ST WITH (READUNCOMMITTED) ON
			JMBkpJobInfo.backupTaskId = ST.subTaskId
		LEFT OUTER JOIN TM_Task T WITH (READUNCOMMITTED) ON
			ST.taskId = T.taskId
		-- Perf: moving subqueries to table joins
		LEFT OUTER JOIN JMJobWF jwf WITH (READUNCOMMITTED) ON
			jwf.childJobId = JMJobInfo.jobId
			AND jwf.commcellId = JMJobInfo.commCellId
		LEFT OUTER JOIN JMMisc MISC WITH (READUNCOMMITTED) ON
			MISC.jobId = JMJobInfo.jobId
			AND MISC.itemType = 25
			AND MISC.commcellId = JMJobInfo.commcellId
		LEFT OUTER JOIN GXGlobalParam GP WITH (READUNCOMMITTED) ON
			GP.name = 'JMShowPseudoVMJobs'
			AND GP.modified = 0
		LEFT OUTER JOIN GXGlobalParam GP2 WITH (READUNCOMMITTED) ON
			GP2.name = 'JMShowInactiveJobs'
			AND GP2.modified = 0
		LEFT JOIN APP_iDAType AppIdaType WITH (READUNCOMMITTED) ON
			AppIdaType.type = APP_Application.appTypeId
		LEFT JOIN APP_InstanceName AppInsName WITH (READUNCOMMITTED) ON
			AppInsName.id = APP_Application.instance
		LEFT JOIN APP_BackupSetName AppBkpSetName WITH (READUNCOMMITTED) ON
			AppBkpSetName.id = APP_Application.backupSet
		LEFT JOIN APP_Client AppTargetClient WITH (READUNCOMMITTED) ON
			AppTargetClient.id = JMBkpJobInfo.targetClientId
		LEFT JOIN APP_Client APPAppIdClient WITH (READUNCOMMITTED) ON
			APPAppIdClient.id = APP_Application.clientId
		LEFT OUTER JOIN JMJobOptions forecast WITH (READUNCOMMITTED) ON
forecast.attributeId = 76 AND forecast.jobId = JMJobInfo.jobId AND forecast.commCellId = JMJobInfo.commCellId
		LEFT OUTER JOIN JMJobOptions dyProgress (READUNCOMMITTED) on
dyProgress.jobId = JMJobInfo.jobId AND dyProgress.commCellId = JMJobInfo.commCellId AND dyProgress.attributeId = 94
        LEFT OUTER JOIN JMJobOptions exCurrentContext WITH (READUNCOMMITTED) ON
			exCurrentContext.attributeId = 57 AND exCurrentContext.jobId = JMJobInfo.jobId AND exCurrentContext.commCellId = JMJobInfo.commCellId
		LEFT OUTER JOIN JMMisc selectiveVMClientMisc WITH (READUNCOMMITTED) ON
selectiveVMClientMisc.jobId = JMJobInfo.jobId AND selectiveVMClientMisc.commcellId = JMJobInfo.commCellId AND selectiveVMClientMisc.itemType = 81 --JM_SELECTIVE_VM_CLIENT_ID
		LEFT OUTER JOIN APP_Client selectiveVMClient WITH(READUNCOMMITTED) ON
			selectiveVMClient.id = selectiveVMClientMisc.intData
		LEFT OUTER JOIN JMOpTable OP WITH(READUNCOMMITTED) ON
			OP.operation = opType AND OP.appTypeType = APP_Application.appTypeId
		LEFT OUTER JOIN JMPhase PH WITH(READUNCOMMITTED) ON
			PH.opTableId = OP.ID AND PH.phase = currentPhase
/* min perf gain
		LEFT OUTER JOIN JMFailureReasonLocaleMsgCache drMsg WITH (READUNCOMMITTED) ON
			drMsg.reasonCode = failureReason
			AND drMsg.jobID = JMJobInfo.jobID
			AND drMsg.commCellId = JMJobInfo.commCellId
		LEFT OUTER JOIN JMFailureReasonLocaleMsgCache stcMsg WITH (READUNCOMMITTED) ON
			stcMsg.reasonCode = scanTypeChangeReason
			AND stcMsg.jobID = JMJobInfo.jobID
			AND stcMsg.commCellId = JMJobInfo.commCellId
		LEFT OUTER JOIN app_componentProp cloudCP WITH (READUNCOMMITTED) ON
			cloudId <> 0
			AND cloudCP.id = cloudId
			and cloudCP.componentId=2
			AND cloudCP.propertyTypeId=1
			AND cloudCP.modified=0
*/
	WHERE (GP.value = 1 OR JMBkpJobInfo.bkpAttributesEx & 0x4000000 = 0) -- Hide pseudo VM jobs by default -- JMBKP_EX_PSEUDO_CHILD_JOB
		  AND (GP2.value = 1 OR JMJobInfo.state <> 20) -- Hide INACTIVE jobs by default
		  AND JMJobInfo.opType <> 116 --Hide Cloud laptop jobs from UI (GUI and Web)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningBackups]'
END
GO

