

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/PseudoClientsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: PseudoClientsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PseudoClientsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[PseudoClientsView]
GO

delete from GXDBVersions where name = 'PseudoClientsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'PseudoClientsView', '1.1.2.1', 'PseudoClientsView', '')
GO
CREATE VIEW dbo.PseudoClientsView
AS
	SELECT
		c.id clientId
	FROM APP_Client c WITH(READUNCOMMITTED)
		LEFT OUTER JOIN (		-- Other Pseudo Client types
			SELECT	-- DISCOVERED CLIENTS
				acp.componentNameId clientId
			FROM APP_ClientProp acp WITH(READUNCOMMITTED)
			WHERE
				(
					acp.attrName = 'Virtual Server Discovered Clients'
					OR acp.attrName = 'Mini SRM Agent'
				)
				AND acp.attrVal = '1'
			UNION
			SELECT	-- VS PSEUDO CLIENTS
				Ida.clientId
			FROM
				APP_IdaProp IdaProp WITH(READUNCOMMITTED)
				INNER JOIN APP_IDAName Ida WITH(READUNCOMMITTED) ON
					IdaProp.componentNameId = Ida.id
					AND IdaProp.attrName = 'Pseudo Apptype'
					AND IdaProp.attrVal = '1'
			UNION
			SELECT	-- OPENVMS CLIENTS	N_CV_OS_ID_OPENVMS = 38
				c.id clientId
			FROM
				APP_Client c WITH(READUNCOMMITTED)
			WHERE
				c.simOperatingSystemId = 38
			UNION
			SELECT	--EDC CLIENTS
				cga.clientId
			FROM
				APP_ClientGroup cg WITH(READUNCOMMITTED)
				INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
					cg.id = cga.clientGroupId
			WHERE
				(
					(cg.flag & 0x100 = 0x100)
					OR (cg.flag & 0x200 = 0x200)
				)
		) pcl ON
			pcl.clientId = c.id
	WHERE
		-- PROCCED ONLY IF NO PACKAGES EXIST, ELSE ITS NOT A PSEUDO CLIENT
		NOT EXISTS (SELECT ip.clientId FROM simInstalledPackages ip WITH(READUNCOMMITTED) WHERE ip.clientId = c.id)
		AND (	-- additional criteria for pseudo client
			CASE
				WHEN pcl.clientId IS NOT NULL THEN 1
				WHEN (c.status & 0x0040) > 0 THEN 1
				WHEN (c.status & 0x0080) > 0 THEN 1
				WHEN (c.status & 0x0200) > 0 THEN 1
				WHEN (c.status & 0x200000) > 0 THEN 1
				WHEN (c.status & 0x400000) > 0 THEN 1
				WHEN (c.status & 0x4000000) > 0 THEN 1
				WHEN (c.status & 0x2000000) > 0 THEN 1
				WHEN (c.status & 0x20000000) > 0 THEN 1
				WHEN (c.specialClientFlags & 0x02) <> 0 THEN
					CASE
						WHEN (
								EXISTS(SELECT a.clientId FROM APP_Application a WITH(READUNCOMMITTED) WHERE a.clientId = c.id)
								OR EXISTS(SELECT * FROM LicUsage lu WITH(READUNCOMMITTED) WHERE lu.CId = c.id)
							)
							THEN 0
						ELSE 1
					END
				ELSE 0
			END
		) = 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [PseudoClientsView]'
END
GO

