SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO

BEGIN
	DECLARE @ViewNameCursorFlag 	INTEGER
	SET 		@ViewNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@ViewName		NVARCHAR(256)

	DECLARE	ViewNameListCursor CURSOR STATIC FOR
	SELECT DISTINCT name
	FROM sysobjects 
	WHERE	xtype = 'V'
		AND OBJECTPROPERTY(id, N'IsView') = 1
		AND name NOT LIKE '%_CUSTOMOBJ'
		AND name != 'sysextendedarticlesview'
					
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@ViewNameCursorFlag = 1
	OPEN	ViewNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM ViewNameListCursor
	INTO @ViewName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all views
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		
		IF EXISTS (select * from sysobjects where name = @ViewName and OBJECTPROPERTY(id, N'IsView') = 1) 
		BEGIN
			print '>>> Drop View: ' + @ViewName + ' <<<'
			EXEC ('DROP VIEW "' + @ViewName + '"')
		END
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
					
		IF EXISTS (select * from GXDBVersions where aliasname = @ViewName AND type = 4)
			DELETE FROM GXDBVersions WHERE aliasname = @ViewName AND type = 4
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM ViewNameListCursor
		INTO @ViewName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @ViewNameCursorFlag = 1
	BEGIN
			CLOSE				ViewNameListCursor
			DEALLOCATE	ViewNameListCursor
	END
END	

RETURN
GO

