

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DiskBackupView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DiskBackupView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DiskBackupView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DiskBackupView]
GO

delete from GXDBVersions where name = 'DiskBackupView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DiskBackupView', '1.1', 'DiskBackupView', '')
GO
CREATE VIEW dbo.DiskBackupView
AS
SELECT	B.jobId AS JobID,
		A5.name AS Client,
		A4.name As Agent,
		dbo.FixInstanceName(A3.name, A1.appTypeId ) AS Instance,
		A2.name AS Backupset,
		A1.subclientName AS Subclient,
		X.policyName AS StoragePolicy,
		dbo.GetJobStatusName(B.status) AS JobStatus,
		dbo.GetJobBackupTypeDisplay(B.bkpLevel) AS BackupType,
		dbo.UTCToCellLocalTime(dbo.GetDateTime(B.servStartDate), 2) AS JobStartTime,
		dbo.UTCToCellLocalTime(dbo.GetDateTime(B.servEndDate), 2) AS JobEndTime,
		B.totalUncompBytes AS ApplicationSize
FROM	JMBkpStats B
		INNER JOIN APP_Application A1 ON A1.id = B.appId
		INNER JOIN APP_BackupSetName A2 ON A2.id = A1.backupSet
		INNER JOIN APP_InstanceName A3 ON A3.id = A1.instance
		INNER JOIN APP_iDAType A4 ON A4.type = A1.appTypeId
		INNER JOIN APP_Client A5 ON A5.id = B.appId
		INNER JOIN
		(SELECT	DISTINCT R.jobId, R.commCellId, AG.id AS policyId, AG.name AS policyName
		FROM	JMJobResourceHistory R
				INNER JOIN MMMedia M ON M.MediaId = R.MediaId
				INNER JOIN archGroup AG ON AG.defaultCopy = R.copyId
		WHERE	M.MediaTypeId = 10001 AND R.commCellId = 2) X
			ON X.jobId = B.jobId AND X.commCellId = B.commCellId
		INNER JOIN
		(SELECT	jobId, commCellId, archGrpId
		FROM	JMJobDataStats
		WHERE	(disabled & 256) = 0 AND commCellId = 2
		GROUP BY jobId, commCellId, archGrpId
		HAVING COUNT(DISTINCT archGrpCopyId) = 1) Y
			ON Y.jobId = X.jobId AND Y.commCellId = X.commCellId AND Y.archGrpId = X.policyId
WHERE	B.status IN (1, 3, 14) AND B.opType IN (4, 14, 76)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DiskBackupView]'
END
GO

