

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DDBView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DDBView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DDBView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DDBView]
GO

delete from GXDBVersions where name = 'DDBView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DDBView', '1.3.76.2', 'DDBView', '')
GO
CREATE VIEW DDBView
-- WITH ENCRYPTION
AS
select idxPath.MAName, idxPath.Volume,
		MIN(idxPath.TotalCapacityMB) as TotalCapacityMB,
		MIN(idxPath.FreeDiskSpaceMB) as FreeDiskSpaceMB,
		SUM(idxPath.DiskUsageMB) as TotalSpaceUsedMB,
		SUM(idxPath.NumActiveDDB) as totalActiveDedupPartitions,
		SUM(idxPath.NumSealedDDB) as totalSealedDedupPartitions
from ( select distinct IdxS.ClientId,
				(select name from APP_Client with (nolock) where id = idxAP.ClientId) as MAName,idxAP.IdxAccessPathId,
				 case when idxC.DiskUsageMB = -1 then 0 else idxC.DiskUsageMB end as DiskUsageMB,
				 case when idxC.FreeDiskSpaceMB = -1 then 0 else idxC.FreeDiskSpaceMB end  as FreeDiskSpaceMB,
				 case when idxC.totalCapacityMB = -1 then 0 else idxC.totalCapacityMB  end as totalCapacityMB,
				  isnull((select numActiveDDB from
									(select COUNT (SubStoreId) as numActiveDDB, IdxAccessPathId
										  from IdxSIDBSubStore with (nolock)
										  where SealedTime = 0 and IdxAccessPathId > 0
										  group by IdxAccessPathId) as activeDDB
							  where activeDDB.IdxAccessPathId = idxAP.IdxAccessPathId), 0) as NumActiveDDB,
				  isnull((select numSealedDDB from
									(select COUNT (SubStoreId) as numSealedDDB, IdxAccessPathId
										  from IdxSIDBSubStore with (nolock)
										  where SealedTime > 0 and IdxAccessPathId > 0
										  group by IdxAccessPathId) as sealedDDB
                  where sealedDDB.IdxAccessPathId = idxAP.IdxAccessPathId), 0) as NumSealedDDB,
				case when SUBSTRING(idxAP.Path, 1, 1) = '/' then SUBSTRING(idxAP.Path, 1, CHARINDEX('/', idxAP.Path, 2))
					 when SUBSTRING(idxAP.Path, 2, 2) = ':\' then SUBSTRING(idxAP.Path, 1, 3)
					 else idxAP.Path end as Volume
		from IdxAccessPath idxAP with (nolock), IdxSIDBSubStore idxS with (nolock), archCopySIDBStore agcStore with (nolock), IdxCache idxC with (nolock), archGroupCopy agc with (nolock)
		where idxAP.IdxAccessPathId > 0
		and idxAP.IdxAccessPathId = idxS.IdxAccessPathId
		and idxS.SIDBStoreId = agcStore.SIDBStoreId
		and idxS.IdxCacheId = idxC.IdxCacheId
		and agcStore.CopyId = agc.id
		and agc.dedupeFlags & 134217728 = 0
	) as idxPath
group by idxPath.MAName, idxPath.Volume
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DDBView]'
END
GO

