

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellVMBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellVMBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellVMBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellVMBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellVMBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellVMBackupInfo', '1.1.2.1', 'CommCellVMBackupInfo', '')
GO
CREATE VIEW CommCellVMBackupInfo
AS
select C.displayName as vmname,
	   pvt.VMclientId as vmclientid,
	   vc.name as virtualizationclient,
	   vc.id as virtualizationclientid,
	   pvt.jobid,
	   vmGUID,
	   case when vmStatus =0 then 'Success'
		    when vmStatus =1 then 'Failed'
			when vmStatus =3 then 'PartialSuccess'
			when vmStatus =2 then 'In Progress'
			when vmstatus = 4 then 'Waiting'
			when vmstatus = 5 then 'Kill Pending'
			when vmstatus = 6 then 'Killed'
			when vmstatus = 7 then 'Pending'
			when vmstatus =8 then  'Suspended'
	   end as vmstatus,
	   vmHost as vmhost,
	   vmAgent as proxy,
	   vmBackupStartTime as startdateunixsec,
	   vmbackupendtime as enddateunixsec,
	   dbo.getdatetime(vmbackupstarttime) as startdate,
	   dbo.getdatetime(vmbackupendtime) as enddate,
	   vmFailureReason as failureReason,
	   vmUsedSpace as vmbackupsizebytes,
	   vmGuestSize as vmguestsizebytes,
	   vmSize as vmsizebytes,
	   vmCBTStatus as vmcbtstatus,
	   vmTransportMode as vmtransportmode,
	   a.subclientName as subclient,
	   B.name as backupset,
data_sp = ISNULL(AG.name,''),
backuplevelInt =j.bkplevel,
backuplevel =
CASE  j.bkplevel
 WHEN 1 THEN 'Full'
 WHEN 2 THEN 'Incremental'
 WHEN 4 THEN 'Differential'
 WHEN 64 THEN 'SyntheticFull'
 WHEN 256 THEN 'Transaction Log w. NoTruncate'
 WHEN 512 THEN 'ASR'
 ELSE 'Unknown'
 END
from
(
select vmclientid, jobid, attrname, attrval
from app_vmprop with (nolock)
) as t
pivot
( max(attrval) for attrname in ([vmGUID], [vmStatus], [vmHost], [vmAgent], [vmFailureReason],
			      [vmUsedSpace], [vmGuestSize], [vmBackupStartTime], [vmBackupEndTime], [vmSize] ,[vmCBTStatus], [vmTransportMode] )
) as pvt
inner join app_client c with (nolock)
on VMclientId = c.id
inner join jmbkpstats j with (nolock)
on pvt.jobid = j.jobid
inner join app_application A with (nolock)
on j.appid = A.id
inner join APP_BackupSetName B with (nolock)
on A.backupSet = B.id
inner join app_client VC with (nolock)
on A.clientId =VC.id
LEFT OUTER JOIN
dbo.archGroup AG ON AG.id > 1 AND (j.dataArchGrpId = AG.id )
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellVMBackupInfo]'
END
GO

