

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellSnapInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellSnapInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellSnapInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellSnapInfo]
GO

delete from GXDBVersions where name = 'CommCellSnapInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellSnapInfo', '1.2.210.1', 'CommCellSnapInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Snap info
CREATE VIEW CommCellSnapInfo
AS
SELECT	C.id AS ClientId,
		C.name AS ClientName,
		V.JobId AS JobId,
		SN.SMSnapId AS SnapId,
		SN.UniqueIdentifier AS SnapUniqueId,
		(CASE
			WHEN V.MountStatus < 38 THEN 'Creating'
			WHEN V.MountStatus = 38 THEN 'Create Failed'
			WHEN V.MountStatus = 39 THEN 'Created'
			WHEN V.MountStatus < 58 THEN 'Mounting'
			WHEN V.MountStatus = 58 THEN 'Mount Failed'
			WHEN V.MountStatus = 59 THEN 'Mounted'
			WHEN V.MountStatus < 78 THEN 'Unmounting'
			WHEN V.MountStatus = 78 THEN 'Unmount Failed'
			WHEN V.MountStatus = 79 THEN 'Unmounted'
			WHEN V.MountStatus < 88 THEN 'Reverting'
			WHEN V.MountStatus = 88 THEN 'Revert Failed'
			WHEN V.MountStatus = 89 THEN 'Reverted'
			WHEN V.MountStatus < 98 THEN 'Deleting'
			WHEN V.MountStatus = 98 THEN 'Delete Failed'
			WHEN V.MountStatus = 99 THEN 'Deleted'
			ELSE 'Unknown'
		END) AS 'Mount Status',
		CH.ControlHostId AS FilerId,
		(CASE
			WHEN(LEN(CH.SMArrayId) > 0) THEN CH.SMArrayId
			WHEN(LEN(CH.SMHostName) > 0) THEN CH.SMHostName
			ELSE SMHostIP
		END) AS FilerName,
		SE.SnapEngineName AS EngineName,
		SN.ReserveFieldStr AS SourcePath,
		AG.id AS StoragePolicyId,
		AG.name AS StoragePolicyName,
		AGC.id AS CopyId,
		AGC.name AS CopyName,
		(CASE WHEN (AG.defaultSnapCopy = AGC.id) THEN 'Snap Primary' WHEN AGC.isMirrorCopy = 1 THEN 'Snap Mirror' ELSE 'Snap Vault' END) AS CopyType
FROM	SMSnap SN, SMVolSnapMap VSM, SMVolume V, archGroupCopy AGC, archGroup AG, APP_Client C, SMControlHost CH, SMSnapShotEngine SE
WHERE	SN.UniqueIdentifier IS NOT NULL
		AND LEN(SN.UniqueIdentifier) > 0
		AND SN.SMSnapId = VSM.SMSnapId
		AND VSM.SMVolumeId = V.SMVolumeId
		AND V.CopyId = AGC.id
		AND AGC.archGroupId = AG.id
		AND V.SourceClientId = C.id
		AND SN.ControlHostId = CH.ControlHostId
		AND SN.SnapShotEngineId = SE.SnapShotEngineId
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View [CommCellSnapInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellSnapInfo]'
END
GO

