

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellRetentionInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellRetentionInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellRetentionInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellRetentionInfo]
GO

delete from GXDBVersions where name = 'CommCellRetentionInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellRetentionInfo', '1.6.12.2', 'CommCellRetentionInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Retention Info
CREATE VIEW dbo.CommCellRetentionInfo
AS
SELECT  DISTINCT
    CommCellID = (SELECT UPPER(substring(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
    CommCellName = CCELL.aliasName,
    SpName = AG.name,
    CopyName = AGC.name,
    RetentionDays = (CASE ARR.retentionDays WHEN -1 THEN 'Infinite' ELSE CAST(ARR.retentionDays AS VARCHAR(1024)) END),
    Cycles = (CASE ARR.fullCycles WHEN -1 THEN 'Infinite' ELSE CAST(ARR.fullCycles AS VARCHAR(1024)) END),
	ArchiverRetention = (CASE ARR.archiverRetDays WHEN -1 THEN 'Infinite' ELSE CAST(ARR.archiverRetDays AS VARCHAR(1024)) END),
	IsDataAgingEnabled= (CASE (ARR.flags & 4) WHEN 4 THEN 'No' ELSE 'Yes'  END),
	IsManagedDiskSpaceEnabled=(CASE (ARR.flags & 8) WHEN 8 THEN 'Yes' ELSE 'No' END),
    IsExtendedRetentionEnabled = (CASE WHEN (TRE.retentionDays1 IS NULL) THEN 'No' ELSE  CASE WHEN TRE.retentionDays1 = 0 THEN 'No' ELSE 'Yes' END END),
	ExtendedRetentionRule1 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule1,0)),
	RetentionDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays1) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays1 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
						WHEN ISNULL(TRE.retentionRule1 ,0) & 262144 = 262144
								THEN CAST(TRE.GraceDays1 AS VARCHAR(100)) + ' Hour(s)'
						ELSE CAST (TRE.GraceDays1 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule2 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule2,0)),
	RetentionDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays2) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays2 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
						WHEN ISNULL(TRE.retentionRule2 ,0) & 262144 = 262144
								THEN CAST(TRE.GraceDays2 AS VARCHAR(100)) + ' Hour(s)'
						ELSE CAST (TRE.GraceDays2 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule3 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule3,0)),
	RetentionDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays3) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays3 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
						WHEN ISNULL(TRE.retentionRule3 ,0) & 262144 = 262144
								THEN CAST(TRE.GraceDays3 AS VARCHAR(100)) + ' Hour(s)'
						ELSE CAST (TRE.GraceDays3 AS VARCHAR(100))
						END,
	--===================================================================================================--
	BackupSelectionTimePeriod = CASE	WHEN (TRE.retentionDays1 IS NULL) THEN 'N\A'
										WHEN TRE.retentionDays1 = 0 THEN 'N\A'
										WHEN (ARR.flags & 1) = 1 THEN  'First full backup of time period'
										ELSE 'Last full backup of time period'
								END,
	WeeklyRuleStartDay = CASE	WHEN (TRE.retentionDays1 IS NULL) THEN 'N\A'
								WHEN TRE.retentionDays1 = 0 THEN 'N\A'
								WHEN ARR.weekStart = 1 THEN 'Monday'
								WHEN ARR.weekStart = 2 THEN 'Tuesday'
								WHEN ARR.weekStart = 3 THEN 'Wednesday'
								WHEN ARR.weekStart = 4 THEN 'Thursday'
								WHEN ARR.weekStart = 5 THEN 'Friday'
								WHEN ARR.weekStart = 6 THEN 'Saturday'
								WHEN ARR.weekStart = 0 THEN 'Sunday'
						END,
	MonthlyRuleStartDate = CASE	WHEN (TRE.retentionDays1 IS NULL) THEN 'N\A'
								WHEN TRE.retentionDays1 = 0 THEN 'N\A'
								ELSE CAST ( ARR.monthStart AS VARCHAR(1024))
							END,
	SelectJobsFromPreviousTier = CASE	WHEN (TRE.retentionDays1 IS NULL) THEN 'N\A'
										WHEN TRE.retentionDays1 = 0 THEN 'N\A'
										WHEN ARR.flags & 32 = 32 THEN 'Select the jobs from previous tier is enabled'
										ELSE 'Select the jobs from previous tier is disabled'
								 END,
	CalendarName = ACC.name
FROM		dbo.archGroup AS AG INNER JOIN
			dbo.archGroupCopy AS AGC ON AG.id = AGC.archGroupId INNER JOIN
			dbo.archAgingRule AS ARR ON AGC.id = ARR.copyId INNER JOIN
			dbo.APP_CustomCalendar AS ACC ON ACC.id = AGC.calendarId INNER JOIN
			dbo.APP_CommCell CCELL ON 2 = CCELL.id LEFT OUTER JOIN
			dbo.GetTempExtendedRentiontionTransposedTable() TRE ON TRE.Copyid = AGC.id AND ARR.copyId = TRE.Copyid
      WHERE AG.id > 1  and AGC.type <> 5
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print 'RETVAL: 10 View [CommCellRetentionInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellRetentionInfo]'
END
GO

