

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellOracleBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellOracleBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellOracleBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellOracleBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellOracleBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellOracleBackupInfo', '1.2.12.2', 'CommCellOracleBackupInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup History Info
CREATE VIEW dbo.CommCellOracleBackupInfo
AS
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
		end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		storagePolicy = dbo.archGroup.name,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 1024 THEN 'Offline Full'
		 WHEN 32768 THEN 'Online Full'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE A.aged
			 WHEN 0 THEN 0
			 WHEN NULL THEN 1
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE A.aged
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'Yes'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		retentionDays = (CASE WHEN (AR.flags & 4) <> 0 THEN 'Data Aging Disabled' WHEN (AR.flags & 128) <> 0 THEN 'Job Count Based Retention'
						 ELSE (CASE WHEN AR.retentionDays = -1 THEN 'Infinite' ELSE CAST(AR.retentionDays AS VARCHAR(8)) END)
						 END),
		systemStateBackup = CASE WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1 ELSE 0 END,
		(select top 1 substring(F.attributeValue, charindex(char(18), F.attributeValue) + 1, len(F.attributeValue)) From
                  JMJobOptions(NOLOCK) F Where F.jobid = BS.jobid and F.commCellId =2 And F.attributeName = 'DB Backup Time') as nextSCN ,
        ISNULL(dbo.archGroupCopy.name, 'Not Available') as CopyName,
        ISNULL(cast(dbo.archGroupCopy.copy as varchar(32)), 'Not Available') as CopyPrecedence,
        dataOrLog =
        (
			CASE A.dataType
			     WHEN 4 THEN 'log'
			     ELSE 'data'
			     END
        )
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId LEFT OUTER JOIN
			  (select jobId, commcellId, archGrpId, archGrpCopyId, Disabled & 256 as aged, dataType From dbo.JMJobDataStats(NOLOCK) WHERE Status = 100 AND (Disabled & 256 = 0) AND dataType in(1,4)) A ON A.jobId = BS.jobId AND A.commCellId = BS.commCellId LEFT OUTER JOIN
			  dbo.archGroupCopy WITH (NOLOCK) ON dbo.archGroupCopy.id = A.archGrpCopyId LEFT OUTER JOIN
			  dbo.archGroup WITH (NOLOCK) ON A.archGrpId = dbo.archGroup.id LEFT OUTER JOIN
			  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65) OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
			  WHERE dbo.APP_Application.appTypeId In(2/*ORACLE_7*/, 22/*ORACLE_8*/, 23/*ORACLE_8I*/, 80/*ORACLE_RAC*/)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View [CommCellOracleBackupInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellOracleBackupInfo]'
END
GO

