

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMediaRetentionInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMediaRetentionInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMediaRetentionInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMediaRetentionInfo]
GO

delete from GXDBVersions where name = 'CommCellMediaRetentionInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMediaRetentionInfo', '1.2.86.1', 'CommCellMediaRetentionInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Library Info
CREATE VIEW dbo.CommCellMediaRetentionInfo
AS
	SELECT distinct				CM.MediaId As MediaID,
								CM.MediaBarcode As BarCode,
								L.AliasName As LibraryName,
								SG.spareGroupName As ScratchPool,
								M.isInMediaGroup As IsAssignedMedia,
								CM.Type As MediaType,
								CM.MediaStatus As MediaStatus,
								(CASE CM.Location
								WHEN 'In Slot' THEN 'In Library'
								WHEN 'In Drive' THEN 'In Library'
								ELSE
									(CASE CM.ExportLocation
									WHEN '' THEN CM.Location
									WHEN NULL THEN CM.Location
									ELSE CM.Location + '(' + CM.ExportLocation + ')'
									END)
								END) As "MediaLocation(ExportLocation)",
								ISNULL(CM.StoragePolicy, 'N/A') As StoragePolicy,
								ISNULL(CM.StoragePolicyCopy, 'N/A') As StoragePolicyCopy,
								(CASE
								WHEN M.IsAged = 1 THEN 'Data Aged'
								WHEN M.RetentionExpireTime = 0 THEN 'N/A'
								WHEN M.RetentionExpireTime = -1 THEN 'Infinite'
								ELSE
									(CASE M.RetentionFlags
									WHEN 0 THEN CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.getDateTime(M.RetentionExpireTime), 2)) + '(BASIC)'
									ELSE
									CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.getDateTime(M.RetentionExpireTime), 2)) + '(EXTENDED)'
									END)
								END) As "RetentionDate(RetentionType)",
								(CASE
								WHEN CM.retentionDays IS NULL THEN 'N/A'
								WHEN CM.retentionDays = 'Unlimited' THEN 'Infinite'
								ELSE CM.retentionDays
								END) As BasicRetentionDays,
								(CASE
								WHEN CM.fullcycles IS NULL THEN 'N/A'
								WHEN CM.fullcycles = 'Unlimited' THEN 'Infinite'
								ELSE CM.fullcycles
								END) As BasicRetentionCycles
	FROM MMMedia M JOIN MMLibrary L
		ON M.LibraryId = L.LibraryId
	JOIN MMSpareGroup SG
		ON M.SpareGroupId = SG.SpareGroupId
	JOIN CommCellMediaInfo CM
		ON M.MediaId = CM.MediaId
	WHERE M.MediaTypeId <> 10001
GO
declare @retCode integer        -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
    set @retCode = @@error;
    print 'RETVAL: 10 View [CommCellDriveInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMediaRetentionInfo]'
END
GO

