

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMAVersion.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMAVersion"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMAVersion]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMAVersion]
GO

delete from GXDBVersions where name = 'CommCellMAVersion' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMAVersion', '1.3', 'CommCellMAVersion', '')
GO
CREATE VIEW CommCellMAVersion
AS
SELECT    C.name AS Name,
          ISNULL(CGAList.ClientGroupNames,'""') as ClientGroups,
          R.release + ' ' + MAX(ISNULL(Version,'')) as Version,
          CASE WHEN  MAX(LEN(CONVERT(NVARCHAR(100),ISNULL(SIMP.AdditionalPatches, 'None')))) > LEN('None') THEN 'Yes' ELSE 'No' END as AdditionalUpdates,
          CASE  MAX(ISNULL(Baseline,8))
			 WHEN 0 THEN 'Unknown'
			 WHEN 1 THEN 'Up To Date'
			 WHEN 2 THEN 'Needs Update'
			 WHEN 4 THEN 'Ahead Of Cache'
			 WHEN 8 THEN 'N/A'
			 WHEN 16 THEN 'Hotfix'
		  END as Status
      FROM        APP_Client AS C
                  INNER JOIN simAllGalaxyRel R
                  ON R.id = C.releaseId
                  AND C.id > 1
                  INNER JOIN MMHost ON
                  MMHost.ClientId = c.id
                  LEFT OUTER JOIN (SELECT ClientID, simPackageID, AdditionalPatches,
									  Baseline,
									  (CASE WHEN HighestSP > 0 THEN 'SP' + CAST(HighestSP as varchar(20)) ELSE '' END + CASE
										WHEN SpMinorVersion > 0 THEN char((96 + SpMinorVersion))
										ELSE ''
										END) as Version FROM simInstalledPackages ) as SIMP
                  ON C.ID = SIMP.ClientID
                  LEFT OUTER JOIN simPackage SP ON
                  SIMP.simPackageID  = SP.id
			LEFT OUTER JOIN
    		(SELECT
				CL.clientId,
				'"' + LEFT(o.list, LEN(o.list) -1) +'"' as ClientGroupNames
			FROM
				(SELECT  distinct CGA.clientId, CG.name FROM APP_Client  C
						INNER JOIN APP_ClientGroupAssoc CGA
						ON CGA.clientId = C.id
						AND C.id >0 and (C.specialClientFlags & 2) = 0
						INNER JOIN APP_ClientGroup CG
						ON CG.id = CGA.clientGroupId )AS CL
				CROSS APPLY (SELECT
									s.name  + ','  AS [text()]
								FROM
									(SELECT CGA.clientId, CG.name
									 FROM APP_ClientGroupAssoc CGA
									 INNER JOIN APP_ClientGroup CG
									 ON CGA.clientGroupId = CG.id
									 AND CL.clientId = CGA.clientId) AS  s
								FOR XML PATH('')) AS o(list) )  AS CGAList
			ON CGAList.clientId = C.id
     GROUP BY    C.name,  SIMP.ClientID,  C.releaseId, R.release, CGAList.ClientGroupNames
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMAVersion]'
END
GO

