

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellCompletedBkpJobsInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellCompletedBkpJobsInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellCompletedBkpJobsInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellCompletedBkpJobsInfo]
GO

delete from GXDBVersions where name = 'CommCellCompletedBkpJobsInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellCompletedBkpJobsInfo', '1.3.274.1', 'CommCellCompletedBkpJobsInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Displays only Completed (FULL/INC/DIFF) Backup Jobs for last 30 days
--- The output of this veiw is similar to Backup Job Summary Report (Summary Section)
---	Report Selection -- Backup Types :Full, Inc & Diff   --Job Status: Completed
CREATE VIEW dbo.CommCellCompletedBkpJobsInfo
AS
SELECT
      ClienID = C.id,
      ClientName = C.name,
      TotalBkpJobs = COUNT(JB.JobID),
      TotalFullBkpJobs = SUM(CASE WHEN JB.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN 1 ELSE 0 END),
      TotalIncBkpJobs = SUM(CASE WHEN JB.BkpLevel IN (2, 0x100) THEN 1 ELSE 0 END),
      TotalOtherBkpJobs = SUM(CASE WHEN JB.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN 1 ELSE 0 END),
      TotalBkpSizeGB = CAST(SUM(JB.totalUncompBytes)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalFullBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalIncBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel IN (2, 0x100) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalOtherBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2))
FROM  JMBkpStats JB WITH (READUNCOMMITTED)
            INNER JOIN APP_Application AP  WITH (READUNCOMMITTED) ON JB.appId = AP.id
            INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON C.id =AP.clientId
WHERE JB.servEndDate <= dbo.GetUnixTime(GETUTCDATE()) --End Time - Current Time
AND JB.servEndDate >= (dbo.GetUnixTime(GETUTCDATE()) - 30 * 24 *60 *60) --Start Time - last 30 days
and JB.datastatus!=1    --donot show aged jobs
and JB.datastatus!=2    --donot show media deleted jobs
AND JB.status IN (1)	--successful jobs only
and (bkplevel & 7) >0   --full/inc/diff jobs
and JB.apptype not in ( --not including these apptype in backup job report
       84, 47, 50 , 45 , 57 , 56 , 58 , 66 , 73 , 82 , 83 , 67 , 68 , 90 , 89 , 93,
       105, 600, 601, 602, 603, 604, 605, 606, 607, 650, 651, 652, 699)
GROUP BY C.id, C.Name
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print 'RETVAL: 10 View [CommCellCompletedBkpJobsInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellCompletedBkpJobsInfo]'
END
GO

