

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellCloudLaptopClients.view] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET ANSI_NULLS  ON
print '... Creating View: CommCellCloudLaptopClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellCloudLaptopClients]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellCloudLaptopClients]
GO

delete from GXDBVersions where name = 'CommCellCloudLaptopClients' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellCloudLaptopClients', '1.1.2.5', 'CommCellCloudLaptopClients', '')
GO
CREATE VIEW dbo.CommCellCloudLaptopClients
AS
/*
	Conditons to check if a Client is Cloud laptop client
	1. If the default Subclient of default backupset has property 'Cloud Mode Enabled' set to '1'
*/
SELECT  AC.id AS ClientID , AC.name AS ClientName
			FROM APP_Client AC WITH (NOLOCK)
				INNER JOIN APP_Application APP WITH (NOLOCK) on APP.clientId = AC.id
				INNER JOIN APP_BackupSetName B WITH (NOLOCK) on APP.backupSet = B.id
				INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) on SCP.componentNameId = APP.id AND  SCP.attrName = 'Cloud Mode Enabled' and SCP.modified = 0 and SCP.attrVal = '1' AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')		-- subClientProp has CV_SC_PROP_CLOUD_MODE_ENABLED='Cloud Mode Enabled' set
			WHERE (AC.status & 4096) = 4096																-- Laptop configured CV_STATUS_PERSONAL_WKSTN = 4096
				AND (B.status & 8) = 8  																-- default backupset CV_STATUS_DEFAULT = 8
				AND    B.id = APP.backupset
				AND    (APP.subclientStatus & 8) = 8
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellCloudLaptopClients]'
END
GO

