

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientLevelBkpJobSummary.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientLevelBkpJobSummary"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientLevelBkpJobSummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientLevelBkpJobSummary]
GO

delete from GXDBVersions where name = 'CommCellClientLevelBkpJobSummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientLevelBkpJobSummary', '', 'CommCellClientLevelBkpJobSummary', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Client Level Backup Job Summary
CREATE VIEW dbo.CommCellClientLevelBkpJobSummary
AS
SELECT
ClientID			= C.id,
ClientName			= (SELECT name FROM APP_Client WHERE id = C.id),
TotalJobs			= COUNT(J.JobID),
Completed			= SUM(CASE WHEN J.status = 1 THEN 1 ELSE 0 END),
CompletedWithErrors	= SUM(CASE WHEN J.status = 3 THEN 1 ELSE 0 END),
Killed				= SUM(CASE WHEN J.status = 4 THEN 1 ELSE 0 END),
Failed				= SUM(CASE WHEN J.status = 2 THEN 1 ELSE 0 END),
NoRun				= SUM(CASE WHEN J.failureErrorCode IN (7, 8, 11) THEN 1 ELSE 0 END),
Dropped				= SUM(CASE WHEN J.status = 9 THEN 1 ELSE 0 END),
Other				= SUM(CASE WHEN J.status NOT IN (1, 2, 3, 4, 9) AND J.failureErrorCode NOT IN (7, 8, 11) THEN 1 ELSE 0 END),
SchedInitiated		= SUM(CASE WHEN J.initFrom = 3 THEN 1 ELSE 0 END),
TotalFullAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalIncAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (2, 0x100) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalOtherAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalAppSizeGB		= CAST(SUM(ISNULL(J.totalUncompBytes, 0))/(1024.0 *1024*1024) as decimal(20,4)),
TotalFullBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalIncBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (2, 0x100) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalOtherBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalBkpSizeGB		= CAST(SUM(ISNULL(J.sizeOnMedia, 0))/(1024.0 *1024*1024) as decimal(20,4)),
ProtectedObjects	= SUM(ISNULL(totalNumOFFiles, 0)),
FailedObjects		= SUM(ISNULL(scanFileFailures, 0) + ISNULL(backupFileFailures, 0)),
FailedFolders		= SUM(ISNULL(scanFolderFailures, 0) + ISNULL(backupFolderFailures, 0)),
StartTime			= dbo.GetDateTime(ISNULL(MIN(J.servStartDate), 0)),
EndTime				= dbo.GetDateTime(ISNULL(MAX(J.servEndDate), 0))
FROM		APP_Client	C
			INNER JOIN	APP_Application AP
				ON C.id = AP.clientID
			LEFT OUTER JOIN
			(SELECT B.jobId, B.commCellId, B.appId, B.BkpLevel, B.servStartDate, B.servEndDate, B.initFrom, B.status,
					B.totalUncompBytes, B.totalNumOfFiles, B.scanFileFailures, B.backupFileFailures,
					B.scanFolderFailures, B.backupFolderFailures, B.failureErrorCode, SUM(D.sizeOnMedia) AS sizeOnMedia
			FROM JMBkpStats B
				INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId
				INNER JOIN archGroup G ON B.opType NOT IN (59, 65) AND D.archGrpCopyId = G.defaultCopy OR B.opType IN (59, 65) AND D.archGrpCopyId = G.defaultSnapCopy
			WHERE B.servEndDate >= (dbo.GetUnixTime(GETUTCDATE()) - 30 * 24 *60 *60) --Duration Last 30 days
			GROUP BY B.jobId, B.commCellId, B.appId, B.BkpLevel, B.servStartDate, B.servEndDate, B.initFrom, B.status,
					B.totalUncompBytes, B.totalNumOfFiles, B.scanFileFailures, B.backupFileFailures,
					B.scanFolderFailures, B.backupFolderFailures, B.failureErrorCode
			) J ON J.appID = AP.id
GROUP BY C.id
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientLevelBkpJobSummary]'
END
GO

