

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkupSizeInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkupSizeInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkupSizeInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkupSizeInfo]
GO

delete from GXDBVersions where name = 'CommCellBkupSizeInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkupSizeInfo', '1.9.274.1', 'CommCellBkupSizeInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Last Backup Size Info
CREATE VIEW dbo.CommCellBkupSizeInfo
AS
SELECT
JobId		= JB.JobId,
AppId		= JB.appId,
Client		= (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = AP.clientId),
iDataAgent	= (SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = AP.appTypeId),
Instance	= (SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = AP.instance),
BackupSet	= (SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE id = AP.backupset),
Subclient	= AP.subclientName,
Data_SP		= (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = JB.dataArchGrpId),
BackupType	= (CASE WHEN T.isFullBackup <> 0 THEN 'Full' ELSE 'Incr/Diff/Others' END),
LastBkp_AppSize_WithoutIndex= ISNULL((
			SELECT	TOP 1 physicalsize FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
			WHERE	AF.jobId = JB.jobId AND AF.commCellId = JB.commCellId AND AF.isValid = 1 AND AF.fileType NOT IN (2, 8)
				AND AFC.archFileId = AF.id AND AFC.commCellId = Af.commCellId AND AFC.isValid = 1), 0),
LastBkp_indexSize= ISNULL((
			SELECT TOP 1 physicalsize FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
			WHERE	AF.jobId = JB.jobId AND AF.commCellId = JB.commCellId AND AF.isValid = 1 AND AF.fileType IN (2, 8)
				AND AFC.archFileId = AF.id AND AFC.commCellId = Af.commCellId AND AFC.isValid = 1), 0),
LastBkp_TotBkpSize		= totalBackupSize,
LastBkp_percentageChange= percentageChange,
IsCompresstionEnabled	= (CASE WHEN APC.appNumber IS NULL THEN 'No' WHEN APC.compressWhere = 2 THEN 'No' ELSE 'Yes' END)
--
FROM	APP_Application AP with(NOLOCK)
		INNER JOIN JMBkpStats JB WITH (NOLOCK)
			ON AP.id = JB.appId
		INNER JOIN (SELECT	appId, (bkpLevel & (1|64|128|16384|1024|32768)) AS isFullBackup, MAX(servStartDate) AS servStartDate
					FROM	JMBkpStats WITH (NOLOCK)
					WHERE	status IN (1, 3) and optype != 58 GROUP BY appId, (bkpLevel & (1|64|128|16384|1024|32768)) ) T
			ON JB.appId = T.appId AND JB.servStartDate = T.servStartDate
		LEFT  JOIN archPipeConfig APC WITH (NOLOCK)
			ON APC.appNumber = AP.id
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print 'RETVAL: 10 View [CommCellBkupSizeInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkupSizeInfo]'
END
GO

