

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkScheduleSummary.view] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET ANSI_NULLS  ON
print '... Creating View: CommCellBkScheduleSummary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkScheduleSummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkScheduleSummary]
GO

delete from GXDBVersions where name = 'CommCellBkScheduleSummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkScheduleSummary', '1.8.12.4.8.1', 'CommCellBkScheduleSummary', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup Schedule Info
CREATE VIEW dbo.CommCellBkScheduleSummary
AS
SELECT DISTINCT
 CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
 CommCellName = CCELL.aliasName,
 scheduleId = STASK.subTaskid,
 schedulePolicy = TASK.taskname,
 scheduleName  = STASK.subtaskname,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype =
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  WHEN 1024 THEN 'Automatic'
  WHEN 4096 THEN 'Continuous'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 WHEN 1024 THEN 'Based on automatic settings'
 WHEN 4096 THEN 'Every ' + CONVERT(varchar(2),PAT.freq_interval)+' minutes'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedbackupday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
  WHEN 128 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
		 + ' ' + 'of' + ' ' +
		 CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
	WHEN 1024 THEN 'Unknown'
	WHEN 4096 THEN 'Unknown'
	ELSE ' '
	END,
	schedbackupTime =
		CASE PAT.freq_type
		WHEN 1024 THEN ''
		WHEN 4096 THEN ''
		ELSE CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 )
		END,
	schednextbackuptime =
		CASE PAT.freq_type
		WHEN 1024 THEN CAST('01/01/1970' AS datetime)
		WHEN 4096 THEN CAST('01/01/1970' AS datetime)
		ELSE RTASSOC.nextRunTime
		END,
	associationCount = (select count(*) from TM_AssocEntity ASSOC WITH (NOLOCK) where ASSOC.taskId = TASK.taskId),
	-- Check to see if JobsToRun Column is disabled
	CASE ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = N'CommCellBkScheduleSummary JobsToRun Disabled'), 0)
		WHEN 0 THEN
			(	select	count(distinct A.id)
			FROM    TM_Associations TA WITH (NOLOCK) -- Use view to get plan assoc too
			JOIN APP_Application A WITH (NOLOCK) ON
			(
				TA.clientId IN (0, A.clientId) AND TA.appTypeId IN (0, A.apptypeId) AND
				TA.instanceId IN (0, A.instance) AND TA.backupSetId IN (0, A.backupset) AND TA.subclientId IN (0, A.id)
			)
			WHERE TA.taskId = TASK.taskId
				--AND NOT EXISTS
				--(
				--	SELECT 1 FROM JMJobAction JA WITH (NOLOCK) --CHECK BACKUP ACTIVITY DISABLED
				--	WHERE
				--	(
				--		JA.appId = A.id --AT SUBCLIENT LEVEL
				--		OR
				--		(
				--			JA.clientId = A.clientId AND JA.appType IN (0, A.appTypeId) --AT CLIENT OR AGENT LEVEL
				--		)
				--	)
				--	AND JA.action = 1 and JA.opType = 4
				--)
				AND
				(
					(
						A.clientId IN
						( SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc WITH (NOLOCK) where clientgroupid in
						( SELECT clientGroupId from TM_AssocEntity WITH (NOLOCK) where taskId = TASK.taskId AND clientId = 0 AND exclude = 0))
					)
					OR
					(
						A.appTypeId IN
						( SELECT DISTINCT (appTypeId) FROM APP_AppTypeGroupAssoc WITH (NOLOCK) where appGroupId in
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 1 AND taskId = TASK.taskId AND
							taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TASK.taskId AND clientGroupId = 0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)))
					)
					OR
					(
						A.appTypeId IN
						( (SELECT type from dbo.APP_iDAType WITH (NOLOCK) where type IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 2 AND taskId = TASK.taskId AND
							taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TASK.taskId AND clientGroupId = 0 AND  clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0))))
					)
					OR
					(
						NOT EXISTS (SELECT taskId from TM_AssocFilter WITH (NOLOCK) where  taskId = TASK.taskId)
					)
				)
				AND NOT
				(
					(A.appTypeId >= 600 AND A.appTypeId <= 699)
					OR
					(A.apptypeId IN (24, 27, 31, 40, 47, 48, 67, 68,  87, 65, 25) AND (( A.subclientStatus & 8 ) = 8)
					)
					OR
					(
						--(A.appTypeId IN (84, 107) AND (((status & 8) <> 8) OR (@fanInRP = 0 AND backupsetId IN (SELECT id FROM APP_BackupSetName WITH (NOLOCK) WHERE status&40=40 AND id=backupsetId))))
						--OR
						(A.appTypeId IN (84) AND (TASK.taskType & 4 = 4) --MR54684 REMOVED CDR FROM SCHEDULE POLICY AGAIN WILL BE ADDED IN 10.0?
						--AND
							--backupSetId IN  ( select componentnameid from APP_Backupsetprop WITH (NOLOCK) where modified = 0 and attrName = N'FLR Replication Options' and CAST(attrVal AS INT)&0x10000=0x10000)
						) --DO NOT RUN JOBS FOR DDR SCHEDULE POLICIES
						OR (A.appTypeId IN (107) AND (TASK.taskType & 4 = 4) AND backupsetId IN (SELECT id FROM APP_BackupSetName WITH (NOLOCK) WHERE status&40=40 AND id=backupsetId)) --ONLY RUN JOBS FOR NON-DEFAULT BACKUPSET FOR SCHEDULE POLICIES
						--DO NOT RUN JOBS ON PSEUDO HIDDEN BACKUP SETS
						OR (A.appTypeId IN (37, 62, 103) AND A.backupSet IN (SELECT id FROM APP_BackupSetName WITH (NOLOCK) WHERE status&24=24 AND id=A.backupSet))
					)
					OR
					(A.appTypeId IN (6,51,59,77) AND A.subclientStatus&0x0080<>0x0080)	--SKIP TRANSACTION LOG SUBCLIENTS
					OR
					(A.appTypeId IN (72) OR A.appTypeId >= 1000) --FILTER DUMMY IDA
					OR
					(A.apptypeId IN (84, 107) AND A.subclientStatus&8<>8) --IGNORE NO DEF SUBCLIENTS FOR CDR/WBA IDA
					OR
					(
						TASK.taskType & 4 = 4 --SCHEDULE POLICY
						AND
						(
							A.subclientStatus&64=64 OR A.subclientStatus&4096=4096 -- COMMAND LINE AND COMMAND LOG SUBCLIENT
							OR A.appTypeId IN (47, 50)	-- QR APPTYPE
							OR A.backupSet IN ( select componentnameid from APP_backupsetprop WITH (NOLOCK) where modified = 0 and attrName = N'OnDemand Backupset' and attrVal = N'1')
						)
					)
					OR
					(A.apptypeId NOT IN (
						(SELECT appTypeId from APP_AppTypeGroupAssoc WITH (NOLOCK) where typeOfGroup = 0 and appgroupid IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 1 AND taskId = TASK.taskId))
						UNION ALL (SELECT type from dbo.APP_iDAType WITH (NOLOCK) where type IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 2 AND taskId = TASK.taskId))
						UNION ALL (SELECT DISTINCT filter_value from TM_AssocFilter WITH (NOLOCK) --, dbo.GetAppTypesForAppGroup(22, 0) removed outer join
							WHERE  filter_type = 2 AND taskId = TASK.taskId AND filter_value IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(22, 0))) --APPGRP_W2KFileSystem
						)
						AND
						(
							EXISTS (SELECT taskId from TM_AssocFilter WITH (NOLOCK) where  taskId = TASK.taskId)
						)
					)
					OR
					(A.appTypeId = 81 AND
						(EXISTS( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 3 AND filter_value = 1 AND taskId = TASK.taskId	--FILTER_Subclient= 3 --FIL_SC_SQL_FFG = 2
								) OR NOT EXISTS(SELECT TA.taskId FROM TM_Associations TA WITH (NOLOCK) WHERE TA.taskId=TASK.taskId AND TA.subclientId = A.id ) -- Use view to account for plan association
						)
						AND
						A.id IN  ( select componentnameid from APP_Subclientprop WITH (NOLOCK) where modified = 0 and attrName = N'mssql subclient type' and attrVal = N'2')
					)
				)
				AND NOT
				(
					(( A.subclientstatus & 2 ) = 2)   -- CV_STATUS_UNINSTALLED
					OR    ((( A.subclientstatus & 4 ) =  4)   -- CV_STATUS_DELETED
							)
					OR    (( A.subclientstatus & 16 ) = 16)  -- CV_STATUS_DUMMY
					OR    (( A.subclientstatus & 32 ) = 32)  -- CV_STATUS_HIDDEN
							AND NOT (A.apptypeId IN (84, 107) AND (A.subclientStatus & 8) = 8)  --IGNORE CDR/WBA SINCE THEY ARE MARKED HIDDEN
				)
				)
			ELSE 0
	END JobsToRun,
	JobsFiredInLastRun = ISNULL(TT.firedJobs, 0),
	lastScheduleFireTime = DATEADD(second, TT.maxTime, '01/01/1970 00:00:00AM'),
	mismatchedAppTypeCount = ISNULL(MAPP.mismatchedAppType, 0),
	TimeZoneId = PAT.tzId,
	TimeZoneName = (CASE PAT.tzId
						WHEN 1000 THEN 'CS TimeZone'
						WHEN 1001 THEN 'Client TimeZone'
						ELSE STZ.TimeZoneName
					END),
	TimeZoneOffSet = (CASE
						WHEN PAT.tzId NOT IN (1000, 1001) THEN STZ.Bias
						ELSE 0
					  END)
  FROM
		TM_Task as TASK WITH (NOLOCK) LEFT OUTER JOIN
		TM_SubTask as STASK WITH (NOLOCK) ON TASK.taskId = STASK.taskId  JOIN
		TM_SubTaskOptions as SOPT WITH (NOLOCK) ON STASK.subTaskId = SOPT.subTaskId JOIN
		TM_PatternAssoc AS PATASSOC WITH (NOLOCK) ON PATASSOC.subTaskId = STASK.subTaskId JOIN
		TM_Pattern AS PAT WITH (NOLOCK) ON PAT.patternId = PATASSOC.patternId  LEFT JOIN
		TM_RunTime AS RT WITH (NOLOCK) ON RT.patternId = PAT.patternId  LEFT JOIN
		(	SELECT runTimeId, nextRunTime=MAX(nextRunTime) FROM TM_RunTimeAssoc WITH (NOLOCK)
			WHERE processed = 0 AND firing = 0 GROUP BY runTimeId) AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
		--TM_AssocFilter AS TF WITH (NOLOCK) ON TF.taskId = TASK.taskId LEFT OUTER  JOIN
		App_Commcell AS CCELL WITH (NOLOCK) ON 2 = CCELL.id LEFT OUTER JOIN
		TempCvView3 t3 WITH (NOLOCK) ON PAT.PatternId=t3.patternid LEFT OUTER JOIN
		(	select TJ.taskId, TJ.subTaskId, TJ.maxTime, firedJobs=count(distinct TR.jobId)
			from (	select taskId, subTaskId, maxTime=MAX(created), maxReqId=MAX(jobRequestId)
				from TM_JobRequest WITH (NOLOCK) group by taskId, subTaskId) TJ, TM_Jobs TR WITH (NOLOCK)
			where TJ.maxReqId = TR.jobRequestId AND
			(	EXISTS (select 1 from JmBkpStats JB WITH (NOLOCK) where TR.jobId = JB.JobId)
					OR
				EXISTS (select 1 from JMBkpJobInfo JActive WITH (NOLOCK) where TR.jobId = JActive.JobId))
			group by TJ.taskId, TJ.subTaskId, TJ.maxTime ) TT ON STASK.taskId=TT.taskId AND STASK.subTaskId=TT.subTaskId LEFT OUTER JOIN
		(	select taskId, mismatchedAppType=COUNT(*)
			from (	select T2.taskId, T2.clientId, T2.appTypeId
					from (	select taskId, clientId, apptypeId from TM_AssocEntity WITH (NOLOCK) where clientGroupId = 0 and apptypeId > 0
							UNION
							select taskId, T.clientId, apptypeId from TM_AssocEntity T WITH (NOLOCK), APP_ClientGroupAssoc G WITH (NOLOCK)
								where T.apptypeId > 0 and T.clientGroupId = G.clientGroupId) T2
						LEFT OUTER JOIN TM_AssocFilter TA2 WITH (NOLOCK) ON T2.taskId = TA2.taskId
					where TA2.taskId is NULL OR TA2.filter_type=2 AND TA2.filter_value=T2.appTypeId ) T3
				LEFT JOIN APP_iDAName A WITH (NOLOCK) ON T3.clientId = A.clientId and T3.apptypeId = A.appTypeId
		 	where A.id is null
		 	group by taskId) MAPP ON STASK.taskId=MAPP.taskId LEFT OUTER JOIN
		 	SchedTimeZone STZ WITH (NOLOCK) ON PAT.tzId = STZ.TimeZoneID
WHERE
		STASK.subTaskType = 2 AND STASK.operationType=2 AND
		SOPT.optionId = 458405394
		AND (RT.processed = 0 OR RT.processed IS NULL OR PAT.freq_type = 4096 OR PAT.freq_type = 1024)
		AND (RT.firing =  0 OR RT.processed IS NULL OR PAT.freq_type = 4096 OR PAT.freq_type = 1024) AND
		TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0 AND
		TASK.disabled = 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print 'RETVAL: 10 View [CommCellBkSchedule]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkScheduleSummary]'
END
GO

