

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkScheduleForSubclients.view] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET ANSI_NULLS  ON
print '... Creating View: CommCellBkScheduleForSubclients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkScheduleForSubclients]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkScheduleForSubclients]
GO

delete from GXDBVersions where name = 'CommCellBkScheduleForSubclients' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkScheduleForSubclients', '', 'CommCellBkScheduleForSubclients', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup Schedule Info For Subclients
CREATE VIEW dbo.CommCellBkScheduleForSubclients
AS
WITH IncludedEntities ( schedulePolicy , clientId, appTypeId, instanceId, backupsetId, appid, clientName, idaagent, instance,backupset,subclient) AS
(
       SELECT
	   assoc.taskid,
	   c.id,
	   AA.appTypeId,
	   aa.instance,
	   aa.backupset,
	   appid =
		CASE WHEN ASSOC.subclientId = 0
		THEN AA.id
		ELSE ASSOC.subclientId END,
	   clientName =
			CASE WHEN C.id is NULL
			THEN 'All Clients'
			ELSE C.name
			END,
	   idaagent = APT.name,
	   instance =
			CASE  ITN.name
			 WHEN 'DefaultInstanceName' THEN ''
			 WHEN 'defaultDummyInstanceForOracle' THEN ''
			 ELSE ITN.name
			END,
	   backupset =
		   CASE  APT.type
			WHEN 6 THEN 'NULL'
			WHEN 9 THEN 'NULL'
			WHEN 15 THEN 'NULL'
			WHEN 27 THEN 'NULL'
			WHEN 31 THEN 'NULL'
		   ELSE
			  CASE WHEN AA.backupSet IS NULL
			  THEN 'All BackupSets'
			  ELSE (Select name from APP_BackupSetName where id=AA.backupSet)
			  END
		   END,
	   subclient =
			CASE WHEN AA.subclientName IS NULL
			THEN 'All subclients'
			ELSE AA.subclientName
			END
       FROM TM_Associations AS ASSOC -- Use view to account for plan association also.
       LEFT OUTER JOIN APP_ClientGroupAssoc ACG ON (ASSOC.assocType = 28 AND ASSOC.clientGroupId = ACG.clientGroupId)
       LEFT OUTER JOIN APP_Client C ON (ACG.clientId = C.id OR ASSOC.clientId = C.id )
       LEFT OUTER JOIN APP_Application AA ON ( ASSOC.exclude = 0 AND ( (c.id = AA.clientId
                                            AND (ASSOC.appTypeId=AA.appTypeId OR ASSOC.appTypeId = 0)
                                            AND (ASSOC.instanceId =AA.instance OR ASSOC.instanceId= 0)
                                            AND (ASSOC.backupsetId = AA.backupSet OR ASSOC.backupsetId=0)
                                            AND (ASSOC.subclientId = AA.id OR assoc.subclientId = 0) )
                                            ))
	   LEFT OUTER JOIN APP_iDAType  APT ON ((ASSOC.appTypeId = APT.type AND ASSOC.appTypeId<>0)  OR AA.apptypeId = APT.type)
	   LEFT OUTER JOIN APP_InstanceName  ITN ON (ASSOC.instanceId = ITN.id OR AA.instance = ITN.id)
       WHERE ASSOC.exclude = 0 AND Assoc.taskId in
       (
              SELECT TM_Subtask.taskid FROM TM_SubTask WHERE TM_SubTask.subTaskType=2
       )
       AND AA.subclientStatus & 54 = 0 --Dummy+Hidden+deleted+uninstalled
	   AND AA.appTypeId <> 1000
       except
       SELECT
		assoc.taskid,
		c.id,
		AA.appTypeId,
		aa.instance,
		aa.backupset,
		appid =
		CASE WHEN ASSOC.subclientId = 0
		THEN AA.id
		ELSE ASSOC.subclientId END,
		clientName =
			CASE WHEN C.id is NULL
			THEN 'All Clients'
			ELSE C.name
			END,
		idaagent = APT.name,
		instance =
			CASE  ITN.name
				WHEN 'DefaultInstanceName' THEN ''
				WHEN 'defaultDummyInstanceForOracle' THEN ''
				ELSE ITN.name
			END,
		backupset =
			CASE  APT.type
			WHEN 6 THEN 'NULL'
			WHEN 9 THEN 'NULL'
			WHEN 15 THEN 'NULL'
			WHEN 27 THEN 'NULL'
			WHEN 31 THEN 'NULL'
			ELSE
				CASE WHEN AA.backupSet IS NULL
				THEN 'All BackupSets'
				ELSE (Select name from APP_BackupSetName where id=AA.backupSet)
				END
			END,
		subclient =
			CASE WHEN AA.subclientName IS NULL
			THEN 'All subclients'
			ELSE AA.subclientName
			END
       FROM TM_Associations AS ASSOC -- Use view to account for plan association also.
       LEFT OUTER JOIN APP_ClientGroupAssoc ACG ON (ASSOC.assocType = 28 AND ASSOC.clientGroupId = ACG.clientGroupId)
       LEFT OUTER JOIN APP_Client C ON (ACG.clientId = C.id OR ASSOC.clientId = C.id )
       LEFT OUTER JOIN APP_Application AA ON ( ASSOC.exclude = 1 AND ( (c.id = AA.clientId
                                              AND (ASSOC.appTypeId=AA.appTypeId OR ASSOC.appTypeId = 0)
                                              AND (ASSOC.instanceId =AA.instance OR ASSOC.instanceId= 0)
                                              AND (ASSOC.backupsetId = AA.backupSet OR ASSOC.backupsetId=0)
                                              AND (ASSOC.subclientId = AA.id OR assoc.subclientId = 0) )
                                              ))
	   LEFT OUTER JOIN APP_iDAType  APT ON ((ASSOC.appTypeId = APT.type AND ASSOC.appTypeId<>0)  OR AA.apptypeId = APT.type)
	   LEFT OUTER JOIN APP_InstanceName  ITN ON (ASSOC.instanceId = ITN.id OR AA.instance = ITN.id)
       WHERE ASSOC.exclude = 1 AND Assoc.taskId in
       (
              SELECT TM_Subtask.taskid FROM TM_SubTask WHERE TM_SubTask.subTaskType=2
       )
),ScheduledTimes (CommCellId, CommCellName, scheduleId, schedulePolicyId, scheduePolicy, scheduleName, scheduletask, schedbackuptype,schedpattern,
schedinterval,schedbackupday,schedbackupTime,schednextbackuptime) AS
(
SELECT
DISTINCT
CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
CommCellName = CCELL.aliasName,
scheduleId = STASK.subTaskid,
schedulePolicyID = Task.taskID,
schedulePolicy = TASK.taskname,
scheduleName  = STASK.subtaskname,
scheduleTask =
CASE STASK.subTasktype
WHEN 1 THEN 'Administration'
WHEN 2 THEN 'Backup'
WHEN 3 THEN 'Restore'
ELSE 'OTHER'
END,
schedbackuptype =
CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
ELSE 'Unknown'
END,
schedpattern =
CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  WHEN 1024 THEN 'Automatic'
  WHEN 4096 THEN 'Continuous'
  ELSE 'Unknown'
END,
schedinterval =
CASE PAT.freq_type
WHEN 128 THEN 'Every 1'
WHEN 1024 THEN 'Based on automatic settings'
WHEN 4096 THEN 'Every ' + CONVERT(varchar(10),PAT.freq_interval)+' minutes'
ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
schedbackupday=
CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
  WHEN 128 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
         + ' ' + 'of' + ' ' +
         CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
       WHEN 1024 THEN 'Unknown'
       WHEN 4096 THEN 'Unknown'
    ELSE ' '
    END,
    schedbackupTime =
             CASE PAT.freq_type
             WHEN 1024 THEN ''
             WHEN 4096 THEN ''
             ELSE CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 )
             END,
    schednextbackuptime =
             CASE PAT.freq_type
             WHEN 1024 THEN CAST('01/01/1970' AS datetime)
             WHEN 4096 THEN CAST('01/01/1970' AS datetime)
             ELSE RTASSOC.nextRunTime
			 END
  FROM
        TM_Task as TASK LEFT OUTER JOIN
        TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
        TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId AND
        SOPT.optionId = 458405394 JOIN
        TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
        TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  --AND Pat.freq_type!=4096
              JOIN TM_RunTime AS RT ON RT.patternId = PAT.patternId JOIN
        TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId
              LEFT OUTER  JOIN App_Commcell AS CCELL ON 2 = CCELL.id
              LEFT OUTER JOIN TempCvView3 t3 ON PAT.PatternId=t3.patternid
  WHERE
        STASK.subTaskType = 2 AND
        TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
		AND (RTASSOC.processed = 0 OR PAT.freq_type = 4096 OR PAT.freq_type = 1024)
		AND (RTASSOC.firing = 0 OR PAT.freq_type = 4096 OR PAT.freq_type = 1024)
		AND (RT.processed = 0 OR PAT.freq_type = 4096 OR PAT.freq_type = 1024)
		AND (RT.firing =  0 OR PAT.freq_type = 4096 OR PAT.freq_type = 1024)
)
SELECT ST.[CommCellId]
      ,ST.[CommCellName]
      ,ST.[scheduleId]
      ,ST.[scheduePolicy]
      ,ST.[scheduleName]
      ,ST.[scheduletask]
      ,ST.[schedbackuptype]
      ,ST.[schedpattern]
      ,ST.[schedinterval]
      ,ST.[schedbackupday]
      ,ST.[schedbackupTime]
      ,ST.[schednextbackuptime]
      ,AE.[appid]
      ,AE.[clientName]
      ,AE.[idaagent]
      ,AE.[instance]
      ,AE.[backupset]
      ,AE.[subclient]
	  FROM ScheduledTimes ST inner join IncludedEntities AE ON
		ST.schedulePolicyId = AE.schedulePolicy
GO
declare @retCode integer        -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
    set @retCode = @@error;
        print 'RETVAL: 10 View [CommCellBkScheduleForSubclients]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkScheduleForSubclients]'
END
GO

