

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBackupInfo', '1.26.56.13', 'CommCellBackupInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup History Info
CREATE VIEW dbo.CommCellBackupInfo
AS
SELECT
jobid=BS.jobId,
appid=BS.appid,
jobinitfrom=
case BS.initFrom
when 1 then 'Command Line'
when 2 then 'Gui'
when 3 then 'Schedule'
when 4 then 'System'
end,
clientname = dbo.APP_Client.name,
idataagent = dbo.APP_IDAType.name,
instance = APP_InstanceName.name,
backupset = dbo.APP_BackupSetName.Name,
subclient = dbo.app_application.SubClientName,
data_sp = CASE WHEN AG.name IS NOT NULL THEN AG.name
          ELSE ISNULL((
               SELECT name FROM archGroup  WITH (NOLOCK)
	           WHERE  BS.dataArchGrpId > 1 AND id = BS.dataArchGrpId
	               OR BS.dataArchGrpId <= 1 AND id = BS.logArchGrpId
			   ), '')
          END,
backuplevelInt =BS.bkplevel,
backuplevel = ISNULL(BLN.bkpLevelName,'Unknown'),
incrlevel =
case  BS.bkplevel
when 2 then
     case BS.oraSublevel
     when 0 then 1
     else BS.oraSublevel
     end
else 0
end,
jobstatusInt =BS.status,
jobstatus =
 CASE BS.status
 WHEN 1 THEN 'Success'
 WHEN 2 THEN 'Failed'
 WHEN 3 THEN 'PartialSuccess'
 WHEN 4 THEN 'Killed'
 WHEN 5 THEN 'Stopped'
 WHEN 6 THEN 'Interrupted'
 WHEN 9 THEN 'Failed to Start'
 ELSE 'Unknown'
 END,
jobfailedreason =
case
when BS.status > 1 then
	case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 		then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
				from JMBkpAtmptStats WITH (NOLOCK)
				where jobid =Bs.jobid)
		 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
	end
else ''
end,
transferTime=BS.totalWriteTime,
startdateunixsec =  BS.servStartdate,
enddateunixsec = BS.servEndDate,
startdate = dbo.GetDateTime(BS.servStartDate),
enddate =dbo.GetDateTime(BS.servEndDate),
durationunixsec = BS.duration,
duration = case
  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
  else ''
  end,
numstreams = BS.numStreams,
numbytesuncomp= BS.totaluncompbytes,
numbytescomp=BS.totalcompbytes,
numobjects=BS.totalNumOfFiles,
isAged = (CASE WHEN ISNULL(BS.agedtime, 0) = 0 THEN 0 ELSE 1 END),
isAgedStr = (CASE WHEN ISNULL(BS.agedtime, 0) = 0 THEN 'No' ELSE 'Yes' END),
xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
retentionDays = ISNULL(CASE WHEN (AR.flags & 4) <> 0 THEN 'Data Aging Disabled' WHEN (AR.flags & 128) <> 0 THEN 'Job Count Based Retention'
	WHEN I.isDMAppType = 1 THEN (CASE WHEN AR.ArchiverRetDays = -1 THEN 'Infinite' ELSE CAST(AR.ArchiverRetDays AS VARCHAR(8)) END)
	ELSE (CASE WHEN AR.retentionDays = -1 THEN 'Infinite' ELSE CAST(AR.retentionDays AS VARCHAR(8)) END)
	END, ''),
systemStateBackup = CASE WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1 ELSE 0 END,
inPrimaryCopy = ISNULL((1*JD.InPrimaryCopy | 2*JD.InPrimarySnapCopy), 0),
failedobjects=BS.scanFileFailures + BS.scanFolderFailures + BS.backupFileFailures + BS.backupFolderFailures,
BS.totalBackupSize,
encrypted = (
			CASE
				WHEN JOBAF.encKeyType IS NULL THEN 'Unavailable'
				WHEN JOBAF.encKeyType > 0 THEN 'Yes'
				ELSE 'No'
			END
			),
    ISNULL(UMDS.domainName,'Commcell') as Company
FROM  dbo.APP_Application    WITH (NOLOCK) INNER JOIN
      dbo.APP_BackupSetName  WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
      dbo.APP_InstanceName   WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
      dbo.APP_iDAType        WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
      dbo.APP_Client         WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
      dbo.JMBkpStats AS BS   WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId
      ---Below couple lines are added by Echo to fetch umprovider company info
	  LEFT JOIN App_CompanyEntities  CE WITH (NOLOCK)
	  ON dbo.APP_Client.id = CE.entityId
	  AND  CE.entitytype =3
	  LEFT JOIN  UMDSProviders UMDS WITH (NOLOCK)
	  on CE.companyid = UMDS.id
	 ------end here----------------------------
      LEFT OUTER JOIN
      (SELECT jobId, commCellId,
              MAX(CASE dataType WHEN 4 THEN 0 ELSE archGrpId END) AS dataArchGrpId,
              MAX(CASE dataType WHEN 4 THEN archGrpId ELSE 0 END) AS logArchGrpId,
              MAX(CASE WHEN J.archGrpCopyId = P.defaultCopy AND J.status = 100 AND (J.disabled & 256) = 0 THEN 1 ELSE 0 END) AS InPrimaryCopy,
              MAX(CASE WHEN J.archGrpCopyId = P.defaultSnapCopy AND J.status = 100 AND (J.disabled & 256) = 0 THEN 1 ELSE 0 END) AS InPrimarySnapCopy
         FROM JMJobDataStats J WITH (NOLOCK) INNER JOIN archGroup P WITH (NOLOCK) ON J.archGrpId = P.id
        GROUP BY jobId, commCellId) JD ON BS.jobId = JD.jobId AND BS.commCellId = JD.commCellId LEFT OUTER JOIN
      dbo.archGroup AG ON AG.id > 1 AND AG.id = (CASE
			WHEN ISNULL(JD.dataArchGrpId, 0)> 0 THEN JD.dataArchGrpId
			WHEN ISNULL(JD.logArchGrpId, 0) > 0 THEN JD.logArchGrpId
			WHEN BS.dataArchGrpId > 1 THEN BS.dataArchGrpId
			ELSE BS.logArchGrpId END) LEFT OUTER JOIN
      dbo.archAgingRule AR ON AR.copyId = AG.defaultCopy AND BS.opType NOT IN (59, 65)
		OR AR.copyId = AG.defaultSnapCopy AND BS.opType IN (59, 65) LEFT OUTER JOIN
      dbo.APP_IDATypeHandlingInfo I ON I.appTypeId = BS.appType
	  LEFT OUTER JOIN(
						SELECT AF.jobId, AF.commCellId, encKeyType = MAX(AFC.encKeyType)
						FROM archFile AF WITH (NOLOCK)
						INNER JOIN archFileCopy AFC  WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
						WHERE AF.isValid = 1
						GROUP BY AF.jobId, AF.commCellId
					 )JOBAF ON BS.jobId = JOBAF.jobId AND BS.commCellId = JOBAF.commCellId
	  LEFT OUTER JOIN dbo.JMBackupLevelNames BLN ON BLN.bkpLevel = BS.bkpLevel
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View [CommCellBackupInfo]'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBackupInfo]'
END
GO

