

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CloudLaptopClientCCSCfgdView.view] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET ANSI_NULLS  ON
print '... Creating View: CloudLaptopClientCCSCfgdView'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CloudLaptopClientCCSCfgdView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CloudLaptopClientCCSCfgdView]
GO

delete from GXDBVersions where name = 'CloudLaptopClientCCSCfgdView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CloudLaptopClientCCSCfgdView', '1.1.4.7', 'CloudLaptopClientCCSCfgdView', '')
GO
	CREATE VIEW
		CloudLaptopClientCCSCfgdView
	AS
		SELECT AC.id AS clientId,
			CASE WHEN ACP.id IS NULL
				THEN NULL /* Client 'CCS Enabled' property not set*/
				ELSE TRY_CAST(ACP.attrVal AS INT) /* CCS enabled or disabled*/
			END ccsEnabled,
			(AC.releaseId - 5) release,
			ip.HighestSP servicePack
		FROM APP_Client AC WITH (NOLOCK)
			INNER JOIN APP_Application APP WITH (NOLOCK) on APP.clientId = Ac.id
			INNER JOIN APP_BackupSetName B WITH (NOLOCK) on APP.backupSet = B.id
			INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) on SCP.componentNameId = APP.id AND SCP.attrName = 'Cloud Mode Enabled' and SCP.modified = 0 and SCP.attrVal = '1' AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')					-- get CV_SC_PROP_CLOUD_MODE_ENABLED='Cloud Mode Enabled' property from SubClientProp
			INNER JOIN	simInstalledPackages ip WITH (NOLOCK) ON ip.ClientId = AC.id AND ip.simPackageID = 1
			LEFT OUTER JOIN APP_ClientProp ACP WITH (NOLOCK) ON ACP.componentNameId = AC.id AND ACP.attrName = N'CCS Enabled' AND ACP.modified = 0
		WHERE (AC.status & 4096) = 4096														-- Laptop configured CV_STATUS_PERSONAL_WKSTN = 4096
			AND (B.status & 8) = 8														    -- default backupset CV_STATUS_DEFAULT = 8
			AND    B.id = APP.backupset
			AND    (APP.subclientStatus & 8) = 8
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CloudLaptopClientCCSCfgdView]'
END
GO

