

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ClientsWithOnlyFSCoreLaptopCCSCfgdView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientsWithOnlyFSCoreLaptopCCSCfgdView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientsWithOnlyFSCoreLaptopCCSCfgdView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientsWithOnlyFSCoreLaptopCCSCfgdView]
GO

delete from GXDBVersions where name = 'ClientsWithOnlyFSCoreLaptopCCSCfgdView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientsWithOnlyFSCoreLaptopCCSCfgdView', '1.1.4.7', 'ClientsWithOnlyFSCoreLaptopCCSCfgdView', '')
GO
	CREATE VIEW
		ClientsWithOnlyFSCoreLaptopCCSCfgdView
	AS
		SELECT
			c.id clientId,		-- clients with ONLY FS Core Laptop configurations
			CASE
				WHEN cp.id IS NULL THEN NULL		-- Client 'CCS Enabled' property not set
				ELSE TRY_CAST(cp.attrVal AS INT)	-- CCS enabled or disabled
			END ccsEnabled,
			(c.releaseId - 5) release,
			MAX(ip.HighestSP) servicePack
		FROM APP_Client c WITH(NOLOCK)
			INNER JOIN simInstalledPackages ip WITH(NOLOCK) ON
				ip.ClientId = c.id
				AND ip.simPackageID NOT IN (SELECT pkgId FROM dbo.ccsSupportedPackages() WHERE pkgType = 2)		-- 2 Optional Packages
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
			LEFT OUTER JOIN dbo.ccsSupportedPackages() sp ON
				sp.pkgType = 1		-- Core Packages only
				AND ip.simPackageID = sp.pkgId
				AND sp.pkgId = 1			-- N_WIN_PACKAGE_BASECLIENT
		WHERE
			(c.status & 4096) = 4096		-- Laptop Configuration
		GROUP BY
			c.id,
			cp.id,
			cp.attrVal,
			c.releaseId
		HAVING
			SUM(CASE WHEN sp.pkgId IS NOT NULL THEN 1 ELSE 0 END) = 1
			AND COUNT(DISTINCT ip.simPackageID) = 1							-- Looking for ONLY 1 package installed - FS CORE
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientsWithOnlyFSCoreLaptopCCSCfgdView]'
END
GO

