

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ClientScheduleCount.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientScheduleCount"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientScheduleCount]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientScheduleCount]
GO

delete from GXDBVersions where name = 'ClientScheduleCount' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientScheduleCount', '1.1.2.3', 'ClientScheduleCount', '')
GO
CREATE VIEW ClientScheduleCount
AS
	SELECT C.id clientId,
		C.NAME clientName,
		SUM([sched count]) [scheduleCount]
	FROM (
		SELECT SUM(T.SchedInitiate) [sched count],
			T.subclientId subclientId
		FROM (
			SELECT CASE P.freq_type
					WHEN 4
						THEN 1 * 30 --DAILY SCHEDULE
					WHEN 8
						THEN --WEEKLY
							(freq_interval & 1 + (freq_interval & 2) / 2 + (freq_interval & 4) / 4 + (freq_interval & 8) / 8 + (freq_interval & 16) / 16 + (freq_interval & 32) / 32) * 4
					WHEN 16
						THEN 1 --MONTHLY SCHEDULE
					WHEN 32
						THEN 1 --MONTHLY ON LAST/FIRST...
					WHEN 64
						THEN CASE P.freq_recurrence_factor
								WHEN DATEPART(mm, GetDate())
									THEN 1
								ELSE 0
								END --YEARLY SCHEDULE
					ELSE 0
					END SchedInitiate,
				CC.subclientId,
				CC.scheduleId
			FROM SubClientSchedules CC
			INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)
				ON PA.subTaskId = CC.scheduleId
			INNER JOIN TM_Pattern P WITH(NOLOCK)
				ON P.patternId = PA.patternId
			) T
		GROUP BY T.subclientId
		) X
	INNER JOIN APP_Application APP WITH(NOLOCK)
		ON APP.id = X.subclientId
	INNER JOIN APP_Client C WITH(NOLOCK)
		ON C.id = APP.clientId
	GROUP BY C.id,
		C.NAME
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientScheduleCount]'
END
GO

