

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ClientOSNameView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientOSNameView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientOSNameView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientOSNameView]
GO

delete from GXDBVersions where name = 'ClientOSNameView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientOSNameView', '1.1.2.7', 'ClientOSNameView', '')
GO
-- Duncan V11 SP11:
-- * No need to test for CV_STATUS_NON_NDMP (0x8000000). That bit will be set for any NAS client that
--   has the FS iDA under it - including clients which have the NDMP iDA. So that
--   code will make a NAS client behave differently if it happens to have the FS iDA as well as NDMP.
-- * New NAS clients will now get the "Sim OS Info" client property. And existing NAS clients will get updated as they run backups.
-- * No need to test for CV_STATUS_UNINSTALLED (c.status & 2) - whether it is deconfigured or not does not
--   change whether it is NAS. And the NAS osName is the same regardless of whether it is deconfigured
-- * Some rows in the simOperatingSystem with a 'NAS' subtype do NOT have a type of 'Any' - they have a type of 'Windows'
--   Only NetApp has a type of 'Any'
--
-- Duncan V11 SP20
-- * Adding Dell EMC PowerStore file server similar to the Unity.
-- * Currently the design is to not share the same OS (17) as the Celerra, VNX, and Unity file servers.
--   The simOperatingSystem table Name for OS 17 is "Unity/VNX/Celerra" - I really don't want to add "PowerStore" to this name.
--   Even if we don't add PowerStore to this name, this name is ugly and it is simple to make it better.
-- * The "Sim OS Info" client property is populated with the better OS name - i.e. "Dell EMC Unity" or "Dell EMC PowerStore"
--   This is true for all file servers.
-- * So we should always use the "Sim OS Info" if it is populated. This simplifies the code removing one special case for NDMP.
CREATE VIEW
	ClientOSNameView
AS
	SELECT
		q.clientId,
		CASE
			-- First "WHEN": if we do not have the version from NDMP (osRel), but we know it is Isilon from array management, without this first WHEN we will incorrectly show "NAS Filer" instead of "Isilon"
			WHEN q.isNAS = 1 AND (q.osRel = N'') AND (q.simOSName = N'NAS Filer') AND (q.osName IS NOT NULL) AND (q.osName <> N'') THEN q.osName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')
			WHEN q.isNAS = 1 AND ((q.osRel IS NULL) OR (q.osRel = N'')) THEN q.simOSName + N'' + ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = q.clientId), '')
			WHEN q.osName IS NULL OR q.osName = N'' THEN q.simOSName + q.osRel
			ELSE q.osName + q.osRel
		END osName
	FROM
		(
			SELECT
				c.id clientId,
				c.status,
				SUBSTRING(cp.attrVal, 0, CHARINDEX(N':-', cp.attrVal, 0)) osName,
				ISNULL((CASE (CHARINDEX(N'Windows', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END))
								+ CHARINDEX(N'Any', (CASE WHEN cp.attrVal IS NULL OR cp.attrVal = N'' THEN os.name ELSE cp.attrVal END)))
						WHEN 0 THEN N' ' +
									SUBSTRING(
										SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))),
										0,
										CHARINDEX(N':-', SUBSTRING(cp.attrVal, CHARINDEX(N':-', cp.attrVal) + 2, LEN(cp.attrVal) - LEN(CHARINDEX(N':-',cp.attrVal))), 0)
									)
						ELSE ''
					END), '') osRel,
				ISNULL(os.name, N'') simOSName,
				CASE
					-- WHEN os.Type = N'Any' AND os.SubType = N'NAS'  AND (c.status & 2) <> 2 THEN 1
					WHEN os.SubType = N'NAS' THEN 1
					ELSE 0
				END isNAS
			FROM
				APP_Client c WITH(READUNCOMMITTED)
				LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
					cp.componentNameId = c.id
					AND cp.attrName = N'Sim OS Info'
					AND cp.modified = 0
					AND cp.attrVal <> N''
				LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
					os.id = c.simOperatingSystemId
		) q
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientOSNameView]'
END
GO

