SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningRestores.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningRestores"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningRestores]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningRestores]
GO

delete from GXDBVersions where name = 'RunningRestores' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningRestores', '1.39', 'RunningRestores', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
CREATE VIEW dbo.RunningRestores
AS
	SELECT jobID = JMJobInfo.jobId,
		opType = CASE WHEN JMJobInfo.subOpType > 0 THEN JMJobInfo.subOpType ELSE JMJobInfo.opType END,
		userId,
		JMJobInfo.commCellId,
		srcClientId,
		destClientId,
		JMRstJobInfo.appType,
		JMRstJobInfo.instanceID,
		JMRstJobInfo.bkpSetID,
		state,
		displayState,
		clientPriority,
		opPriority,
		appPriority,
		combPriority,
		currentPhase,
		jobStartTime,
		attemptStartTime,
		elapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + elapsedTime ELSE elapsedTime END,
		jobElapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + jobElapsedTime ELSE jobElapsedTime END,
		startAttempts,
		runAttempts,
		CASE WHEN state = 1 THEN preemptable
		WHEN state = 2 OR state = 3 OR state = 15 OR state = 16 THEN 1
		ELSE 0
		END AS isPreemptable,
		totCompBytes,
		totUnCompBytes,
		totSuccess,
		totFailures,
		totSkipped,
		totFiles2Xfer,
		totBytes2Xfer,
		initFrom,
		pendingCause,
		errorType,
		guiAlertColorLevel,
		timeToComplete,
		percentcomplete,
		lastUpdateFromClient,
		lastStateChangeTime,
		noOfGUIMonitors,
		isScheduledAlert,
		jobBasedAlertId,
		maxRestarts,
		restartInterval,
		rstTaskID,
		rstattributes,
		taskId = (ISNULL(T.taskId, 0)),
		subTaskName = (ISNULL(ST.subTaskName, '')),
		taskName = (ISNULL(T.taskName, '')),
		[UserName] = CASE WHEN dmUserName IS NOT NULL AND LEN(CAST(dmUserName AS VARCHAR)) <> 0 THEN dmUserName
				ELSE ISNULL((SELECT login FROM UMUsers WHERE id = userId),'') END,
		alertName,
		srcClientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = srcClientId),
		destClientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = destClientId),
		appTypeName = (SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = JMRstJobInfo.appType),
		instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = JMRstJobInfo.instanceID),
		backupSetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = JMRstJobInfo.bkpSetID),
		ISNULL(libraryList,'') AS libraryList,
		ISNULL(driveList,'') AS driveList,
		failureReason,
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = failureReason) AS DelayReason,
		--dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		foreignToken,
		currentPhaseName,
		ISNULL(curDatabase,'') AS curDatabase,
		ISNULL(mediaAgent,'') AS mediaAgent,
		ISNULL(shortMediaAgent,'') AS shortMediaAgent,
		activeFile,
		dbo.JMGetKBArticlesForFailures( failureReason, 0 ) AS failureKBArticle,
		jobDescription,
		xmlJobInfo
	FROM JMJobInfo
	INNER JOIN JMRstJobInfo ON
	JMRstJobInfo.jobId = JMJobInfo.jobId
	LEFT OUTER JOIN TM_SubTask ST ON
	JMRstJobInfo.rstTaskID = ST.subTaskId
	LEFT OUTER JOIN TM_Task T ON
	ST.taskId = T.taskId
	WHERE 0 = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningRestores]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningAdminJobs.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningAdminJobs"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningAdminJobs]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningAdminJobs]
GO

delete from GXDBVersions where name = 'RunningAdminJobs' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningAdminJobs', '1.67', 'RunningAdminJobs', '')
GO
CREATE VIEW dbo.RunningAdminJobs
AS
	SELECT jobID = JMJobInfo.jobId,
		opType = CASE WHEN JMJobInfo.subOpType > 0 THEN JMJobInfo.subOpType ELSE JMJobInfo.opType END,
		JMJobInfo.userId,
		JMJobInfo.commCellId,
		clientId = CASE WHEN JMAdminJobInfoTable.opType IN(90, 108) THEN ISNULL(JMAdminJobInfoTable.cloudId,0) ELSE ISNULL(APP_Application.clientId,0) END,
		appType = ISNULL(APP_Application.appTypeId,0),
		instance = ISNULL(APP_Application.instance,0),
		backupset = ISNULL(APP_Application.backupSet,0),
		appId = ISNULL(JMAdminJobInfoTable.appID,0),
		archGrpID,
		archGrpCopyID,
		state,
		displayState,
		clientPriority,
		opPriority,
		appPriority,
		combPriority,
		currentPhase,
		jobStartTime,
		attemptStartTime,
		elapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + elapsedTime ELSE elapsedTime END,
		jobElapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + jobElapsedTime ELSE jobElapsedTime END,
		startAttempts,
		runAttempts,
		initFrom,
		pendingCause,
		errorType,
		guiAlertColorLevel,
		CASE WHEN state = 1 THEN preemptable
		WHEN state = 2 OR state = 3 OR state = 15 OR state = 16 THEN 1
		ELSE 0
		END AS isPreemptable,
		percentcomplete,
		timeToComplete,
		lastUpdateFromClient,
		lastStateChangeTime,
		noOfGUIMonitors,
		isScheduledAlert,
		jobBasedAlertId,
		AP_NumDays,
		AP_IsForecast,
		AP_SeqNum,
		ER_BkpLevel,
		ER_SendCount,
		TotalObjects,
		ObjectsDone,
		ObjectsFailed,
		TotalSize,
		JMAdminJobInfoTable.LibraryID,
		MI_InventoryType,
		currentWriteTime,
		noOfStreams,
		noOfStreamsAllocated = CASE
			WHEN JMAdminJobInfoTable.opType = 104
			THEN ISNULL((SELECT COUNT(DISTINCT AJS.StreamReaderId)
				FROM ArchJobStreamStatus AJS WITH (NOLOCK), JMJobStreams JS WITH (NOLOCK)
				WHERE AJS.jobId = JMAdminJobInfoTable.jobId
					AND AJS.DestRCId = JS.destRcId
					AND AJS.DestReservationId = JS.destReservationId
					AND JS.commCellId = JMAdminJobInfoTable.commCellId
					AND AJS.StreamReaderId > 0
					AND AJS.status IN ( 1, 2 /*STREAM_READER_STATUS_RESERVED, STREAM_READER_STATUS_INITED*/ )
					AND JS.status = 1 /*STREAMACTIVE*/ ), 0)
			ELSE noOfStreamsAllocated END,
		maxRestarts,
		restartInterval,
		embeddedObjects,
		JMAdminJobInfoTable.uncompBytes,
		JMAdminJobInfoTable.nwTransBytes,
		JMAdminJobInfoTable.numFiles,
		JMAdminJobInfoTable.skippedItems,
		JMAdminJobInfoTable.writeTime,
		drivePoolId,
		mediaId,
		sourceJobId,
		JMAdminJobInfoTable.reportType,
		JMAdminJobInfoTable.reportSetId,
		JMAdminJobInfoTable.cloudId,
		fromTime,
		toTime,
		JMAdminJobInfoTable.subTaskId,
		currentThroughput = (SELECT ISNULL(SUM(throughput), 0) FROM JMJobStreams(NOLOCK) WHERE jobId = JMAdminJobInfoTable.jobId AND commCellId = JMAdminJobInfoTable.commCellId AND status = 1/*STREAMACTIVE*/),
		averageThroughput = (
								SELECT
								CASE WHEN J.writeTime > 0 then J.unCompBytes/J.writeTime
								ELSE 0 END
								FROM
								(
									SELECT ISNULL(JMAdminJobInfoTable.objectsDone, 0) as unCompBytes,
									CASE WHEN state = 1/*Running*/ THEN ISNULL((dbo.GetUnixTime(GETUTCDATE()) - JMJobInfo.attemptStartTime), 0)
									ELSE 0 END
									+ ISNULL((SELECT SUM(writeTime) FROM JMAdminJobAttemptInfoTable(NOLOCK) WHERE
									JMAdminJobAttemptInfoTable.jobId = JmJobInfo.jobId AND JMAdminJobAttemptInfoTable.commCellId = JmJobInfo.commCellId ), 0) AS writeTime
								) J
							),
		taskId = (ISNULL(T.taskId, 0)),
		subTaskName = (ISNULL(ST.subTaskName, '')),
		taskName = (ISNULL(T.taskName, '')),
		storagePolicyName = CASE
			WHEN archGrpID = 0 THEN ''
			WHEN archGrpID = 1 THEN ''
			ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = archGrpID),'Unavailable')
			END,
		CopyName = CASE
			WHEN archGrpCopyID = 0 THEN 'All Copies'
			ELSE ISNULL((SELECT name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = archGrpCopyID),'Unavailable')
			END,
		LibraryName = CASE
			WHEN LibraryID = 0 THEN ''
			ELSE ISNULL((SELECT AliasName FROM MMLibrary WITH (READUNCOMMITTED) WHERE MMLibrary.LibraryId = JMAdminJobInfoTable.LibraryID),'Unavailable')
			END,
		DrivePoolName = CASE
			WHEN JMAdminJobInfoTable.drivePoolId = 0 THEN ''
			ELSE ISNULL((SELECT DrivePoolName FROM MMDrivePool WITH (READUNCOMMITTED) WHERE MMDrivePool.DrivePoolId = JMAdminJobInfoTable.drivePoolId),'Unavailable')
			END,
		ISNULL((SELECT login FROM UMUsers WHERE id = userId),'') AS [UserName],
		alertName,
		libraryList,
		driveList,
		clientName = CASE
			WHEN JMAdminJobInfoTable.opType IN(90, 108) THEN ISNULL((SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = JMAdminJobInfoTable.cloudId),'')
			WHEN JMAdminJobInfoTable.appID = 0 THEN ''
			ELSE ISNULL((SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = APP_Application.clientId),'') END,
		appTypeName = CASE WHEN JMAdminJobInfoTable.appID = 0 THEN '' ELSE ISNULL((SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = APP_Application.appTypeId),'') END,
		instanceName = CASE WHEN JMAdminJobInfoTable.appID = 0 THEN '' ELSE ISNULL((SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = APP_Application.instance),'') END,
		backupSetName = CASE WHEN JMAdminJobInfoTable.appID = 0 THEN '' ELSE ISNULL((SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = APP_Application.backupSet),'') END,
		subclientName = ISNULL(APP_Application.subclientName,''),
		MediaName = CASE
			WHEN JMAdminJobInfoTable.mediaId = 0 THEN ''
			ELSE ISNULL((SELECT BarCode FROM MMMedia WITH (READUNCOMMITTED) WHERE MMMedia.MediaId = JMAdminJobInfoTable.mediaId),'Unavailable')
			END,
		MediaUniqueId = CASE
			WHEN JMAdminJobInfoTable.mediaId = 0 THEN ''
			ELSE ISNULL((SELECT UniqueId FROM MMMedia WITH (READUNCOMMITTED) WHERE MMMedia.MediaId = JMAdminJobInfoTable.mediaId),'Unavailable')
			END,
		ER_DbName,
		ER_Destination,
		ER_MediasUsed,
		failureReason,
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = failureReason) AS DelayReason,
		--dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		currentPhaseName,
		srcMediaAgent,
		destMediaAgent,
		ISNULL(shortMediaAgent,'') AS shortMediaAgent,
		cloudName = CASE
			WHEN JMAdminJobInfoTable.opType = 90 THEN ''
			WHEN JMAdminJobInfoTable.cloudId = 0 THEN ''
			WHEN JMAdminJobInfoTable.opType IN (31, 13, 104) THEN ISNULL((SELECT SIDBStoreAliasName FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = JMAdminJobInfoTable.cloudId AND SIDBStoreId <> 0), '')
			WHEN JMJobInfo.subOpType = 103 THEN ISNULL((DC.name),'')
			ELSE ISNULL(( CP.stringVal),'')
			END,
		foreignToken,
		dbo.JMGetKBArticlesForFailures( failureReason, 0 ) AS failureKBArticle,
		JMAdminJobInfoTable.reportName,
		JMAdminJobInfoTable.reportSetName,
		jobDescription,
		xmlJobInfo,
		activeFile,
		workflowName = CASE WHEN JMAdminJobInfoTable.opType = 90 THEN ISNULL((SELECT dbo.DecodeInvalidXMLChar(Name) from WF_Definition WITH (READUNCOMMITTED) where WorkflowId = JMAdminJobInfoTable.workFlowId),'') ELSE '' END,
		currentActivityMsg = CASE WHEN JMAdminJobInfoTable.opType = 89 THEN ISNULL((SELECT attributeValue FROM JMJobOptions WITH (READUNCOMMITTED) WHERE jobId = JMAdminJobInfoTable.jobId AND commCellId = JMAdminJobInfoTable.commCellId AND attributeName = 'Current Activity'), '') ELSE '' END
	FROM JMJobInfo
	INNER JOIN JMAdminJobInfoTable ON
	JMAdminJobInfoTable.jobId = JMJobInfo.jobId
	LEFT JOIN APP_Application ON
	JMAdminJobInfoTable.appID = APP_Application.id
	LEFT JOIN DM2Cloud DC WITH (NOLOCK) ON
	DC.cloudId = JMAdminJobInfoTable.cloudId
	LEFT JOIN app_componentProp CP WITH (NOLOCK) ON
	CP.ID= JMAdminJobInfoTable.cloudId and componentId=2 AND propertyTypeId=1 AND CP.modified=0
	LEFT OUTER JOIN TM_SubTask ST ON
	JMAdminJobInfoTable.subTaskId = ST.subTaskId
	LEFT OUTER JOIN TM_Task T ON
	ST.taskId = T.taskId
	WHERE JMJobInfo.opType NOT IN (39,33)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningAdminJobs]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningBackups.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningBackups"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningBackups]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningBackups]
GO

delete from GXDBVersions where name = 'RunningBackups' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningBackups', '1.62', 'RunningBackups', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
  --- JMBKP_SINGLE_INSTENCE_SILO 0x100000000LL
CREATE VIEW dbo.RunningBackups
AS
	SELECT jobID = JMJobInfo.jobId,
		opType = CASE WHEN subOpType > 0 THEN subOpType ELSE opType END,
		userId,
		JMJobInfo.commCellId,
		APP_Application.clientId,
		APP_Application.appTypeId,
		APP_Application.instance,
		APP_Application.backupSet,
		applicationId,
		bkpLevel,
		secondaryBkpLevel,
		jobIdActedOn,
		fromTime,
		toTime,
		state,
		displayState,
		clientPriority,
		opPriority,
		appPriority,
		combPriority,
		currentPhase,
		jobStartTime,
		attemptStartTime,
		elapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + elapsedTime ELSE elapsedTime END,
		jobElapsedTime = CASE WHEN attemptStartTime > 0 THEN dbo.GetUnixTime(GETUTCDATE()) - attemptStartTime + jobElapsedTime ELSE jobElapsedTime END,
		startAttempts,
		runAttempts,
		initFrom,
		pendingCause,
		errorType,
		guiAlertColorLevel,
		numStreams,
		numStreamsAllocated,
		maxRestarts,
		restartInterval,
		currentPolicy,
		filesToXfer,
		filesXfered,
		uncompBytes,
		compBytes,
		CASE WHEN state = 1 THEN preemptable
		WHEN state = 2 OR state = 3 OR state = 15 OR state = 16 THEN 1
		ELSE 0
		END AS isPreemptable,
		percentcomplete,
		bkpOptions,
		bkpattributes,
		scanType,
		scanFileFailures,
		scanFolderFailures,
		backupFileFailures,
		backupFolderFailures,
		oraSubLevel,
		lastUpdateFromClient,
		lastStateChangeTime,
		noOfGUIMonitors,
		isScheduledAlert,
		jobBasedAlertId,
		totalMediaUsageTime,
		currentThroughput,
		averageThroughput,
		filesIndexed,
		filesFailedToIndex,
		filesSkippedForIndex,
		contentIndexDBSize,
		timeToComplete,
		backupTaskId,
		cloudId,
		retentionFlags = (SELECT ISNULL(MAX(retentionFlags),0) from JMJobCopyInfo where JMJobCopyInfo.jobId = JMJobInfo.jobId),
		snapJobID = CASE
			WHEN JMJobInfo.opType <> 60 THEN 0
			ELSE ISNULL((SELECT processedJobId from JMJobWF where JMJobWF.childJobId = JMJobInfo.jobId AND JMJobWF.commcellId = JMJobInfo.commCellId),0)
			END,
		snapWFJobID = CASE
			WHEN JMJobInfo.opType <> 60 THEN 0
			ELSE ISNULL((SELECT jobId from JMJobWF where JMJobWF.childJobId = JMJobInfo.jobId AND JMJobWF.commcellId = JMJobInfo.commCellId), 0)
			END,
		currentContext,
		nwTransBytes,
		totSkippedObjects,
		bkpAttributesEx,
		jobReferenceTime,
		sidbStoreId = (ISNULL((SELECT intData FROM JMMisc MISC WHERE MISC.jobId = JMJobInfo.jobId AND MISC.commcellId = JMJobInfo.commcellId AND MISC.itemType = 25), 0)),
		taskId = (ISNULL(T.taskId, 0)),
		subTaskName = (ISNULL(ST.subTaskName, '')),
		taskName = (ISNULL(T.taskName, '')),
		sidbStoreName = ((ISNULL((SELECT data FROM JMMisc MISC WHERE MISC.jobId = JMJobInfo.jobId AND MISC.commcellId = JMJobInfo.commcellId AND MISC.itemType = 25), ''))),
		currentPolicyName = CASE
			WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = currentPolicy),'Unavailable')
			WHEN currentPolicy = 0 THEN ''
			ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = currentPolicy),'Unavailable')
			END,
		ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = userId),'') AS [UserName],
		alertName,
		clientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = (CASE
																						WHEN JMBkpJobInfo.bkpattributes & 0x100000000 = 0x100000000 THEN JMBkpJobInfo.targetClientId
																						WHEN JMBkpJobInfo.bkpattributesEx & 0x200 = 0x200 THEN JMBkpJobInfo.targetClientId
																					 ELSE APP_Application.clientId END)),
		appTypeName = (SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = APP_Application.appTypeId),
		instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = APP_Application.instance),
		backupSetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = APP_Application.backupSet),
		APP_Application.subclientName,
		libraryList,
		driveList,
		failureReason,
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = failureReason) AS DelayReason,
		--dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		scanTypeChangeReason AS [ScanTypeChangeReasonId],
		(SELECT localisedMessage FROM JMFailureReasonLocaleMsgCache where jobID = JMJobInfo.jobID AND commCellId = JMJobInfo.commCellId AND reasonCode = scanTypeChangeReason) AS scanTypeChangeReason,
		--dbo.JMGetLocalizedMessageFunc(0,scanTypeChangeReason) AS [ScanTypeChangeReason],
		currentPhaseName,
		mediaAgentName,
		ISNULL(shortMediaAgent,'') AS shortMediaAgent,
		activeFile,
		cloudName = CASE
			WHEN cloudId = 0 THEN ''
			ELSE ISNULL((SELECT stringVal from app_componentProp WITH (READUNCOMMITTED) where id = cloudId and componentId=2 AND propertyTypeId=1 AND modified=0),'')
			END,
		foreignToken,
		dbo.JMGetKBArticlesForFailures(failureReason, 0) AS [failureKBArticle],
		jobDescription,
		xmlJobInfo
	FROM JMJobInfo
	INNER JOIN JMBkpJobInfo ON
	JMBkpJobInfo.jobId = JMJobInfo.jobId
	INNER JOIN APP_Application ON
	JMBkpJobInfo.applicationId = APP_Application.id
	LEFT OUTER JOIN TM_SubTask ST ON
	JMBkpJobInfo.backupTaskId = ST.subTaskId
	LEFT OUTER JOIN TM_Task T ON
	ST.taskId = T.taskId
	WHERE 0 = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningBackups]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/MMS2getMountPathList.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: MMS2getMountPathList"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2getMountPathList]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[MMS2getMountPathList]
GO

delete from GXDBVersions where name = 'MMS2getMountPathList' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'MMS2getMountPathList', '1.6', 'MMS2getMountPathList', '')
GO
CREATE VIEW
	MMS2getMountPathList
WITH ENCRYPTION
AS
SELECT	DISTINCT MP.MountPathId, MS.MediaId, MP.MediaSideId, MP.MasterPoolId, MP.LibraryId, MP.MountPathTypeId,
		ISNULL(MPSD.DeviceId, 0) AS DeviceId,
		ISNULL(MPSD.CenteraId, 0) AS CenteraId,
		ISNULL(MPDC.DeviceControllerId, 0) AS DeviceControllerId,
		ISNULL(MD.DeviceTypeId, 0) AS DeviceTypeId,
		CASE WHEN MPDC.ClientId IS NULL THEN (SELECT TOP 1 ClientId FROM MMLibraryController WHERE LibraryId = MP.LibraryId)
			 ELSE MPDC.ClientId
			 END AS ClientId,
		CASE WHEN MPSD.DeviceId is null then MP.MountPathName
			 WHEN MP.MountPathTypeId = 1 /* MOUNT_PATH_CENTERA */
			 THEN ISNULL(
					(SELECT TOP 1 A.FriendlyName
						FROM MMCenteraInfo A INNER JOIN MMMountPathToStorageDevice B
						ON A.CenteraId = B.CenteraId
						WHERE B.MountPathId = MP.MountPathId),
					'Unavailable')
			 WHEN (MPDC.DeviceAccessType & 16>0 /* DATASERVER_IP_DEVICEACCESS */ OR  MPDC.DeviceAccessType & 32>0 /*DATASERVER_SAN_DEVICEACCESS*/ OR MPDC.DeviceAccessType & 128>0 /*DATASERVER_ISCSI_DEVICEACCESS*/ )
			 THEN dbo.MMS2FUNC_GetSharedMountPath(MPDC.DeviceId,0) /*1 = get only path, 0 = get path in following format IP/SAN|<path>|<MA>*/
			 ELSE MPDC.Folder
			 END AS MountPathName,
		MP.UserName, MP.UserPassword, MP.IsEnabled, MP.NumberOfWriters, MP.MaxConcurrentWriters, MP.CurrentFileMarker,
		MP.IsOffline, MP.OfflineReason, MP.OffLineTimeStamp, MP.origCCcommCellID, MP.origCCmediaSideID,
		MP.MaxDataToWriteMB, MP.MagneticSpaceRsrvInMB, MP.Attribute, MP.RMStatus, MP.RMStatusUpdateTime,
		MP.OrigCCMountPathId, MP.MagneticChunkFileIncrSizeMB, MP.MountPathOfflineReasonEventId
FROM	MMMountPath MP inner join MMMediaSide MS on MP.MountPathId > 0 and MP.MediaSideId = MS.MediaSideId
		left outer join MMMountPathToStorageDevice MPSD on MP.MountPathId = MPSD.MountPathId
		left outer join MMDeviceController MPDC on MPSD.DeviceId = MPDC.DeviceId
		left outer join MMDevice as MD on MD.DeviceId = MPDC.DeviceId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [MMS2getMountPathList]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ActiveStreams.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ActiveStreams"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ActiveStreams]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ActiveStreams]
GO

delete from GXDBVersions where name = 'ActiveStreams' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ActiveStreams', '1.30', 'ActiveStreams', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display the active streams
CREATE VIEW dbo.ActiveStreams
AS
        SELECT jobID = JS.jobId,
        JS.commCellId,
        JS.destRcId,
        JS.destReservationId,
        JS.srcRcId,
        JS.srcReservationId,
        JS.archGrpId,
        JS.destCopyId,
        JS.srcCopyId,
        JS.status,
        JS.streamNum,
		JS.destStreamNum,
        isPrimary,
        JS.guiAlertColorLevel,
        unCompBytes,
        compBytes,
        nwTransBytes,
        writeTime,
        committedUncompBytes,
        committedCompBytes,
        committedWriteTime,
        numFiles,
        numFolders,
        numFailures,
        numSkipped,
        phaseNumber,
        attemptNumber,
        throughput,
        totalToCopy = CASE WHEN JI.opType = 104 AND JS.status = 7/*Completed*/ THEN unCompBytes
						   WHEN JI.opType = 31 AND JI.subOpType = 106 AND JS.status = 7/*Completed*/ THEN compBytes
						   WHEN JI.opType = 104 THEN
						   ISNULL((Select AJS.TotalSizeToProcess From ArchJobStreamStatus AJS(NOLOCK) Where JS.jobId = AJS.JobId AND JS.destRcId = AJS.DestRCId And JS.destReservationId = AJS.DestReservationId) ,JS.totalToCopy)
						   WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
						   ISNULL((Select AJS.TotalSizeToProcess From ArchJobStreamStatus AJS(NOLOCK) Where JS.jobId = AJS.JobId AND JS.SrcRCId = AJS.srcRcId And JS.SrcReservationId = AJS.srcReservationId) ,JS.totalToCopy)
						   ELSE JS.totalToCopy END,
        embeddedObjects,
        compScheme,
		destDriveName,
		srcDriveName = CASE WHEN JS.srcReservationId = 0 AND JI.opType = 104 THEN
							ISNULL((
									select TOP 1 list.MountPathName
									From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMMountPath path WITH (NOLOCK), MMS2getMountPathList list with (NOLOCK)
									Where stream.JobId = JS.JobId And stream.DestRCId = JS.destRcId And stream.DestReservationId = JS.destReservationId
									AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = side.MediaId AND side.MediaSideId = path.MediaSideId
									AND	stream.srcMAId = list.ClientId AND path.MountPathId = list.MountPathId
									), '')
							WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
							ISNULL((
									select TOP 1 list.MountPathName
									From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMMountPath path WITH (NOLOCK), MMS2getMountPathList list with (NOLOCK)
									Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
									AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = side.MediaId AND side.MediaSideId = path.MediaSideId
									AND	stream.srcMAId = list.ClientId AND path.MountPathId = list.MountPathId
									), '')
						ELSE srcDriveName END,
        archGrpName = CASE JS.archGrpId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroup WHERE id = JS.archGrpId),'Unavailable') END,
        destCopyName = CASE JS.destCopyId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroupCopy WHERE id = JS.destCopyId),'Unavailable') END,
        srcCopyName = CASE JS.srcCopyId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroupCopy WHERE id = JS.srcCopyId),'Unavailable') END,
		(CASE
			WHEN JI.opType = 104 THEN
				ISNULL((SELECT	TOP 1 CAST(R.backupJobId AS varchar(1024))
						FROM	ArchJobStreamStatus AJS, ArchChunkToReplicate R
						WHERE	AJS.JobId = R.AdminJobId AND AJS.SegmentId = R.segmentId
								AND JS.jobId = AJS.JobId AND JS.commCellId = AJS.CommCellId AND JS.destRcId = AJS.DestRCId
								ORDER BY R.Modified DESC), '')
			WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
				ISNULL((SELECT	TOP 1 CAST(V.backupJobId AS varchar(1024))
						FROM	ArchJobStreamStatus AJS, ArchChunkToVerify2 V
						WHERE	AJS.JobId = V.AdminJobId AND AJS.SegmentId = V.segmentId
								AND JS.jobId = AJS.JobId AND JS.commCellId = AJS.CommCellId AND JS.srcRcId = AJS.srcRcId
								ORDER BY V.Modified DESC), '')
			ELSE ''
		END)AS BackupJobId,
        destMedAgent,
        srcClient,
        JS.restartString,
        JS.activeFile,
        JS.failureReason,
		srcBarCode = CASE WHEN len(JS.srcBarCode) = 0 AND JS.srcReservationId = 0 AND JI.opType = 104 THEN
						ISNULL((select TOP 1 media.Barcode
								From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMedia media WITH (NOLOCK)
								Where stream.JobId = JS.JobId And stream.DestRCId = JS.destRcId And stream.DestReservationId = JS.destReservationId
								AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = media.MediaId
								), '')
						WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
						ISNULL((select TOP 1 media.Barcode
								From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMedia media WITH (NOLOCK)
								Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
								AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = media.MediaId
								), '')
						ELSE srcBarCode END,
        destBarCode,
        dbo.JMGetLocalizedMessageFunc(0,JS.failureReason) AS [DelayReason],
        dbo.JMGetKBArticlesForFailures(JS.failureReason, 0) AS failureKBArticle
        FROM JMJobStreams JS INNER JOIN JMJobInfo(NOLOCK) JI
        ON JS.JobId = JI.JobId And JS.commCellId = JI.commCellId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ActiveStreams]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ActiveBackupAttempts.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ActiveBackupAttempts"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ActiveBackupAttempts]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ActiveBackupAttempts]
GO

delete from GXDBVersions where name = 'ActiveBackupAttempts' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ActiveBackupAttempts', '1.3', 'ActiveBackupAttempts', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display the active streams
CREATE VIEW dbo.ActiveBackupAttempts
AS
SELECT jobId, commCellId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, unCompBytes, compBytes, numFiles,
writeTime, attributes, numFolders, archGrpId, copyId, maxStreamsUsed, failureReason,
dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason], phaseName, archGroupName, copyName, mediaAgent,
libraryName, drivePoolName, dbo.JMGetKBArticlesForFailures(failurereason,0) AS failureKBArticle, restartString
FROM JMBkpAttemptInfo
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ActiveBackupAttempts]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ActiveRestoreAttempts.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ActiveRestoreAttempts"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ActiveRestoreAttempts]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ActiveRestoreAttempts]
GO

delete from GXDBVersions where name = 'ActiveRestoreAttempts' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ActiveRestoreAttempts', '1.3', 'ActiveRestoreAttempts', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display the active streams
CREATE VIEW dbo.ActiveRestoreAttempts
AS
SELECT jobID, commCellId, attemptNum, phaseNum, status, numSuccess_h, numSuccess_l, numFailures_h, numFailures_l, compBytes_h,
compBytes_l, uCompBytes_h, uCompBytes_l, elapsedTime, startTime, endTime, numSkipped, failureReason,
dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason], phaseName,
dbo.JMGetKBArticlesForFailures(failurereason,0) AS failureKBArticle
FROM JMRstAttemptInfo
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ActiveRestoreAttempts]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ActiveAdminAttempts.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ActiveAdminAttempts"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ActiveAdminAttempts]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ActiveAdminAttempts]
GO

delete from GXDBVersions where name = 'ActiveAdminAttempts' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ActiveAdminAttempts', '1.4', 'ActiveAdminAttempts', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display the active streams
CREATE VIEW dbo.ActiveAdminAttempts
AS
SELECT jobID, commCellId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, writeTime, embeddedObjects, uncompBytes, numFiles, skippedItems, failureReason,
dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason], phaseName,
dbo.JMGetKBArticlesForFailures(failurereason,0) AS failureKBArticle
FROM JMAdminJobAttemptInfoTable
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ActiveAdminAttempts]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningCDRJobs.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningCDRJobs"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningCDRJobs]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningCDRJobs]
GO

delete from GXDBVersions where name = 'RunningCDRJobs' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningCDRJobs', '1.29', 'RunningCDRJobs', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running continious data replication jobs
CREATE VIEW dbo.RunningCDRJobs
AS
SELECT  JMCdrJobs.jobId,
		JMCdrJobs.commCellId,
        JMCdrJobs.pairId,
        JMCdrJobs.currentStatus,
        JMCdrJobs.lastStateChangeTime,
        JMCdrJobs.lastUpdateTime,
        JMCdrJobs.clientStatusChangeTime,
        JMCdrJobs.unverifiable,
        JMCdrJobs.currentThroughput,
        JMCdrJobs.currentPhase,
        JMCdrJobs.currentAttempt,
        JMCdrJobs.currentSourceLogNumber,
        JMCdrJobs.currentDestinationLogNumber,
        JMCdrJobs.lastLoggedPlayedNumber,
        JMCdrJobs.lastLogPlayedTime,
        JMCdrJobs.bytesToTransfer,
        JMCdrJobs.bytesTransfered,
        JMCdrJobs.filesToTransfer,
		JMCdrJobs.filesTransfered,
        JMCdrJobs.bytesReplicated,
        JMCdrJobs.abortReason,
        JMCdrJobs.noOfGUIMonitors,
        APP_Application.clientId,
        APP_Application.backupSet,
        APP_Application.appTypeId,
        hostId = CAST( (SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = APP_Application.backupSet AND attrType = 7 AND attrName = 'FLR Destination HostId' AND modified = 0) AS INT ),
        ISNULL( (SELECT intVal from APP_SCreplicationPair where pairId = JMCdrJobs.pairId AND propType = 4 AND modified = 0), 0 ) AS replicationStartTime,
		replicationOptions = CAST( (SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = APP_Application.backupSet AND attrType = 7 AND attrName = 'FLR Replication Options' AND modified = 0) AS INT ),
		ISNULL((SELECT intVal FROM APP_ScReplicationPair WHERE APP_ScReplicationPair.pairId = JMCdrJobs.pairId AND modified = 0 AND propType = 10014), 0 ) AS failedFilesFlag,
        ISNULL( (SELECT [name] FROM APP_Client WHERE APP_Client.id = APP_Application.clientId), N'' ) AS clientName,
        ISNULL( (SELECT [name] FROM APP_BackupSetName WHERE APP_BackupSetName.id = APP_Application.backupSet), N'' ) AS backupsetName,
       (SELECT TOP 1 ida.displayName
		FROM LicUsage LU, simLicApptypeV2 SL, SimAppTypeLicTypeMap TL, APP_IdaType ida
			WHERE LU.CId = APP_Application.clientId AND LU.LicType NOT IN (71, 10, 26)
			AND TL.simLicAppType = SL.id and TL.appTypeId = APP_Application.appTypeId
			AND LU.appType = APP_Application.appTypeId AND LU.opType = 'Install'
			AND SL.id = LU.LicType AND TL.appTypeId = ida.type
		ORDER BY LU.id DESC) AS appTypeName,
        ISNULL( (SELECT stringVal FROM APP_ScReplicationPair WHERE APP_ScReplicationPair.pairId = JMCdrJobs.pairId AND modified = 0 AND propType = 10001), N'' ) AS sourcePath,
        ISNULL( (SELECT stringVal FROM APP_ScReplicationPair WHERE APP_ScReplicationPair.pairId = JMCdrJobs.pairId AND modified = 0 AND propType = 10002), N'' ) AS destinationPath,
        JMCdrJobs.currentFileBeingTransfered,
        ISNULL( (SELECT [name] FROM APP_Client WHERE id = CAST( (SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = APP_Application.backupSet AND attrType = 7 AND attrName = 'FLR Destination HostId' AND modified = 0) AS INT )), N'') AS hostName,
        JMCdrJobs.failureReason,
		dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		APP_Application.instance
FROM    JMCdrJobs INNER JOIN APP_Application ON JMCdrJobs.pairId = dbo.APP_Application.id and (dbo.APP_Application.subclientStatus&6 = 0)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningCDRJobs]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CDRJobAttempts.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CDRJobAttempts"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CDRJobAttempts]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CDRJobAttempts]
GO

delete from GXDBVersions where name = 'CDRJobAttempts' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CDRJobAttempts', '1.11', 'CDRJobAttempts', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
CREATE VIEW dbo.CDRJobAttempts
AS
SELECT dbo.JMCdrAttempts.jobId,
       dbo.JMCdrAttempts.phaseNum,
       dbo.JMCdrAttempts.attemptNum,
       dbo.JMCdrAttempts.status,
       dbo.JMCdrAttempts.startTime,
       dbo.JMCdrAttempts.endTime,
       elapsedTime = CASE WHEN dbo.JMCdrAttempts.endTime = 0 THEN dbo.GetUnixTime(GETUTCDATE()) - dbo.JMCdrAttempts.startTime
                     ELSE dbo.JMCdrAttempts.endTime - dbo.JMCdrAttempts.startTime
                     END,
       dbo.JMCdrAttempts.bytesToTransfer,
       dbo.JMCdrAttempts.dataTransfer AS dataTransfered,
       dbo.JMCdrAttempts.numberOfFilesToTransfer,
       dbo.JMCdrAttempts.noFilesTransfered,
       dbo.JMCdrAttempts.abortReason,
       dbo.JMCdrAttempts.averageThroughput,
       ISNULL((SELECT name FROM JMPhase WHERE JMPhase.phase = JMCdrAttempts.phaseNum AND dbo.JMPhase.opTableId IN (SELECT id FROM dbo.JMOpTable WHERE(appTypeType = 84) AND (operation = 56) ) ), N'') AS currentPhaseName,
       CASE WHEN dbo.JMCdrAttempts.status = 1  THEN 'Start Pending'
            WHEN dbo.JMCdrAttempts.status = 2  THEN 'Started'
            WHEN dbo.JMCdrAttempts.status = 3  THEN 'Paused'
            WHEN dbo.JMCdrAttempts.status = 4  THEN 'Pause pending'
            WHEN dbo.JMCdrAttempts.status = 5  THEN 'Resume pending'
            WHEN dbo.JMCdrAttempts.status = 6  THEN 'Stopped'
            WHEN dbo.JMCdrAttempts.status = 7  THEN 'Stop pending'
            WHEN dbo.JMCdrAttempts.status = 8  THEN 'Done'
            WHEN dbo.JMCdrAttempts.status = 9  THEN 'Failed'
            WHEN dbo.JMCdrAttempts.status = 10 THEN 'Failed'
            WHEN dbo.JMCdrAttempts.status = 11 THEN 'Aborting'
            WHEN dbo.JMCdrAttempts.status = 12 THEN 'Aborted'
            WHEN dbo.JMCdrAttempts.status = 13 THEN 'Success'
            ELSE 'Error'
       END AS currentStatusName,
       dbo.JMCdrAttempts.Id,
       dbo.JMCdrAttempts.commCellId,
       dbo.JMCdrAttempts.failureReason
FROM dbo.JMCdrAttempts
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CDRJobAttempts]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CDRJobStateInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CDRJobStateInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CDRJobStateInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CDRJobStateInfo]
GO

delete from GXDBVersions where name = 'CDRJobStateInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CDRJobStateInfo', '1.5', 'CDRJobStateInfo', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
CREATE VIEW dbo.CDRJobStateInfo
AS
SELECT dbo.JMCdrJobs.jobId,
       dbo.JMCdrJobs.pairId,
       dbo.JMCdrJobs.currentStatus,
       dbo.JMCdrJobs.lastStateChangeTime,
       dbo.JMCdrJobs.lastUpdateTime,
       dbo.JMCdrJobs.clientStatusChangeTime,
       dbo.JMCdrJobs.unverifiable,
       dbo.JMCdrJobs.currentThroughput,
       dbo.JMCdrJobs.currentPhase,
       dbo.JMCdrJobs.currentSourceLogNumber,
       dbo.JMCdrJobs.currentDestinationLogNumber,
       dbo.JMCdrJobs.lastLoggedPlayedNumber,
       dbo.JMCdrJobs.lastLogPlayedTime,
       dbo.JMCdrJobs.bytesToTransfer,
       CASE WHEN dbo.JMCdrJobs.currentPhase = 6 THEN dbo.JMCdrJobs.bytesReplicated
			ELSE dbo.JMCdrJobs.bytesTransfered
       END AS bytesTransfered,
       dbo.JMCdrJobs.abortReason,
       dbo.JMCdrJobs.filesToTransfer AS numberOfFilesToTransfer,
	   dbo.JMCdrJobs.filesTransfered AS numberOfFilesTransfered,
       dbo.JMCdrJobs.currentFileBeingTransfered
FROM   dbo.JMCdrJobs
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CDRJobStateInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/RunningJobs.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: RunningJobs"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RunningJobs]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[RunningJobs]
GO

delete from GXDBVersions where name = 'RunningJobs' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'RunningJobs', '1.1', 'RunningJobs', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display all the currently running backups
CREATE VIEW dbo.RunningJobs
AS
	SELECT jobId,
		opType,
		commCellId,
		commCellType = (select type from APP_CommCell where id = JMJobInfo.commCellId),
		combPriority,
		jobStartTime
	FROM JMJobInfo
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [RunningJobs]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNClientPatchInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNClientPatchInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNClientPatchInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNClientPatchInfoView]
GO

delete from GXDBVersions where name = 'CNClientPatchInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNClientPatchInfoView', '1.10', 'CNClientPatchInfoView', '')
GO
--Create the CNClientPatchInfoView
CREATE VIEW CNClientPatchInfoView
WITH ENCRYPTION
AS
        SELECT	ClientID = C.ID, PI1.simPackageID,
			ReleaseID = C.releaseId,
			BuildIDString = ISNULL(APC.attrVal, 'N/A'),
			ServicePack =
		CASE
			-- When all the rows for a given ClientID matches the SP (and the HighestSP is greather than 0)
			when min(HighestSP) = max(HighestSP) and min(HighestSP) > 0 then
				CASE
				when (select count(*) from simInstalledPackages PI2 where PI2.ClientID = PI1. ClientID AND PI2.simPackageID = PI1.simPackageID AND CONVERT(varchar(10), MissingPatches) <> N'' AND CONVERT(varchar(10), MissingPatches) <> N'None') > 0
					then 'SP' + cast( min(HighestSP) as varchar(20) ) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end + ' (Missing Patches)'
					else 'SP' + cast(min(HighestSP) as varchar(20)) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end
				END
			-- When the rows for a given ClientID DO NOT MATCH
			when max(HighestSP) > 0 then 'SP' + cast( max(HighestSP) as varchar(20) ) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end + '-'
			-- Otherwise (No rows, all rows have HighestSP equal to 0)
			else ''
		  END
	FROM		APP_Client AS C
			LEFT OUTER JOIN simInstalledPackages PI1
			ON C.ID = PI1.ClientID AND PI1.simPackageID NOT IN (51,1301,2003)
			LEFT OUTER JOIN APP_ClientProp AS APC
			ON C.ID = APC.componentNameId AND APC.attrName='Galaxy Build'
	GROUP BY 	C.ID, PI1.ClientID, PI1.simPackageID, C.releaseId,APC.attrVal
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNClientPatchInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNQNetAgentInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNQNetAgentInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNQNetAgentInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNQNetAgentInfoView]
GO

delete from GXDBVersions where name = 'CNQNetAgentInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNQNetAgentInfoView', '1.7', 'CNQNetAgentInfoView', '')
GO
--Create the CNQNetAgentInfoView
	CREATE VIEW
		CNQNetAgentInfoView
	WITH ENCRYPTION
	AS
	SELECT	CC.id			as ID,
		ISNULL((GXREL.release +  '.' + CPV.BuildIdString), 'N/A')
					as SWVersion,
		CPV.ServicePack		as ServicePack
	FROM	APP_CommCell as CC,
		APP_Client as C,
		SimAllGalaxyRel as GXREL,
		CNClientPatchInfoView as CPV
	WHERE
		    CC.id = 2
		and C.id = CC.clientId
		and CPV.ClientID = C.id
		and CPV.simPackageID = 804
		and GXREL.id = CPV.ReleaseID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNQNetAgentInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/NTnotificationsByUserView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: NTnotificationsByUserView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTnotificationsByUserView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[NTnotificationsByUserView]
GO

delete from GXDBVersions where name = 'NTnotificationsByUserView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'NTnotificationsByUserView', '1.4', 'NTnotificationsByUserView', '')
GO
--Create the NTnotificationsByUserView
    CREATE VIEW NTnotificationsByUserView
    WITH ENCRYPTION
    AS
	with UserGroupAssociationTbl(groupId ,userId )
	As
	(
		SELECT DISTINCT UMGroups.id groupId,UMUserGroup.userId
		FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
		where (UMGroups.groupFlags & 1) = 1
		union
		SELECT  DISTINCT  UMGroups.id groupId,UMDSUserGroup.userId
		FROM UMDSgroups inner join UMDSUserGroup On
		UMDSgroups.id = UMDSUserGroup.groupId and UMDSgroups.enabled=1
		INNER JOIN
		UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId INNER JOIN
		UMGroups ON UMDSGroupMaps.umgroupId = UMGroups.id
		where (UMGroups.groupFlags & 1) = 1
	)
	select Distinct   NRULE.id AS NTnotificationId, U.userId AS userId
	FROM NTnotificationRule AS NRULE, NTNotificationUsers as U
	WHERE	U.NTnotificationId = NRULE.id  AND NRULE.revision > 0
	UNION
	select Distinct NRULE.id AS NTnotificationId, notifOwner AS userId
	FROM NTnotificationRule AS NRULE WHERE NRULE.revision > 0
	UNION
	SELECT Distinct NRULE.id AS NTnotificationId, UserGroup.userId AS userId
	FROM    NTnotificationGroups AS G inner join
			UserGroupAssociationTbl UserGroup on
			UserGroup.groupId = G.groupId
			inner join NTnotificationRule AS NRULE
			ON NRULE.id = G.NTnotificationID  AND NRULE.revision > 0
	union
	SELECT  Distinct NRULE.id AS NTnotificationId, UserGroup.userId AS userId
	from NTnotificationRule AS NRULE inner join UserGroupAssociationTbl creatorsGroup on
			NRULE.notifOwner = creatorsGroup.userId AND NRULE.revision > 0
			inner join UserGroupAssociationTbl UserGroup on
			UserGroup.groupId = creatorsGroup.groupId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [NTnotificationsByUserView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/NTnotification.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: NTnotification"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTnotification]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[NTnotification]
GO

delete from GXDBVersions where name = 'NTnotification' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'NTnotification', '1.9', 'NTnotification', '')
GO
CREATE VIEW dbo.NTnotification
AS
SELECT DISTINCT
                      dbo.NTnotificationRule.id AS NTnotificationID, dbo.NTnotificationRule.notificationName, dbo.NTnotificationRule.revision,
                      dbo.NTnotificationRule.lastModified, dbo.NTnotificationRule.description, dbo.NTnotificationRule.notifOwner, dbo.NTnotificationRule.locale,
                      NTSEL1.reportingOptions AS reportingOptions, NTSEL1.delayTimeSeconds AS delayTimeSeconds,
                      NTSEL1.persistTimeSeconds AS persistTimeSeconds, NTSEL2.reportingOptions AS reportingOptions2, NTSEL2.delayTimeSeconds AS delayTimeSeconds2,NTSEL2.persistTimeSeconds AS persistTimeSeconds2,
                      dbo.NTnotificationRule.notifType & 1 AS EmailEnable, dbo.NTnotificationRule.notifType & 2 AS pagerEnable,
                      dbo.NTnotificationRule.notifType & 4 AS SnmpEnable, dbo.NTnotificationRule.notifType & 8 AS appLogEnable,
                      dbo.NTnotificationRule.notifType & 512 AS saveAlertEnable, dbo.NTnotificationRule.notifType & 1024 AS rssFeedEnable,
					  dbo.NTnotificationRule.notifType & 2048 AS ROMSenable,
                      dbo.NTnotificationRule.notifType & 16 AS actionEnable, dbo.NTnotificationRule.hasAttachments AS hasAttachments,
                      dbo.NTnotificationRule.hasAttachments2 AS hasAttachments2
FROM         dbo.NTnotificationRule
LEFT OUTER JOIN   dbo.NTSelCriteria NTSEL1 ON dbo.NTnotificationRule.id = NTSEL1.ruleId AND NTSEL1.esclationLevel = 1
LEFT OUTER JOIN   dbo.NTSelCriteria NTSEL2 ON dbo.NTnotificationRule.id = NTSEL2.ruleId AND NTSEL2.esclationLevel = 2
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [NTnotification]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/USuserGroups.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: USuserGroups"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[USuserGroups]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[USuserGroups]
GO

delete from GXDBVersions where name = 'USuserGroups' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'USuserGroups', '1.6', 'USuserGroups', '')
GO
CREATE VIEW dbo.USUserGroups
AS
	SELECT DISTINCT
		dbo.UMUserGroup.userId AS userId,
		dbo.UMUserGroup.groupId AS groupId,
		dbo.UMUserGroup.flag AS Flag
	FROM         dbo.UMUserGroup
UNION ALL
	Select DISTINCT
		UM.userId,
		GM.umgroupId,
		0
	FROM dbo.UMDSUserGroup AS UM,
		 dbo.UMDSGroupMaps AS GM,
		 dbo.UMDSGroups    AS UG
	WHERE
		 UM.groupId     = GM.umdsgroupID
	AND	 GM.umdsGroupID = UG.id
    AND  UG.enabled     <> 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [USuserGroups]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/USusers.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: USusers"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[USusers]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[USusers]
GO

delete from GXDBVersions where name = 'USusers' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'USusers', '1.4', 'USusers', '')
GO
CREATE VIEW dbo.USusers
AS
SELECT DISTINCT
					dbo.UMUsers.id    AS userId,
					dbo.UMUsers.login AS login,
					dbo.UMUsers.name AS UserName,
					dbo.UMUsers.email AS email,
					dbo.UMUsers.Pager AS Pager,
					dbo.UMUsers.flags AS userFlags
FROM         dbo.UMUsers
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [USusers]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/USGroups.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: USGroups"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[USGroups]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[USGroups]
GO

delete from GXDBVersions where name = 'USGroups' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'USGroups', '1.3', 'USGroups', '')
GO
CREATE VIEW dbo.USgroups
AS
SELECT DISTINCT
					dbo.UMGroups.id AS groupID,
					dbo.UMGroups.groupFlags AS groupFlags
FROM         dbo.UMGroups
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [USGroups]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/userClientGroupClients.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: userClientGroupClients"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[userClientGroupClients]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[userClientGroupClients]
GO

delete from GXDBVersions where name = 'userClientGroupClients' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'userClientGroupClients', '1.6', 'userClientGroupClients', '')
GO
CREATE VIEW dbo.userClientGroupClients
AS
SELECT DISTINCT UG.userId, GA.groupId, AGA.clientId
 FROM UMGroupAssociation  AS GA,
      APP_ClientGroupAssoc AS AGA,
      UMUserGroup   AS UG
  WHERE GA.type1 = 2572
     AND ( GA.id1 = AGA.clientGroupId OR GA.id1 = -10 )
     AND UG.groupId = GA.groupId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [userClientGroupClients]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/userGroupAssociations.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: userGroupAssociations"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[userGroupAssociations]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[userGroupAssociations]
GO

delete from GXDBVersions where name = 'userGroupAssociations' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'userGroupAssociations', '1.5', 'userGroupAssociations', '')
GO
CREATE VIEW dbo.userGroupAssociations
AS
SELECT DISTINCT
userId, UG.groupId, Type1, id1, type2, id2, type3, id3, type4, id4
FROM UMGroupAssociation AS GA, UMUserGroup AS UG
WHERE GA.groupId = UG.groupId
UNION
SELECT DISTINCT
 UG.userId, UG.groupId, 2009,  AGA.clientId, 0, 0,  0, 0, 0, 0
 FROM UMGroupAssociation  AS GA,
      APP_ClientGroupAssoc AS AGA,
      UMUserGroup   AS UG
  WHERE GA.type1 = 2572
     AND GA.id1 = AGA.clientGroupId
     AND UG.groupId = GA.groupId
--ORDER BY userId, UG.GroupId, type1, id1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [userGroupAssociations]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/extUserGroupAssociations.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: extUserGroupAssociations"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[extUserGroupAssociations]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[extUserGroupAssociations]
GO

delete from GXDBVersions where name = 'extUserGroupAssociations' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'extUserGroupAssociations', '1.1', 'extUserGroupAssociations', '')
GO
CREATE VIEW dbo.extUserGroupAssociations
AS
SELECT DISTINCT
		UG.userId,
		extGroup=UG.groupId,
		groupId=GM.umgroupId,
		GA.type1, GA.id1, GA.type2, GA.id2, GA.type3, GA.id3, GA.type4, GA.id4
FROM
		umdsusergroup AS UG,  umdsGroupMaps AS GM, UMgroupAssociation AS GA
WHERE
		UG.groupId = GM.umdsGroupId
		AND GA.GroupId = GM.umgroupId
UNION
SELECT DISTINCT
		UG.userId,
		extGroup=UG.groupId,
		groupId=GM.umgroupId,
		2009,  AGA.clientId, 0, 0,  0, 0, 0, 0
FROM
		UMgroupAssociation AS GA,    APP_ClientGroupAssoc AS AGA,     umdsusergroup AS UG,  umdsGroupMaps AS GM
WHERE
		GA.type1 = 2572
		AND GA.id1 = AGA.clientGroupId
		AND  UG.groupId = GM.umdsGroupId
		AND  GA.GroupId = GM.umgroupId
--ORDER BY userId, UG.GroupId, type1, id1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [extUserGroupAssociations]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/AppGlobalParam.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: AppGlobalParam"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppGlobalParam]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[AppGlobalParam]
GO

delete from GXDBVersions where name = 'AppGlobalParam' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'AppGlobalParam', '1.4', 'AppGlobalParam', '')
GO
CREATE VIEW dbo.AppGlobalParam
AS
SELECT     dbo.APP_iDATypePropLookup.priority AS name, dbo.APP_iDAType.priority AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.casesensitivity AS name, dbo.APP_iDAType.casesensitivity AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.updateRecoSec AS name, dbo.APP_iDAType.updateRecoSec AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.chunkSizeMB AS name, dbo.APP_iDAType.chunkSizeMB AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.dirDelim AS name, dbo.APP_iDAType.dirDelim AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.updateIntervalSec AS name, dbo.APP_iDAType.updateIntervalSec AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
UNION ALL
SELECT     dbo.APP_iDATypePropLookup.dirOrder AS name, dbo.APP_iDAType.dirOrder AS [value]
FROM         dbo.APP_iDAType INNER JOIN
                      dbo.APP_iDATypePropLookup ON dbo.APP_iDAType.type = dbo.APP_iDATypePropLookup.appType
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [AppGlobalParam]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ScheduleView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ScheduleView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ScheduleView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ScheduleView]
GO

delete from GXDBVersions where name = 'ScheduleView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ScheduleView', '1.4', 'ScheduleView', '')
GO
CREATE VIEW dbo.ScheduleView
AS
        SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
        sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
        sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
        sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber, sc.calendarId,
	    bt.type as backupTaskType , bt.clientId as clientId, bt.appTypeId as appTypeId, bt.instance as instanceId,
        bt.backupSet as backupSetId, bt.subClient as subclientId , CL.name as clientName, BSET.name as backupSetName, INST.name as instanceName,
        APPT.name as appTypeName , APPL.subclientName as subclientName, CCELL.aliasName as commcellName,  0 as preserveOrStripLevel, 0  as type_h,
        0 as type_l,0 as toTime,0 as fromTime ,  CAST(BOPTION.VALUE as int) as clientGroupId, CLGRP.name as clientGroupName, bt.alertId as alertId, NTR.notificationName as alertName, bt.userId as userId, USR.login as userName
FROM    schedule sc
   INNER JOIN SchedBackupTask bt ON sc.id = bt.scheduleId
LEFT OUTER JOIN    APP_Client CL ON bt.clientId = CL.id
LEFT OUTER JOIN    APP_BackupSetName BSET ON bt.backupSet = BSET.id
LEFT OUTER JOIN    APP_InstanceName INST ON bt.instance = INST.id
LEFT OUTER JOIN    APP_iDAType  APPT ON bt.appTypeId = APPT.type
LEFT OUTER JOIN    APP_Application APPL ON APPL.id = bt.subClient
LEFT OUTER JOIN    APP_CommCell CCELL ON 2 = CCELL.id
left outer JOIN    SchedBackupTaskOptions boption on BOPTION.BACKUPTASKID = Bt.ID and boption.NAME = 'ClientGroupId'
left outer JOIN    APP_ClientGroup CLGRP on CLGRP.ID = CAST(BOPTION.VALUE as int)
LEFT OUTER JOIN    ntnotificationrule as NTR ON bt.alertId = NTR.id
LEFT OUTER JOIN    UMUsers as USR ON bt.userid = USR.id
WHERE   sc.type > 0
UNION
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
      sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
      sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
      sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber,sc.calendarId,
	  0 as backupTaskType, rt.sourceclientId as clientId, rt.appTypeId as appTypeId, rt.instanceId  as instanceId,
      rt.backupSetId as backupSetId, 0 as subclientId ,  CL.name as clientName, BSET.name as backupSetName, INST.name instanceName,
      APPT.name as appTypeName , NULL as subclientName, CCELL.aliasName as commcellName, rt.preserveOrStripLevel as preserveOrStripLevel, rt.type_h as type_h,
      rt.type_l as type_l, rt.toTime as toTime, rt.fromTime as fromTime, 0 as clientGroupId, NULL as clientGroupName, rt.alertId as alertId, NTR.notificationName as alertName, rt.userId as userId, USR.login as userName
FROM    schedule sc
   INNER JOIN SchedRestoreTask rt ON sc.id = rt.scheduleId
LEFT OUTER JOIN    APP_Client as CL ON rt.sourceclientId = CL.id
LEFT OUTER JOIN    APP_BackupSetName as BSET ON rt.backupSetId = BSET.id
LEFT OUTER JOIN    APP_InstanceName as INST ON rt.instanceId = INST.id
LEFT OUTER JOIN    APP_iDAType as APPT ON rt.appTypeId = APPT.type
LEFT OUTER JOIN    APP_CommCell as CCELL ON 2 = CCELL.id
LEFT OUTER JOIN    ntnotificationrule as NTR ON rt.alertId = NTR.id
LEFT OUTER JOIN    UMUsers as USR ON rt.userid = USR.id
WHERE   sc.type > 0
UNION
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
        sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
        sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
        sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber,sc.calendarId,
	    at.type as backupTaskType, 0 as clientId, 0 as appTypeId , 0 as instanceId,
        0 as backupSetId, 0 as subclientId , NULL as clientName , NULL as backupSetName, NULL instanceName,
        NULL as appTypeName , NULL as subclientName, NULL as commcellName, 0 as preserveOrStripLevel, 0 as type_h,
        0 as type_l,0 as toTime,0 as fromTime, 0 as clientGroupId, NULL as clientGroupName, at.alertId as alertId, NTR.notificationName, at.userId as userId, USR.login as userName
FROM    schedule sc
   INNER JOIN SchedAdminTask at ON sc.id = at.scheduleId
   LEFT OUTER JOIN    ntnotificationrule as NTR ON at.alertId = NTR.id
   LEFT OUTER JOIN    UMUsers as USR ON at.userid = USR.id
WHERE   sc.type > 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ScheduleView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/TempCvView1.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: TempCvView1"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TempCvView1]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[TempCvView1]
GO

delete from GXDBVersions where name = 'TempCvView1' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'TempCvView1', '1.16', 'TempCvView1', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---temp view for CommCellMediaInfo
CREATE VIEW dbo.TempCvView1
AS
select distinct
 mediaid = M.MediaId ,
 mediabarcode = M.Barcode ,
 type = MT.MediaTypeName ,
 sidename = MS.sidename ,
 volumeid = MV.volumeid ,
 volumename=MV.volumename,
 bsizeKB = cast(MV.FlushBlockSizeKB as varchar(2048) ),
 totalspaceMB = MS.TotalspaceMB ,
 usedspaceMB = MS.LogicalBytesMB,
 freespaceMB = MS.FreebytesMB ,
 writenum = MS.NumberOfBackups ,
 reusenum = MS.NumberOfReuses ,
 libraryid=M.libraryid,
 creationTime=M.creationTime,
 mediastatus =
 case M.mediaflags
 when 0 then 'Invalid'
 when 1 then 'Good'
 when 2 then 'Bad'
 when 3 then 'Expired'
 else 'Unknown'
 end,
 volumestatus =
     CASE MV.VolumeFlags
     WHEN 0 THEN 'Invalid'
     WHEN 1 THEN 'Active'
     WHEN 2 THEN 'Full'
     WHEN 3 THEN 'ReadOnly'
     WHEN 4 THEN 'Bad'
     WHEN 5 THEN 'Idle'
     WHEN 6 THEN 'Recycle'
     WHEN 7 THEN 'Active_Append'
     ELSE 'Unknown'
     END,
 volumefullreason =
  CASE MV.VolumeFlags
  WHEN 2 then
     CASE (MV.VolumeFullReason - 41954)
     WHEN -41952 then 'Phycial end of media'
     WHEN 46 then 'User marked full'
     WHEN 47 then 'Physical end of media'
     WHEN 48 then 'Hardware error'
     WHEN 49 then 'Media exported'
     WHEN 50 then 'Media stuck in drive'
     WHEN 51 then 'Recycled Media'
     WHEN 52 then 'Mountpath disabled'
     WHEN 54 then 'Media write protected'
     WHEN 55 then 'Inconsistent file count between media and the database'
     WHEN 56 then 'Mount path not accessible'
     WHEN 57 then 'Number of Streams reduced on the storage policy'
     WHEN 58 then 'Marked full in previous Galaxy Release'
     WHEN 59 then 'Media Marked full after successful data protection operation'
     WHEN 60 then 'Marked full to create Synthetic Full'
     WHEN 61 then 'Marked full to allow for LAN free backup'
     WHEN 62 then 'User marked appendable'
     WHEN 63 then 'Marked full as the archiving data path has switched'
     WHEN 64 then 'Media was found exportable when required by a backup or copy job'
     WHEN 65 then 'Marked full as the Media was inherited from a Foreign CommCell during CommCellMigration Merge operation'
     WHEN 66 then 'Media recycled as part of option to overwrite media'
     WHEN 67 then 'Media marked full as the flush block size has changed for upgrade'
     WHEN 68 then 'Media Marked full after successful copy'
     WHEN 69 then 'Started'
     WHEN 70 then 'Completed'
     WHEN 71 then 'Media is reserved'
     WHEN 72 then 'Media is in use'
     WHEN 73 then 'Unmount failed'
     WHEN 74 then 'Resources not ready'
     WHEN 75 then 'Internal database error'
     WHEN 76 then 'MediaAgent not ready'
     WHEN 77 then 'No free mail slots in the library'
     WHEN 78 then 'Export in progress'
     WHEN 79 then 'Media moved to mail slot'
     ELSE 'Other'
     END
   ELSE ''
   END,
   volumefulljobid= MV.VolumeFullJobID,
     location =
     CASE M.MediaLocation
     WHEN 1 THEN 'In Slot'
     WHEN 2 THEN 'In Drive'
     WHEN 3 THEN 'Not In Library'
     WHEN 0 THEN 'Not In Library'
     ELSE 'Unknown'
     END,
     slotname=MMSlot.slotname,
     drivename=MMDrive.drivename,
     exportlocation=MMExportLocation.exportlocation,
     lastwritetimeunixsec = M.LastBackupTime,
     rawlastwritetime = dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'),
    lastwritetime =
    CASE datepart(month, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
    WHEN  4  THEN
        case datepart(dd, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 6 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
         when 5 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 4 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 5 then  dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 3 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                when 3  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 2 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 1 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    WHEN 5  THEN dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 6  THEN dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 7  THEN dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 8  THEN dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 9  THEN dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 10  THEN
        case datepart(dd, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 31 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
         when 30 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 29 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 6 then  dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 28 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                when 4  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 27 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 26 then
                case datepart(dw, dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (M.lastBackupTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    ELSE  dateadd (second, convert(real, (M.lastBackupTime - 915170400)), '01/01/1999 01:00:00AM')
    END,
    LabelErrors = MS.NumberOfSoftErrors,
    ReadWriteErrors = MS.NumberOfHardErrors
FROM MMMedia M
LEFT JOIN MMSlot  ON M.MediaId = MMSlot.MediaId
LEFT JOIN MMDrive ON M.MediaId=MMDrive.MediaId
LEFT JOIN MMExportLocation ON MMExportLocation.ExportLocationId=M.ExportLocationId and M.MediaLocation = 3
LEFT JOIN MMMediaType MT ON M.MediaTypeId = MT.MediaTypeId
LEFT JOIN MMMediaSide MS ON M.MediaId = MS.MediaId
LEFT JOIN MMVolume  MV ON MS.MediaSideId = MV.MediaSideId
WHERE M.MediaId > 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [TempCvView1]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [TempCvView1]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/TempCvView2.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: TempCvView2"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TempCvView2]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[TempCvView2]
GO

delete from GXDBVersions where name = 'TempCvView2' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'TempCvView2', '1.11', 'TempCvView2', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---temp view for CommCellMediaInfo
CREATE VIEW dbo.TempCvView2
AS
SELECT DISTINCT
     mediaid = t1.MediaId ,
     mediabarcode = t1.mediabarcode ,
     type = t1.type,
     format = RF.RecordingFormatName,
     sidename = t1.sidename ,
     volumeid = t1.volumeid ,
     volumename=t1.volumename,
     bsizeKB = t1.bsizeKB,
     totalspaceMB = t1.totalspaceMB ,
     usedspaceMB = t1.usedspaceMB,
     freespaceMB = t1.freespaceMB ,
     writenum = t1.writenum ,
     reusenum = t1.reusenum ,
     mediastatus =t1.mediastatus,
     volumestatus =t1.volumestatus,
     volumefullreason = t1.volumefullreason,
     volumefulljobid = t1.volumefulljobid,
     location = t1.location,
     slotname=t1.slotname,
     drivename=t1.drivename,
     exportlocation=t1.exportlocation,
     lastwritetimeunixsec = t1.lastwritetimeunixsec,
     rawlastwritetime = t1.rawlastwritetime,
     lastwritetime = t1.lastwritetime,
     mediagroupid=MG.mediagroupid,
     drivepoolname = MP.drivepoolname ,
     library = ML.LibraryName,
     creationtime = t1.creationTime,
     LabelErrors = t1.LabelErrors,
     ReadWriteErrors = t1.ReadWriteErrors
FROM TempCvView1 t1
LEFT JOIN MMVolume MV ON t1.VolumeId = MV.VolumeId
LEFT JOIN MMMediaGroup MG ON MG.mediagroupid = MV.mediagroupid
LEFT JOIN MMDrivePool MP ON MG.drivepoolid = MP.drivepoolid
LEFT JOIN MMLibrary ML ON t1.LibraryId = ML.LibraryId
LEFT JOIN MMRecordingFormats RF ON MG.RecordingFormatID = RF.RecordingFormatID
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [TempCvView2]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [TempCvView2]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/TempCvView3.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: TempCvView3"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TempCvView3]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[TempCvView3]
GO

delete from GXDBVersions where name = 'TempCvView3' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'TempCvView3', '1.9', 'TempCvView3', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---temp view for CommCellBkSchedule
CREATE VIEW dbo.TempCvView3
AS
SELECT
patternid = PAT.patternId,
sunday =
case
when (PAT.freq_interval&1 > 0) then 'Sunday'
else ''
end,
monday=
case
when (PAT.freq_interval&2 > 0) then 'Monday'
else ''
end,
tuesday=
case
when (PAT.freq_interval&4 > 0) then 'Tuesday'
else ''
end,
wednesday=
case
when (PAT.freq_interval&8 > 0) then 'Wednesday'
else ''
end,
thursday=
case
when (PAT.freq_interval&16 > 0) then 'Thursday'
else ''
end,
friday=
case
when (PAT.freq_interval&32 > 0) then 'Friday'
else ''
end,
saturday=
case
when (PAT.freq_interval&64 > 0) then 'Saturday'
else ''
end
FROM TM_Pattern PAT
WHERE PAT.freq_interval <> 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [TempCvView3]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [TempCvView3]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/TempCvView4.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: TempCvView4"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TempCvView4]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[TempCvView4]
GO

delete from GXDBVersions where name = 'TempCvView4' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'TempCvView4', '1.8', 'TempCvView4', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---temp view for CommCellAdminSchedule and CommCellAuxCopyInfo
CREATE VIEW dbo.TempCvView4
AS
SELECT
copyid=AGC.id,
copyname=AGC.name,
--sourcecopyid=AGC.sourcecopyid,
sourcecopyid=
case AGC.sourcecopyid
when 0 then
(select AGC1.id from ArchGroupCopy AGC1, ArchGroup AG where AG.id=AGC.archGroupId and AGC1.id=AG.defaultcopy)
else AGC.sourcecopyid
end,
sourcecopyname=
case AGC.sourcecopyid
when 0 then
(select AGC1.name from ArchGroupCopy AGC1, ArchGroup AG where AG.id=AGC.archGroupId and AGC1.id=AG.defaultcopy)
else
(select AGC2.name from ArchGroupCopy AGC2 where AGC2.id=AGC.sourcecopyid)
end
FROM         ArchGroupCopy AGC
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [TempCvView4]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [TempCvView4]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellAuxCopyInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellAuxCopyInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellAuxCopyInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellAuxCopyInfo]
GO

delete from GXDBVersions where name = 'CommCellAuxCopyInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellAuxCopyInfo', '1.15', 'CommCellAuxCopyInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Auxcopy Info
CREATE VIEW dbo.CommCellAuxCopyInfo
AS
SELECT
	auxcopyjobid= JAJS.jobid,
	storagepolicy = JAJS.archgrpname,
	sourcecopyid = (select t4.sourcecopyid from TempCvView4 t4 where t4.copyid = JDCST.archgrpcopyid),
	sourcecopy = (select t4.sourcecopyname from TempCvView4 t4 where t4.copyid = JDCST.archgrpcopyid),
	destcopyid=JDCST.archgrpcopyid,
	destcopy =
	(select ARP.name from ArchGroupCopy ARP where JDCST.archgrpcopyid = ARP.id),
	jobinitfrom=
	case JAJS.initFrom
	when 1 then 'Command Line'
	when 2 then 'Gui'
	when 3 then 'Schedule'
	when 4 then 'System'
	end,
	jobstatus=
	 CASE JAJS.status
	 WHEN 1 THEN 'Success'
	 WHEN 2 THEN 'Failed'
	 WHEN 3 THEN 'PartialSuccess'
	 WHEN 4 THEN 'Killed'
	 WHEN 5 THEN 'Stopped'
	 WHEN 6 THEN 'Interrupted'
	 WHEN 9 THEN 'Failed to Start'
	 ELSE 'Unknown'
	 END,
	startdateunixsec = JAJS.servstart,
	enddateunixsec =JAJS.servend,
	startdate = dbo.UTCToClientLocalTime(dbo.GetDateTime(JAJS.servStart), 2),
	enddate = dbo.UTCToClientLocalTime(dbo.GetDateTime(JAJS.servEnd), 2),
	ElapsedTime = JAJS.servEnd - (CASE WHEN JAJS.servStart > 0 THEN JAJS.servStart ELSE 0 END),
	bytesxferred = ISNULL(JDCST.bytesxferred, 0),
	NWTransBytes = JAJS.nwTransBytes,
	ApplicationSize =EX_TotalSuccess,
	BackupSize = -1,
	DataWritten = JAJS.totalbackupsize
FROM JMAdminJobStatsTable JAJS
LEFT JOIN JMDataCopiedStatsTable JDCST on JAJS.jobId = JDCST.jobId
WHERE JAJS.optype IN (13, 104)
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellAuxCopyInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellAuxCopyInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkSchedule.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkSchedule"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkSchedule]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkSchedule]
GO

delete from GXDBVersions where name = 'CommCellBkSchedule' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkSchedule', '1.20', 'CommCellBkSchedule', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup Schedule Info
CREATE VIEW dbo.CommCellBkSchedule
AS
SELECT
 CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
 CommCellName = CCELL.aliasName,
 scheduleId = STASK.subTaskid,
 schedulePolicy = TASK.taskname,
 scheduleName  = STASK.subtaskname,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype =
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedbackupday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
  WHEN 128 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
		 + ' ' + 'of' + ' ' +
		 CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
	ELSE ' '
	END,
	schedbackupTime = CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ),
	schednextbackuptime = RTASSOC.nextRunTime,
	appid = ASSOC.subclientId,
	clientName =
	CASE ASSOC.clientid
	WHEN 0 THEN 'All Clients'
	ELSE C.name
	END,
	idataagent = APT.name,
	instance =
	CASE  ITN.name
	 WHEN 'DefaultInstanceName' THEN ''
	 WHEN 'defaultDummyInstanceForOracle' THEN ''
	 ELSE ITN.name
	END,
	 backupset =
   CASE  APT.type
    WHEN 6 THEN 'NULL'
    WHEN 9 THEN 'NULL'
    WHEN 15 THEN 'NULL'
    WHEN 27 THEN 'NULL'
    WHEN 31 THEN 'NULL'
   ELSE
      CASE ASSOC.backupsetId
      WHEN 0 THEN 'All BackupSets'
      ELSE ( select name from APP_BackupSetName BN where BN.id = ASSOC.backupsetid)
      END
   END,
   subclient =
  CASE ASSOC.subclientId
  WHEN 0 THEN 'All subclients'
  ELSE (select subclientName from APP_Application AP where AP.id = ASSOC.subclientid)
  END
  FROM
		TM_Task as TASK LEFT OUTER JOIN
		TM_AssocEntity AS ASSOC ON ASSOC.taskId = TASK.taskId JOIN
		TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
		TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId JOIN
		TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
		TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN
		TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN
		TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
		App_Client AS C ON ASSOC.clientId = C.id LEFT OUTER JOIN
		App_Commcell AS CCELL ON 2 = CCELL.id LEFT OUTER JOIN
		APP_iDAType  APT ON ASSOC.appTypeId = APT.type LEFT OUTER JOIN
		TempCvView3 t3 ON PAT.PatternId=t3.patternid  LEFT OUTER JOIN
		APP_InstanceName  ITN ON ASSOC.instanceId = ITN.id
		WHERE
		STASK.subTaskType = 2 AND
		SOPT.optionId = 458405394 AND
		RTASSOC.processed = 0 AND RTASSOC.firing = 0 AND
		RT.processed = 0 AND RT.firing =  0 AND
		TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellBkSchedule]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkSchedule]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkScheduleSummary.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkScheduleSummary"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkScheduleSummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkScheduleSummary]
GO

delete from GXDBVersions where name = 'CommCellBkScheduleSummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkScheduleSummary', '1.8', 'CommCellBkScheduleSummary', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup Schedule Info
CREATE VIEW dbo.CommCellBkScheduleSummary
AS
SELECT DISTINCT
 CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
 CommCellName = CCELL.aliasName,
 scheduleId = STASK.subTaskid,
 schedulePolicy = TASK.taskname,
 scheduleName  = STASK.subtaskname,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype =
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedbackupday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
  WHEN 128 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
		 + ' ' + 'of' + ' ' +
		 CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
	ELSE ' '
	END,
	schedbackupTime = CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ),
	schednextbackuptime = RTASSOC.nextRunTime,
	associationCount = (select count(*) from TM_AssocEntity ASSOC WITH (NOLOCK) where ASSOC.taskId = TASK.taskId),
	-- Check to see if JobsToRun Column is disabled
	CASE ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name = N'CommCellBkScheduleSummary JobsToRun Disabled'), 0)
		WHEN 0 THEN
			(	select	count(distinct A.id)
			FROM    TM_AssocEntity TA WITH (NOLOCK)
			JOIN APP_Application A WITH (NOLOCK) ON
			(
				TA.clientId IN (0, A.clientId) AND TA.appTypeId IN (0, A.apptypeId) AND
				TA.instanceId IN (0, A.instance) AND TA.backupSetId IN (0, A.backupset) AND TA.subclientId IN (0, A.id)
			)
			WHERE TA.taskId = TASK.taskId
				--AND NOT EXISTS
				--(
				--	SELECT 1 FROM JMJobAction JA WITH (NOLOCK) --CHECK BACKUP ACTIVITY DISABLED
				--	WHERE
				--	(
				--		JA.appId = A.id --AT SUBCLIENT LEVEL
				--		OR
				--		(
				--			JA.clientId = A.clientId AND JA.appType IN (0, A.appTypeId) --AT CLIENT OR AGENT LEVEL
				--		)
				--	)
				--	AND JA.action = 1 and JA.opType = 4
				--)
				AND
				(
					(
						A.clientId IN
						( SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc WITH (NOLOCK) where clientgroupid in
						( SELECT clientGroupId from TM_AssocEntity WITH (NOLOCK) where taskId = TASK.taskId AND clientId = 0 AND exclude = 0))
					)
					OR
					(
						A.appTypeId IN
						( SELECT DISTINCT (appTypeId) FROM APP_AppTypeGroupAssoc WITH (NOLOCK) where appGroupId in
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 1 AND taskId = TASK.taskId AND
							taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TASK.taskId AND clientGroupId = 0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)))
					)
					OR
					(
						A.appTypeId IN
						( (SELECT type from dbo.APP_iDAType WITH (NOLOCK) where type IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 2 AND taskId = TASK.taskId AND
							taskId IN (SELECT taskId FROM TM_AssocEntity WITH (NOLOCK) WHERE taskId = TASK.taskId AND clientGroupId = 0 AND  clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0))))
					)
					OR
					(
						NOT EXISTS (SELECT * from TM_AssocFilter where  taskId = TASK.taskId)
					)
				)
				AND NOT
				(
					(A.appTypeId >= 600 AND A.appTypeId <= 699)
					OR
					(A.apptypeId IN (24, 27, 31, 40, 47, 48, 67, 68,  87, 65, 25) AND (( A.subclientStatus & 8 ) = 8)
					)
					OR
					(
						--(A.appTypeId IN (84, 107) AND (((status & 8) <> 8) OR (@fanInRP = 0 AND backupsetId IN (SELECT id FROM APP_BackupSetName WHERE status&40=40 AND id=backupsetId))))
						--OR
						(A.appTypeId IN (84) AND (TASK.taskType & 4 = 4) --MR54684 REMOVED CDR FROM SCHEDULE POLICY AGAIN WILL BE ADDED IN 10.0?
						--AND
							--backupSetId IN  ( select componentnameid from APP_Backupsetprop where modified = 0 and attrName = N'FLR Replication Options' and CAST(attrVal AS INT)&0x10000=0x10000)
						) --DO NOT RUN JOBS FOR DDR SCHEDULE POLICIES
						OR (A.appTypeId IN (107) AND (TASK.taskType & 4 = 4) AND backupsetId IN (SELECT id FROM APP_BackupSetName WHERE status&40=40 AND id=backupsetId)) --ONLY RUN JOBS FOR NON-DEFAULT BACKUPSET FOR SCHEDULE POLICIES
						--DO NOT RUN JOBS ON PSEUDO HIDDEN BACKUP SETS
						OR (A.appTypeId IN (37, 62, 103) AND A.backupSet IN (SELECT id FROM APP_BackupSetName WHERE status&24=24 AND id=A.backupSet))
					)
					OR
					(A.appTypeId IN (6,51,59,77) AND A.subclientStatus&0x0080<>0x0080)	--SKIP TRANSACTION LOG SUBCLIENTS
					OR
					(A.appTypeId IN (72) OR A.appTypeId >= 1000) --FILTER DUMMY IDA
					OR
					(A.apptypeId IN (84, 107) AND A.subclientStatus&8<>8) --IGNORE NO DEF SUBCLIENTS FOR CDR/WBA IDA
					OR
					(
						TASK.taskType & 4 = 4 --SCHEDULE POLICY
						AND
						(
							A.subclientStatus&64=64 OR A.subclientStatus&4096=4096 -- COMMAND LINE AND COMMAND LOG SUBCLIENT
							OR A.appTypeId IN (47, 50)	-- QR APPTYPE
							OR A.backupSet IN ( select componentnameid from APP_backupsetprop WITH (NOLOCK) where modified = 0 and attrName = N'OnDemand Backupset' and attrVal = N'1')
						)
					)
					OR
					(A.apptypeId NOT IN (
						(SELECT appTypeId from APP_AppTypeGroupAssoc WITH (NOLOCK) where typeOfGroup = 0 and appgroupid IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 1 AND taskId = TASK.taskId))
						UNION ALL (SELECT type from dbo.APP_iDAType WITH (NOLOCK) where type IN
						( SELECT filter_value from TM_AssocFilter WITH (NOLOCK) where  filter_type = 2 AND taskId = TASK.taskId))
						UNION ALL (SELECT DISTINCT appTypeId from TM_AssocFilter WITH (NOLOCK), dbo.GetAppTypesForAppGroup(22, 0)
							WHERE  filter_type = 2 AND taskId = TASK.taskId AND filter_value IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(22, 0))) --APPGRP_W2KFileSystem
						)
						AND
						(
							EXISTS (SELECT * from TM_AssocFilter where  taskId = TASK.taskId)
						)
					)
					OR
					(A.appTypeId = 81 AND
						(EXISTS( SELECT filter_value from TM_AssocFilter where  filter_type = 3 AND filter_value = 1 AND taskId = TASK.taskId	--FILTER_Subclient= 3 --FIL_SC_SQL_FFG = 2
								) OR NOT EXISTS(SELECT * FROM TM_AssocEntity TA WHERE TA.taskId=TASK.taskId AND TA.subclientId = A.id )
						)
						AND
						A.id IN  ( select componentnameid from APP_Subclientprop where modified = 0 and attrName = N'mssql subclient type' and attrVal = N'2')
					)
				)
				AND NOT
				(
					(( A.subclientstatus & 2 ) = 2)   -- CV_STATUS_UNINSTALLED
					OR    ((( A.subclientstatus & 4 ) =  4)   -- CV_STATUS_DELETED
							)
					OR    (( A.subclientstatus & 16 ) = 16)  -- CV_STATUS_DUMMY
					OR    (( A.subclientstatus & 32 ) = 32)  -- CV_STATUS_HIDDEN
							AND NOT (A.apptypeId IN (84, 107) AND (A.subclientStatus & 8) = 8)  --IGNORE CDR/WBA SINCE THEY ARE MARKED HIDDEN
				)
				)
			ELSE 0
	END JobsToRun,
	JobsFiredInLastRun = ISNULL(TT.firedJobs, 0),
	lastScheduleFireTime = DATEADD(second, TT.maxTime, '01/01/1970 00:00:00AM'),
	mismatchedAppTypeCount = ISNULL(MAPP.mismatchedAppType, 0),
	TimeZoneId = PAT.tzId,
	TimeZoneName = (CASE PAT.tzId
						WHEN 1000 THEN 'CS TimeZone'
						WHEN 1001 THEN 'Client TimeZone'
						ELSE STZ.TimeZoneName
					END),
	TimeZoneOffSet = (CASE
						WHEN PAT.tzId NOT IN (1000, 1001) THEN STZ.Bias
						ELSE 0
					  END)
  FROM
		TM_Task as TASK WITH (NOLOCK) LEFT OUTER JOIN
		TM_SubTask as STASK WITH (NOLOCK) ON TASK.taskId = STASK.taskId  JOIN
		TM_SubTaskOptions as SOPT WITH (NOLOCK) ON STASK.subTaskId = SOPT.subTaskId JOIN
		TM_PatternAssoc AS PATASSOC WITH (NOLOCK) ON PATASSOC.subTaskId = STASK.subTaskId JOIN
		TM_Pattern AS PAT WITH (NOLOCK) ON PAT.patternId = PATASSOC.patternId  JOIN
		TM_RunTime AS RT WITH (NOLOCK) ON RT.patternId = PAT.patternId  JOIN
		(	SELECT runTimeId, nextRunTime=MAX(nextRunTime) FROM TM_RunTimeAssoc WITH (NOLOCK)
			WHERE processed = 0 AND firing = 0 GROUP BY runTimeId) AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
		--TM_AssocFilter AS TF WITH (NOLOCK) ON TF.taskId = TASK.taskId LEFT OUTER  JOIN
		App_Commcell AS CCELL WITH (NOLOCK) ON 2 = CCELL.id LEFT OUTER JOIN
		TempCvView3 t3 WITH (NOLOCK) ON PAT.PatternId=t3.patternid LEFT OUTER JOIN
		(	select TJ.taskId, TJ.subTaskId, TJ.maxTime, firedJobs=count(distinct TR.jobId)
			from (	select taskId, subTaskId, maxTime=MAX(created), maxReqId=MAX(jobRequestId)
				from TM_JobRequest WITH (NOLOCK) group by taskId, subTaskId) TJ, TM_Jobs TR WITH (NOLOCK)
			where TJ.maxReqId = TR.jobRequestId AND
			(	EXISTS (select * from JmBkpStats JB WITH (NOLOCK) where TR.jobId = JB.JobId)
					OR
				EXISTS (select * from JMBkpJobInfo JActive WITH (NOLOCK) where TR.jobId = JActive.JobId))
			group by TJ.taskId, TJ.subTaskId, TJ.maxTime ) TT ON STASK.taskId=TT.taskId AND STASK.subTaskId=TT.subTaskId LEFT OUTER JOIN
		(	select taskId, mismatchedAppType=COUNT(*)
			from (	select T2.taskId, T2.clientId, T2.appTypeId
					from (	select taskId, clientId, apptypeId from TM_AssocEntity WITH (NOLOCK) where clientGroupId = 0 and apptypeId > 0
							UNION
							select taskId, T.clientId, apptypeId from TM_AssocEntity T WITH (NOLOCK), APP_ClientGroupAssoc G WITH (NOLOCK)
								where T.apptypeId > 0 and T.clientGroupId = G.clientGroupId) T2
						LEFT OUTER JOIN TM_AssocFilter TA2 ON T2.taskId = TA2.taskId
					where TA2.taskId is NULL OR TA2.filter_type=2 AND TA2.filter_value=T2.appTypeId ) T3
				LEFT JOIN APP_iDAName A WITH (NOLOCK) ON T3.clientId = A.clientId and T3.apptypeId = A.appTypeId
		 	where A.id is null
		 	group by taskId) MAPP ON STASK.taskId=MAPP.taskId LEFT OUTER JOIN
		 	SchedTimeZone STZ WITH (NOLOCK) ON PAT.tzId = STZ.TimeZoneID
WHERE
		STASK.subTaskType = 2 AND STASK.operationType=2 AND
		SOPT.optionId = 458405394 AND
		RT.processed = 0 AND RT.firing =  0 AND
		TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0 AND
		TASK.disabled = 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellBkSchedule]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkScheduleSummary]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellAdminSchedule.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellAdminSchedule"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellAdminSchedule]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellAdminSchedule]
GO

delete from GXDBVersions where name = 'CommCellAdminSchedule' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellAdminSchedule', '1.21', 'CommCellAdminSchedule', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Admin Schedule Info
CREATE VIEW dbo.CommCellAdminSchedule
AS
SELECT
 scheduleId = STASK.subTaskid,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedtype=
 CASE STASK.operationType
  WHEN 4001 THEN 'Data Aging'
  WHEN 4002 THEN 'DR Backup'
  WHEN 4003 THEN 'Auxiliary Copy' + '-' +
         (CASE TASK.taskType
           WHEN 4 THEN (SELECT TASK.taskName)
           ELSE ''
          END
          )
  WHEN 4004 THEN 'Report'
  WHEN 4005 THEN 'Media Inventory'
  WHEN 4006 THEN 'Schedule Export'
  WHEN 4007 THEN 'Data Verfication'
  WHEN 4008 THEN 'Media Prediction'
  WHEN 4009 THEN 'Tape Erase'
  WHEN 4010 THEN 'Vault Tracker'
  WHEN 4011 THEN 'Selective Delete'
  WHEN 4012 THEN 'Workflow'
  WHEN 4013 THEN 'Drive Validation'
  WHEN 4014 THEN 'Drive Cleaning'
  WHEN 4015 THEN 'Stamp Media'
  WHEN 4016 THEN 'Browse Delete'
  WHEN 4017 THEN 'Catalogue Media'
  WHEN 4018 THEN 'Data Aging'
  WHEN 4019 THEN 'Download Updates'
  WHEN 4020 THEN 'Install Updates'
  WHEN 4021 THEN 'SRM Report'
  WHEN 4022 THEN 'Content Indexing'
  WHEN 4023 THEN 'Magentic Library Maintainance'
  WHEN 4024 THEN 'Shelf Management'
  WHEN 4025 THEN 'Information Management'
  WHEN 4026 THEN 'Install Client'
  WHEN 4027 THEN 'Uninstall Client'
  WHEN 4028 THEN 'Backup Copy'
  WHEN 4029 THEN 'CCM Export'
  WHEN 4030 THEN 'CCM Import'
  WHEN 4031 THEN 'External Data Connector'
  WHEN 4032 THEN 'Media Refresh'
  WHEN 4033 THEN 'Preparation'
  WHEN 4034 THEN 'Foreign Data Connector'
  WHEN 4035 THEN 'Mag Library Volume Reconciliation'
  ELSE 'Other'
 END,
sp_id=
CASE STASK.operationType
WHEN 4003 THEN CAST(ASSOC.PolicyId AS varchar(512))
ELSE 'not apply'
END,
sp=
case STASK.operationType
WHEN 4003 THEN  (SELECT AGROUP.name FROM ArchGroup AS AGROUP WHERE AGROUP.id = ASSOC.PolicyId)
ELSE 'not apply'
END,
sp_dest_copy_id=
CASE STASK.operationType
WHEN 4003 THEN
(CASE ASSOC.copyId
  WHEN 0 THEN 'ALL'
  ELSE CAST(ASSOC.copyId AS varchar(512))
  END
 )
ELSE 'not apply'
END,
sp_dest_copy=
CASE STASK.operationType
WHEN 4003 THEN
          CASE ASSOC.copyId
          WHEN 0 then 'all copies'
          ELSE (SELECT AGCOPY.name FROM ArchGroupCopy AS AGCOPY WHERE AGCOPY.id = ASSOC.copyId)
          END
ELSE 'not apply'
END,
sp_src_copy_id =
CASE STASK.operationType
 WHEN 4003 THEN
       CASE
        WHEN ASSOC.copyId != 0 THEN
        (SELECT distinct cast(t4.sourcecopyid as varchar(512)) from TempCvView4 t4 where ASSOC.copyId=t4.copyid)
        ELSE CASE
              WHEN ASSOC.PolicyId != 0 THEN
                         (select distinct cast(t4.sourcecopyid as varchar(512)) from TempCvView4 t4 where ASSOC.PolicyId=t4.copyid)
              ELSE 'not apply'
             END
       END
 ELSE 'not apply'
END,
sp_src_copy =
CASE STASK.operationType
 WHEN 4003 THEN
       CASE
        WHEN ASSOC.copyId != 0 THEN
        (SELECT distinct t4.sourcecopyname from TempCvView4 t4 where ASSOC.copyId=t4.copyid)
        ELSE CASE
              WHEN ASSOC.PolicyId != 0 THEN
                         (SELECT distinct t4.sourcecopyname FROM TempCvView4 t4 where ASSOC.PolicyId=t4.copyid)
              ELSE 'not apply'
             END
       END
 ELSE 'not apply'
END,
-- AUXCOPYOPTION_USE_MAXIMUM_STREAMS = 1109628066
-- AUXCOPYOPTION_MAX_NUMBER_OF_STREAMS = 2105046087
streams=
CASE STASK.operationType
 WHEN 4003 THEN
       CASE (SELECT SOPT.value FROM TM_SubTaskOptions AS SOPT WHERE SOPT.optionId = 1109628066 AND STASK.subTaskId = SOPT.subTaskId)
	    WHEN 0 THEN (SELECT SOPT.value FROM TM_SubTaskOptions AS SOPT WHERE SOPT.optionId = 2105046087  AND STASK.subTaskId = SOPT.subTaskId)
	    ELSE 'MAX'
	   END
 ELSE 'not apply'
END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
  WHEN 128 THEN
		CASE PAT.freq_relative_interval
			WHEN 5 THEN 'Last'
			ELSE
			LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
		  WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
		  WHEN 5 THEN 'Thursday'
		  WHEN 6 THEN 'Friday'
		  WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
		  ELSE 'Unknown'
		 END
		 + ' ' + 'of' + ' ' +
		 CASE PAT.freq_recurrence_factor
		  WHEN 1 THEN 'January'
		  WHEN 2 THEN 'February'
		  WHEN 3 THEN 'March'
		  WHEN 4 THEN 'April'
		  WHEN 5 THEN 'May'
		  WHEN 6 THEN 'June'
		  WHEN 7 THEN 'July'
		  WHEN 8 THEN 'August'
		  WHEN 9 THEN 'September'
		  WHEN 10 THEN 'October'
		  WHEN 11 THEN 'November'
		  WHEN 12 THEN 'December'
		 END
	ELSE ' '
	END,
	schedTime = CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ),
	schednexttime = RTASSOC.nextRunTime
  FROM
		TM_Task as TASK LEFT OUTER JOIN
		TM_AssocEntity AS ASSOC ON ASSOC.taskId = TASK.taskId JOIN
		TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
		TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
		TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN
		TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN
		TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
		TempCvView3 t3 ON PAT.PatternId=t3.patternid
		WHERE
		STASK.subTaskType = 1 AND
		RTASSOC.processed = 0 AND RTASSOC.firing = 0 AND
		RT.processed = 0 AND RT.firing =  0 AND
		TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellAdminSchedule]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellAdminSchedule]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/TempCvView5.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: TempCvView5"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TempCvView5]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[TempCvView5]
GO

delete from GXDBVersions where name = 'TempCvView5' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'TempCvView5', '1.10', 'TempCvView5', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Temp View for Client Configuration Info
CREATE VIEW dbo.TempCvView5
AS
SELECT DISTINCT
 appid = AP.id,
 data_sp =
 case AP.dataArchGrpId
 when 1 then 'not assigned'
 else ARG.name
 end,
 data_sp_copy =
 case
 when ( ARG.defaultcopy = ARP.id) then ARP.name+'(default)'
 else ARP.name
 end,
 data_sp_copy_retendays=
 case AG.retentiondays
    when '-1' then 'unlimited'
    else convert(varchar(5), AG.retentiondays)
 end,
 data_sp_copy_fullcycles=
 case ARG.type
 when 3 then ''
 else
   case AG.fullcycles
   when '-1' then 'unlimited'
   else convert(varchar(5), AG.fullcycles)
   end
 end,
 data_sp_schedauxcopypattern=
 case
 when ( GAS.sp_src_copy_id = ARP.id) then GAS.schedpattern + ' / ' + GAS.schedinterval
 else ''
 end,
 data_sp_schedauxcopyday=
 case
 when ( GAS.sp_src_copy_id = ARP.id) then GAS.schedday
 else ''
 end,
 data_sp_schedauxcopytime=
 case
 when ( GAS.sp_src_copy_id = ARP.id) then GAS.schedtime
 else ''
 end,
 data_sp_schednextauxcopytime=
 case
 when ( GAS.sp_src_copy_id = ARP.id ) then convert(varchar(36), GAS.schednexttime)
 else ''
 end,
 data_sp_scheddestcopy=
 case
 when ( GAS.sp_src_copy_id = ARP.id) then GAS.sp_dest_copy
 else ''
 end,
 log_sp=
 case AP.logArchGrpId
 when 1 then 'not assigned'
 else (select ARG.name from ArchGroup ARG where ARG.id=AP.logArchGrpId)
 end
FROM APP_Application AP
LEFT JOIN  ArchGroup ARG ON AP.dataArchGrpId=ARG.id
LEFT JOIN  ArchGroupCopy ARP ON ARG.id=ARP.archGroupId
LEFT JOIN CommCellAdminSchedule GAS ON  GAS.sp_id=cast(ARP.id as varchar(50))  and  GAS.sp_src_copy_id <> 'not apply'
LEFT JOIN archAgingRule AG ON ARP.id=AG.copyid
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [TempCvView5]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [TempCvView5]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellStoragePolicy.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellStoragePolicy"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellStoragePolicy]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellStoragePolicy]
GO

delete from GXDBVersions where name = 'CommCellStoragePolicy' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellStoragePolicy', '1.9', 'CommCellStoragePolicy', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display Storage Policy Info
CREATE VIEW dbo.CommCellStoragePolicy
AS
SELECT Distinct
    storagepolicy = ARG.name ,
    defaultcopy = ARP.name ,
    hardwarecompress =
    CASE (select IsHardwareCompressed from MMDataPath where MG.DataPathId = DataPathId)
    WHEN 1 THEN 'Yes'
    WHEN 0 THEN 'No'
    ELSE 'Unknown'
    END,
    maxstreams = ARG.maxstreams ,
    drivepool = MP.DrivepoolName ,
    library = ML.Libraryname ,
    appid=AP.id,
    clientname = C.name ,
    idataagent = APT.name ,
    instance =
 case ITN.name
 when 'DefaultInstanceName' then ''
 when 'defaultDummyInstanceForOracle' then ''
 else ITN.name
 end,
    backupset =
    case APT.type
 when 6 then 'NULL'
 when 9 then 'NULL'
 when 15 then 'NULL'
 when 27 then 'NULL'
 when 31 then 'NULL'
 else BN.name
    end,
 subclient=AP.subClientName
FROM ArchGroup ARG LEFT JOIN
    ArchGroupCopy ARP ON ARG.id = ARP.archGroupId AND ARG.defaultCopy = ARP.id LEFT JOIN
    ArchStream ARS ON ARP.id = ARS.archGroupCopyId AND ARG.id = ARS.archGroupId and ARS.stream = 1  LEFT JOIN
    MMMediaGroup MG ON ARS.mediagroupid = MG.mediagroupid LEFT JOIN
    MMDrivePool MP ON MG.DrivePoolId = MP.DrivePoolId JOIN
    MMMasterPool MMP ON MMP.MasterPoolId = MP.MasterPoolId LEFT JOIN
    MMLibrary ML ON MMP.LibraryId = ML.LibraryId LEFT JOIN
    APP_Application AP ON ARG.id = AP.dataArchGrpId LEFT JOIN
    APP_Client C ON AP.clientid = C.id LEFT JOIN
    APP_iDAType APT ON AP.apptypeid = APT.type LEFT JOIN
    APP_InstanceName ITN ON AP.instance = ITN.id LEFT JOIN
    APP_BackupSetName BN ON AP.backupset = BN.id LEFT JOIN
    MMDataPath AS MDP ON ARP.id = MDP.CopyId AND MG.DataPathId = MDP.DataPathId AND MP.DrivePoolId = MDP.DrivePoolId
WHERE ARG.id > 0
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellStoragePolicy]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellStoragePolicy]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientConfig.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientConfig"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientConfig]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientConfig]
GO

delete from GXDBVersions where name = 'CommCellClientConfig' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientConfig', '1.27', 'CommCellClientConfig', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Client Configuration Info
CREATE VIEW dbo.CommCellClientConfig
AS
SELECT
ClientId=C.id,
'Client'=C.name,
NetworkInterface = C.net_hostname ,
'OS [Version]'= dbo.getClientOSName(C.id, NULL) + ' [' + dbo.getClientOSVersion(C.id, NULL) + ']',
'Hardware'= dbo.getClientHardwareName(C.id, NULL),
GalaxyRelease =  AGR.Release + '.0(' + (select CP.attrVal from APP_ClientProp CP where componentNameId = C.id AND CP.attrName='Galaxy Build') + ')',
InstallTime =     CASE  WHEN LI.timeVal IS NULL THEN '' ELSE (dbo.UTCToLocalStringTime(LI.timeVal,(SELECT  TimeZoneStdName
					FROM    SchedTimeZone
					INNER JOIN APP_CommCell CC ON CC.id =2
					AND   TimeZoneName = SUBSTRING(CC.timeZone, CHARINDEX(':', CC.timeZone, CHARINDEX(':', CC.timeZone, 0) + 1) + 1, 255)))) END,
UninstallTime =  CASE  CP.attrval  WHEN '1' THEN  (CASE  WHEN LU.timeVal IS NULL  THEN '' ELSE (dbo.UTCToLocalStringTime(LU.timeVal,(SELECT  TimeZoneStdName
				 FROM    SchedTimeZone
				 INNER JOIN APP_CommCell CC ON CC.id =2
				 AND   TimeZoneName = SUBSTRING(CC.timeZone, CHARINDEX(':', CC.timeZone, CHARINDEX(':', CC.timeZone, 0) + 1) + 1, 255)))) END) ELSE '' END,
DeletedTime = '',
ClientStatus =
 CASE  CP.attrval
  WHEN '1' THEN 'uninstalled'
  ELSE 'installed'
  END,
ClientBkpEnable =
 CASE  CP.attrval  WHEN '1' THEN 'N/A'
 ELSE
 (CASE
	( select JA.action from JMJobAction JA where C.id = JA.clientid and JA.apptype = 0  and JA.optype = 4 )
	   WHEN 2 THEN 'Yes'
	   WHEN 1 THEN 'No'
	   ELSE 'NULL'
	   END)
	  end,
ClientRstEnable =
  CASE  CP.attrval WHEN '1' THEN 'N/A'
  ELSE
	(CASE
	   ( select JA.action from JMJobAction JA where C.id = JA.clientid and JA.apptype = 0  and JA.optype = 5 )
	   WHEN 2 THEN 'Yes'
	   WHEN 1 THEN 'No'
	   ELSE 'NULL'
	   END)
	END
FROM  APP_Client C LEFT JOIN
       simAllGalaxyRel AGR ON C.releaseId = AGR.id LEFT JOIN
	    APP_ClientProp CP ON C.id = CP.componentNameId  and CP.attrname = 'PlatformDeleted 4' and CP.modified = 0
	    LEFT JOIN
	    (SELECT CId, timeVal = MIN(OpTimeUTC) FROM  LicUsageHistory
				where OpType = 'Install' and AppType = 1001
				GROUP BY CId) LI
		ON C.id = LI.CId
	    LEFT JOIN
	    (SELECT CId, timeVal = MIN(OpTimeUTC) FROM  LicUsageHistory
				where OpType = 'Uninstall' and AppType = 1001
				GROUP BY CId) LU
		ON C.id = LU.CId
WHERE C.id !=1
AND (C.specialClientFlags & 1 )<> 1
UNION
SELECT DISTINCT L.CId, Name, 'N/A','N/A','N/A','N/A',CASE  WHEN LI.timeVal IS NULL THEN '' ELSE dbo.UTCToLocalStringTime(LI.timeVal,(SELECT  TimeZoneStdName
					FROM    SchedTimeZone
					INNER JOIN APP_CommCell CC ON CC.id =2
					AND   TimeZoneName = SUBSTRING(CC.timeZone, CHARINDEX(':', CC.timeZone, CHARINDEX(':', CC.timeZone, 0) + 1) + 1, 255))) END ,'',
					CASE  WHEN LD.timeVal IS NULL THEN '' ELSE dbo.UTCToLocalStringTime(LD.timeVal,(SELECT  TimeZoneStdName
					FROM    SchedTimeZone
					INNER JOIN APP_CommCell CC ON CC.id =2
					AND   TimeZoneName = SUBSTRING(CC.timeZone, CHARINDEX(':', CC.timeZone, CHARINDEX(':', CC.timeZone, 0) + 1) + 1, 255))) END,L.OpType,'N/A','N/A'
FROM LicUsageHistory L
	LEFT JOIN
	    (SELECT CId, timeVal =MIN(OpTimeUTC) FROM  LicUsageHistory
				where OpType = 'Deleted' and AppType = 1001
				GROUP BY CId) LD
		ON L.Cid = LD.CId
	LEFT JOIN
	    (SELECT CId, timeVal =MIN(OpTimeUTC) FROM  LicUsageHistory
				where OpType = 'install' and AppType = 1001
				GROUP BY CId) LI
		ON L.Cid = LI.CId
WHERE OpType = 'Deleted' and AppType = 1001 AND L.CId NOT IN (SELECT id from APP_Client)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellClientConfig]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientConfig]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellSubClientConfig.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellSubClientConfig"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellSubClientConfig]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellSubClientConfig]
GO

delete from GXDBVersions where name = 'CommCellSubClientConfig' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellSubClientConfig', '1.20', 'CommCellSubClientConfig', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display SubClient Configuration Info
CREATE VIEW dbo.CommCellSubClientConfig
AS
SELECT DISTINCT
 appid = AP.id,
 clientid = C.id,
 clientname = C.name ,
 idataagent = APT.name ,
 idataagentstatus = ISNULL( ( SELECT 'installed' FROM APP_IDAName WHERE clientId = C.id AND appTypeId = APT.type AND status & 2 = 0), 'uninstalled'),
  idagentbkenable =
 CASE
 ( select JA.action from JMJobAction JA where C.id = JA.clientid and JA.apptype = APT.type and JA.optype = 4 )
   WHEN 2 THEN 'Yes'
   WHEN 1 THEN 'No'
   ELSE 'NULL'
   END,
 idagentrstenable =
  CASE
   ( select JA.action from JMJobAction JA where C.id = JA.clientid and JA.apptype = APT.type  and JA.optype = 5 )
   WHEN 2 THEN 'Yes'
   WHEN 1 THEN 'No'
   ELSE 'NULL'
   END,
 instance =
 case ITN.name
 when 'DefaultInstanceName' then ''
 when 'defaultDummyInstanceForOracle' then ''
 else ITN.name
 end,
 backupset =
 case APT.type
    WHEN 6 THEN 'NULL'
    WHEN 9 THEN 'NULL'
    WHEN 15 THEN 'NULL'
    WHEN 27 THEN 'NULL'
    WHEN 31 THEN 'NULL'
 else BN.name
 end,
 subclient = AP.subclientName,
 subclientstatus =
 case AP.subclientstatus
        WHEN 0 THEN 'Active'
		WHEN 2 THEN 'Uninstalled'
		WHEN 4 THEN 'Deleted'
		WHEN 6 THEN 'Deleted (Uninstalled)'
		WHEN 8 THEN 'Default'
		WHEN 10 THEN 'Default (Uninstalled)'
		WHEN 12 THEN 'Default (Deleted)'
		--Dummy
		WHEN 16 THEN 'Dummy'
		WHEN 18 THEN 'Dummy (Uninstalled)'
		WHEN 20 THEN 'Dummy (Deleted)'
		WHEN 24 THEN 'Dummy (Default)'
		WHEN 26 THEN 'Dummy (Default, Uninstalled)'
		WHEN 28 THEN 'Dummy (Default, Deleted)'
		--Hidden
		WHEN 32 THEN 'Hidden'
		WHEN 34 THEN 'Hidden (Uninstalled)'
		WHEN 36 THEN 'Hidden (Deleted)'
		WHEN 40 THEN 'Hidden (Default)'
		WHEN 42 THEN 'Hidden (Default, Uninstalled)'
		WHEN 44 THEN 'Hidden (Default, Deleted)'
		--Cmd Line
		WHEN 64 THEN 'Cmd Line'
		WHEN 66 THEN 'Cmd Line (Uninstalled)'
		WHEN 68 THEN 'Cmd Line (Deleted)'
		WHEN 72 THEN 'Cmd Line (Deleted)'
		WHEN 74 THEN 'Cmd Line (Default, Uninstalled)'
		WHEN 76 THEN 'Cmd Line (Default, Deleted)'
		--Tran Log
        WHEN 128 THEN 'Tran Log'
		WHEN 130 THEN 'Tran Log (Uninstalled)'
		WHEN 132 THEN 'Tran Log (Deleted)'
		WHEN 136 THEN 'Tran Log (Default)'
		WHEN 138 THEN 'Tran Log (Default, Uninstalled)'
		WHEN 142 THEN 'Tran Log (Default, Deleted)'
		--System Recovery
		WHEN 256 THEN 'System Recovery'
		WHEN 258 THEN 'System Recovery (Uninstalled)'
		WHEN 260 THEN 'System Recovery (Deleted)'
		WHEN 264 THEN 'System Recovery (Default)'
		WHEN 266 THEN 'System Recovery (Default, Uninstalled)'
		WHEN 268 THEN 'System Recovery (Default, Deleted)'
		--Erase for backup
		WHEN 512 THEN 'Erase for backup'
		WHEN 514 THEN 'Erase for backup (Uninstalled)'
		WHEN 516 THEN 'Erase for backup (Deleted)'
		WHEN 520 THEN 'Erase for backup (Default)'
		WHEN 522 THEN 'Erase for backup (Default, Uninstalled)'
		WHEN 524 THEN 'Erase for backup (Default, Deleted)'
		--FileSystem Index
		WHEN 536 THEN 'FileSystem Index'
		WHEN 538 THEN 'FileSystem Index (Uninstalled)'
		WHEN 540 THEN 'FileSystem Index (Deleted)'
		--ILM class
		WHEN 1024 THEN 'ILM class'
		WHEN 1026 THEN 'ILM class (Uninstalled)'
		WHEN 1028 THEN 'ILM class (Deleted)'
		WHEN 1032 THEN 'ILM class (Default)'
		--SPDB
		WHEN 2048 THEN 'SPDB'
		WHEN 2050 THEN 'SPDB (Uninstalled)'
		WHEN 2052 THEN 'SPDB (Deleted)'
		WHEN 2056 THEN 'SPDB (Default)'
		WHEN 2058 THEN 'SPDB (Default, Uninstalled)'
		WHEN 2060 THEN 'SPDB (Default, Deleted)'
else
		case AP.dataArchGrpId
			when 1 then ' '
			else 'valid'
		end
end,
 schedjobpattern= GBS.schedpattern + ' / ' + GBS.schedinterval,
 schedbackupday=GBS.schedbackupday,
 schedbackuptime=GBS.schedbackuptime,
 schednextbackuptime=GBS.schednextbackuptime,
 data_sp =t5.data_sp,
 data_sp_copy = t5.data_sp_copy,
 data_sp_copy_retendays=t5.data_sp_copy_retendays,
 data_sp_copy_fullcycles=t5.data_sp_copy_fullcycles,
 data_sp_schedauxcopypattern=t5.data_sp_schedauxcopypattern,
 data_sp_schedauxcopyday=t5.data_sp_schedauxcopyday,
 data_sp_schedauxcopytime=t5.data_sp_schedauxcopytime,
 data_sp_schednextauxcopytime=t5.data_sp_schednextauxcopytime,
 data_sp_scheddestcopy=t5.data_sp_scheddestcopy,
 log_sp=t5.log_sp,
 temp.fullsize AS [LastFullBkpSize(Bytes)],
 temp.incsize AS [LastIncBkpSize(Bytes)],
 temp.diffsize AS [LastDiffBkpSize(Bytes)],
 dbo.GetReportApptypeName(APT.type) AS [QDisplayName],
 (case (APT.type)
            WHEN 1000 then (SELECT name FROM APP_iDAType WHERE APP_iDAType.type = 1000)
            ELSE (SELECT displayName  FROM app_idaType WHERE app_idaType.type = APT.type)
  END) As [xmlDisplayName]
FROM   (SELECT DISTINCT appid,
                        (SELECT     TOP 1 j1.totaluncompbytes
                         FROM          jmbkpstats AS j1
                         WHERE      j1.appid = JB.appid AND (j1.bkplevel = 1 or j1.bkplevel = 0x400 or j1.bkplevel = 0x8000) AND j1.status = 1
                         ORDER BY servstartdate DESC) AS FullSize,
                        (SELECT     TOP 1 j2.totaluncompbytes
                         FROM          jmbkpstats AS j2
                         WHERE      j2.appid = JB.appid AND j2.bkplevel = 2 AND j2.status = 1
                         ORDER BY servstartdate DESC) AS IncSize,
                        (SELECT     TOP 1 j4.totaluncompbytes
                         FROM          jmbkpstats AS j4
                         WHERE      j4.appid = JB.appid AND j4.bkplevel = 4 AND j4.status = 1
                         ORDER BY servstartdate DESC) AS DiffSize
         FROM   jmbkpstats JB
       ) AS temp RIGHT OUTER JOIN     dbo.APP_Application AS AP ON AP.id = temp.appid
LEFT JOIN APP_iDAType APT ON  AP.appTypeId=APT.type
LEFT JOIN APP_InstanceName ITN ON AP.instance=ITN.id
LEFT JOIN APP_BackupSetName BN ON AP.backupset=BN.id
LEFT JOIN APP_Client C ON AP.clientId=C.id
LEFT JOIN CommCellBkSchedule GBS ON AP.id=GBS.appid or ((BN.name = GBS.backupset and C.name=GBS.clientname and APT.name = GBS.idataagent) and GBS.appid=0)
LEFT JOIN TempCvView5 t5 ON AP.id=t5.appid
WHERE C.id > 1 and AP.subclientname != 'Do Not Backup'
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellSubClientConfig]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellSubClientConfig]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBackupInfo', '1.26', 'CommCellBackupInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup History Info
CREATE VIEW dbo.CommCellBackupInfo
AS
SELECT
jobid=BS.jobId,
appid=BS.appid,
jobinitfrom=
case BS.initFrom
when 1 then 'Command Line'
when 2 then 'Gui'
when 3 then 'Schedule'
when 4 then 'System'
end,
clientname = dbo.APP_Client.name,
idataagent = dbo.APP_IDAType.name,
instance = APP_InstanceName.name,
backupset = dbo.APP_BackupSetName.Name,
subclient = dbo.app_application.SubClientName,
data_sp = AG.name,
backuplevelInt =BS.bkplevel,
backuplevel =
CASE  BS.bkplevel
 WHEN 1 THEN 'Full'
 WHEN 2 THEN 'Incremental'
 WHEN 4 THEN 'Differential'
 WHEN 64 THEN 'SyntheticFull'
 WHEN 256 THEN 'Transaction Log w. NoTruncate'
 WHEN 512 THEN 'ASR'
 ELSE 'Unknown'
 END,
incrlevel =
case  BS.bkplevel
when 2 then
     case BS.oraSublevel
     when 0 then 1
     else BS.oraSublevel
     end
else 0
end,
jobstatusInt =BS.status,
jobstatus =
 CASE BS.status
 WHEN 1 THEN 'Success'
 WHEN 2 THEN 'Failed'
 WHEN 3 THEN 'PartialSuccess'
 WHEN 4 THEN 'Killed'
 WHEN 5 THEN 'Stopped'
 WHEN 6 THEN 'Interrupted'
 WHEN 9 THEN 'Failed to Start'
 ELSE 'Unknown'
 END,
jobfailedreason =
case
when BS.status > 1 then
	case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 		then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
				from JMBkpAtmptStats
				where jobid =Bs.jobid)
		 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
	end
else ''
end,
startdateunixsec =  BS.servStartdate,
enddateunixsec = BS.servEndDate,
startdate = dbo.GetDateTime(BS.servStartDate),
enddate =dbo.GetDateTime(BS.servEndDate),
durationunixsec = BS.duration,
duration = case
  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
  else ''
  end,
numstreams = BS.numStreams,
numbytesuncomp= BS.totaluncompbytes,
numbytescomp=BS.totalcompbytes,
numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
isAged=
 (CASE BS.agedtime
	 WHEN 0 THEN 0
	 WHEN NULL THEN 0
	 ELSE 1
 END),
isAgedStr=
 (CASE BS.agedtime
	 WHEN 0 THEN 'No'
	 WHEN NULL THEN 'No'
	 ELSE 'Yes'
 END),
xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
retentionDays = (CASE WHEN (AR.flags & 4) <> 0 THEN 'Data Aging Disabled' WHEN (AR.flags & 128) <> 0 THEN 'Job Count Based Retention'
	WHEN I.isDMAppType = 1 THEN (CASE WHEN AR.ArchiverRetDays = -1 THEN 'Infinite' ELSE CAST(AR.ArchiverRetDays AS VARCHAR(8)) END)
	ELSE (CASE WHEN AR.retentionDays = -1 THEN 'Infinite' ELSE CAST(AR.retentionDays AS VARCHAR(8)) END)
END),
systemStateBackup = CASE WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1 ELSE 0 END,
inPrimaryCopy = ISNULL((1*JD.InPrimaryCopy | 2*JD.InPrimarySnapCopy), 0),
failedobjects=BS.scanFileFailures + BS.scanFolderFailures + BS.backupFileFailures + BS.backupFolderFailures,
BS.totalBackupSize
FROM  dbo.APP_Application INNER JOIN
      dbo.APP_BackupSetName ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
      dbo.APP_InstanceName ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
      dbo.APP_iDAType ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
      dbo.APP_Client ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
      dbo.JMBkpStats AS BS ON dbo.APP_Application.id = BS.appId LEFT OUTER JOIN
      (SELECT jobId, commCellId,
              MAX(CASE WHEN J.archGrpCopyId = P.defaultCopy AND J.status = 100 AND (J.disabled & 256) = 0 THEN 1 ELSE 0 END) AS InPrimaryCopy,
              MAX(CASE WHEN J.archGrpCopyId = P.defaultSnapCopy AND J.status = 100 AND (J.disabled & 256) = 0 THEN 1 ELSE 0 END) AS InPrimarySnapCopy
         FROM JMJobDataStats J INNER JOIN archGroup P ON J.archGrpId = P.id
        GROUP BY jobId, commCellId) JD ON BS.jobId = JD.jobId AND BS.commCellId = JD.commCellId INNER JOIN
      dbo.archGroup AG ON AG.id > 1 AND (BS.dataArchGrpId = AG.id OR BS.dataArchGrpId <= 1 AND BS.logArchGrpId = AG.id) INNER JOIN
      dbo.archAgingRule AR ON AR.copyId = AG.defaultCopy AND BS.opType NOT IN (59, 65)
		OR AR.copyId = AG.defaultSnapCopy AND BS.opType IN (59, 65) LEFT OUTER JOIN
      dbo.APP_IDATypeHandlingInfo I ON I.appTypeId = BS.appType
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellBackupInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBackupInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellRestoreInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellRestoreInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellRestoreInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellRestoreInfo]
GO

delete from GXDBVersions where name = 'CommCellRestoreInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellRestoreInfo', '1.17', 'CommCellRestoreInfo', '')
GO
  --- Copyright (c) 1998  CommVault Systems, Inc.
  --- Display Restore History Info
CREATE VIEW dbo.CommCellRestoreInfo
AS
SELECT
    jobid=RS.jobid,
    destclientname = C.name ,
    idataagent = APT.name ,
    instance =
 case ITN.name
 when 'DefaultInstanceName' then ''
 when 'defaultDummyInstanceForOracle' then ''
 else ITN.name
 end,
    backupset =
    case APT.type
when 6 then 'NULL'
when 9 then 'NULL'
when 15 then 'NULL'
when 27 then 'NULL'
when 31 then 'NULL'
else BN.name
    end,
    jobstatus =
    CASE RS.status
    WHEN 1 THEN 'Successful'
    WHEN 2 THEN 'Failed'
    WHEN 3 THEN 'PartialSuccess'
    WHEN 4 THEN 'Killed'
    WHEN 5 THEN 'Stopped'
    WHEN 6 THEN 'Interrupted'
    WHEN 9 THEN 'Failed to Start'
    ELSE 'Unknown'
    END,
    jobfailedreason =
case
when RS.status > 1 then dbo.JMGetLocalizedMessageFunc(0,failureReason)
else ''
end,
   starttimeunixsec = RS.servStartTime,
   endtimeunixsec = RS.servEndTime,
   starttime =
    CASE datepart(month, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
    WHEN  4  THEN
        case datepart(dd, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 6 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
         when 5 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 4 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 5 then  dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 3 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                when 3  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 2 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 1 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    WHEN 5  THEN dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 6  THEN dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 7  THEN dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 8  THEN dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 9  THEN dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 10  THEN
	case datepart(dd, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 31 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
         when 30 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 29 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 6 then  dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 28 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                when 4  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 27 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 26 then
                case datepart(dw, dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (RS.servStartTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    ELSE  dateadd (second, convert(real, (RS.servStartTime - 915170400)), '01/01/1999 01:00:00AM')
    END,
   endtime =
    CASE datepart(month, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
    WHEN  4  THEN
        case datepart(dd, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 6 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
         when 5 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 4 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 6  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 5 then  dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 3 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                when 3  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 2 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 2  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 1 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    WHEN 5  THEN dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 6  THEN dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 7  THEN dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 8  THEN dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 9  THEN dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
    WHEN 10  THEN
      case datepart(dd, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
              when 31 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
         when 30 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           end
               when 29 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 7  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 1  then   dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           when 6 then  dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 28 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                when 4  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 27 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           when 3  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
               when 26 then
                case datepart(dw, dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM'))
                           when 2  then   dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
                           else
                         dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
                           end
              else dateadd (second, convert(real, (RS.servEndTime - 915170400 + 3600)), '01/01/1999 01:00:00AM')
        end
    ELSE  dateadd (second, convert(real, (RS.servEndTime - 915170400)), '01/01/1999 01:00:00AM')
    END,
  durationunixsec = RS.duration,
  duration = case
  when RS.duration between 0 and 60 then  convert (varchar(2), RS.duration) + ' s'
  when RS.duration between 60 and 3600 then convert(varchar(2), RS.duration/60) + ' m ' + convert (varchar(2), RS.duration % 60) + ' s'
  when RS.duration between 3600 and 86400 then convert(varchar(2), RS.duration/3600) + ' h ' + convert (varchar(2), (RS.duration % 3600)/60) + ' m ' + convert(varchar(2), (RS.duration%3600)%60) + ' s'
  when RS.duration > 86400 then convert(varchar(3), RS.duration/86400) + ' d ' + convert(varchar(2), (RS.duration%86400)/3600) +' h ' + convert(varchar(2), (((RS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((RS.duration%86400)%3600)%60)) + ' s'
  else ''
  end,
   numfiles=convert(real, RS.totFiles2xfer_h) * 214748.3648*10000 + convert(real, RS.totFiles2xfer_l) ,
   numbytescomp= convert(real, RS.totCompBytes_h) * 214748.3648*10000 + convert(real, RS.totCompBytes_l),
   numbytesuncomp = convert(real, RS.totUnCompBytes_h) * 214748.3648*10000 + convert(real, RS.totUnCompBytes_l),
   xmlJobOptions = dbo.GetXMLJobOptions(RS.jobId),
   UserName=RS.username,
   ScheduleName=ISNULL(T.subTaskName,'')
FROM JMRestoreStats RS
    JOIN APP_Client C ON RS.destClientId = C.id
    JOIN APP_iDAType APT ON RS.appType = APT.type
    JOIN APP_InstanceName ITN ON RS.instanceId = ITN.id
    JOIN APP_BackupSetName BN ON RS.bkpsetId = BN.id
    LEFT OUTER JOIN TM_SubTask T on RS.subTaskId=T.subTaskId
WHERE C.id > 1
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellRestoreInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellRestoreInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientFSFilters.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientFSFilters"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientFSFilters]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientFSFilters]
GO

delete from GXDBVersions where name = 'CommCellClientFSFilters' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientFSFilters', '1.19', 'CommCellClientFSFilters', '')
GO
 --- Copyright (c) 2003  CommVault Systems, Inc.
 --- Display Client FS iDA Filters Info
CREATE VIEW dbo.CommCellClientFSFilters
AS
SELECT DISTINCT
CommCellID = (SELECT UPPER(substring(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
CommCellName = CCELL.aliasName,
appid=FC.componentNameId,
clientname = C.name ,
idataagent = APT.name ,
backupset = BN.name,
subclient = AP.subclientName ,
subclientstatus=
 case AP.subclientstatus
       when 2 then 'Uninstalled'
       when 4 then 'Deleted'
--       when 8 then 'Default'
--      when 16 then 'Dummy'
--       when 32 then 'Hidden'
--       when 64 then 'Cmd Line'
--       when 128 then 'Tran Log'
--       when 256 then 'System Recovery'
 else
	case AP.dataArchGrpId
	when 1 then ' '
	else 'valid'
	end
end,
content=
case FC.type
when 1 then FC.fileName
else ''
end,
Include_Global_Filters =
case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use global filters' and SP.attrType=2  and SP.modified=0)
when  '1'  then  'ON'
when  '0'  then  (case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use cs setting for global filters' and SP.attrType=2  and SP.modified=0)
				when  '1'  then  'Use Cell Level Policy' ELSE 'OFF' END)
else 'OFF'
end,
global_exclude_filter =
case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use global filters' and SP.attrType=2  and SP.modified=0)
when  '1'  then  CAST(GP.value as varchar(2048))
when  '0'  then  (case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use cs setting for global filters' and SP.attrType=2  and SP.modified=0)
				when  '1'  then  CAST(GP.value as varchar(2048)) else '' END)
else ''
end,
'exclude_dirs/files/patterns' =
case FC.type
when 3 then FC.fileName
else ''
end,
'except_dirs/files/patterns_to_exclude'=
case FC.type
when 2 then FC.fileName
else ''
end,
Backup_System_State=
case ( select attrval from APP_SubClientProp SC where SC.componentNameId = AP.id and SC.attrName = 'System State' AND modified = 0)
when '1' then 'Yes' else 'No'
end
FROM  APP_ScFilterFile FC
JOIN APP_Application AP ON AP.id=FC.componentNameId and FC.modified=0
JOIN APP_Client C ON AP.clientId=C.id and C.id > 1
LEFT JOIN  APP_CommCell CCELL ON 2 = CCELL.id
JOIN APP_iDAType APT ON  AP.appTypeId=APT.type and APT.name != 'Sybase Database'
JOIN APP_BackupSetName BN ON AP.backupset=BN.id
LEFT JOIN GXGlobalParam GP ON (GP.name LIKE 'Win%filter%' AND APT.name LIKE 'Windows%')
OR (GP.name LIKE 'Unix%filter%' AND (APT.name LIKE 'Unix%' OR APT.name LIKE 'Linux%' OR APT.name LIKE 'AIX%' OR APT.name LIKE 'Solaris%'))
OR (GP.name LIKE 'Netware%filter%' AND APT.name LIKE 'Netware%')
OR (GP.name LIKE 'Exchange Mailbox%Filters' AND APT.name LIKE 'Exchange%Mailbox')
OR (GP.name LIKE 'Exchange DataMigrator%Filters' AND APT.name LIKE 'Exchange%Mailbox Archiver')
OR (GP.name LIKE 'Exchange Archiver%Filters' AND APT.name LIKE 'Exchange %Compliance Archiver')
-- Pick up filter info for those subclients that use sub-client policy filters
UNION ALL
SELECT DISTINCT
CommCellID = (SELECT UPPER(substring(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
CommCellName = CCELL.aliasName,
appid=AP.id,
clientname = C.name ,
idataagent = APT.name ,
backupset = BN.name,
subclient = AP.subclientName ,
subclientstatus=
 case AP.subclientstatus
       when 2 then 'Uninstalled'
       when 4 then 'Deleted'
--       when 8 then 'Default'
--      when 16 then 'Dummy'
--       when 32 then 'Hidden'
--       when 64 then 'Cmd Line'
--       when 128 then 'Tran Log'
--       when 256 then 'System Recovery'
 else
	case AP.dataArchGrpId
	when 1 then ' '
	else 'valid'
	end
end,
content=
case FC.type
when 1 then FC.fileName
else ''
end,
Include_Global_Filters =
case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use global filters' and SP.attrType=2  and SP.modified=0)
when  '1'  then  'ON'
when  '0'  then  (case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use cs setting for global filters' and SP.attrType=2  and SP.modified=0)
				when  '1'  then  'Use Cell Level Policy' ELSE 'OFF' END)
else 'OFF'
end,
global_exclude_filter =
case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use global filters' and SP.attrType=2  and SP.modified=0)
when  '1'  then  CAST(GP.value as varchar(2048))
when  '0'  then  (case (select SP.attrVal from APP_SubclientProp SP where SP.componentNameId=FC.componentNameId and SP.attrName='use cs setting for global filters' and SP.attrType=2  and SP.modified=0)
				when  '1'  then  CAST(GP.value as varchar(2048)) else '' END)
else ''
end,
'exclude_dirs/files/patterns' =
case FC.type
when 3 then FC.fileName
else ''
end,
'except_dirs/files/patterns_to_exclude'=
case FC.type
when 2 then FC.fileName
else ''
end,
Backup_System_State=
case ( select attrval from APP_SubClientProp SC where SC.componentNameId = AP.id and SC.attrName = 'System State' AND modified = 0)
when '1' then 'Yes' else 'No'
end
FROM  APP_ScFilterFile FC
JOIN APP_SubClientProp APP ON APP.cs_attrName = '1461505555' AND APP.attrVal=FC.componentNameId and FC.modified=0
JOIN APP_Application AP ON AP.id=APP.componentNameId and APP.modified=0
JOIN APP_Client C ON AP.clientId=C.id and C.id > 1
LEFT JOIN  APP_CommCell CCELL ON 2 = CCELL.id
JOIN APP_iDAType APT ON  AP.appTypeId=APT.type and APT.name != 'Sybase Database'
JOIN APP_BackupSetName BN ON AP.backupset=BN.id
LEFT JOIN GXGlobalParam GP ON (GP.name LIKE 'Win%filter%' AND APT.name LIKE 'Windows%')
OR (GP.name LIKE 'Unix%filter%' AND (APT.name LIKE 'Unix%' OR APT.name LIKE 'Linux%'))
OR (GP.name LIKE 'Netware%filter%' AND APT.name LIKE 'Netware%')
OR (GP.name LIKE 'Exchange Mailbox%Filters' AND APT.name LIKE 'Exchange%Mailbox')
OR (GP.name LIKE 'Exchange DataMigrator%Filters' AND APT.name LIKE 'Exchange%Mailbox Archiver')
OR (GP.name LIKE 'Exchange Archiver%Filters' AND APT.name LIKE 'Exchange %Compliance Archiver')
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellClientFSFilters]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientFSFilters]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellJobControllerCount.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellJobControllerCount"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellJobControllerCount]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellJobControllerCount]
GO

delete from GXDBVersions where name = 'CommCellJobControllerCount' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellJobControllerCount', '1.8', 'CommCellJobControllerCount', '')
GO
 ---Copyright (c) 1998  CommVault Systems, Inc.
 --- Display JobController Count Info
CREATE VIEW dbo.CommCellJobControllerCount
AS
select
commcellid=(SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8)) FROM APP_CommCell CCELL WHERE CCELL.id = JI.commCellId),
jobtype=
case JI.optype
when 4 then 'Backup'
when 5 then 'Restore'
else 'Other'
end,
numofpending=
(select count( displaystate) from JMJobInfo where displaystate=2 and optype=JI.optype ),
numofwaiting=
(select count( displaystate) from JMJobInfo where displaystate=3 and optype=JI.optype ),
numofstopped=
(select count( displaystate) from JMJobInfo where displaystate=5 and optype=JI.optype ),
numofqueued=
(select count( displaystate) from JMJobInfo where displaystate=15 and optype=JI.optype ),
numofrunning=
(select count( displaystate) from JMJobInfo where displaystate!= 2 and displaystate!=3 and displaystate!=5 and displaystate!=15 and optype=JI.optype)
from JMJobInfo JI
group by commcellid, opType
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellJobControllerCount]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellJobControllerCount]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellUpdateInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellUpdateInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellUpdateInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellUpdateInfo]
GO

delete from GXDBVersions where name = 'CommCellUpdateInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellUpdateInfo', '1.8', 'CommCellUpdateInfo', '')
GO
 ---Copyright (c) 1998  CommVault Systems, Inc.
 --- Display CommCell Update Info
CREATE VIEW dbo.CommCellUpdateInfo
AS
select
clientid=C.id,
'client [idataagent]'=C.name + ' [' + AT.name + ']' ,
galaxyrelease=GR.release+ '.0(' + CP.attrVal + ')',
installedSP=cast(P.HighestSP as varchar(2048)),
'installedAdditionalPatch [latest]'=
case (cast(P.AdditionalPatches as varchar(max)))
		when '' then 'None'
		else (cast(P.AdditionalPatches as varchar(2048)))
end
+' [' +
case
	when CONVERT(varchar(max), P.AdditionalPatches) in ('', 'None') then 'None'
    else (
    case (CHARINDEX(',',REVERSE(CONVERT(varchar(max), P.AdditionalPatches)),2))
    when 0 then
      substring(P.AdditionalPatches,1,len(CONVERT(varchar(max), P.AdditionalPatches))-1)
    else
      substring(P.AdditionalPatches, len(CONVERT(varchar(max), P.AdditionalPatches)) -
      CHARINDEX(',',REVERSE(CONVERT(varchar(max), P.AdditionalPatches)),2)+2,
      CHARINDEX(',',REVERSE(CONVERT(varchar(max), P.AdditionalPatches)),2)-2 )
    end
    )
end
+ ']' ,
missingPatch =  cast(P.MissingPatches as varchar(2048))
from 		APP_Client C,
		simAllGalaxyRel GR,
		simPackage AT,
		simInstalledPackages P,
		APP_ClientProp CP
where 		c.id = P.clientID
		and GR.id = C.ReleaseID
		and AT.id = P.simPackageID
		and C.id=CP.componentNameId AND CP.attrName='Galaxy Build'
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellUpdateInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellUpdateInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkupSizeInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkupSizeInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkupSizeInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkupSizeInfo]
GO

delete from GXDBVersions where name = 'CommCellBkupSizeInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkupSizeInfo', '1.9', 'CommCellBkupSizeInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Last Backup Size Info
CREATE VIEW dbo.CommCellBkupSizeInfo
AS
SELECT
JobId		= JB.JobId,
AppId		= JB.appId,
Client		= (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = AP.clientId),
iDataAgent	= (SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = AP.appTypeId),
Instance	= (SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = AP.instance),
BackupSet	= (SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE id = AP.backupset),
Subclient	= AP.subclientName,
Data_SP		= (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = JB.dataArchGrpId),
BackupType	= (CASE WHEN T.isFullBackup <> 0 THEN 'Full' ELSE 'Incr/Diff/Others' END),
LastBkp_AppSize_WithoutIndex= ISNULL((
			SELECT	TOP 1 physicalsize FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
			WHERE	AF.jobId = JB.jobId AND AF.commCellId = JB.commCellId AND AF.isValid = 1 AND AF.fileType NOT IN (2, 8)
				AND AFC.archFileId = AF.id AND AFC.commCellId = Af.commCellId AND AFC.isValid = 1), 0),
LastBkp_indexSize= ISNULL((
			SELECT TOP 1 physicalsize FROM archFileCopy AFC WITH (NOLOCK), archFile AF WITH (NOLOCK)
			WHERE	AF.jobId = JB.jobId AND AF.commCellId = JB.commCellId AND AF.isValid = 1 AND AF.fileType IN (2, 8)
				AND AFC.archFileId = AF.id AND AFC.commCellId = Af.commCellId AND AFC.isValid = 1), 0),
LastBkp_TotBkpSize		= totalBackupSize,
LastBkp_percentageChange= percentageChange,
IsCompresstionEnabled	= (CASE WHEN APC.appNumber IS NULL THEN 'No' WHEN APC.compressWhere = 2 THEN 'No' ELSE 'Yes' END)
--
FROM	APP_Application AP with(NOLOCK)
		INNER JOIN JMBkpStats JB WITH (NOLOCK)
			ON AP.id = JB.appId
		INNER JOIN (SELECT	appId, (bkpLevel & (1|64|128|16384|1024|32768)) AS isFullBackup, MAX(servStartDate) AS servStartDate
					FROM	JMBkpStats WITH (NOLOCK)
					WHERE	status IN (1, 3) and optype != 58 GROUP BY appId, (bkpLevel & (1|64|128|16384|1024|32768)) ) T
			ON JB.appId = T.appId AND JB.servStartDate = T.servStartDate
		LEFT  JOIN archPipeConfig APC WITH (NOLOCK)
			ON APC.appNumber = AP.id
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellBkupSizeInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkupSizeInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellRetentionInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellRetentionInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellRetentionInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellRetentionInfo]
GO

delete from GXDBVersions where name = 'CommCellRetentionInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellRetentionInfo', '1.6', 'CommCellRetentionInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Retention Info
CREATE VIEW CommCellRetentionInfo
AS
SELECT  DISTINCT
    CommCellID = CONVERT (NVARCHAR(128), CONVERT(VARBINARY(8),  CCELL.number),2),
    CommCellName = CCELL.aliasName,
    SpName = AG.name,
    CopyName = AGC.name,
    RetentionDays = (CASE ARR.retentionDays WHEN -1 THEN 'Infinite' ELSE CAST(ARR.retentionDays AS VARCHAR(1024)) END),
    RetentionCycles = (CASE ARR.fullCycles WHEN -1 THEN 'Infinite' ELSE CAST(ARR.fullCycles AS VARCHAR(1024)) END),
    IsExtendedRetentionEnabled = (CASE WHEN (TRE.retentionDays1 IS NULL) THEN 'No' ELSE  CASE WHEN TRE.retentionDays1 = 0 THEN 'No' ELSE 'Yes' END END),
	ExtendedRetentionRule1 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule1,0)),
	RetentionDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays1) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays1 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays1 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule2 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule2,0)),
	RetentionDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays2) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays2 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays2 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule3 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule3,0)),
	RetentionDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays3) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays3 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays3 AS VARCHAR(100))
						END
FROM		dbo.archGroup AS AG INNER JOIN
			dbo.archGroupCopy AS AGC ON AG.id = AGC.archGroupId INNER JOIN
			dbo.archAgingRule AS ARR ON AGC.id = ARR.copyId INNER JOIN
			dbo.APP_CommCell CCELL ON 2 = CCELL.id LEFT OUTER JOIN
			dbo.GetTempExtendedRentiontionTransposedTable() TRE ON TRE.Copyid = AGC.id AND ARR.copyId = TRE.Copyid
      WHERE AG.id > 1  and AGC.type <> 5
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellRetentionInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellPrePostCmdInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellPrePostCmdInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellPrePostCmdInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellPrePostCmdInfo]
GO

delete from GXDBVersions where name = 'CommCellPrePostCmdInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellPrePostCmdInfo', '1.6', 'CommCellPrePostCmdInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Pre-Post Scan /Backup command Info
CREATE VIEW dbo.CommCellPrePostCmdInfo
AS
select client = CL.name,
	   appType = (select name from APP_iDAType where type=APP.appTypeId),
	   backupSet=(select name from APP_BackupSetName where id=APP.backupSet),
	   instance= (select name from APP_InstanceName where id=APP.instance),
	   subclientName,
	   preScanCommand,
	   postScanCommand,
	   preBkpCommand,
	   postBkpCommand,
       userName = (case (select cast(attrVal as integer) from APP_SubClientProp where componentNameId = PPE.componentNameId and attrName = 'use prepost username' and modified = 0) when 1
				   then 'Local System Account'
				   else (select attrVal from APP_SubClientProp where componentNameId = PPE.componentNameId and attrName = 'prepost username' and modified = 0) end),
	   isClientConfigured = (CASE WHEN CL.status & (2|4) = 0 THEN 'Yes' ELSE 'No' END),
	   isSubclientConfigured = (CASE WHEN APP.subclientStatus & (2|4) = 0 THEN 'Yes' ELSE 'No' END)
from
	(select componentNameId, isnull([sys:pre PreIfind],'Not Selected') as PreScanCommand, isnull([sys:post PostIfind],'Not Selected') as PostScanCommand,
		   isnull([sys:pre PreBackup],'Not Selected') as PreBkpCommand, isnull([sys:post PostBackup],'Not Selected') as PostBkpCommand
	from
		(select componentNameId, attrName, attrVal from APP_SubClientProp
			where attrname IN ('sys:post PostBackup', 'sys:post PostIfind', 'sys:pre PreBackup', 'sys:pre PreIfind') and modified = 0 and attrVal <> '') as T1
		pivot(max(attrVal) for attrName in ([sys:pre PreIfind], [sys:post PostIfind], [sys:pre PreBackup], [sys:post PostBackup])) as P
	) PPE
	JOIN APP_Application APP on PPE.componentNameId = APP.id
	JOIN APP_Client CL ON APP.clientId = CL.id
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellPrePostCmdInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellPrePostCmdInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellJobController.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellJobController"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellJobController]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellJobController]
GO

delete from GXDBVersions where name = 'CommCellJobController' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellJobController', '1.7', 'CommCellJobController', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Job Controller Information
CREATE VIEW dbo.CommCellJobController
AS
SELECT *
FROM
(SELECT jobID,
	   operation = dbo.GetJobOperationName(opType),
	   clientComputer = clientName,
	   agentType = appTypeName,
	   subclient = subclientName,
	   jobType = CASE  bkplevel
				 WHEN 1 THEN 'Full'
				 WHEN 2 THEN 'Incremental'
				 WHEN 4 THEN 'Differential'
				 WHEN 64 THEN 'SyntheticFull'
				 WHEN 256 THEN 'Transaction Log w. NoTruncate'
				 WHEN 512 THEN 'ASR'
				 ELSE 'Unknown'
				 END,
	   phase = currentPhaseName,
	   storagePolicy = currentPolicyName,
	   mediaAgent = shortMediaAgent,
	   status =	 dbo.GetJobStateName(state),
	   progress = percentcomplete,
	   errors = dbo.GetJobErrorName(errorType),
	   delayReason = DelayReason,
	   description = jobDescription,
	   scheduleId = backupTaskId,
	   instanceName = instanceName
FROM RunningBackups) derivedTbl_1
UNION ALL
(SELECT jobID,
	   operation = dbo.GetJobOperationName(opType),
	   clientComputer = srcClientName,
	   appType = appTypeName,
	   subclient =  '',
	   jobType = '',
	   phase = currentPhaseName,
	   storagePolicy = '',
	   mediaAgent = '',
	   status =	 dbo.GetJobStateName(state),
	   progress = percentcomplete,
	   errors = dbo.GetJobErrorName(errorType),
	   delayReason = DelayReason,
	   description = jobDescription,
	   scheduleId = rstTaskID,
	   instanceName = instanceName
FROM RunningRestores)
UNION ALL
(SELECT jobID,
	   operation = dbo.GetJobOperationName(opType),
	   clientComputer = clientName,
	   appType = appTypeName,
	   subclientName = subclientName,
	   jobType = '',
	   phase = currentPhaseName,
	   storagePolicy = storagePolicyName,
	   mediaAgent = shortMediaAgent,
	   status =	 dbo.GetJobStateName(state),
	   progress = percentcomplete,
	   errors = dbo.GetJobErrorName(errorType),
	   delayReason = DelayReason,
	   description = jobDescription,
	   scheduleId = subTaskId,
	   instanceName = instanceName
FROM RunningAdminJobs)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellJobController]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellJobController]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellCompletedBkpJobsInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellCompletedBkpJobsInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellCompletedBkpJobsInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellCompletedBkpJobsInfo]
GO

delete from GXDBVersions where name = 'CommCellCompletedBkpJobsInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellCompletedBkpJobsInfo', '1.3', 'CommCellCompletedBkpJobsInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Displays only Completed (FULL/INC/DIFF) Backup Jobs for last 30 days
--- The output of this veiw is similar to Backup Job Summary Report (Summary Section)
---	Report Selection -- Backup Types :Full, Inc & Diff   --Job Status: Completed
CREATE VIEW dbo.CommCellCompletedBkpJobsInfo
AS
SELECT
      ClienID = C.id,
      ClientName = C.name,
      TotalBkpJobs = COUNT(JB.JobID),
      TotalFullBkpJobs = SUM(CASE WHEN JB.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN 1 ELSE 0 END),
      TotalIncBkpJobs = SUM(CASE WHEN JB.BkpLevel IN (2, 0x100) THEN 1 ELSE 0 END),
      TotalOtherBkpJobs = SUM(CASE WHEN JB.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN 1 ELSE 0 END),
      TotalBkpSizeGB = CAST(SUM(JB.totalUncompBytes)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalFullBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalIncBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel IN (2, 0x100) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2)),
      TotalOtherBkpSizeGB = CAST(SUM(CASE WHEN JB.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN JB.totalUncompBytes ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,2))
FROM  JMBkpStats JB WITH (READUNCOMMITTED)
            INNER JOIN APP_Application AP  WITH (READUNCOMMITTED) ON JB.appId = AP.id
            INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON C.id =AP.clientId
WHERE JB.servEndDate <= dbo.GetUnixTime(GETUTCDATE()) --End Time - Current Time
AND JB.servEndDate >= (dbo.GetUnixTime(GETUTCDATE()) - 30 * 24 *60 *60) --Start Time - last 30 days
and JB.datastatus!=1    --donot show aged jobs
and JB.datastatus!=2    --donot show media deleted jobs
AND JB.status IN (1)	--successful jobs only
and (bkplevel & 7) >0   --full/inc/diff jobs
and JB.apptype not in ( --not including these apptype in backup job report
       84, 47, 50 , 45 , 57 , 56 , 58 , 66 , 73 , 82 , 83 , 67 , 68 , 90 , 89 , 93,
       105, 600, 601, 602, 603, 604, 605, 606, 607, 650, 651, 652, 699)
GROUP BY C.id, C.Name
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellCompletedBkpJobsInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellCompletedBkpJobsInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientLevelBkpJobSummary.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientLevelBkpJobSummary"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientLevelBkpJobSummary]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientLevelBkpJobSummary]
GO

delete from GXDBVersions where name = 'CommCellClientLevelBkpJobSummary' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientLevelBkpJobSummary', '', 'CommCellClientLevelBkpJobSummary', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Client Level Backup Job Summary
CREATE VIEW dbo.CommCellClientLevelBkpJobSummary
AS
SELECT
ClientID			= C.id,
ClientName			= (SELECT name FROM APP_Client WHERE id = C.id),
TotalJobs			= COUNT(J.JobID),
Completed			= SUM(CASE WHEN J.status = 1 THEN 1 ELSE 0 END),
CompletedWithErrors	= SUM(CASE WHEN J.status = 3 THEN 1 ELSE 0 END),
Killed				= SUM(CASE WHEN J.status = 4 THEN 1 ELSE 0 END),
Failed				= SUM(CASE WHEN J.status = 2 THEN 1 ELSE 0 END),
NoRun				= SUM(CASE WHEN J.failureErrorCode IN (7, 8, 11) THEN 1 ELSE 0 END),
Dropped				= SUM(CASE WHEN J.status = 9 THEN 1 ELSE 0 END),
Other				= SUM(CASE WHEN J.status NOT IN (1, 2, 3, 4, 9) AND J.failureErrorCode NOT IN (7, 8, 11) THEN 1 ELSE 0 END),
SchedInitiated		= SUM(CASE WHEN J.initFrom = 3 THEN 1 ELSE 0 END),
TotalFullAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalIncAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (2, 0x100) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalOtherAppSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN ISNULL(J.totalUncompBytes, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalAppSizeGB		= CAST(SUM(ISNULL(J.totalUncompBytes, 0))/(1024.0 *1024*1024) as decimal(20,4)),
TotalFullBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalIncBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel IN (2, 0x100) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalOtherBkpSizeGB	= CAST(SUM(CASE WHEN J.BkpLevel NOT IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000, 2, 0x100) THEN ISNULL(J.sizeOnMedia, 0) ELSE 0 END)/(1024.0 *1024*1024) as decimal(20,4)),
TotalBkpSizeGB		= CAST(SUM(ISNULL(J.sizeOnMedia, 0))/(1024.0 *1024*1024) as decimal(20,4)),
ProtectedObjects	= SUM(ISNULL(totalNumOFFiles, 0)),
FailedObjects		= SUM(ISNULL(scanFileFailures, 0) + ISNULL(backupFileFailures, 0)),
FailedFolders		= SUM(ISNULL(scanFolderFailures, 0) + ISNULL(backupFolderFailures, 0)),
StartTime			= dbo.GetDateTime(ISNULL(MIN(J.servStartDate), 0)),
EndTime				= dbo.GetDateTime(ISNULL(MAX(J.servEndDate), 0))
FROM		APP_Client	C
			INNER JOIN	APP_Application AP
				ON C.id = AP.clientID
			LEFT OUTER JOIN
			(SELECT B.jobId, B.commCellId, B.appId, B.BkpLevel, B.servStartDate, B.servEndDate, B.initFrom, B.status,
					B.totalUncompBytes, B.totalNumOfFiles, B.scanFileFailures, B.backupFileFailures,
					B.scanFolderFailures, B.backupFolderFailures, B.failureErrorCode, SUM(D.sizeOnMedia) AS sizeOnMedia
			FROM JMBkpStats B
				INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId
				INNER JOIN archGroup G ON B.opType NOT IN (59, 65) AND D.archGrpCopyId = G.defaultCopy OR B.opType IN (59, 65) AND D.archGrpCopyId = G.defaultSnapCopy
			WHERE B.servEndDate >= (dbo.GetUnixTime(GETUTCDATE()) - 30 * 24 *60 *60) --Duration Last 30 days
			GROUP BY B.jobId, B.commCellId, B.appId, B.BkpLevel, B.servStartDate, B.servEndDate, B.initFrom, B.status,
					B.totalUncompBytes, B.totalNumOfFiles, B.scanFileFailures, B.backupFileFailures,
					B.scanFolderFailures, B.backupFolderFailures, B.failureErrorCode
			) J ON J.appID = AP.id
GROUP BY C.id
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientLevelBkpJobSummary]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellHWEncInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellHWEncInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellHWEncInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellHWEncInfo]
GO

delete from GXDBVersions where name = 'CommCellHWEncInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellHWEncInfo', '', 'CommCellHWEncInfo', '')
GO
CREATE VIEW [dbo].[CommCellHWEncInfo]
AS
select distinct ARG.name as StoragePolicy,
arc.name as CopyName,
MediaAgentName = (select name from APP_Client where dp.hostclientid = id),
UseHWEncryption =
    case dp.UseHardwareEncryption
 when 0 then 'No'
 when 1 then 'Yes'
 when 2 then 'Yes'
 else 'Unknown'
    end,
 DirectMediaAccess =
 case dp.UseHardwareEncryption
 when 0 then 'Not Applicable'
 when 1 then 'Via Media Password'
 when 2 then 'No Access'
 else 'Unknown'
    end
from
archGroup arg, archGroupCopy arc, MMDataPath dp
where arg.id = arc.archGroupId
and dp.CopyId = arc.id
and dp.UseHardwareEncryption <> 1
and arg.id > 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellHWEncInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientVersion.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientVersion"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientVersion]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientVersion]
GO

delete from GXDBVersions where name = 'CommCellClientVersion' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientVersion', '1.3', 'CommCellClientVersion', '')
GO
CREATE VIEW CommCellClientVersion
AS
SELECT    C.name AS Name,
          ISNULL(CGAList.ClientGroupNames,'""') as ClientGroups,
          R.release + ' ' + MAX(ISNULL(Version,'')) as Version,
          CASE  (C.status & 2) WHEN 0 THEN (CASE WHEN MAX(LEN(CONVERT(NVARCHAR(100),ISNULL(SIMP.AdditionalPatches,'')))) > LEN('None') THEN 'Yes' ELSE 'No' END) ELSE 'N/A' END  as AdditionalUpdates,
          CASE  (C.status & 2) WHEN 0 THEN (CASE MAX(ISNULL(Baseline,8))
			 WHEN 0 THEN 'Unknown'
			 WHEN 1 THEN 'Up To Date'
			 WHEN 2 THEN 'Needs Update'
			 WHEN 4 THEN 'Ahead Of Cache'
			 WHEN 8 THEN 'N/A'
			 WHEN 16 THEN 'Hotfix'
		  END ) ELSE 'N/A' END as Status
      FROM        APP_Client AS C
                  INNER JOIN simAllGalaxyRel R
                  ON R.id = C.releaseId
                  AND C.id > 1
                  AND (C.specialClientFlags & 1) <> 1
                  AND C.id not in ( select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
                  LEFT OUTER JOIN ( SELECT ClientID, simPackageID, AdditionalPatches,
									  Baseline,
									  (CASE WHEN HighestSP > 0 THEN 'SP' + CAST(HighestSP as varchar(20)) ELSE '' END + CASE
										WHEN SpMinorVersion > 0 THEN char((96 + SpMinorVersion))
										ELSE ''
										END) as Version FROM simInstalledPackages ) as SIMP
                  ON C.ID = SIMP.ClientID
                  LEFT OUTER JOIN simPackage SP ON
                  SIMP.simPackageID  = SP.id
                  AND SP.Name NOT LIKE '%MediaAgent'
			LEFT OUTER JOIN
    		(SELECT
				CL.clientId,
				'"' + LEFT(o.list, LEN(o.list) -1) +'"' as ClientGroupNames
			FROM
				(SELECT  distinct CGA.clientId, CG.name FROM APP_Client  C
						INNER JOIN APP_ClientGroupAssoc CGA
						ON CGA.clientId = C.id
						AND C.id >0 and (C.specialClientFlags & 2) = 0
						INNER JOIN APP_ClientGroup CG
						ON CG.id = CGA.clientGroupId )AS CL
				CROSS APPLY (SELECT
									s.name  + ','  AS [text()]
								FROM
									(SELECT CGA.clientId, CG.name
									 FROM APP_ClientGroupAssoc CGA
									 INNER JOIN APP_ClientGroup CG
									 ON CGA.clientGroupId = CG.id
									 AND CL.clientId = CGA.clientId) AS  s
								FOR XML PATH('')) AS o(list) )  AS CGAList
			ON CGAList.clientId = C.id
     GROUP BY    C.name, C.status, SIMP.ClientID,  C.releaseId, R.release, CGAList.ClientGroupNames
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientVersion]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMAVersion.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMAVersion"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMAVersion]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMAVersion]
GO

delete from GXDBVersions where name = 'CommCellMAVersion' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMAVersion', '1.3', 'CommCellMAVersion', '')
GO
CREATE VIEW CommCellMAVersion
AS
SELECT    C.name AS Name,
          ISNULL(CGAList.ClientGroupNames,'""') as ClientGroups,
          R.release + ' ' + MAX(ISNULL(Version,'')) as Version,
          CASE WHEN  MAX(LEN(CONVERT(NVARCHAR(100),ISNULL(SIMP.AdditionalPatches, 'None')))) > LEN('None') THEN 'Yes' ELSE 'No' END as AdditionalUpdates,
          CASE  MAX(ISNULL(Baseline,8))
			 WHEN 0 THEN 'Unknown'
			 WHEN 1 THEN 'Up To Date'
			 WHEN 2 THEN 'Needs Update'
			 WHEN 4 THEN 'Ahead Of Cache'
			 WHEN 8 THEN 'N/A'
			 WHEN 16 THEN 'Hotfix'
		  END as Status
      FROM        APP_Client AS C
                  INNER JOIN simAllGalaxyRel R
                  ON R.id = C.releaseId
                  AND C.id > 1
                  INNER JOIN MMHost ON
                  MMHost.ClientId = c.id
                  LEFT OUTER JOIN (SELECT ClientID, simPackageID, AdditionalPatches,
									  Baseline,
									  (CASE WHEN HighestSP > 0 THEN 'SP' + CAST(HighestSP as varchar(20)) ELSE '' END + CASE
										WHEN SpMinorVersion > 0 THEN char((96 + SpMinorVersion))
										ELSE ''
										END) as Version FROM simInstalledPackages ) as SIMP
                  ON C.ID = SIMP.ClientID
                  LEFT OUTER JOIN simPackage SP ON
                  SIMP.simPackageID  = SP.id
			LEFT OUTER JOIN
    		(SELECT
				CL.clientId,
				'"' + LEFT(o.list, LEN(o.list) -1) +'"' as ClientGroupNames
			FROM
				(SELECT  distinct CGA.clientId, CG.name FROM APP_Client  C
						INNER JOIN APP_ClientGroupAssoc CGA
						ON CGA.clientId = C.id
						AND C.id >0 and (C.specialClientFlags & 2) = 0
						INNER JOIN APP_ClientGroup CG
						ON CG.id = CGA.clientGroupId )AS CL
				CROSS APPLY (SELECT
									s.name  + ','  AS [text()]
								FROM
									(SELECT CGA.clientId, CG.name
									 FROM APP_ClientGroupAssoc CGA
									 INNER JOIN APP_ClientGroup CG
									 ON CGA.clientGroupId = CG.id
									 AND CL.clientId = CGA.clientId) AS  s
								FOR XML PATH('')) AS o(list) )  AS CGAList
			ON CGAList.clientId = C.id
     GROUP BY    C.name,  SIMP.ClientID,  C.releaseId, R.release, CGAList.ClientGroupNames
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMAVersion]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/VMsInMultipleSubClients.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: VMsInMultipleSubClients"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[VMsInMultipleSubClients]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[VMsInMultipleSubClients]
GO

delete from GXDBVersions where name = 'VMsInMultipleSubClients' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'VMsInMultipleSubClients', '1.1', 'VMsInMultipleSubClients', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
CREATE VIEW dbo.VMsInMultipleSubClients
AS
select vmData.*, vmCount.countOfVMs
from
(select c.id, c.name, q.clientId as vmId, q.clientName as vmName, jbs.appId, a.subclientName
from JMBkpStats jbs
		join JMQinetixUpdateStatus q
			on jbs.jobId = q.jobId
			and jbs.commCellId = q.commCellId
		join app_application a
			on jbs.appId = a.id
		join APP_Client as c
			on c.id = a.clientId
where jbs.appType = 106
group by c.id, c.name, q.clientId, q.clientName, jbs.appId, a.subclientName
) as vmData
join
(select v1.vmId, COUNT(v1.vmId) as countOfVMs from (select c.id, c.name, q.clientId as vmId, q.clientName as vmName, jbs.appId, a.subclientName
from JMBkpStats jbs
		join JMQinetixUpdateStatus q
			on jbs.jobId = q.jobId
			and jbs.commCellId = q.commCellId
		join app_application a
			on jbs.appId = a.id
		join APP_Client as c
			on c.id = a.clientId
where jbs.appType = 106
group by c.id, c.name, q.clientId, q.clientName, jbs.appId, a.subclientName) as v1 group by vmId
) as vmCount
on vmCount.vmId = vmData.vmId
where countOfVMs > 1
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [VMsInMultipleSubClients]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellClientGroupConfig.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellClientGroupConfig"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellClientGroupConfig]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellClientGroupConfig]
GO

delete from GXDBVersions where name = 'CommCellClientGroupConfig' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellClientGroupConfig', '', 'CommCellClientGroupConfig', '')
GO
CREATE VIEW CommCellClientGroupConfig
AS
SELECT CG.id,
	   CG.name,
	   type = CASE when CG.flag & 4096 = 4096
						then 'automatic'
					else
						'manual'
					end,
	   ClientGroupBkpEnable = CASE (select JA.action from JMJobAction JA where CG.id = JA.clientGroupId and JA.apptype = 0  and JA.optype = 4 )
             WHEN 1
				THEN 'No'
             ELSE 'Yes'
				END,
	   ClientGroupRstEnable = CASE (select JA.action from JMJobAction JA where CG.id = JA.clientGroupId and JA.apptype = 0  and JA.optype = 5 )
             WHEN 1
				THEN 'No'
             ELSE 'Yes'
				END,
	   clientnamelist.clientnames
FROM APP_ClientGroup as CG WITH (NOLOCK)
LEFT OUTER JOIN
(SELECT DISTINCT cg.Id as clientgroupid, ISNULL((SUBSTRING((
	SELECT ',' + cl.name
	FROM APP_Client as cl WITH (NOLOCK)  INNER JOIN APP_ClientGroupAssoc as cga WITH (NOLOCK)
	ON cga.clientid = cl.id
	WHERE cga.clientgroupid = cg.id and cl.status & 2 = 0 and cl.id <> 1
	FOR XML PATH('')
),2,2147483647)),'')as clientnames
FROM APP_ClientGroup cg WITH (NOLOCK)
GROUP BY cg.Id )
as clientnamelist
ON clientnamelist.clientgroupid = cg.id
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellClientGroupConfig]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellStoragePolicyExtended.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellStoragePolicyExtended"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellStoragePolicyExtended]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellStoragePolicyExtended]
GO

delete from GXDBVersions where name = 'CommCellStoragePolicyExtended' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellStoragePolicyExtended', '', 'CommCellStoragePolicyExtended', '')
GO
create view CommCellStoragePolicyExtended
as
SELECT  DISTINCT
    CommCellID = CONVERT (NVARCHAR(128), CONVERT(VARBINARY(8),  CCELL.number),2),
    CommCellName = CCELL.aliasName,
    SpName = AG.name,
    CopyName = AGC.name,
    IsDedupe = CASE WHEN AGC.dedupeFlags & 0x40000 = 0x40000 THEN 'Yes' ELSE 'No' END,
    DedupePath = ISNULL(CASE WHEN e.path = 'N/A' THEN '' ELSE e.Path END,''),
    RetentionDays = (CASE ARR.retentionDays WHEN -1 THEN 'Infinite' ELSE CAST(ARR.retentionDays AS VARCHAR(1024)) END),
    RetentionCycles = (CASE ARR.fullCycles WHEN -1 THEN 'Infinite' ELSE CAST(ARR.fullCycles AS VARCHAR(1024)) END),
	IsExtendedRetentionEnabled = (CASE WHEN (TRE.retentionDays1 IS NULL) THEN 'No' ELSE  CASE WHEN TRE.retentionDays1 = 0 THEN 'No' ELSE 'Yes' END END),
	ExtendedRetentionRule1 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule1,0)),
		RetentionDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays1) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays1 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule1 = CASE WHEN ISNULL(TRE.retentionRule1,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays1 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule2 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule2,0)),
	RetentionDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays2) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays2 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule2 = CASE WHEN ISNULL(TRE.retentionRule2,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays2 AS VARCHAR(100))
						END,
	--===================================================================================================--
	ExtendedRetentionRule3 = dbo.GetExtendedRetentionRuleString(ISNULL(TRE.retentionRule3,0)),
	RetentionDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
								ELSE ISNULL((CASE
                                                                  WHEN (TRE.retentionDays3) = -1 THEN 'Infinite'
                                                                  ELSE CAST (TRE.retentionDays3 AS VARCHAR(1024))
                                                            END),0) END,
	GraceDaysForRule3 = CASE WHEN ISNULL(TRE.retentionRule3,0) = 0
								THEN 'N\A'
								ELSE CAST (TRE.GraceDays3 AS VARCHAR(100))
						END
FROM				  dbo.archGroup AS AG WITH (NOLOCK) INNER JOIN
                      dbo.archGroupCopy AS AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId LEFT OUTER JOIN
                      dbo.archAgingRule AS ARR WITH (NOLOCK) ON AGC.id = ARR.copyId LEFT OUTER JOIN
                      dbo.IdxSIDBStore AS c WITH (NOLOCK) ON AGC.SIDBStoreId = c.SIDBStoreId LEFT OUTER JOIN
                      dbo.IdxSIDBSubStore AS d WITH (NOLOCK) ON c.SIDBStoreId = d.SIDBStoreId LEFT OUTER JOIN
                      dbo.IdxAccessPath AS e WITH (NOLOCK) ON d.IdxAccessPathId = e.IdxAccessPathId INNER JOIN
                      dbo.APP_CommCell CCELL ON 2 = CCELL.id LEFT OUTER JOIN
					  dbo.GetTempExtendedRentiontionTransposedTable() TRE ON TRE.Copyid = AGC.id AND ARR.copyId = TRE.Copyid
      WHERE AG.id > 1  and AGC.type <> 5
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellStoragePolicyExtended]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkSchedulePolicy.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkSchedulePolicy"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkSchedulePolicy]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkSchedulePolicy]
GO

delete from GXDBVersions where name = 'CommCellBkSchedulePolicy' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkSchedulePolicy', '1.2', 'CommCellBkSchedulePolicy', '')
GO
CREATE VIEW dbo.CommCellBkSchedulePolicy
AS
SELECT
		SchedulePolicyId = T.taskId ,
		SchedulePolicyName = T.taskName ,
		Description = T.description ,
		Enabled = (	CASE T.disabled
						WHEN 0 THEN 1
						ELSE 0
					END) ,
		OwnerName = U.name,
		AgentTypes =	ISNULL((SELECT SUBSTRING((	SELECT ',' + name
								FROM (SELECT DISTINCT IDA.name FROM TM_AssocFilter TA
									  INNER JOIN APP_AppTypeGroupAssoc A ON TA.filter_value = A.appGroupId
									  INNER JOIN APP_iDAType IDA ON A.appTypeId = IDA.type
									  WHERE TA.filter_type = 1 AND TA.taskId = T.taskId
									  UNION
									  SELECT DISTINCT IDA.name FROM TM_AssocFilter TA
									  INNER JOIN APP_iDAType IDA ON TA.filter_value = IDA.type
									  WHERE TA.filter_type = 2 AND TA.taskId = T.taskId)TEMP
								FOR XML PATH(''))
								, 2, 2147483647)), 'All Agents'),
		--SchedulePolicySubtasks = (SELECT SUBSTRING((SELECT ',' + CAST(S.subTaskId AS NVARCHAR(MAX))
		--				   FROM TM_SubTask S
		--				   WHERE S.taskId = T.taskId
		--				   FOR XML PATH(''))
		--				  , 2, 2147483647)),
		SchedulePolicyAlert = ISNULL(A.notificationName, '')
FROM TM_Task T WITH (NOLOCK)
LEFT OUTER JOIN UMUsers U WITH (NOLOCK) ON T.ownerId = U.id
LEFT OUTER JOIN NTNotificationRule A WITH (NOLOCK) ON T.alertId = A.id
WHERE T.taskType= 4 AND T.policyType = 0
AND T.invalid = 0 AND T.uninstalled = 0 AND T.deleted = 0
GO
declare @retCode integer                -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
        set @retCode = @@error;
        print "RETVAL: 10 View [CommCellBkSchedule]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkSchedulePolicy]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellScheduledBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellScheduledBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellScheduledBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellScheduledBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellScheduledBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellScheduledBackupInfo', '1.2', 'CommCellScheduledBackupInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup History Info
CREATE VIEW dbo.CommCellScheduledBackupInfo
AS
SELECT	SC.CommCellID AS 'CommCell ID',
		SC.CommCellName AS 'CommCell Name',
		SC.clientName AS 'Client Name',
		SC.idataagent AS 'Agent Name',
		dbo.FixInstanceName(SC.instance, A.appTypeId) AS 'Instance Name',
		SC.backupset AS 'Backupset Name',
		SC.subclient AS 'Subclient Name',
		SC.schedbackuptype AS 'Backup Type',
		SC.schedpattern AS 'Schedule Pattern',
		SC.schednextbackuptime AS 'Scheduled Date',
		AG.name AS 'Storage Policy',
		CASE WHEN AR.retentionDays < 0 THEN 'Infinite' ELSE CAST(AR.retentionDays AS VARCHAR(8)) END AS 'Retention Days'
FROM	CommCellBkSchedule SC
		INNER JOIN APP_Application A ON A.id = SC.appid
		INNER JOIN archGroup AG ON AG.id = A.dataArchGrpID
		INNER JOIN archAgingRule AR ON AR.copyId = AG.defaultCopy
WHERE	SC.appid IS NOT NULL AND SC.scheduleTask = 'Backup'
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellScheduledBackupInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellClientsForOwner.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellClientsForOwner"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellClientsForOwner]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellClientsForOwner]
GO

delete from GXDBVersions where name = 'CommcellClientsForOwner' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellClientsForOwner', '1.3', 'CommcellClientsForOwner', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Clients and owners
CREATE VIEW dbo.CommcellClientsForOwner
AS
select C.name as 'ClientName', C.net_hostname as 'HostName', U.login as 'UserName' from
App_Client C join UMUserandGroupEntityAssociation as E on C.id=E.objectId
join UMUsers U on U.id = E.userId where E.entityType=2009
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: View CommcellClientsForOwner'
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellClientsForOwner]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellBackupInfoStats.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellBackupInfoStats"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellBackupInfoStats]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellBackupInfoStats]
GO

delete from GXDBVersions where name = 'CommcellBackupInfoStats' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellBackupInfoStats', '1.4', 'CommcellBackupInfoStats', '')
GO
CREATE VIEW CommcellBackupInfoStats AS
SELECT jobid, appid, jobinitfrom, clientname, idataagent, instance, backupset, subclient, data_sp, backuplevelInt, backuplevel, incrlevel, jobstatusInt, jobstatus, jobfailedreason, startdateunixsec, enddateunixsec, startdate, enddate, durationunixsec, duration, numstreams, numbytesuncomp, numbytescomp, numobjects, isAged, isAgedStr, retentionDays, systemStateBackup, totalBackupSize
FROM CommcellBackupInfo
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellBackupInfoStats]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellBkScheduleForSubclients.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellBkScheduleForSubclients"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBkScheduleForSubclients]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellBkScheduleForSubclients]
GO

delete from GXDBVersions where name = 'CommCellBkScheduleForSubclients' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellBkScheduleForSubclients', '', 'CommCellBkScheduleForSubclients', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup Schedule Info For Subclients
CREATE VIEW dbo.CommCellBkScheduleForSubclients
AS
WITH AllSchedEntities (CommCellId, CommCellName, scheduleId, scheduePolicy, scheduleName, scheduletask, schedbackuptype,schedpattern,
schedinterval,schedbackupday,schedbackupTime,schednextbackuptime,appid,clientName, idaagent,instance,backupset,subclient)AS
(
SELECT
DISTINCT
 CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
 CommCellName = CCELL.aliasName,
 scheduleId = STASK.subTaskid,
 schedulePolicy = TASK.taskname,
 scheduleName  = STASK.subtaskname,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype =
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedbackupday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
  WHEN 128 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
         + ' ' + 'of' + ' ' +
         CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
    ELSE ' '
    END,
    schedbackupTime = CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ),
    schednextbackuptime = RTASSOC.nextRunTime,
    appid =
    CASE WHEN ASSOC.subclientId = 0
    THEN AA.id
    ELSE ASSOC.subclientId
    END,
    clientName =
    CASE WHEN C.id is NULL
    THEN 'All Clients'
    ELSE C.name
    END,
    idataagent = APT.name,
    instance =
    CASE  ITN.name
     WHEN 'DefaultInstanceName' THEN ''
     WHEN 'defaultDummyInstanceForOracle' THEN ''
     ELSE ITN.name
    END,
     backupset =
   CASE  APT.type
    WHEN 6 THEN 'NULL'
    WHEN 9 THEN 'NULL'
    WHEN 15 THEN 'NULL'
    WHEN 27 THEN 'NULL'
    WHEN 31 THEN 'NULL'
   ELSE
      CASE WHEN AA.backupSet IS NULL
      THEN 'All BackupSets'
      ELSE (Select name from APP_BackupSetName where id=AA.backupSet)
      END
   END,
   subclient =
  CASE WHEN AA.subclientName IS NULL
  THEN 'All subclients'
  ELSE AA.subclientName
  END
  FROM
        TM_Task as TASK LEFT OUTER JOIN
        TM_AssocEntity AS ASSOC ON ASSOC.taskId = TASK.taskId JOIN
        TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
        TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId JOIN
        TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
        TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN
        TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN
        TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
        App_Commcell AS CCELL ON 2 = CCELL.id LEFT OUTER JOIN
        APP_ClientGroupAssoc ACG ON (ASSOC.assocType = 28 AND ASSOC.clientGroupId = ACG.clientGroupId) LEFT OUTER JOIN
        APP_Application AA ON ( ASSOC.exclude = 0 AND ((ACG.clientId = AA.clientId) OR (ASSOC.clientId=AA.clientId AND ASSOC.assocType=3 )
                                                             OR (ASSOC.clientId=AA.clientId AND ASSOC.appTypeId=AA.appTypeId AND ASSOC.assocType=4)
                                                             OR (ASSOC.instanceId =AA.instance AND ASSOC.assocType=5)
                                                             OR (ASSOC.backupsetId = AA.backupSet AND ASSOC.assocType=6)
                                                             OR (ASSOC.subclientId = AA.id AND ASSOC.assocType=7)
                                                             OR ASSOC.assocType=2)) LEFT OUTER JOIN
        APP_iDAType  APT ON ((ASSOC.appTypeId = APT.type AND ASSOC.appTypeId<>0)  OR AA.apptypeId = APT.type) LEFT OUTER JOIN
        TempCvView3 t3 ON PAT.PatternId=t3.patternid  LEFT OUTER JOIN
        APP_InstanceName  ITN ON (ASSOC.instanceId = ITN.id OR AA.instance = ITN.id)LEFT OUTER JOIN
        APP_Client C ON (ACG.clientId = C.id OR ASSOC.clientId = C.id OR AA.clientId = C.id)
  WHERE
        STASK.subTaskType = 2 AND
        SOPT.optionId = 458405394 AND
        RTASSOC.processed = 0 AND RTASSOC.firing = 0 AND
        RT.processed = 0 AND RT.firing =  0 AND
        TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
        AND AA.subclientStatus & (0x00010) = 0      --Dummy
        AND AA.subclientStatus & (0x00020) = 0      --Hidden
        AND AA.subclientStatus & (0x00004) = 0      --deleted
        AND AA.subclientStatus & (0x00002) = 0      --uninstalled
        AND AA.appTypeId <> 1000                    --DR Subclient
),
ExcludedSchedEntitites (CommCellId, CommCellName, scheduleId, scheduePolicy, scheduleName, scheduletask, schedbackuptype,schedpattern,
schedinterval,schedbackupday,schedbackupTime,schednextbackuptime,appid,clientName, idaagent,instance,backupset,subclient) AS (
SELECT
DISTINCT
 CommCellID = (SELECT UPPER(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), CCELL.number)),3,8))),
 CommCellName = CCELL.aliasName,
 scheduleId = STASK.subTaskid,
 schedulePolicy = TASK.taskname,
 scheduleName  = STASK.subtaskname,
 scheduleTask =
 CASE STASK.subTasktype
 WHEN 1 THEN 'Administration'
 WHEN 2 THEN 'Backup'
 WHEN 3 THEN 'Restore'
 ELSE 'OTHER'
 END,
 schedbackuptype =
 CASE CONVERT(int,SOPT.value)
  WHEN 1 THEN 'Full'
  WHEN 2 THEN 'Incremental'
  WHEN 3 THEN 'Differential'
  WHEN 4 THEN 'Synthetic Full'
  WHEN 5 THEN 'ASR'
 ELSE 'Unknown'
 END,
 schedpattern =
 CASE PAT.freq_type
  WHEN 1   THEN 'One time'
  WHEN 4   THEN 'Daily'
  WHEN 8  THEN 'Weekly'
  WHEN 16  THEN 'Monthly'
  WHEN 32  THEN 'Monthly'
  WHEN 64 THEN 'Yearly'
  WHEN 128 THEN 'Yearly'
  ELSE 'Unknown'
 END,
 schedinterval =
CASE PAT.freq_type
 WHEN 128 THEN 'Every 1'
 ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
END,
 schedbackupday=
 CASE PAT.freq_type
  WHEN 1 THEN 'One Time'
  WHEN 4 THEN 'Daily'
  WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
  WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval)
  WHEN 32 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
  WHEN 64 THEN CONVERT(varchar(2), PAT.freq_interval)
  + ' of ' +
  CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
  WHEN 128 THEN
        CASE PAT.freq_relative_interval
            WHEN 5 THEN 'Last'
            ELSE
            LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
              CASE  PAT.freq_relative_interval
               WHEN 1 THEN 'st'
               WHEN 2 THEN 'nd'
               WHEN 3 THEN 'rd'
               ELSE 'th'
              END
              )
         END + ' ' +
         CASE PAT.freq_interval
          WHEN 1 THEN 'Sunday'
          WHEN 2 THEN 'Monday'
          WHEN 3 THEN 'Tuesday'
          WHEN 4 THEN 'Wednesday'
          WHEN 5 THEN 'Thursday'
          WHEN 6 THEN 'Friday'
          WHEN 7 THEN 'Saturday'
          WHEN 8 THEN 'Week Day'
          WHEN 9 THEN 'Day'
          WHEN 10 THEN 'Weekend Day'
          ELSE 'Unknown'
         END
         + ' ' + 'of' + ' ' +
         CASE PAT.freq_recurrence_factor
          WHEN 1 THEN 'January'
          WHEN 2 THEN 'February'
          WHEN 3 THEN 'March'
          WHEN 4 THEN 'April'
          WHEN 5 THEN 'May'
          WHEN 6 THEN 'June'
          WHEN 7 THEN 'July'
          WHEN 8 THEN 'August'
          WHEN 9 THEN 'September'
          WHEN 10 THEN 'October'
          WHEN 11 THEN 'November'
          WHEN 12 THEN 'December'
         END
    ELSE ' '
    END,
    schedbackupTime = CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ),
    schednextbackuptime = RTASSOC.nextRunTime,
    appid =
    CASE WHEN ASSOC.subclientId = 0
    THEN AA.id
    ELSE ASSOC.subclientId
    END,
    clientName =
    CASE WHEN C.id is NULL
    THEN 'All Clients'
    ELSE C.name
    END,
    idataagent = APT.name,
    instance =
    CASE  ITN.name
     WHEN 'DefaultInstanceName' THEN ''
     WHEN 'defaultDummyInstanceForOracle' THEN ''
     ELSE ITN.name
    END,
     backupset =
   CASE  APT.type
    WHEN 6 THEN 'NULL'
    WHEN 9 THEN 'NULL'
    WHEN 15 THEN 'NULL'
    WHEN 27 THEN 'NULL'
    WHEN 31 THEN 'NULL'
   ELSE
      CASE WHEN AA.backupSet IS NULL
      THEN 'All BackupSets'
      ELSE (Select name from APP_BackupSetName where id=AA.backupSet)
      END
   END,
   subclient =
  CASE WHEN AA.subclientName IS NULL
  THEN 'All subclients'
  ELSE AA.subclientName
  END
  FROM
        TM_Task as TASK LEFT OUTER JOIN
        TM_AssocEntity AS ASSOC ON ASSOC.taskId = TASK.taskId JOIN
        TM_SubTask as STASK ON TASK.taskId = STASK.taskId  JOIN
        TM_SubTaskOptions as SOPT ON STASK.subTaskId = SOPT.subTaskId JOIN
        TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = STASK.subTaskId JOIN
        TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId  JOIN
        TM_RunTime AS RT ON RT.patternId = PAT.patternId  JOIN
        TM_RunTimeAssoc AS RTASSOC ON RTASSOC.runTimeId = RT.runTimeId LEFT OUTER  JOIN
        App_Commcell AS CCELL ON 2 = CCELL.id LEFT OUTER JOIN
        APP_ClientGroupAssoc ACG ON (ASSOC.assocType = 28 AND ASSOC.clientGroupId = ACG.clientGroupId) LEFT OUTER JOIN
        APP_Application AA ON ( ASSOC.exclude = 1 AND ((ACG.clientId = AA.clientId) OR (ASSOC.clientId=AA.clientId AND ASSOC.assocType=3 )
                                                             OR (ASSOC.clientId=AA.clientId AND ASSOC.appTypeId=AA.appTypeId AND ASSOC.assocType=4)
                                                             OR (ASSOC.instanceId =AA.instance AND ASSOC.assocType=5)
                                                             OR (ASSOC.backupsetId = AA.backupSet AND ASSOC.assocType=6)
                                                             OR (ASSOC.subclientId = AA.id AND ASSOC.assocType=7)
                                                             OR ASSOC.assocType=2)) LEFT OUTER JOIN
        APP_iDAType  APT ON ((ASSOC.appTypeId = APT.type AND ASSOC.appTypeId<>0)  OR AA.apptypeId = APT.type) LEFT OUTER JOIN
        TempCvView3 t3 ON PAT.PatternId=t3.patternid  LEFT OUTER JOIN
        APP_InstanceName  ITN ON (ASSOC.instanceId = ITN.id OR AA.instance = ITN.id)LEFT OUTER JOIN
        APP_Client C ON (ACG.clientId = C.id OR ASSOC.clientId = C.id OR AA.clientId = C.id)
  WHERE
        STASK.subTaskType = 2 AND
        SOPT.optionId = 458405394 AND
        RTASSOC.processed = 0 AND RTASSOC.firing = 0 AND
        RT.processed = 0 AND RT.firing =  0 AND
        TASK.deleted = 0 AND TASK.invalid = 0 AND TASK.uninstalled = 0
        AND AA.subclientStatus & (0x00010) = 0      --Dummy
        AND AA.subclientStatus & (0x00020) = 0      --Hidden
        AND AA.subclientStatus & (0x00004) = 0      --deleted
        AND AA.subclientStatus & (0x00002) = 0      --uninstalled
        AND AA.appTypeId <> 1000                    --DR Subclient
)
SELECT * FROM AllSchedEntities EXCEPT (SELECT * FROM ExcludedSchedEntitites)
GO
declare @retCode integer        -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
    set @retCode = @@error;
        print "RETVAL: 10 View [CommCellBkScheduleForSubclients]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellBkScheduleForSubclients]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellRestoreInfoStats.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellRestoreInfoStats"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellRestoreInfoStats]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellRestoreInfoStats]
GO

delete from GXDBVersions where name = 'CommcellRestoreInfoStats' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellRestoreInfoStats', '1.3', 'CommcellRestoreInfoStats', '')
GO
CREATE VIEW CommcellRestoreInfoStats AS
SELECT jobid, destclientname, idataagent, instance, backupset, jobstatus, jobfailedreason, starttimeunixsec, endtimeunixsec, starttime, endtime, durationunixsec, duration, numfiles, numbytescomp, numbytesuncomp
FROM CommcellRestoreInfo
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellRestoreInfoStats]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellOracleBackupInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellOracleBackupInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellOracleBackupInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellOracleBackupInfo]
GO

delete from GXDBVersions where name = 'CommCellOracleBackupInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellOracleBackupInfo', '1.2', 'CommCellOracleBackupInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
---Display Backup History Info
CREATE VIEW dbo.CommCellOracleBackupInfo
AS
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
		end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		storagePolicy = dbo.archGroup.name,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 1024 THEN 'Offline Full'
		 WHEN 32768 THEN 'Online Full'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE A.aged
			 WHEN 0 THEN 0
			 WHEN NULL THEN 1
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE A.aged
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'Yes'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		retentionDays = (CASE WHEN (AR.flags & 4) <> 0 THEN 'Data Aging Disabled' WHEN (AR.flags & 128) <> 0 THEN 'Job Count Based Retention'
						 ELSE (CASE WHEN AR.retentionDays = -1 THEN 'Infinite' ELSE CAST(AR.retentionDays AS VARCHAR(8)) END)
						 END),
		systemStateBackup = CASE WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1 ELSE 0 END,
		(select top 1 substring(F.attributeValue, charindex(char(18), F.attributeValue) + 1, len(F.attributeValue)) From
                  JMJobOptions(NOLOCK) F Where F.jobid = BS.jobid and F.commCellId =2 And F.attributeName = 'DB Backup Time') as nextSCN ,
        ISNULL(dbo.archGroupCopy.name, 'Not Available') as CopyName,
        ISNULL(cast(dbo.archGroupCopy.copy as varchar(32)), 'Not Available') as CopyPrecedence
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId LEFT OUTER JOIN
			  (select jobId, commcellId, archGrpId, archGrpCopyId, Disabled & 256 as aged From dbo.JMJobDataStats(NOLOCK) WHERE Status = 100 AND (Disabled & 256 = 0) AND dataType = 1) A ON A.jobId = BS.jobId AND A.commCellId = BS.commCellId LEFT OUTER JOIN
			  dbo.archGroupCopy WITH (NOLOCK) ON dbo.archGroupCopy.id = A.archGrpCopyId LEFT OUTER JOIN
			  dbo.archGroup WITH (NOLOCK) ON A.archGrpId = dbo.archGroup.id LEFT OUTER JOIN
			  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65) OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
			  WHERE dbo.APP_Application.appTypeId In(2/*ORACLE_7*/, 22/*ORACLE_8*/, 23/*ORACLE_8I*/, 80/*ORACLE_RAC*/)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellOracleBackupInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellOracleBackupInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DAMediaRecycledAlertInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DAMediaRecycledAlertInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAMediaRecycledAlertInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DAMediaRecycledAlertInfo]
GO

delete from GXDBVersions where name = 'DAMediaRecycledAlertInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DAMediaRecycledAlertInfo', '1.2', 'DAMediaRecycledAlertInfo', '')
GO
CREATE VIEW dbo.DAMediaRecycledAlertInfo
AS
SELECT 	jobId AS jobId,
				commCellId AS commCellId,
				ref.value('@id', 'int') AS mediaId,
				ref.value('@barcode', 'nvarchar(256)') AS barCode
FROM   archDAAlertInfo
CROSS APPLY alertXML.nodes('/DAAlert/media') AS Media(ref)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DAMediaRecycledAlertInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DAJobPrunedAlertInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DAJobPrunedAlertInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAJobPrunedAlertInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DAJobPrunedAlertInfo]
GO

delete from GXDBVersions where name = 'DAJobPrunedAlertInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DAJobPrunedAlertInfo', '1.1', 'DAJobPrunedAlertInfo', '')
GO
CREATE VIEW dbo.DAJobPrunedAlertInfo
AS
SELECT 	jobId AS jobId,
				commCellId AS commCellId,
				ISNULL(alertXML.value('(/DAAlert/prunedJobs/@count)[1]', 'int'), 0) AS pruneJobCount
FROM   archDAAlertInfo
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DAJobPrunedAlertInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DDBView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DDBView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DDBView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DDBView]
GO

delete from GXDBVersions where name = 'DDBView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DDBView', '1.3', 'DDBView', '')
GO
CREATE VIEW DDBView
WITH ENCRYPTION
AS
select idxPath.MAName, idxPath.Volume,
		MIN(idxPath.TotalCapacityMB) as TotalCapacityMB,
		MIN(idxPath.FreeDiskSpaceMB) as FreeDiskSpaceMB,
		SUM(idxPath.DiskUsageMB) as TotalSpaceUsedMB,
		SUM(idxPath.NumActiveDDB) as totalActiveDedupPartitions,
		SUM(idxPath.NumSealedDDB) as totalSealedDedupPartitions
from ( select distinct IdxS.ClientId,
				(select name from APP_Client with (nolock) where id = idxAP.ClientId) as MAName,idxAP.IdxAccessPathId,
				 case when idxC.DiskUsageMB = -1 then 0 else idxC.DiskUsageMB end as DiskUsageMB,
				 case when idxC.FreeDiskSpaceMB = -1 then 0 else idxC.FreeDiskSpaceMB end  as FreeDiskSpaceMB,
				 case when idxC.totalCapacityMB = -1 then 0 else idxC.totalCapacityMB  end as totalCapacityMB,
				  isnull((select numActiveDDB from
									(select COUNT (SubStoreId) as numActiveDDB, IdxAccessPathId
										  from IdxSIDBSubStore with (nolock)
										  where SealedTime = 0 and IdxAccessPathId > 0
										  group by IdxAccessPathId) as activeDDB
							  where activeDDB.IdxAccessPathId = idxAP.IdxAccessPathId), 0) as NumActiveDDB,
				  isnull((select numSealedDDB from
									(select COUNT (SubStoreId) as numSealedDDB, IdxAccessPathId
										  from IdxSIDBSubStore with (nolock)
										  where SealedTime > 0 and IdxAccessPathId > 0
										  group by IdxAccessPathId) as sealedDDB
                  where sealedDDB.IdxAccessPathId = idxAP.IdxAccessPathId), 0) as NumSealedDDB,
				case when SUBSTRING(idxAP.Path, 1, 1) = '/' then SUBSTRING(idxAP.Path, 1, CHARINDEX('/', idxAP.Path, 2))
					 when SUBSTRING(idxAP.Path, 2, 2) = ':\' then SUBSTRING(idxAP.Path, 1, 3)
					 else idxAP.Path end as Volume
		from IdxAccessPath idxAP with (nolock), IdxSIDBSubStore idxS with (nolock), archCopySIDBStore agcStore with (nolock), IdxCache idxC with (nolock), archGroupCopy agc with (nolock)
		where idxAP.IdxAccessPathId > 0
		and idxAP.IdxAccessPathId = idxS.IdxAccessPathId
		and idxS.SIDBStoreId = agcStore.SIDBStoreId
		and idxS.IdxCacheId = idxC.IdxCacheId
		and agcStore.CopyId = agc.id
		and agc.dedupeFlags & 134217728 = 0
	) as idxPath
group by idxPath.MAName, idxPath.Volume
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DDBView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/archJobsOnStoreInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: archJobsOnStoreInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archJobsOnStoreInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[archJobsOnStoreInfo]
GO

delete from GXDBVersions where name = 'archJobsOnStoreInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'archJobsOnStoreInfo', '1.8', 'archJobsOnStoreInfo', '')
GO
CREATE VIEW dbo.archJobsOnStoreInfo
AS
	SELECT 	DISTINCT AF.archGroupId AS "archGroupId", isnull((SELECT name FROM archGroup WITH (NOLOCK) WHERE id = AF.archGroupId), '') AS "StoragePolicyName",
					AFD.archCopyId AS "archCopyId", isnull((SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = AFD.archCopyId), '') AS "CopyName",
					AFD.SIDBStoreId AS "StoreId",
					isnull((SELECT SIDBStoreName FROM IDXSIDBStore WITH (NOLOCK) WHERE sidbStoreId = AFD.SIDBStoreId), '') AS "StoreName",
					AF.jobId AS "JobId",
					AF.commCellId AS "CommCellId",
					isnull((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = APP.clientId), '') AS "ClientName",
					isnull((SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = APP.appTypeId), '') AS "iDAName",
					isnull((SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = APP.instance), '') AS "InstanceName",
					isnull((SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE id = APP.backupSet), '') AS "BackupSetName",
					APP.subclientName AS "SubclientName"
	FROM archFile AF WITH (NOLOCK), archFileCopyDedup AFD WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), app_application APP WITH (NOLOCK)
	WHERE AF.id = AFD.archFileId
	AND AF.commCellId = AFD.commCellId
	AND AFD.SIDBStoreId > 0
	AND AFD.archFileId = AFC.archFileId
	AND AFD.CommCellId = AFC.CommCellId
	AND AFD.archCopyId = AFC.archCopyId
	AND AFC.lastChunkNumber > 0
	AND AF.appId = APP.id
	AND	AF.appId NOT IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [archJobsOnStoreInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/AuxCopyBehindView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: AuxCopyBehindView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AuxCopyBehindView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[AuxCopyBehindView]
GO

delete from GXDBVersions where name = 'AuxCopyBehindView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'AuxCopyBehindView', '1.2', 'AuxCopyBehindView', '')
GO
CREATE VIEW AuxCopyBehindView
WITH ENCRYPTION
AS
SELECT	AG.name AS PolicyName,
		AGC.name AS CopyName,
		CASE WHEN AGC.isMirrorCopy = 1 THEN 'Snap Mirror'
			WHEN AGC.isSnapCopy = 1 THEN 'Snap Vault'
			WHEN AGC.type = 1 THEN 'Synchronous'
			WHEN AGC.type = 2 THEN 'Selective'
		END AS CopyType,
		CASE WHEN (AGC.dedupeFlags & (524288|8388608)) > 0 THEN 'Y' ELSE 'N' END AS IsDashCopy,
		ISNULL(NumOfJobsBehind, 0) AS NumOfJobsBehind,
		ISNULL(OldestJobToCopy, 0) AS OldestJobToCopy
FROM	archGroupCopy AGC
		INNER JOIN archGroup AG
	ON	AGC.archGroupId = AG.id
		AND AG.id > 1 AND AG.type IN (1, 2)
		AND AGC.isActive > 0 AND AGC.type IN (1, 2) AND (AGC.flags & 524288) = 0
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
		LEFT JOIN (SELECT	archGrpCopyId, COUNT(DISTINCT jobId) AS NumOfJobsBehind, MIN(jobId) AS OldestJobToCopy
					FROM	JMJobDataStats
					WHERE	status IN (101, 102, 103) AND (disabled & (1|256)) = 0
					GROUP BY archGrpCopyId) J
	ON	AGC.id = J.archGrpCopyId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [AuxCopyBehindView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/BackupCopyBehindView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: BackupCopyBehindView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupCopyBehindView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[BackupCopyBehindView]
GO

delete from GXDBVersions where name = 'BackupCopyBehindView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'BackupCopyBehindView', '1.1', 'BackupCopyBehindView', '')
GO
CREATE VIEW BackupCopyBehindView
WITH ENCRYPTION
AS
SELECT	AG.name AS PolicyName, ISNULL(NumOfJobsBehind, 0) AS NumOfJobsBehind, ISNULL(OldestJobToCopy, 0) AS OldestJobToCopy
FROM	archGroup AG LEFT JOIN
		(SELECT archGrpId, COUNT(jobId) AS NumOfJobsBehind, MIN(jobId) AS OldestJobToCopy
		FROM	JMJobSnapshotStats
		WHERE	materializationStatus IN (101, 102, 103) AND (disabled & (1|256)) = 0
		GROUP BY archGrpId) J
	ON	AG.id = J.archGrpId
WHERE	AG.defaultSnapCopy > 0 AND AG.id > 1 AND AG.type IN (1, 2)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [BackupCopyBehindView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNGetTimeNow.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNGetTimeNow"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNGetTimeNow]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNGetTimeNow]
GO

delete from GXDBVersions where name = 'CNGetTimeNow' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNGetTimeNow', '1.1', 'CNGetTimeNow', '')
GO
CREATE VIEW CNGetTimeNow
WITH ENCRYPTION
AS
SELECT 	Now = datediff (second, '1/1/1970', GETUTCDATE())
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNGetTimeNow]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNClientPatchInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNClientPatchInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNClientPatchInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNClientPatchInfoView]
GO

delete from GXDBVersions where name = 'CNClientPatchInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNClientPatchInfoView', '1.10', 'CNClientPatchInfoView', '')
GO
--Create the CNClientPatchInfoView
CREATE VIEW CNClientPatchInfoView
WITH ENCRYPTION
AS
        SELECT	ClientID = C.ID, PI1.simPackageID,
			ReleaseID = C.releaseId,
			BuildIDString = ISNULL(APC.attrVal, 'N/A'),
			ServicePack =
		CASE
			-- When all the rows for a given ClientID matches the SP (and the HighestSP is greather than 0)
			when min(HighestSP) = max(HighestSP) and min(HighestSP) > 0 then
				CASE
				when (select count(*) from simInstalledPackages PI2 where PI2.ClientID = PI1. ClientID AND PI2.simPackageID = PI1.simPackageID AND CONVERT(varchar(10), MissingPatches) <> N'' AND CONVERT(varchar(10), MissingPatches) <> N'None') > 0
					then 'SP' + cast( min(HighestSP) as varchar(20) ) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end + ' (Missing Patches)'
					else 'SP' + cast(min(HighestSP) as varchar(20)) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end
				END
			-- When the rows for a given ClientID DO NOT MATCH
			when max(HighestSP) > 0 then 'SP' + cast( max(HighestSP) as varchar(20) ) + CASE
																		when max(SpMinorVersion) > 0 then char((96 + max(SpMinorVersion)))
																		else ''
																		end + '-'
			-- Otherwise (No rows, all rows have HighestSP equal to 0)
			else ''
		  END
	FROM		APP_Client AS C
			LEFT OUTER JOIN simInstalledPackages PI1
			ON C.ID = PI1.ClientID AND PI1.simPackageID NOT IN (51,1301,2003)
			LEFT OUTER JOIN APP_ClientProp AS APC
			ON C.ID = APC.componentNameId AND APC.attrName='Galaxy Build'
	GROUP BY 	C.ID, PI1.ClientID, PI1.simPackageID, C.releaseId,APC.attrVal
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNClientPatchInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMediaAgentPatchInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMediaAgentPatchInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMediaAgentPatchInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMediaAgentPatchInfoView]
GO

delete from GXDBVersions where name = 'CNMediaAgentPatchInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMediaAgentPatchInfoView', '1.2', 'CNMediaAgentPatchInfoView', '')
GO
CREATE VIEW CNMediaAgentPatchInfoView
WITH ENCRYPTION
AS
SELECT	MediaAgentID = C.ID, ServicePack =
	CASE
				--  When all the rows for a given ClientID matches the SP (and the HighestSP is greather than 0)
		when min(HighestSP) = max(HighestSP) and min(HighestSP) > 0 then
			CASE
			when (select count(*) from simInstalledPackages PI2 where PI2.ClientID = PI1. ClientID AND PI2.simPackageID = PI1.simPackageID AND PI2.MissingPatches IS NOT NULL AND DATALENGTH(PI2.MissingPatches) <> 0 AND PI2.MissingPatches NOT LIKE 'None' ) > 0
				then 'SP' + cast( min(HighestSP) as varchar(20) ) + ' (Missing Updates)'
				else CASE when (select count(*) from simInstalledPackages PI3 where PI3.ClientID = PI1. ClientID AND PI3.simPackageID = PI1.simPackageID AND PI3.AdditionalPatches IS NOT NULL AND DATALENGTH(PI3.AdditionalPatches) <> 0 AND PI3.AdditionalPatches NOT LIKE 'None') > 0
					then 'SP' + cast( min(HighestSP) as varchar(20) ) + ' (Additional Updates)'
					else 'SP' + cast(min(HighestSP) as varchar(20))
				     END
			END
				--  When the rows for a given ClientID DO NOT MATCH
		when max(HighestSP) > 0 then 'SP' + cast( max(HighestSP) as varchar(20) ) + '-'
				--  Otherwise (No rows, all rows have HighestSP equal to 0)
		else ''
	  END
FROM		APP_Client C
		LEFT OUTER JOIN simInstalledPackages PI1
		ON C.ID = PI1.ClientID AND PI1.simPackageID IN(51,1301,2003)
GROUP BY 	C.ID, PI1.ClientID, PI1.simPackageID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMediaAgentPatchInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNIsIDADeletedView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNIsIDADeletedView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNIsIDADeletedView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNIsIDADeletedView]
GO

delete from GXDBVersions where name = 'CNIsIDADeletedView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNIsIDADeletedView', '1.2', 'CNIsIDADeletedView', '')
GO
CREATE VIEW
	CNIsIDADeletedView
WITH ENCRYPTION
AS
SELECT 	DISTINCT
	Client		= C.id,
	AppType		= (SELECT TOP 1 CAST(SUBSTRING(CP.attrName, 21, 12) as int)),
	LogDeleted	= CP.attrVal
FROM	APP_Client as C,
	APP_ClientProp as CP
WHERE	    C.id = CP.componentNameId
	and attrName like 'sys:apptype: deleted %'
	and CP.modified = 0
	and attrVal = '1'
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNIsIDADeletedView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNOpPhaseTableView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNOpPhaseTableView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNOpPhaseTableView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNOpPhaseTableView]
GO

delete from GXDBVersions where name = 'CNOpPhaseTableView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNOpPhaseTableView', '1.1', 'CNOpPhaseTableView', '')
GO
CREATE VIEW CNOpPhaseTableView
WITH ENCRYPTION
AS
SELECT	AppType			= O.AppTypeType,
	OpType			= O.Operation,
	OpTypeName		= O.OpName,
	MaxInstances		= O.MaxInstances,
	NumPhases		= O.NumPhases,
	PhaseNum		= P.Phase,
	PhaseName		= P.Name,
	PhaseStartFrom		= P.StartFrom,
	PhaseStartExec		= P.StartExec,
	PhaseRestartable	= P.Restartable,
	PhaseRestartPhase	= P.RestartPhase,
	PhaseMaxRestarts	= P.MaxRestarts,
	PhaseRestartInterval	= P.RestartInterval,
	PhaseCleanupTimeout	= P.CleanupTimeout,
	PhasePreemptable	= P.Preemptable
FROM	JMOpTable O,
	JMPhase P
WHERE 	O.id = P.OpTableId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNOpPhaseTableView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNSPToMAView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNSPToMAView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNSPToMAView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNSPToMAView]
GO

delete from GXDBVersions where name = 'CNSPToMAView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNSPToMAView', '1.2', 'CNSPToMAView', '')
GO
CREATE VIEW CNSPToMAView
WITH ENCRYPTION
AS
	SELECT	AppTypeID	= 47,
		AppTypeName	= AT.Name,
		SPID		= QRPolicy.id,
		SPName		= QRPolicy.name,
		MAName		= 'NoReplicationMANameYet'
	FROM	APP_IDAType as AT,
		QRPolicy
	WHERE	AT.Type = 47
	UNION ALL
	SELECT	AppTypeID	= AT.type,
		AppTypeName	= AT.Name,
		SPID		= AGO.id,
		SPName		= AGO.name,
		MAName		= (	SELECT	TOP 1 MA.name
					FROM	ArchGroup as AG,
						ArchStream as ASTR,
						MMMediaGroup as MG,
						MMDrivePool as DP,
						MMHost as H,
						APP_Client as MA
					WHERE	    ASTR.archGroupID = AG.id
						and ASTR.archGroupCopyId = AG.defaultCopy
						and ASTR.stream = 1
						and MG.mediaGroupId = ASTR.mediagroupId
						and DP.drivePoolId = MG.drivePoolId
						and H.clientId = DP.clientId
						and MA.id = H.clientId
						and AG.id = AGO.id
				)
	FROM	APP_IDAType as AT,
		ArchGroup as AGO
	WHERE	AT.type <> 47
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNSPToMAView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNQNetAgentInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNQNetAgentInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNQNetAgentInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNQNetAgentInfoView]
GO

delete from GXDBVersions where name = 'CNQNetAgentInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNQNetAgentInfoView', '1.7', 'CNQNetAgentInfoView', '')
GO
--Create the CNQNetAgentInfoView
	CREATE VIEW
		CNQNetAgentInfoView
	WITH ENCRYPTION
	AS
	SELECT	CC.id			as ID,
		ISNULL((GXREL.release +  '.' + CPV.BuildIdString), 'N/A')
					as SWVersion,
		CPV.ServicePack		as ServicePack
	FROM	APP_CommCell as CC,
		APP_Client as C,
		SimAllGalaxyRel as GXREL,
		CNClientPatchInfoView as CPV
	WHERE
		    CC.id = 2
		and C.id = CC.clientId
		and CPV.ClientID = C.id
		and CPV.simPackageID = 804
		and GXREL.id = CPV.ReleaseID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNQNetAgentInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNCommCellInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNCommCellInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNCommCellInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNCommCellInfoView]
GO

delete from GXDBVersions where name = 'CNCommCellInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNCommCellInfoView', '1.9', 'CNCommCellInfoView', '')
GO
CREATE VIEW
	CNCommCellInfoView
WITH ENCRYPTION
AS
SELECT	CC.id			as ID,
	CC.number		as Number,
	C.OfflineEntity	AS OfflineSvcsMask,
	C.OfflineTimeStamp	AS OfflineSvcsTime,
--			On CommCell 5.0 SP1 we had an extra row with mediaAgent = 1, clientId = 1, appType = 0 and opType = 4 with appId = 4
--			Which was of appType = 42. We should only look for appId with appType = 1000 (CS) MR 57960
	DataProtActivity	= (select ISNULL(SUM(action/2)*2, 2) from JMJobAction
				   where clientid = 1 and mediaAgentID = 1 and appType = 0 and ClientGroupID = 0
				   and appId = (SELECT id FROM APP_Application WHERE appTypeId = 1000) and opType in (1, 4)),
	SUBSTRING(
		SUBSTRING(CC.timezone, CHARINDEX(':',CC.timezone,0) + 1, LEN(CC.timezone)),
		CHARINDEX(':', SUBSTRING(CC.timezone, CHARINDEX(':',CC.timezone,0) + 1, LEN(CC.timezone))) + 1,
		LEN(CC.timezone)
	)				as TimezoneName,
	-(SUBSTRING(
		SUBSTRING(CC.timezone, CHARINDEX(':',CC.timezone,0) + 1, LEN(CC.timezone)),
		0,
		CHARINDEX(':', SUBSTRING(CC.timezone, CHARINDEX(':',CC.timezone,0) + 1, LEN(CC.timezone)))
	)) * 60			as TimezoneOffSet,
	(GXREL.release +  '.' + LU.build)
				as SWVersion,
	CPV.ServicePack		as ServicePack,
	dbo.GetUnixTime(LU.OpTimeUTC)	as InstallDate,
	dbo.GetClientHardwareName(C.id, NULL)			as Hardware,
	dbo.GetClientOSName(C.id, NULL)			as OSName,
	dbo.GetClientOSRelease(C.id, NULL)		as OSRelease,
	OS.version		as OSVersion,
	Lic.oemid		as OEMID,
	(SELECT TOP 1 [value] FROM GXGlobalParam WHERE [name] = N'MaintAdvantageUsername' )
					as MaintAdvantageUsername,
	(SELECT TOP 1 [value] FROM GXGlobalParam WHERE [name] = N'MaintAdvantagePassword' )
					as MaintAdvantagePassword,
	(SELECT MAX(Id) FROM simAllGalaxyRel)	as ReleaseID,
	CC.csGUID		as GUID
FROM	APP_CommCell as CC,
	APP_Client as C,
	APP_Platform P,
	LicUsage LU,
	SimAllGalaxyRel as GXREL,
	--SimSystemOS as SysOS,
	--SimOS as OS,
	SimOperatingSystem as OS,
	CNClientPatchInfoView as CPV,
	LicCSL as Lic
WHERE
	    CC.id = 2
	and C.id = CC.clientId
	and P.clientId = C.id
	and P.platformType = 1
	and CC.clientId = C.id
	and LU.Cid = CC.clientId
	and LU.opType = 'Install'
	and LU.AppType = 1000
	and GXREL.id = LU.releaseID
	--and C.simsystemOSId = SysOS.id
	--and SysOS.simOSId = OS.id
	and C.simOperatingSystemId = OS.id
	and CPV.ClientID = C.id
	and CPV.simPackageID = 20
	and Lic.id = (SELECT Max(id) FROM LicCSL)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNCommCellInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNClientInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNClientInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNClientInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNClientInfoView]
GO

delete from GXDBVersions where name = 'CNClientInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNClientInfoView', '1.28', 'CNClientInfoView', '')
GO
CREATE VIEW
	CNClientInfoView
WITH ENCRYPTION
AS
SELECT
	C.origCCID		as CommCellID,
	C.id			as ID,
	CLP.GUID		as GUID,
	C.name			as DisplayName,
	C.net_hostName		as InterfaceName,
	isnull(dbo.GetClientOSName(C.id,NULL), 'N/A')
		as OSName,
	isnull(CLAPPS.RelAndBuild, isnull((SELECT TOP 1 AttrVal FROM APP_ClientProp CPROP WHERE ComponentNameId = C.id and attrName='Foreign Client Version'), 'N/A'))
				as SWVersion,
	isnull((SELECT TOP 1 CPV.ServicePack FROM CNClientPatchInfoView CPV WHERE CPV.ClientID = C.id ORDER BY CPV.ServicePack DESC), '')
				as ServicePack,
	isnull(CLAPPS.InstTime, 0)
				as InstallTime,
	-- on CommNet side we are going to consider VSDC clients as always reachable
	(CASE WHEN CCR.Flag = 0
		  THEN
		      -- client is offline. however we are going to check if client is VSDC client
		      -- check if it is a VSDC client
			  (CASE WHEN ISNULL(CLP.VirtualServerDiscoveredClients, 0) = '1'
			        -- it is a VSDC client. make it reachable i.e NOT offline
			        THEN 0
			        -- it is a real client. it IS offline
			        ELSE 1
			   END)
		  -- CCR.Flag != 0. client is reachable i.e NOT offline
		  ELSE 0
	END) As Offline,
	CAST(isnull(CCR.lastOfflineTime, 0) AS INTEGER) AS OfflineTime,
	0			as OffLineReason,
	CAST(isnull(CLP.JMPriority, 6) AS INTEGER)
				as Priority,
	CAST(isnull((select TOP 1 action from JMJobAction J where J.clientId=C.id and appType=0 and mediaAgentId=1 and opType=4),0) AS INTEGER)
				as DataProtActivity,
    (CASE WHEN ACC.type > = 100 THEN 0
          ELSE (CASE WHEN ISNULL(CLP.Platformdeleted4, '0') = '1' THEN 1 ELSE 0 END)
     END) as LogDeleted,
	C.modified 		as Modified,
	C.Status 		as Status,
	REPLACE(REPLACE(REPLACE(ISNULL(C.clientDescription, ''), CHAR(10), ' '), CHAR(13), ' '), ',', ';') AS Description,
	(ISNULL(SA.SecStorageClient, 0) + ISNULL(PA.PriStorageClient, 0)) AS ClientType,
	CAST(ISNULL(CLP.CommcellTimezoneId, 0) AS INTEGER) AS CCTimeZoneID,
	CAST(ISNULL(CLP.VirtualClient, 0) AS INTEGER) AS IsVirtualClient,
	CAST(ISNULL(CLP.ContentIndexingEnabled, 0) AS INTEGER) AS IsCIEnabled,
	CAST(ISNULL(CLP.SnapBackupsEnabled, 0) AS INTEGER) AS IsSBEnabled,
	-- StdTimeZoneName
	SUBSTRING(CLP.Timezone, LEN(CLP.Timezone) - CHARINDEX(':',REVERSE(CLP.Timezone)) + 2, CHARINDEX(':',REVERSE(CLP.Timezone)) )
					as StdTimeZoneName,	-- Special Client Flags
	replace(ISNULL(TZ.TimeZoneName, ''), ',', ';') AS TimeZoneName, ISNULL(TZ.Bias, 0) AS TimeZoneBias,
	-- Special Client Flags
	C.specialClientFlags	as SpecialClientFlags,
	-- VSDC
	CAST(ISNULL(CLP.VirtualServerDiscoveredClients, 0) AS INTEGER) AS IsVSDC
FROM
	((((APP_Client	C
		INNER JOIN APP_CommCell ACC ON ACC.id = C.origCCId
		LEFT OUTER JOIN
		(SELECT	componentNameID,
				MAX(CASE WHEN attrName = 'Commcell timezone Id' THEN attrVal ELSE '' END) AS CommcellTimezoneId,
				MAX(CASE WHEN attrName = 'Content Indexing Enabled' THEN attrVal ELSE '' END) AS ContentIndexingEnabled,
				MAX(CASE WHEN attrName = 'Foreign Client Version' THEN attrVal ELSE '' END) AS ForeignClientVersion,
				MAX(CASE WHEN attrName = 'GUID' THEN attrVal ELSE '' END) AS GUID,
				MAX(CASE WHEN attrName = 'JMPriority' THEN attrVal ELSE '' END) AS JMPriority,
				MAX(CASE WHEN attrName = 'platformdeleted 4' THEN attrVal ELSE '' END) AS Platformdeleted4,
				MAX(CASE WHEN attrName = 'Virtual Client' THEN attrVal ELSE '' END) AS VirtualClient,
				MAX(CASE WHEN attrName = 'Virtual Server Discovered Clients' THEN attrVal ELSE '' END) AS VirtualServerDiscoveredClients,
				MAX(CASE WHEN attrName = 'Snap Backups Enabled' THEN attrVal ELSE '' END) AS SnapBackupsEnabled,
				MAX(CASE WHEN attrName = 'timezone' THEN attrVal ELSE '' END) AS Timezone
		FROM	App_ClientProp
		WHERE	attrName IN ('Commcell timezone Id', 'Content Indexing Enabled', 'Foreign Client Version', 'GUID', 'JMPriority',
				'platformdeleted 4', 'Virtual Client', 'Virtual Server Discovered Clients', 'Snap Backups Enabled', 'timezone')
			AND modified = 0
		GROUP BY componentNameID) AS CLP
		ON CLP.componentNameID = C.ID
		LEFT OUTER JOIN SchedTimeZone TZ
			ON TZ.TimeZoneStdName = SUBSTRING(CLP.Timezone, LEN(CLP.Timezone) - CHARINDEX(':',REVERSE(CLP.Timezone)) + 2, CHARINDEX(':',REVERSE(CLP.Timezone)))
				-- This makes sure that we always have a row for every client, even though
				-- we don't have a BASE_CLIENT entry on the SIM tables (CLAPPS)
		LEFT OUTER JOIN
			(SELECT	LU.CID AS ClientID, (SR.Release + '.' + LU.Build) as RelAndBuild, dbo.GetUnixTime(LU.OpTimeUTC) as InstTime
			 FROM	LicUsage LU, SimAllGalaxyRel SR,(	SELECT	T2.CID AS ClientID, MAX(ID) AS LID
														FROM	(SELECT	CID, MAX(OpTimeUTC) AS 'MaxOpTimeUTC'
																FROM	LicUsage
																WHERE	OpType='Install'
																		AND InstallFlag = 0
																		AND LicType NOT IN (10,26,71)
																GROUP BY CID) T, LicUSage T2
														WHERE	T.CID = T2.CID
																AND T.MaxOpTimeUTC = T2.OpTimeUTC
														GROUP BY T2.CID
													 ) LUI
			WHERE	LU.id = LUI.LID AND SR.id = LU.Releaseid
		) as CLAPPS
		ON C.id = CLAPPS.ClientID)
		LEFT OUTER JOIN
		(SELECT * FROM CCRClientToClient
			WHERE FromClientID = (SELECT ClientID From APP_CommCell
								WHERE id = 2)
				  AND ToClientID IN (SELECT DISTINCT ClientID FROM CCRToSubClient)
				  AND isDip = 0 AND serviceType = 0) AS CCR
		ON C.ID = CCR.ToClientID)
		LEFT OUTER JOIN
		(SELECT	ClientID, (CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END) AS SecStorageClient
		FROM	APP_IDAName
		WHERE	AppTypeID BETWEEN 1 AND 599
		GROUP BY ClientID) AS SA
		ON C.ID = SA.ClientID)
		LEFT OUTER JOIN
		(SELECT	ClientID, (CASE WHEN COUNT(*) > 0 THEN 2 ELSE 0 END) AS PriStorageClient
		FROM	APP_IDAName
		WHERE	AppTypeID BETWEEN 600 AND 699
		GROUP BY ClientID
						UNION
		--List of all SRM Enabled Agents
		SELECT agents.clientId, (CASE WHEN COUNT(*) > 0 THEN 2 ELSE 0 END) AS PriStorageClient
		FROM APP_Client AS client
		INNER JOIN APP_IDAName AS agents ON
			client.id = agents.clientId
			AND (agents.status & 2) <> 2		--NOT Uninstalled
			AND (agents.status & 16) <> 16		--NOT DUMMY
		INNER JOIN APP_IDAProp AS props ON
			props.componentNameId = agents.id
			AND props.attrName LIKE 'SRM Data Collection Enabled'
			AND props.attrVal = 1
			AND props.modified = 0
		GROUP BY ClientID) AS PA
		ON C.ID = PA.ClientID),
	APP_Platform	P
WHERE
	    C.id > 1
    	and C.id		= P.clientId
    	and (C.Status & 0x4000)	<> 0x4000
	and P.platformType	= 4
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNClientInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNIDAInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNIDAInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNIDAInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNIDAInfoView]
GO

delete from GXDBVersions where name = 'CNIDAInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNIDAInfoView', '1.4', 'CNIDAInfoView', '')
GO
CREATE VIEW
	CNIDAInfoView
WITH ENCRYPTION
AS
SELECT
	2	 	as CommCellID,
	IDA.clientId 	as ClientID,
	IDA.appTypeId	as AppTypeID,
	(select name from APP_IDAType where type = IDA.appTypeId)
			as AppTypeName,
	(CASE WHEN ((IDA.status & 0x2000) > 0) THEN 0 ELSE		-- 0x2000(8192) - this is a special flag that says that this is external IDA
	    CASE WHEN ((IDA.status & 0x6) > 0) THEN 1 ELSE 0 END
     END) as LogDeleted,
	IDA.Status 		as Status
FROM 	APP_IDAName IDA, CNClientInfoView CL
WHERE 	IDA.clientId = CL.id and IDA.appTypeId < 1000
		AND	(IDA.AppTypeID NOT BETWEEN 600 AND 700)
        AND IDA.appTypeId <> 122 -- filter out commnet agent data type
UNION ALL
SELECT	TOP 1
	2,
	clientId,
	appTypeId,
	(select name from APP_IDAType where type = APP.appTypeId),
	0,
	0
FROM 	APP_Application APP
WHERE 	appTypeId = 1030	-- Subclient Policy
	AND subclientStatus & (2 + 4) = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNIDAInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNInstanceView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNInstanceView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNInstanceView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNInstanceView]
GO

delete from GXDBVersions where name = 'CNInstanceView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNInstanceView', '1.2', 'CNInstanceView', '')
GO
CREATE VIEW
	CNInstanceView
WITH ENCRYPTION
AS
Select DISTINCT I.ID,
		Name = (CASE I.ID WHEN 1 THEN ''
				ELSE dbo.FixInstanceName(I.Name, AppTypeID)
			END),
		Created = I.RefTime,
		Modified = I.Modified
FROM APP_InstanceName AS I,
	(SELECT DISTINCT A1.AppTypeID, A1.Instance
		FROM APP_Application AS A1) AS A
WHERE A.Instance = I.id
--	AND ((I.Status & 0x0010) = 0)
 	AND (
			(A.AppTypeID NOT IN
				(SELECT AT.type
					FROM APP_IDAType AS AT
					WHERE AT.NAME LIKE 'Oracle%'
						OR AT.NAME = 'SAP'
						OR AT.NAME LIKE 'DB2%'
						OR AT.NAME LIKE 'Informix%'
						OR AT.NAME LIKE 'Sybase%' )
			)
			OR
			( (A.AppTypeID IN
				(SELECT AT.type
					FROM APP_IDAType AS AT
					WHERE AT.NAME LIKE 'Oracle%'
						OR AT.NAME = 'SAP'
						OR AT.NAME LIKE 'DB2%'
						OR AT.NAME LIKE 'Informix%'
						OR AT.NAME LIKE 'Sybase%' )
			  )
			  AND
				(I.name NOT IN ('DefaultDummyInstanceForOracle', 'defaultDummyInstanceForSAP') )
			)
		)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNInstanceView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNBackupSetView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNBackupSetView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNBackupSetView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNBackupSetView]
GO

delete from GXDBVersions where name = 'CNBackupSetView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNBackupSetView', '1.1', 'CNBackupSetView', '')
GO
CREATE VIEW
	CNBackupSetView
WITH ENCRYPTION
AS
Select DISTINCT B.ID,
		Name = B.Name,
		Created = B.RefTime,
		Modified = B.Modified
FROM APP_BackupSetName AS B,
	(SELECT DISTINCT A1.AppTypeID, A1.BackupSet
		FROM APP_Application AS A1) AS A
WHERE A.BackupSet = B.id
	AND ((B.Status & 0x0010) = 0)
 	AND (
			(A.AppTypeID NOT IN
				(SELECT AT.type
					FROM APP_IDAType AS AT
					WHERE AT.NAME LIKE 'DB2%')
			)
			OR
			( (A.AppTypeID IN
				(SELECT AT.type
					FROM APP_IDAType AS AT
					WHERE AT.NAME LIKE 'DB2%')
			  )
			  AND
				(B.name NOT IN ('defaultDummyBackupSet') )
			)
		)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNBackupSetView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNJobsBackupView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNJobsBackupView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNJobsBackupView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNJobsBackupView]
GO

delete from GXDBVersions where name = 'CNJobsBackupView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNJobsBackupView', '1.2', 'CNJobsBackupView', '')
GO
CREATE VIEW CNJobsBackupView
WITH ENCRYPTION
AS
SELECT	JobID 		= I.JobID,
	StatusID	= I.State,
	OpType		= I.OpType,
	AppID		= A.id,
	BkpLevel	= BI.BkpLevel,
	EntityID	= A.ClientID,
	AppTypeID	= A.AppTypeId,
	ClientName 	= isnull((select name from APP_Client where id=A.clientId), ''),
	InstanceName 	= isnull((select dbo.FixInstanceName(name,A.AppTypeID) from APP_InstanceName where id=A.instance and id>1), ''),
	BackupSetName 	= isnull((select name from APP_BackupSetName where id=A.backupSet), ''),
	SubClientName 	= isnull(A.subclientName, ''),
	SPName		= isnull(SPTOMA.SPName, ''),
	MAName		= isnull(SPTOMA.MAName, ''),
	CurrentPhaseNum	= I.CurrentPhase,
	CurrentPhaseName = isnull((select TOP 1 PhaseName from CNOpPhaseTableView V where V.AppType = A.AppTypeId and V.OpType = I.OpType and V.PhaseNum = I.CurrentPhase), ''),
	TotalNumOfPhases= O.NumPhases,
	StartTime	= I.jobStartTime,
	EndTime		= 0,
	ElapsedTime	= I.jobElapsedTime,
	Progress	= I.PercentComplete,
	Priority	= I.combPriority,
	UserName	= isnull((select login from UMUsers where id = I.UserId), ''),
	FailureReason	= ISNULL(I.FailureReason, ''),
	Modified	= (select now from CNGetTimeNow),
	Preemptable	= I.Preemptable,
	GUIAlertColorLevel	= I.guiAlertColorLevel,
	TimeToComplete	= I.timeToComplete
FROM	JMJobInfo as I
	INNER JOIN JMBkpJobInfo as BI
		ON I.JobID = BI.JobID
	INNER JOIN JMOpTable as O
		ON O.operation = I.OpType
	INNER JOIN APP_Application A
		ON A.id = BI.applicationId
		and O.apptypetype = A.appTypeId
	LEFT OUTER JOIN CNSPToMAView as SPTOMA
		ON SPTOMA.AppTypeID = A.AppTypeId
		and SPTOMA.SPID = BI.dataPolicy
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNJobsBackupView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNJobsRestoreView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNJobsRestoreView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNJobsRestoreView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNJobsRestoreView]
GO

delete from GXDBVersions where name = 'CNJobsRestoreView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNJobsRestoreView', '1.2', 'CNJobsRestoreView', '')
GO
CREATE VIEW CNJobsRestoreView
WITH ENCRYPTION
AS
SELECT	JobID 		= I.JobID,
	StatusID	= I.State,
	OpType		= I.OpType,
	OpTypeName	= O.OpName,
	EntityID	= RI.srcClientID,
	AppTypeID	= RI.AppType,
	ClientName 	= isnull((select name from APP_Client where id=srcClientId), ''),
	DestClientName 	= isnull((select name from APP_Client where id=destClientId), ''),
	InstanceName 	= isnull((select dbo.FixInstanceName(name,RI.AppType) from APP_InstanceName where id=instanceId and id>1), ''),
	BackupSetName 	= isnull((select name from APP_BackupSetName where id=bkpSetId), ''),
	CurrentPhaseNum	= I.CurrentPhase,
	CurrentPhaseName = isnull((select TOP 1 PhaseName from CNOpPhaseTableView V where V.AppType = RI.AppType and V.OpType = I.OpType and V.PhaseNum = I.CurrentPhase), ''),
	TotalNumOfPhases= O.NumPhases,
	StartTime	= I.jobStartTime,
	EndTime		= 0,
	ElapsedTime	= I.jobElapsedTime,
	Progress	= I.PercentComplete,
	Priority	= I.combPriority,
	UserName	= isnull((select login from UMUsers where id = I.UserId), ''),
	FailureReason	= ISNULL(FailureReason, ''),
	Modified	= (select now from CNGetTimeNow),
	MAName		= isnull((SELECT name FROM APP_Client WHERE id = (SELECT TOP 1 ClientID FROM JMJobResourceHistory WHERE jobID = I.JobID ORDER BY ReservationTime DESC)), ''),
	Preemptable	= I.Preemptable,
	GUIAlertColorLevel	= I.guiAlertColorLevel,
	TimeToComplete	= I.timeToComplete
FROM	JMJobInfo as I,
	JMRstJobInfo as RI,
	JMOpTable as O
WHERE	    O.operation = I.OpType
	and I.JobID = RI.JobID
	and O.apptypetype = RI.AppType
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNJobsRestoreView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNJobsAdminView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNJobsAdminView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNJobsAdminView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNJobsAdminView]
GO

delete from GXDBVersions where name = 'CNJobsAdminView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNJobsAdminView', '1.2', 'CNJobsAdminView', '')
GO
CREATE VIEW CNJobsAdminView
WITH ENCRYPTION
AS
SELECT	JobID 		= I.JobID,
	StatusID	= I.State,
	OpType		= I.OpType,
	EntityID	= 2, -- TODO! Fetch CommCell's EntityID (2)
	AppTypeID	= O.apptypetype,
	ClientName 	= 'CommServe',
	InstanceName 	= '',
	BackupSetName 	= '',
	CurrentPhaseNum	= I.CurrentPhase,
	CurrentPhaseName = isnull((select TOP 1 PhaseName from CNOpPhaseTableView V where V.AppType = 1000 and V.OpType = I.OpType and V.PhaseNum = I.CurrentPhase), 'Unavailable'),
	TotalNumOfPhases= O.NumPhases,
	StartTime	= I.jobStartTime,
	EndTime		= 0,
	ElapsedTime	= I.jobElapsedTime,
	Progress	= I.PercentComplete,
	Priority	= I.combPriority,
	UserName	= isnull((select login from UMUsers where id=I.UserId), 'Unavailable'),
	FailureReason	= ISNULL(I.FailureReason, ''),
	BkpLevel	= AI.ER_BkpLevel,
	SPName		= isnull(SPTOMA.SPName, 'Unavailable'),
	MAName		= isnull(SPTOMA.MAName, 'Unavailable'),
	NumStreams	= AI.NoOfStreams,
	CopyID		= isnull((select TOP 1 ArchGrpCopyID from JMDataCopiedStatsTable DCopy where AI.jobId = DCopy.jobId), 0),
	CopyName 	= isnull((select name from archgroupcopy where id = (select TOP 1 ArchGrpCopyID from JMDataCopiedStatsTable DCopy where AI.jobId = DCopy.jobId)), 'Unavailable'),
	InventoryType	= AI.MI_InventoryType,
	LibraryName	= isnull((select aliasname from MMLibrary where libraryId=AI.LibraryID), 'Unavailable'),
	Modified	= (select now from CNGetTimeNow),
	Preemptable	= I.Preemptable,
	GUIAlertColorLevel	= I.guiAlertColorLevel,
	TimeToComplete	= I.timeToComplete
FROM	(JMAdminJobInfoTable as AI
		LEFT OUTER JOIN CNSPToMAView as SPTOMA
			ON SPTOMA.AppTypeID = 1000
			and SPTOMA.SPID = AI.ArchGrpID),
	JMJobInfo as I,
	JMOpTable as O
WHERE	O.Operation = I.OpType AND
	   (O.apptypetype = 1000 OR
	     (I.OpType in (38, 44) AND O.apptypetype = (SELECT appTypeID FROM APP_Application WHERE id = AI.appID)))
	and I.JobID = AI.JobID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNJobsAdminView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNEventView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNEventView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNEventView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNEventView]
GO

delete from GXDBVersions where name = 'CNEventView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNEventView', '1.1', 'CNEventView', '')
GO
CREATE VIEW
	CNEventView
WITH ENCRYPTION
AS
SELECT	TOP 200
	id,
	MessageId,
	TimeSource,
	TimeServer,
	Severity,
	JobID = JobID_l,
	Client,
	Subsystem,
	LastOccurrence,
	RepeatCount,
	NextPost
FROM 	evMsg
WHERE	Severity >= 6
ORDER BY id DESC
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNEventView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMAInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMAInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMAInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMAInfoView]
GO

delete from GXDBVersions where name = 'CNMMMAInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMAInfoView', '1.9', 'CNMMMAInfoView', '')
GO
CREATE VIEW
	CNMMMAInfoView
WITH ENCRYPTION
AS
SELECT 	DISTINCT
C.origCCID				as CommCellID,
MH.ClientId			as MediaAgentID,
C.name				as DisplayName,
C.net_hostname			as InterfaceName,
dbo.GetClientOSName(C.id,NULL)	as OSName,
isnull(CLAPPS.RelAndBuild, isnull((SELECT TOP 1 AttrVal FROM APP_ClientProp CPROP WHERE ComponentNameId = C.id and attrName='Foreign Client Version'), 'N/A'))
				as SWVersion,
MPV.ServicePack			as ServicePack,
ISNULL(InstTime, 0)	as InstallTime,
MH.MmHostEnabled			as MAEnabled,
1 - (MH.MmHostSoftState & MH.MmHostEnabled) as Offline,
MH.OfflineTimeStamp		as OfflineTime,
(CASE WHEN (1 - (MH.MmHostSoftState & MH.MmHostEnabled)) = 0
		THEN	0
		ELSE MH.OfflineReason
	END)		as OfflineReason,
TotalDrives=(SELECT count(*) FROM MMDrive WHERE DriveTypeId != 10001 AND
MasterPoolId IN (SELECT MasterPoolId FROM MMDrivePool WHERE ClientID = MH.ClientID)),
OfflineDrives=(SELECT count(*) FROM MMDrive WHERE DriveTypeId != 10001 AND
(DriveSoftState & DriveEnabled & ~DriveBroken & ~CleaningRequired) = 0 AND
MasterPoolId IN (SELECT MasterPoolId FROM MMDrivePool WHERE ClientID = MH.ClientID)),
TotalLibraries=(SELECT count(*) FROM MMLibrary WHERE LibraryId IN
(SELECT LibraryId FROM MMLibraryController WHERE ClientID = MH.ClientID)),
OfflineLibraries=(SELECT count(*) FROM MMLibrary WHERE
(LibrarySoftState & LibraryEnabled & ~LibraryBroken) = 0 AND LibraryId IN
(SELECT LibraryId FROM MMLibraryController WHERE ClientID = MH.ClientID)),
IsNDMPRemoteServer = isnull((select count(*) from APP_ClientProp clprop where attrName = 'NDMP Remote Server' and attrVal = '1' and modified = 0 and componentNameID = C.id), 0)
FROM 	MMHost as MH,
APP_Client as C
LEFT OUTER JOIN
			(SELECT	L.CID AS ClientID, (SR.Release + '.' + L.Build) as RelAndBuild, dbo.GetUnixTime(L.OpTimeUTC) as InstTime
			 FROM	LicUsage L, SimAllGalaxyRel SR
			WHERE	L.OpType = 'Install' AND
					L.InstallFlag = 0 AND
					L.AppType = 1002 AND
					L.Lictype NOT IN (71, 10, 26, 33554432) AND
					SR.id = L.Releaseid
		) as CLAPPS
		ON C.id = CLAPPS.ClientID,
simOperatingSystem as SOS,
-- APP_Platform P,
CNMediaAgentPatchInfoView as MPV
WHERE  	MH.clientid = C.id AND
MH.clientid > 1 AND
(C.Status & 0x4000)	<> 0x4000 AND
-- C.id = P.clientId AND
-- P.platformType	= 2 AND
C.simOperatingSystemId = SOS.id AND
C.id = MPV.MediaAgentID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMAInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMADrivesView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMADrivesView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMADrivesView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMADrivesView]
GO

delete from GXDBVersions where name = 'CNMMMADrivesView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMADrivesView', '1.1', 'CNMMMADrivesView', '')
GO
CREATE VIEW
	CNMMMADrivesView
WITH ENCRYPTION
AS
SELECT distinct
	H.ClientId		as MediaAgentID,
	D.DriveId		as DriveID,
	L.LibraryId		as LibraryID,
	0				as IsActive,
	0				as OSAccessible,
	0				as UserEnabled,
	0				as DriveControllerId,
	''				as DriveControllerName,
	''				as SCSIId
FROM
	MMLibrary L,
	MMDrive D,
	MMMasterPool MP,
	MMDrivePool DP,
	MMHost H
WHERE
	    H.ClientID = DP.ClientID
	AND DP.MasterPoolId = D.MasterPoolId
	AND D.MasterPoolId = MP.MasterPoolId
	AND MP.LibraryId = L.LibraryId
	AND L.LibraryId > 0
	AND L.LibraryTypeId = 3
UNION
SELECT	DISTINCT
		H.ClientId		as MediaAgentID,
		D.DriveId		as DriveID,
		L.LibraryId		as LibraryID,
		DC.DriveControllerActive		as IsActive,
		DC.DriveAccessible				as OSAccessible,
		DC.DriveControllerEnabled		as UserEnabled,
		DC.DriveControllerId			as DriveControllerId,
		DC.DriveControllerName			as DriveControllerName,
		DC.SCSIId						as SCSIId
FROM	MMDrive	D,
		MMDriveController DC,
		MMDrivePool DP,
		MMMasterPool MP,
		MMLibrary L,
		MMHost	H
WHERE	D.DriveID = DC.DriveID
		AND DC.ClientID = H.ClientID
		AND DC.DrivePoolID = DP.DrivePoolID
		AND DP.MasterPoolId = MP.MasterPoolID
		AND MP.LibraryId = L.LibraryId
		AND L.LibraryId > 0
		AND L.LibraryTypeId != 8
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMADrivesView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMALibraryView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMALibraryView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMALibraryView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMALibraryView]
GO

delete from GXDBVersions where name = 'CNMMMALibraryView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMALibraryView', '1.1', 'CNMMMALibraryView', '')
GO
CREATE VIEW
	CNMMMALibraryView
WITH ENCRYPTION
AS
SELECT distinct
H.ClientId		as MediaAgentID,
L.LibraryId		as LibraryID,
LC.LibraryControllerActive		as IsActive,
LC.LibraryControllerEnabled		as UserEnabled,
LC.LibraryControllerId			as LibraryControllerId,
LC.LibraryControllerName		as LibraryControllerName,
LC.SCSIId						as SCSIId
FROM
MMLibrary L,
MMLibraryController LC,
MMHost H
WHERE
LC.ClientID = H.ClientID AND
LC.LibraryId = L.LibraryId AND
L.LibraryId > 0
AND L.LibraryTypeId != 8
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMALibraryView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMLibraryDrivesView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMLibraryDrivesView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryDrivesView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMLibraryDrivesView]
GO

delete from GXDBVersions where name = 'CNMMLibraryDrivesView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMLibraryDrivesView', '1.2', 'CNMMLibraryDrivesView', '')
GO
CREATE VIEW
	CNMMLibraryDrivesView
WITH ENCRYPTION
AS
SELECT	DISTINCT
	L.LibraryId		as LibraryID,
	MP.MasterPoolID		as MasterPoolID,
	MP.MasterPoolName	as MasterPoolName,
	D.DriveId		as DriveID,
	D.DriveName		as DriveName,
	D.AliasName		as DriveAliasName,
	DT.DriveTypeName	as DriveTypeName,
	D.DriveVendor		as Vendor,
	D.DriveModel		as Model,
	D.FirmwareRevision	as FirmwareRevision,
	D.SerialNumber		as SerialNumber,
	D.DriveEnabled		as DriveEnabled,
	1 - (D.DriveSoftState & D.DriveEnabled & ~D.CleaningRequired & ~D.DriveBroken)
				as Offline,
	(CASE WHEN (1 - (D.DriveSoftState & D.DriveEnabled & ~D.CleaningRequired & ~D.DriveBroken) ) = 0
			THEN	0
			ELSE D.OfflineReason
		END)	as OfflineReason,
	D.OfflineTimeStamp	as OfflineTime,
	isnull(MountP.MountPathID, 0) as MountPathID,
	DT.RatedThroughputInMBPerSec as RatedThroughputInMBPerSec,
	D.DriveOfflineReasonEventID		as OfflineReasonEventID,
	D.origCCID				as		CommCellID
FROM
	MMLibrary L,
	MMDrive D,
	MMMasterPool MP,
	MMDriveType DT,
	MMMediaSide MS
		LEFT OUTER JOIN MMMountPath MountP
		ON MountP.MediaSideID = MS.MediaSideID
WHERE
	    D.MasterPoolId = MP.MasterPoolId
	AND MP.LibraryId = L.LibraryId
	AND D.DriveTypeID = DT.DriveTypeID
	AND L.LibraryId > 0
	AND L.LibraryTypeId != 8
	AND D.MediaID = MS.MediaID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMLibraryDrivesView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMLibraryScratchPoolsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMLibraryScratchPoolsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryScratchPoolsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMLibraryScratchPoolsView]
GO

delete from GXDBVersions where name = 'CNMMLibraryScratchPoolsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMLibraryScratchPoolsView', '1.4', 'CNMMLibraryScratchPoolsView', '')
GO
CREATE VIEW
	CNMMLibraryScratchPoolsView
WITH ENCRYPTION
AS
SELECT
SG.LibraryId		as LibraryID,
SG.SpareGroupId		as ScratchPoolID,
SG.SpareGroupName	as ScratchPoolName,
SG.LowWaterMark		as LowWaterMark,
SG.IsLowWaterMark	as IsBelowLowWaterMark,
SG.LowWaterMarkTime	as LastBelowLowWaterMarkTime,
(SELECT count(*) FROM MMMedia LEFT OUTER JOIN APP_CommCell ON origCCcommCellID = APP_CommCell.id WHERE SpareGroupId = SG.SpareGroupId AND (IsInMediaGroup = 0) AND
			((CNDoNotUseCCMMediaCount = 0) OR (origCCcommCellID <= 2) OR ((Attributes & 268435456) = 268435456)
					OR ((origCCcommCellID = APP_CommCell.id) AND (APP_CommCell.type <> 1)))
)			as TotalMedia,
(SELECT count(*) FROM MMMedia LEFT OUTER JOIN APP_CommCell ON origCCcommCellID = APP_CommCell.id WHERE (MediaLocation in (1,2)) AND SpareGroupId = SG.SpareGroupId AND (IsInMediaGroup = 0) AND
			((CNDoNotUseCCMMediaCount = 0) OR (origCCcommCellID <= 2) OR ((Attributes & 268435456) = 268435456)
					OR ((origCCcommCellID = APP_CommCell.id) AND (APP_CommCell.type <> 1)))
)			as MediaInsideLibrary,
isnull((SELECT sum(CAST(FreeBytesMB AS BIGINT)) FROM MMMediaSide
	WHERE MediaId IN
	(
		(SELECT MediaId FROM MMMedia WHERE SpareGroupId = SG.SpareGroupId AND (IsInMediaGroup = 0)
		)
	)
), 0) 		as CapacityMB
FROM
MMLibrary L,
MMSpareGroup SG,
(SELECT (CASE WHEN (EXISTS (SELECT * FROM GxGlobalParam WHERE NAME = 'CNDoNotUseCCMMediaCount')) THEN
		(SELECT	CAST(CAST(value AS nvarchar(5)) AS int) FROM GxGlobalParam WHERE NAME = 'CNDoNotUseCCMMediaCount')
		ELSE 0 END) AS CNDoNotUseCCMMediaCount) T
WHERE
(SG.SpareGroupType = 1 OR SG.SpareGroupType = 2) AND
SG.LibraryId = L.LibraryId AND
L.LibraryId > 0 AND
L.LibraryTypeId != 3 AND
L.LibraryTypeId != 8
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMLibraryScratchPoolsView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMLibraryHistoryView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMLibraryHistoryView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryHistoryView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMLibraryHistoryView]
GO

delete from GXDBVersions where name = 'CNMMLibraryHistoryView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMLibraryHistoryView', '1.1', 'CNMMLibraryHistoryView', '')
GO
CREATE VIEW
	CNMMLibraryHistoryView
WITH ENCRYPTION
AS
SELECT
	LH.LibraryId				as LibraryID,
	LH.TimeStart				as TimeStart,
	LH.HistoryType				as HistoryType,
	LH.NumberOfSoftErrors			as SoftErrors,
	LH.NumberOfHardErrors			as HardErrors,
	LH.NumberOfMediaUsed			as MediaUsed,
	LH.NumberOfMediaFreed			as MediaRecycled,
	LH.DataWritten				as DataWritten,
	LH.DataRead				as DataRead,
	LH.NumberOfBackups			as NumberOfBackups,
	LH.NumberOfRestores			as NumberOfRestores,
	LH.CapacityFreedMB			as CapacityFreedMB,
	LH.Modified				as Modified,
	LH.Version				as Version
FROM	MMLibraryHistory LH
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMLibraryHistoryView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMDriveHistoryView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMDriveHistoryView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMDriveHistoryView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMDriveHistoryView]
GO

delete from GXDBVersions where name = 'CNMMDriveHistoryView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMDriveHistoryView', '1.1', 'CNMMDriveHistoryView', '')
GO
CREATE VIEW
	CNMMDriveHistoryView
WITH ENCRYPTION
AS
SELECT
	isnull((SELECT MP.LibraryId FROM MMMasterPool MP, MMDrive D
			WHERE MP.MasterPoolId = D.MasterPoolId
			AND D.DriveId = DH.DriveId), 0)
	as LibraryID,
	DH.DriveID				as DriveID,
	DH.ClientId				as MediaAgentID,
	DH.TimeStart				as TimeStart,
	DH.HistoryType				as HistoryType,
	DH.NumberOfMounts			as Mounts,
	DH.NumberOfCleans			as Cleans,
	DH.NumberOfSoftErrors			as SoftErrors,
	DH.NumberOfHardErrors			as HardErrors,
	DH.DataWritten				as DataWritten,
	DH.DataRead				as DataRead,
	DH.NumberOfBackups			as NumberOfBackups,
	DH.NumberOfRestores			as NumberOfRestores,
	DH.Modified				as Modified,
	DH.DataWriteDurationSec			as DataWrittenDurationSec,
	DH.DataReadDurationSec			as DataReadDurationSec,
	DH.Version				as Version
FROM	MMDriveHistory DH
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMDriveHistoryView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNFSSubClientContentView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNFSSubClientContentView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNFSSubClientContentView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNFSSubClientContentView]
GO

delete from GXDBVersions where name = 'CNFSSubClientContentView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNFSSubClientContentView', '1.3', 'CNFSSubClientContentView', '')
GO
CREATE VIEW
	CNFSSubClientContentView
WITH ENCRYPTION
AS
SELECT	AppID = A1.ID, type, FileName = dbo.FixInstanceName(fileName, AppTypeID)
FROM	APP_ScFilterFile SC1, APP_Application as A1
WHERE	(    SC1.componentNameId = A1.id
		OR
	     SC1.componentNameId = (SELECT TOP 1 CAST(SCP.attrVal AS INT) FROM APP_SubClientProp AS SCP
				   WHERE SCP.ComponentNameID = A1.id
					AND SCP.attrName = 'Associated subclient Policy'
					AND SCP.attrType = 10
					AND ISNUMERIC(SCP.attrVal) > 0
					AND SCP.modified = 0)
	)
	AND SC1.Type = 1
	AND SC1.Modified = 0
	AND FileName in
		(SELECT TOP 5 FileName
		 FROM 	APP_ScFilterFile SC2
		 WHERE 	Type = 1 AND Modified = 0
			AND SC1.ComponentNameID = SC2.ComponentNameID)
	AND A1.AppTypeID IN
		(SELECT DISTINCT type
		 FROM  app_idaType AS ida
		 WHERE ida.displayName IN ('File System', 'NAS', 'Image Level') )
UNION ALL
SELECT	AppID = ComponentNameID, type,
	fileName = (ISNULL((SELECT Path FROM QRMountPoint WHERE deviceNameId = (SELECT TOP 1 id FROM QRPhysicalDevice WHERE SNRVolumeId =
		CAST(SUBSTRING(filename, 1, CHARINDEX(NCHAR(0x0015), filename)-1) as int))), 'Unknown')
	+ ' -> ' +
	ISNULL(SUBSTRING(filename,
		CHARINDEX(NCHAR(0x0015), filename) + 1,
		CHARINDEX(NCHAR(0x0015),
		   	SUBSTRING(filename, CHARINDEX(NCHAR(0x0015), filename) + 1, 255)) -1), 'Unknown'))
FROM	APP_ScFilterFile SC1
WHERE	    Type = 1
	AND Modified = 0
	AND ComponentNameID IN
		(SELECT DISTINCT id
		 FROM APP_Application AS A
		 WHERE A.AppTypeID = 72)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNFSSubClientContentView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNSubclientView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNSubclientView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNSubclientView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNSubclientView]
GO

delete from GXDBVersions where name = 'CNSubclientView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNSubclientView', '1.1', 'CNSubclientView', '')
GO
CREATE VIEW
	CNSubclientView
WITH ENCRYPTION
AS
Select DISTINCT A.ID,
		A.SubClientName,
		Created = A.RefTime,
		Modified = A.Modified,
		LogDeleted = CASE WHEN (A.SubclientStatus & 0x6 > 0) THEN 1 ELSE 0 END
FROM	APP_Application AS A
WHERE	A.AppTypeID < 1000
	AND(	(A.AppTypeID not in (
				8, 14, 26, 30, 54,		-- Exchange Mailbox IDAs
				6, 7, 51, 52, 59, 60, 77,	-- Lotus Notes IDAs
				69,				-- SharePoint Server 2003 Database IDA
				71				-- NetWare GroupWise DB IDA
				))
		OR	(A.SubClientName <> 'Do Not Backup'))
	AND(	(A.AppTypeID not in (
				45, 56, 57		-- Exchange Data Migrator IDAs
				))
		OR	(A.SubClientName <> 'Do Not Migrate'))
	AND(	(AppTypeID not in (
				1, 11, 12, 13, 17, 18, 19,
				20, 21, 28, 29, 33, 34, 36,
				38, 42, 43, 63, 64, 74,	-- File Systems IDAs
				58, 66,			-- File Systems Alike IDAs (FS Data Migrator)
				65, 75,	76,  		-- File Systems Alike IDAs (Image Level)
				41,			-- File Systems Alike IDAs (Active Directory)
				10,			-- File Systems Alike IDAs (NDS)
				8, 14, 26, 30, 54,	-- File Systems Alike IDAs (Exchanges Mailbox IDAs)
				35, 44,	55,		-- File Systems Alike IDAs (Exchange Public Folder)
				67, 68,			-- File Systems Alike IDAs (Exchange Archiver)
				45, 56, 57,		-- File Systems Alike IDAs (Exchange Data Migrator IDAs)
				6, 7, 51, 52, 59, 60, 77,			-- File Systems Alike IDAs (Lotus Notes IDAs)
				24, 48,			-- File Systems Alike IDAs ( Serverless Data Manager)
				39,			-- File Systems Alike IDAs (Software Data Mover)
				49,			-- File Systems Alike IDAs (Unigraphics)
				46,			-- File Systems Alike IDAs (SharePoint Doc)
				71,			-- File Systems Alike IDAs (Netware Groupwise)
				72,			-- File Systems Alike IDAs (Recovery Director)
				73,			-- File Systems Alike IDAs (NTAP DataMigrator)
				25, 40,			-- File Systems Alike IDAs (Proxy Host)
				47, 50			-- File Systems Alike IDAs (QR Agent)
				))
		    OR	(A.SubClientName <> 'IndexingSubclient'))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNSubclientView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMDrivePoolView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMDrivePoolView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMDrivePoolView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMDrivePoolView]
GO

delete from GXDBVersions where name = 'CNMMDrivePoolView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMDrivePoolView', '1.2', 'CNMMDrivePoolView', '')
GO
CREATE VIEW
	CNMMDrivePoolView
WITH ENCRYPTION
AS
SELECT	DP.DrivePoolID,
		DP.DrivePoolName,
		DrivePoolType = ISNULL( DPType.DriveTypeID, DP.DrivePoolType),
		DP.DrivePoolSoftState,
		DP.DrivePoolEnabled,
		BLCatGUID = (SELECT ISNULL((CASE
							WHEN BCC.CatGUID IS NULL THEN 'F3BE811D-4ACC-49FF-B670-486268D2EFEC'
							WHEN BCC.CatGUID <> 'F3BE811D-4ACC-49FF-B670-486268D2EFEC' THEN BCC.CatGUID
							ELSE (SELECT TOP 1 C.BLCatGUID FROM BLDriveTypeCosts C
								  WHERE DT.DriveTypeID <> 10001
										AND DT.DriveTypeName = C.DriveTypeName)
							END),'F3BE811D-4ACC-49FF-B670-486268D2EFEC')
					 FROM BLCostCategory AS BCC
					 WHERE BCC.CostCategoryID = DP.CostCategoryID),
		AssocType = (SELECT (CASE
							WHEN ((BCC.CatGUID IS NULL OR BCC.CatGUID = 'F3BE811D-4ACC-49FF-B670-486268D2EFEC') AND DT.DriveTypeID <> 10001) THEN 1
							ELSE 2
							END)
					 FROM BLCostCategory AS BCC
					 WHERE BCC.CostCategoryID = DP.CostCategoryID)
FROM MMDrivepool AS DP
	LEFT OUTER JOIN (SELECT DC.DrivePoolID, MAX(D.DriveTypeID) AS DriveTypeID
					FROM MMDriveController AS DC, MMDrive AS D
					WHERE D.DriveID = DC.DriveID
					GROUP BY DC.DrivePoolID) AS DPType ON DPType.DrivePoolID = DP.DrivePoolID
	LEFT OUTER JOIN MMDriveType DT ON DT.DriveTypeID = ISNULL( DPType.DriveTypeID, DP.DrivePoolType)
WHERE DP.DrivePoolID <> 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMDrivePoolView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMDPToMPView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMDPToMPView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMDPToMPView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMDPToMPView]
GO

delete from GXDBVersions where name = 'CNMMDPToMPView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMDPToMPView', '1.1', 'CNMMDPToMPView', '')
GO
CREATE VIEW
	CNMMDPToMPView
WITH ENCRYPTION
AS
SELECT	DISTINCT DP.DrivePoolID,
		MediaAgentID = MH.ClientID,
		DP.MasterPoolID
FROM MMHost AS MH, MMDrivePool AS DP, MMDrive AS D
WHERE MH.ClientID = DP.ClientID
	AND D.MasterPoolID = DP.MasterPoolID
	AND	D.MasterPoolID > 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMDPToMPView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNQRVolumeView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNQRVolumeView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNQRVolumeView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNQRVolumeView]
GO

delete from GXDBVersions where name = 'CNQRVolumeView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNQRVolumeView', '1.1', 'CNQRVolumeView', '')
GO
CREATE VIEW
	CNQRVolumeView
WITH ENCRYPTION
AS
SELECT	QRVolumeID = PHYSVOL.ID,
	ClientID = C.ID,
	ClientName = C.Name,
	DeviceID = DN.ID,
	DeviceName = DN.DeviceName,
	BLCatGUID = BCC.CatGUID
FROM 	APP_Client AS C,
	(
		SELECT	DN1.*
		FROM	QRPhysicalDevice AS DN1
		WHERE ID = (SELECT TOP 1 ID
				FROM 	QRPhysicalDevice AS DN2
				WHERE	DN2.ClientID = DN1.ClientID
					AND DN2.SNRVolumeID = DN1.SNRVolumeID
				ORDER BY DN2.ID DESC)
	) AS DN,
	BLCostCategory AS BCC,
	QRPhysicalVolume PHYSVOL
WHERE	DN.ClientID = C.ID
	AND DN.SNRVolumeID = PHYSVOL.ID
	AND BCC.CostCategoryID = PHYSVOL.CostCategoryID
	AND PHYSVOL.ID > 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNQRVolumeView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNQRVolMPView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNQRVolMPView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNQRVolMPView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNQRVolMPView]
GO

delete from GXDBVersions where name = 'CNQRVolMPView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNQRVolMPView', '1.1', 'CNQRVolMPView', '')
GO
CREATE VIEW
	CNQRVolMPView
WITH ENCRYPTION
AS
SELECT	QRVolumeID = VOL.ID,
	ClientID = C.ID,
	ClientName = C.Name,
	MountPointID = MP.ID,
	MountPointPath = MP.Path
FROM 	APP_Client AS C,
	QRVolume AS VOL,
	(
		SELECT	DN1.*
		FROM	QRPhysicalDevice AS DN1
		WHERE ID = (SELECT TOP 1 ID
				FROM 	QRPhysicalDevice AS DN2
				WHERE	DN2.ClientID = DN1.ClientID
					AND DN2.SNRVolumeID = DN1.SNRVolumeID
				ORDER BY DN2.ID DESC)
	) AS DN,
	QRMountPoint AS MP
WHERE	DN.SNRVolumeID = VOL.ID
	AND DN.ClientID = C.ID
	AND MP.DeviceNameID = DN.ID
	AND (MP.Flags & 0x01 <> 0x01)
	AND VOL.ID <> 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNQRVolMPView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMPCapacityView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMPCapacityView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMPCapacityView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMPCapacityView]
GO

delete from GXDBVersions where name = 'CNMMMPCapacityView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMPCapacityView', '1.1', 'CNMMMPCapacityView', '')
GO
CREATE VIEW
	CNMMMPCapacityView
WITH ENCRYPTION
AS
SELECT
MP.MountPathId		as MountPathID,
(SELECT FreeBytesMB FROM	MMMediaSide WHERE MediaSideId = MP.MediaSideId
)				as FreeSpace,
MP.MaxDataToWriteMB		as MaxSizeAllowed,
MP.MagneticSpaceRsrvInMB	as SpaceReserved
FROM
MMMountPath MP
WHERE
MP.MountPathId > 0
			-- Filter out non-magnetic Mountpaths
	AND MP.MountPathTypeId <> 3
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMPCapacityView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/MMS2getMountPathNameGUIView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: MMS2getMountPathNameGUIView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2getMountPathNameGUIView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[MMS2getMountPathNameGUIView]
GO

delete from GXDBVersions where name = 'MMS2getMountPathNameGUIView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'MMS2getMountPathNameGUIView', '1.5', 'MMS2getMountPathNameGUIView', '')
GO
CREATE VIEW
	MMS2getMountPathNameGUIView
WITH ENCRYPTION
AS
SELECT	MP.MountPathId,
		MountPathName = CASE MP.MountPathTypeId
			WHEN 1 /* MOUNT_PATH_CENTERA */
			THEN ISNULL(
					(SELECT TOP 1 A.FriendlyName
						FROM MMCenteraInfo A INNER JOIN MMMountPathToStorageDevice B
						ON A.CenteraId = B.CenteraId
						WHERE B.MountPathId = MP.MountPathId),
					'Unavailable')
			ELSE ISNULL((
				SELECT DISTINCT CASE
					WHEN (MP.MountPathTypeId in ( 4 /* MOUNT_PATH_SHARED_STATIC */,
													5 /* MOUNT_PATH_SHARED_REPLICA */,
													7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST */ )
							AND MPDC.numController = 1)
					THEN MMDC.Folder
					ELSE MP.MountPathName
					END
				FROM
					( SELECT a.MountPathId, a.DeviceId, COUNT(b.DeviceControllerId) as numController
						FROM	MMMountPathToStorageDevice a,
								MMDeviceController b
						WHERE	a.DeviceId = b.DeviceId
						GROUP BY a.MountPathId, a.DeviceId
					) as MPDC,
					MMDeviceController MMDC
				WHERE	MPDC.MountPathId = MP.MountPathId
				AND MPDC.DeviceId = MMDC.DeviceId ), MP.MountPathName )
			END,
		MediaId = ISNULL((SELECT TOP 1 MediaId FROM MMMediaSide WHERE MediaSideId = MP.MediaSideId), 0) ,
		DeviceId = ISNULL((SELECT TOP 1 DeviceId FROM MMMountPathToStorageDevice WHERE MountPathId = MP.MountPathId), 0),
		CenteraId = ISNULL((SELECT TOP 1 CenteraId FROM MMMountPathToStorageDevice WHERE MountPathId = MP.MountPathId), 0),
		MP.MediaSideId, MP.UserName, MP.UserPassword, MP.IsEnabled, MP.NumberOfWriters, MP.MaxConcurrentWriters, MP.CurrentFileMarker,
		MP.IsOffline, MP.OfflineReason, MP.MountPathTypeId, MP.OffLineTimeStamp, MP.origCCcommCellID, MP.origCCmediaSideID,
		MP.MaxDataToWriteMB, MP.MagneticSpaceRsrvInMB, MP.Attribute, MP.MasterPoolId, MP.LibraryId, MP.RMStatus, MP.RMStatusUpdateTime,
		MP.OrigCCMountPathId, MP.MagneticChunkFileIncrSizeMB, MP.MountPathOfflineReasonEventId
FROM	MMMountPath MP
WHERE	MP.MountPathId > 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [MMS2getMountPathNameGUIView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMountPathView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMountPathView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMountPathView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMountPathView]
GO

delete from GXDBVersions where name = 'CNMMMountPathView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMountPathView', '1.6', 'CNMMMountPathView', '')
GO
CREATE VIEW
	CNMMMountPathView
WITH ENCRYPTION
AS
SELECT
MP.LibraryID		as LibraryID,
MP.MountPathId		as MountPathID,
MP.MountPathTypeId	as MountPathTypeID,
MPV.MountPathName	as MountPathName,
MP.IsEnabled		as Enabled,
MP.IsOffline		as Offline,
MP.OffLineTimeStamp	as OfflineTime,
MP.OfflineReason	as OfflineReason,
(CASE WHEN (FreeSpace - SpaceReserved) > 0 THEN FreeSpace - SpaceReserved ELSE 0 END)
				as CapacityAvailable,
MP.MaxDataToWriteMB		as MaxSizeAllowed,
MP.MagneticSpaceRsrvInMB	as SpaceReserved,
MP.MountPathOfflineReasonEventID	as OfflineReasonEventID
FROM
MMMountPath MP, CNMMMPCapacityView MPCapacity, MMS2getMountPathNameGUIView MPV
WHERE
MP.MountPathId > 0
			-- Filter out non-magnetic Mountpaths
	AND MP.MountPathTypeId <> 3
	AND MP.MountPathId = MPCapacity.MountPathId
	AND MP.MountPathId = MPV.MountPathId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMountPathView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNRepPairInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNRepPairInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNRepPairInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNRepPairInfoView]
GO

delete from GXDBVersions where name = 'CNRepPairInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNRepPairInfoView', '1.1', 'CNRepPairInfoView', '')
GO
CREATE VIEW
	CNRepPairInfoView
WITH ENCRYPTION
AS
SELECT
ClientID = A.ClientID,
AppTypeID = A.AppTypeID,
InstanceID = A.Instance,
RepSetID = A.BackupSet,
RepPairID = A.ID,
State = ISNULL((SELECT TOP 1 intVal FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 1
	 ORDER BY SRP.Modified DESC
	), 0),
SrcPath = ISNULL((SELECT TOP 1 stringVal FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 10001
	 ORDER BY SRP.Modified DESC
	), ' '),
DestPath = ISNULL((SELECT TOP 1 stringVal FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 10002
	 ORDER BY SRP.Modified DESC
	), ' '),
AppList = ISNULL((SELECT TOP 1 REPLACE(REPLACE(stringVal, CHAR(9), ','), CHAR(0x15), ' ') FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 10003
	 ORDER BY SRP.Modified DESC
	), ' '),
CurrentFilePath = ISNULL((SELECT TOP 1 stringVal FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 10005
	 ORDER BY SRP.Modified DESC
	), ' '),
InitFileDataXfer = ISNULL((SELECT TOP 1 CAST(stringVal AS BIGINT) FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 104
	 ORDER BY SRP.Modified DESC
	), 0),
InitFileDataXferred = ISNULL((SELECT TOP 1 CAST(stringVal AS BIGINT) FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 105
	 ORDER BY SRP.Modified DESC
	), 0),
TotalDataXfer = (ISNULL((SELECT TOP 1 intVal FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 108
	 ORDER BY SRP.Modified DESC
	), 0))
	+ (ISNULL((SELECT TOP 1 CAST(stringVal AS BIGINT) FROM APP_scReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 105
	 ORDER BY SRP.Modified DESC
	), 0)),
StartTime = ISNULL((SELECT TOP 1 dbo.GetDateTime(ISNULL(intVal, 0)) FROM APP_scReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 4
	 ORDER BY SRP.Modified DESC
	), dbo.GetDateTime(0)) ,
Modified = ISNULL((SELECT TOP 1 dbo.GetDateTime(ISNULL(cast(Modified as INTEGER), 0)) FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	 ORDER BY SRP.Modified DESC
	), dbo.GetDateTime(0)),
JobID = NULL,
Unverifiable = NULL,
CurrentAttemptNum = NULL,
CurrentPhaseNum = NULL
FROM	APP_Application A, LicUsage L
	WHERE 	A.AppTypeID IN (84, 107)
	AND	((A.subclientStatus & 0x0010) <> 0x0010)	-- Not Dummy
	AND	((A.subclientStatus & 0x0020) <> 0x0020)	-- Not Hidden
	/* MR# 74039: we do not want updates from CommCell for the pairs that were either deleted or uninstalled */
	AND	((A.subclientStatus & 0x02) = 0 )
	AND	((A.subclientStatus & 0x04) = 0 )
    AND A.clientId = L.CId
	AND A.AppTypeID = L.AppType
	AND (L.ReleaseID < 12 OR
	     A.id NOT IN (SELECT	PairID FROM RunningCDRJobs))
UNION ALL
SELECT
ClientID = A.ClientID,
AppTypeID = A.AppTypeID,
InstanceID = A.Instance,
RepSetID = A.BackupSet,
RepPairID = A.ID,
State = ISNULL((currentStatus), 0),
SrcPath = ISNULL(SourcePath, ' '),
DestPath = ISNULL(DestinationPath, ' '),
AppList = ISNULL((SELECT TOP 1 REPLACE(REPLACE(stringVal, CHAR(9), ','), CHAR(0x15), ' ') FROM APP_ScReplicationPair SRP
	 WHERE A.id = SRP.pairId
	       AND SRP.propType = 10003
	 ORDER BY SRP.Modified DESC
	), ' '),
CurrentFilePath = ISNULL(currentFileBeingTransfered, ' '),
InitFileDataXfer = ISNULL(filesToTransfer, 0),
InitFileDataXferred = ISNULL(filesTransfered, 0),
TotalDataXfer = ISNULL(bytesTransfered, 0) + ISNULL(bytesReplicated, 0),
StartTime = dbo.GetDateTime(ISNULL(replicationStartTime, 0)) ,
Modified = ISNULL(dbo.GetDateTime((CASE WHEN (LastStateChangeTime < ClientStatusChangeTime) THEN ClientStatusChangeTime ELSE LastStateChangeTime END)),
			dbo.GetDateTime(0)),
JobID = JobID,
Unverifiable = unverifiable,
CurrentAttemptNum = currentAttempt,
CurrentPhaseNum = currentPhase
FROM	APP_Application A, RunningCDRJobs J
	WHERE 	A.AppTypeID IN (84, 107)
	AND	((A.subclientStatus & 0x0010) <> 0x0010)	-- Not Dummy
	AND	((A.subclientStatus & 0x0020) <> 0x0020)	-- Not Hidden
	/* MR# 74039: we do not want updates from CommCell for the pairs that were either deleted or uninstalled */
	AND	((A.subclientStatus & 0x02) = 0 )
	AND	((A.subclientStatus & 0x04) = 0 )
    AND A.id = J.pairId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNRepPairInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNRepSetInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNRepSetInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNRepSetInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNRepSetInfoView]
GO

delete from GXDBVersions where name = 'CNRepSetInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNRepSetInfoView', '1.1', 'CNRepSetInfoView', '')
GO
CREATE VIEW
	CNRepSetInfoView
WITH ENCRYPTION
AS
SELECT
ClientID = A.ClientID,
AppTypeID = A.AppTypeID,
InstanceID = A.Instance,
RepSetID = BS.ID,
RepSetName = BS.Name,
Status = BS.Status,
CreatedTime = dbo.GetDateTime(BS.refTime),
ModifiedTime = dbo.GetDateTime(BS.modified),
DestHostID = ISNULL((SELECT TOP 1 cast(attrVal as INTEGER) FROM APP_BackupSetProp BSP
	 WHERE BS.id = BSP.componentNameId
	       AND BSP.attrName = 'FLR Destination HostId'
	 ORDER BY BSP.Modified DESC
	), 0),
UseBaseFolder = ISNULL((SELECT TOP 1 cast(attrVal as INTEGER) FROM APP_BackupSetProp BSP
	 WHERE BS.id = BSP.componentNameId
	       AND BSP.attrName = 'FLR Use CommonBase Folder'
	 ORDER BY BSP.Modified DESC
	), 0),
BaseFolder = ISNULL((SELECT TOP 1 attrVal FROM APP_BackupSetProp BSP
	 WHERE BS.id = BSP.componentNameId
	       AND BSP.attrName = 'FLR CommonBase Folder Name'
	 ORDER BY BSP.Modified DESC
	), ' '),
/*	TODO: Remove this column from here. This info is being calculated on the fly in QNet. Also,
	remove DataTransferred coumn from CHReplicationSet table */
TotalDataXfer = 0,
/* TODO: Remove this column from here; also remove StartTime column from CHReplicationSet table */
StartTime = dbo.GetDateTime(0),
Modified = ISNULL((SELECT TOP 1 dbo.GetDateTime(ISNULL(cast(Modified as INTEGER), 0)) FROM APP_BackupSetProp BSP
	 WHERE BS.id = BSP.componentNameId
	 ORDER BY BSP.Modified DESC
	), dbo.GetDateTime(0)),
FLROptions = ISNULL((SELECT TOP 1 cast(attrVal as INTEGER) FROM APP_BackupSetProp BSP
	 WHERE BS.id = BSP.componentNameId
	       AND BSP.attrName = 'FLR Replication Options'
	 ORDER BY BSP.Modified DESC
	), 0)
FROM   	APP_BackupSetName BS, (SELECT DISTINCT ClientID, AppTypeID, Instance, BackupSet FROM APP_Application WHERE AppTypeID IN (84, 107)) AS A
WHERE	BS.id = A.BackupSet
	AND	((BS.Status & 0x0010) <> 0x0010)			-- Not Dummy
	AND	((BS.Status & 0x0020) <> 0x0020)			-- Not Hidden
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNRepSetInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMediaInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMediaInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMediaInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMediaInfoView]
GO

delete from GXDBVersions where name = 'CNMMMediaInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMediaInfoView', '1.7', 'CNMMMediaInfoView', '')
GO
CREATE VIEW
	CNMMMediaInfoView
WITH ENCRYPTION
AS
SELECT	M.MediaID, M.BarCode, M.MediaTypeID, dbo.GetDateTime(M.CreationTime) AS CreationTime,
		(CASE WHEN ISNULL(MT.IsCleaningMedia, 0) = 1 THEN MS.TotalNumberOfMounts ELSE M.NumberOfReUses END) AS NumberOfReUses,
		dbo.GetDateTime(M.LastExportTime) AS LastExportTime,
		M.MediaLocation AS MediaLocationType,
		ISNULL((CASE M.MediaLocation WHEN 1 THEN (SELECT TOP 1 SlotName FROM MMSlot S WHERE S.MediaId = M.MediaID)
							  WHEN 2 THEN (SELECT TOP 1 AliasName FROM MMDrive D WHERE D.MediaId = M.MediaID)
							  WHEN 3 THEN EL.ExportLocation
							  ELSE '' END), '') AS MediaLocation,
		M.retentionFlags, dbo.GetDateTimeBig(M.retentionExpireTime) AS retentionExpireTime,
		M.MediaFlags, M.MediaStatusReason, M.Attributes, M.IsAged,
		L.LibraryID, L.AliasName AS LibraryName,
		MSG.SpareGroupId, MSG.SpareGroupName AS SpareGroupName,
		EL.Type AS ExportLocationType, EL.ExportLocationId, EL.ExportLocation AS ExportLocation,
		MC.ContainerId, MC.ContainerName AS ContainerName,
		dbo.GetDateTime(MS.LastRestoreTime) AS LastRestoreTime,
		dbo.GetDateTime(MS.LastBackupTime) AS LastBackupTime,
		dbo.GetDateTime(M.PinMediaExpireTime) AS PinMediaExpireTime,
		MS.TotalSpaceMB AS TotalSpaceMB,
		MS.TotalFreeSpaceMB AS TotalFreeSpaceMB,
		(MS.TotalSpaceMB - MS.TotalFreeSpaceMB) AS TotalCVDataSizeMB,
		ISNULL(AR.ArchGroupID, 1) AS ArchGroupID, ISNULL(AR.ArchGroupCopyId, 0) AS ArchGroupCopyId,
		(CASE --WHEN (LastWriteLibraryId > 0 AND M.LibraryID <> M.LastWriteLibraryId) THEN -1
			  WHEN (M.SpareGroupID > 0 AND M.IsInMediaGroup = 0) THEN MSG.SpareGroupType
		      ELSE 0 END) AS GroupType,
		ISNULL(V.MediaStatus, 0) AS MediaStatus,
		ISNULL(M.LastWriteLibraryID, 0) AS LastWriteLibraryID,
		ISNULL(M.IsInMediaGroup, 0) AS IsInMediaGroup,
		ISNULL(MS.TotalNumberOfSoftErrors, 0) AS TotalNumberOfSoftErrors,
		ISNULL(MS.TotalNumberOfHardErrors, 0) AS TotalNumberOfHardErrors,
		ISNULL(M.Descript, '' ) AS [Description],
		ISNULL(M.origCCCommCellId, 2) AS origCCCommCellId
FROM	MMMedia M LEFT OUTER JOIN MMLibrary L ON M.LibraryID = L.LibraryID
				  LEFT OUTER JOIN MMMediaType MT ON M.MediaTypeId = MT.MediaTypeId
				  LEFT OUTER JOIN MMSpareGroup MSG ON M.SpareGroupId = MSG.SpareGroupId
				  LEFT OUTER JOIN MMExportLocation EL ON M.ExportLocationId = EL.ExportLocationId
				  LEFT OUTER JOIN MMContainer MC ON M.ContainerId = MC.ContainerId
				  LEFT OUTER JOIN (SELECT	MediaID,
											MAX(LastRestoreTime) AS LastRestoreTime,
											MAX(LastBackupTime) AS LastBackupTime,
											SUM(TotalSpaceMB) AS TotalSpaceMB,
											SUM(FreeBytesMB) AS TotalFreeSpaceMB,
											SUM(NumberOfMounts) AS TotalNumberOfMounts,
											SUM(NumberOfSoftErrors) AS TotalNumberOfSoftErrors,
											SUM(NumberOfHardErrors) AS TotalNumberOfHardErrors
									FROM	MMMediaSide
									GROUP BY MediaID) MS ON M.MediaID = MS.MediaID
				  LEFT OUTER JOIN ( SELECT	DISTINCT MV.MediaID, MV.MediaGroupID, ArchGroupID, ArchGroupCopyId
									FROM	(SELECT	MediaID, MAX(MediaGroupID) AS MediaGroupID
											FROM MMVolume
											WHERE MediaGroupID > 0
											GROUP BY MediaID) MV, ArchStream A
									WHERE	MV.MediaGroupID = A.MediaGroupID) AR ON M.MediaID = AR.MediaID
				  LEFT OUTER JOIN ( SELECT	MediaID,
				  					MIN(case VolumeFlags when 4 then 1 when 3 then 2 when 1 then 3 when 7 then 4
				  						when 2 then 5 when 5 then 6 else 0 end) AS MediaStatus
				  					FROM	MMVolume
				  					WHERE	RecordingFormatId <> 10001
				  					GROUP BY MediaID
				  					UNION
				  					SELECT	MediaID, (CASE isOffline WHEN 1 THEN 5 ELSE 3 END)
				  					FROM	MMMountPath MP, MMMediaSide MS
				  					WHERE	MP.MediaSideID = MS.MediaSideID) V	ON M.MediaID = V.MediaID
WHERE	M.MediaID > 0
		AND M.MediaTypeID <> 10001
UNION
SELECT	M.MediaID, 'Magnetic', M.MediaTypeID, dbo.GetDateTime(M.CreationTime) AS CreationTime,
		M.NumberOfReUses AS NumberOfReUses,
		dbo.GetDateTime(M.LastExportTime) AS LastExportTime,
		M.MediaLocation AS MediaLocationType,
		ISNULL((CASE MP.MountPathTypeId				--MR# 54340
			WHEN 1 THEN								--An EDC discovered library exist for which no mount path is associated.
				(SELECT	FriendlyName
				 FROM	MMCenteraInfo CI, MMMountPathToStorageDevice SD
				 WHERE CI.CenteraId=SD.CenteraId and SD.MountPathId=MP.MountPathId)
			ELSE MP.MountPathName END), '') AS MediaLocation,
		M.retentionFlags, dbo.GetDateTimeBig(M.retentionExpireTime) AS retentionExpireTime,
		M.MediaFlags, M.MediaStatusReason, M.Attributes, M.IsAged,
		L.LibraryID, L.AliasName AS LibraryName,
		0 AS SpareGroupId, 'N/A' AS SpareGroupName,
		1 AS ExportLocationType, 0 AS ExportLocationId, 'Not Available' AS ExportLocation,
		0 AS ContainerId, 'Dummy' AS ContainerName,
		dbo.GetDateTime(MS.LastRestoreTime) AS LastRestoreTime,
		dbo.GetDateTime(MS.LastBackupTime) AS LastBackupTime,
		dbo.GetDateTime(M.PinMediaExpireTime) AS PinMediaExpireTime,
		MS.TotalSpaceMB AS TotalSpaceMB,
		MS.FreeBytesMB  AS TotalFreeSpaceMB,
		ISNULL(AR.CVDataSizeMB, 0) AS TotalCVDataSizeMB,
		ISNULL(AR.ArchGroupID, 1) AS ArchGroupID, ISNULL(AR.ArchGroupCopyId, 0) AS ArchGroupCopyId,
		0 AS GroupType,
		ISNULL((CASE MP.isOffline WHEN 1 THEN 5 ELSE 3 END), 0) AS MediaStatus,
		ISNULL(M.LastWriteLibraryID, 0) AS LastWriteLibraryID,
		ISNULL(M.IsInMediaGroup, 0) AS IsInMediaGroup,
		ISNULL(MS.NumberOfSoftErrors, 0) AS TotalNumberOfSoftErrors,
		ISNULL(MS.NumberOfHardErrors, 0) AS TotalNumberOfHardErrors,
		ISNULL(M.Descript, '' ) AS [Description],
		ISNULL(M.origCCCommCellId, 2) AS origCCCommCellId
FROM	MMMedia M
		INNER JOIN MMLibrary L ON M.LibraryID = L.LibraryID
		INNER JOIN MMMediaSide MS ON M.MediaID = MS.MediaID
		INNER JOIN MMMountPath MP ON MS.MediaSideID = MP.MediaSideID
		LEFT OUTER JOIN (SELECT	DISTINCT MV.MediaID, MV.MediaGroupID, ArchGroupID, ArchGroupCopyId, MV.CVDataSizeMB
						FROM	(SELECT	MediaID, MAX(MediaGroupID) AS MediaGroupID, SUM(PhysicalBytesMB) AS CVDataSizeMB
								FROM MMVolume
								WHERE MediaGroupID > 0
								GROUP BY MediaID) MV, ArchStream A
						WHERE	MV.MediaGroupID = A.MediaGroupID ) AR ON M.MediaID = AR.MediaID
WHERE	M.MediaID > 0
		AND M.MediaTypeID = 10001
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMediaInfoView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMVTActionView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMVTActionView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMVTActionView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMVTActionView]
GO

delete from GXDBVersions where name = 'CNMMVTActionView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMVTActionView', '1.2', 'CNMMVTActionView', '')
GO
CREATE VIEW
	CNMMVTActionView
WITH ENCRYPTION
AS
SELECT	VA.ActionID AS ActionID,
		ISNULL(VP.PolicyID, 0) AS PolicyID,
		ISNULL(VP.PolicyName, '') AS PolicyName,
		VA.UserId AS UserId,
		ISNULL(U.Login,'') AS UserName,
		VA.JobID_L AS JobID,
		S.LocType AS SrcLocType,
		S.Value AS SrcLocationID,
		ISNULL(S.LocationName,'') AS SrcLocation,
		T.LocType AS TransLocType,
		T.Value AS TransLocationID,
		ISNULL(T.LocationName,'') AS Transit,
		D.LocType AS DestLocType,
		D.Value AS DestLocationID,
		ISNULL(D.LocationName,'') AS DestLocation,
		VA.StartTime AS StartTime,
		ISNULL(MC.ContainerName,'') AS ContainerName,
		VA.ActionType AS ActionType,
		VA.ActionState AS ActionState,
		VA.ActionQuitTime AS ActionQuitTime,
		ISNULL(MSG.SpareGroupId, 0) AS SpareGroupId,
		ISNULL(MSG.SpareGroupName,'') AS SpareGroupName
FROM	VTAction VA
		LEFT OUTER JOIN VTPolicy VP ON VA.PolicyId = VP.PolicyId
		LEFT OUTER JOIN UMUsers U ON VA.UserID = U.id
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.Type = 1 AND VT.VALUE = 0 THEN 'Inside Library'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName
																WHEN VT.Type = 4 AND VT.VALUE = 0 THEN 'At virtual mailslots'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName + ' virtual mailslots'
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.VALUE = 0 THEN 'Outside'
																 ELSE EL.ExportLocation
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) S ON VA.SourceId = S.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.Type = 1 AND VT.VALUE = 0 THEN 'Inside Library'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName
																WHEN VT.Type = 4 AND VT.VALUE = 0 THEN 'At virtual mailslots'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName + ' virtual mailslots'
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.VALUE = 0 THEN 'Outside'
																 ELSE EL.ExportLocation
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) T ON VA.InTransitId = T.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.Type = 1 AND VT.VALUE = 0 THEN 'Inside Library'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName
																WHEN VT.Type = 4 AND VT.VALUE = 0 THEN 'At virtual mailslots'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName + ' virtual mailslots'
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.VALUE = 0 THEN 'Outside'
																 ELSE EL.ExportLocation
															END) AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) D ON VA.DestinationId = D.LocationID
		LEFT OUTER JOIN MMContainer MC ON VA.ContainerId = MC.ContainerId
		LEFT OUTER JOIN MMSpareGroup MSG ON (CASE VA.SpareGroupId WHEN -1 THEN 0 ELSE VA.SpareGroupID END)= MSG.SpareGroupId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMVTActionView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMVTHistoryView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMVTHistoryView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMVTHistoryView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMVTHistoryView]
GO

delete from GXDBVersions where name = 'CNMMVTHistoryView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMVTHistoryView', '1.2', 'CNMMVTHistoryView', '')
GO
CREATE VIEW
	CNMMVTHistoryView
WITH ENCRYPTION
AS
SELECT	VH.HistoryID AS HistoryID,
		VH.ActionID AS ActionID,
		ISNULL(VP.PolicyID, 0) AS PolicyID,
		ISNULL(VP.PolicyName, '') AS PolicyName,
		VH.JobID_L AS JobID,
		VH.UserId AS UserID,
		ISNULL(VH.UserName,'') AS UserName,
		VH.MediaId AS MediaID,
		VH.BarCode AS BarCode,
		ISNULL(S.LocType, 0) AS SrcLocType,
		ISNULL(S.Value, 0) AS SrcLocationID,
		ISNULL(S.LocationName,'') AS SrcLocation,
		ISNULL(T.LocType, 0) AS TransLocType,
		ISNULL(T.Value, 0) AS TransLocationID,
		ISNULL(T.LocationName,'') AS Transit,
		ISNULL(D.LocType, 0) AS DestLocType,
		ISNULL(D.Value, 0) AS DestLocationID,
		ISNULL(D.LocationName,'') AS DestLocation,
		VH.State AS State,
		VH.StartTime AS StartTime,
		VH.EndTime AS EndTime,
		VH.ExportError AS ExportError,
		VH.DueBackTime AS DueBackTime,
		VH.ActionType AS ActionType
FROM	VTHistory VH
		LEFT OUTER JOIN VTPolicy VP ON VH.PolicyId = VP.PolicyId
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) S ON VH.SourceId = S.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) T ON VH.InTransitId = T.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) D ON VH.DestinationId = D.LocationID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMVTHistoryView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMVTActionMediaView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMVTActionMediaView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMVTActionMediaView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMVTActionMediaView]
GO

delete from GXDBVersions where name = 'CNMMVTActionMediaView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMVTActionMediaView', '1.3', 'CNMMVTActionMediaView', '')
GO
CREATE VIEW
	CNMMVTActionMediaView
WITH ENCRYPTION
AS
SELECT	VTM.ActionID AS ActionID,
		VTM.MediaID AS MediaID,
		M.BarCode AS BarCode,
		VTM.State AS State,
		VTM.Flag AS Flag,
		VTM.Operation AS Operation,
		VTM.OperationState AS OperationState,
		VTM.TimeStamp AS TimeStamp,
		VTM.ExportError AS ExportError,
		VTM.DueBackTime AS DueBackTime,
		S.LocationID AS CurLocationID,
		S.LocType AS CurLocType,
		S.LocationName +
			(CASE WHEN SL.SlotID IS NOT NULL AND (S.LocType = 1 OR S.LocType = 4) THEN '( ' + SL.SlotName + ' )'
				 WHEN D.DriveID IS NOT NULL AND (S.LocType = 1) THEN '( ' + D.DriveName + ' )'
				 ELSE ''
			END)
				  AS CurLocation,
		MC.ContainerId, MC.ContainerName AS ContainerName
FROM	VTActionMedia VTM
		LEFT OUTER JOIN
					(SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.Type = 1 AND VT.VALUE = 0 THEN 'Inside Library'
                                                                WHEN VT.Type = 1 AND VT.VALUE <> 0 THEN L.AliasName
															   WHEN VT.Type = 4 AND VT.VALUE = 0 THEN 'At virtual mailslots'
                                                              WHEN VT.Type = 4 AND VT.VALUE <> 0 THEN L.AliasName + ' virtual mailslots'
																END) AS LocationName
					FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
					WHERE	VT.Type = 1 OR VT.Type = 4
					UNION
					SELECT	VT.LocationID, VT.Type AS LocType, (CASE WHEN VT.VALUE = 0 THEN 'Not Available'
																	 ELSE EL.ExportLocation
																END) AS LocationName
					FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
					WHERE	VT.Type = 2) S ON VTM.CurrentId = S.LocationID
		LEFT OUTER JOIN (
						SELECT S1.* FROM MMSlot S1 INNER JOIN (SELECT MAX(SlotId) AS 'MaxSlotId' FROM MMSlot GROUP BY MediaId) S2
							ON S1.SlotId = S2.MaxSlotID
						) SL
			ON VTM.MediaID = SL.MediaID
		LEFT OUTER JOIN MMDrive D ON VTM.MediaID = D.MediaID,
		MMMedia M
		LEFT OUTER JOIN MMContainer MC ON M.ContainerId = MC.ContainerId
WHERE	VTM.MediaID = M.MediaID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMVTActionMediaView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/VTActionView.view] ---------- 



GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [VTActionView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMediaInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMediaInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMediaInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMediaInfo]
GO

delete from GXDBVersions where name = 'CommCellMediaInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMediaInfo', '1.11', 'CommCellMediaInfo', '')
GO
---Copyright (c) 1998  CommVault Systems, Inc.
--- Display MediaInfo
CREATE VIEW dbo.CommCellMediaInfo
AS
SELECT DISTINCT
     mediaid = t2.MediaId ,
     mediabarcode = t2.mediabarcode ,
     mediagroupid = t2.mediagroupid,
     type = t2.type,
     format = t2.format,
     sidename = t2.sidename ,
     mediaCreationTime= dbo.getDateTime(t2.creationTime),
     volumeid = t2.volumeid ,
     volumename=t2.volumename,
     blocksizeKB=t2.bsizeKB,
     totalspaceMB = t2.totalspaceMB ,
     usedspaceMB = t2.usedspaceMB,
     freespaceMB = t2.freespaceMB ,
     writenum = t2.writenum ,
     reusenum = t2.reusenum ,
     mediastatus =t2.mediastatus,
     volumestatus =t2.volumestatus,
    -- volumefullreason=t2.volumefullreason,
     'volumefullreason | volumefulljobid'=t2.volumefullreason + ' | ' +  cast(t2.volumefulljobid as varchar(2048)),
     location = t2.location,
     slotname=t2.slotname,
     drivename=t2.drivename,
     exportlocation=
     case t2.exportlocation
     when  'Not Available' then ''
     else t2.exportlocation
     end,
     lastwritetimeunixsec = t2.lastwritetimeunixsec,
     'rawlastwritetime(not adjusted with daylight saving)' = t2.rawlastwritetime,
     lastwritetime = t2.lastwritetime,
     drivepoolname = t2.drivepoolname ,
     library = t2.library ,
     storagepolicy = ARG.name,
     storagepolicycopy = ARP.name,
     retentiondays =
     case AG.retentiondays
     WHEN '-1' THEN 'unlimited'
     else convert(varchar(5), AG.retentiondays)
     end,
     fullcycles =
     case  AG.fullcycles
     when '-1' then 'unlimited'
     else  convert(varchar(5),AG.fullcycles)
     end,
     LabelErrors = t2.LabelErrors,
     ReadWriteErrors = t2.ReadWriteErrors
FROM TempCvView2 t2
LEFT JOIN ArchStream ARS ON t2.mediagroupid = ARS.mediagroupid
LEFT JOIN ArchGroup ARG ON ARS.ArchGroupId = ARG.id
LEFT JOIN ArchGroupCopy ARP ON ARS.ArchGroupCopyId = ARP.id
LEFT JOIN archAgingRule AG ON ARS.ArchGroupCopyId = AG.copyid
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellMediaInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMediaInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellLibraryReservInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellLibraryReservInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellLibraryReservInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellLibraryReservInfo]
GO

delete from GXDBVersions where name = 'CommCellLibraryReservInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellLibraryReservInfo', '1.11', 'CommCellLibraryReservInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Library Reservation Info
CREATE VIEW dbo.CommCellLibraryReservInfo
AS
SELECT distinct
 'jobId [reservId | OP]'=isnull((select (cast(RTJ.JobId_l as varchar(2048))) from MMResource R, MMResourceToJob RTJ, MMMedia M, MMVolume V where RTJ.JobId_l = JIT.jobId and R.ReservationID = RTJ.ReservationID and R.VolumeID =
		                    V.VolumeID and M.MediaID = V.MediaID and M.LibraryID = L.LibraryID and V.MediaID = D.MediaID), '') +
                                     isnull(' [' + (select (cast(RTJ.ReservationID as varchar(2048))) from MMResource R, MMResourceToJob RTJ, MMMedia M, MMVolume V where RTJ.JobId_l = JIT.jobId and R.ReservationID = RTJ.ReservationID and R.VolumeID = V.VolumeID and V.MediaID = D.MediaID and
			      V.MediaID = M.MediaID and M.LibraryID = L.LibraryID) +
                                              ' | ' + (select (case JIT.opType when 4 then 'Backup' when 5 then 'Restore' else 'Other' end) from MMResource R,
			      MMResourceToJob RTJ, MMMedia M, MMVolume V where R.ReservationID = RTJ.ReservationID and RTJ.JobId_l = JIT.jobId and R.VolumeID = V.VolumeID and V.MediaID =
			      D.MediaID and M.MediaID = V.MediaID and M.LibraryID = L.LibraryID) + ']', '') ,
'MA [status]'=C.name + ' [' +
                      case H.MmHostSoftState
                      when 1 then (case H.MmHostEnabled when 1 then 'Ready' else 'Disable' end)
                      else 'OFF' end + ']' ,
'libAlias [libName | libStatus | barcodeReaderPresent]'=L.AliasName + ' [' + L.LibraryName + ' | ' +
                      case L.LibrarySoftState when 1 then (
                               case L.LibraryEnabled when 1 then 'Enable'
                                        --(case L.LibraryBroken
                                        --when 0 then 'ON'
                                                              -- (select distinct
                                                                --   case LC.LibraryControllerSoftState
			                          -- when 1 then (
                                                                    --              case LC.LibraryControllerActive
                                                                      --            when 1 then (case LC.LibraryControllerEnabled when 1 then 'ON' else 'OFF' end)
                                                                        --          else 'OFF'
                                                                          --        end)
                                                                   --else 'OFF'
                                                                  -- end
                                                            --from MMLibraryController LC, MMLibraryToLibraryController LTLC where L.LibraryID = LTLC.LibraryID and LC.LibraryControllerID = LTLC.LibraryControllerID)
                                        --else 'OFF'
                                        --end)
                               else 'Disable'
                               end)
                      else 'OFF'
                      end
                      + case
                        when LT.LibraryTypeName ='Magnetic' then ']'
                        else ' | ' + (case
                                        when LT.LibraryTypeName in ('StandAloneTape', 'StandAloneOptical') then 'N/A]'
                                        else ( case L.BarcodeReaderPresent
                                                 when 1 then 'Y'
                                                 when 0 then 'N'
                                                 else 'N/A'
                                                 end) + ']'
                                       end)
                       end ,
'driveAlias [driveName | driveStatus]'=case
                                                            when LT.LibraryTypeName = 'Magnetic' then D.AliasName + ' [' + D.DriveName + ' | ' +
                                                                      (case D.DriveSoftState
                                                                       when 1 then (case D.DriveEnabled
                                                                                             when 1 then 'Enable'
                                                                                                      --(case D.DriveBroken when 0 then 'ON' else 'OFF' end)
                                                                                             else 'Disable'
                                                                                             end)
                                                                       else 'OFF'
                                                                       end) + ']'
                                                            else D.AliasName + ' [' + D.DriveName + ' | ' +
                                                                   (case D.DriveSoftState
                                                                    when 1 then (case D.DriveEnabled
                                                                                          when 1 then 'Enable'
                                                                                                          --(case D.DriveBroken
                                                                                                           --    when 0 then (select
                                                                                                           --                                 case DC.DriveControllerSoftState
                                                                                                           --                                 when 1 then (
                                                                                                           --                                          case DC.DriveControllerActive
                                                                                                           --                                          when 1 then (case DC.DriveControllerEnabled when 1 then 'ON' else 'OFF' end)
                                                                                                           --                                          else 'Ready'
                                                                                                           --                                          end)
                                                                                                           --                                else 'OFF'
                                                                                                           --                                end
                                                                                                           --                         from MMDriveController DC, MMDriveToDriveController DTDC where D.DriveID = DTDC.DriveID and DC.DriveControllerID =
			                                                                   --                         DTDC.DriveControllerID)
                                                                                                           --   else 'OFF'
                                                                                                           --   end)
                                                                                         else 'Disable'
                                                                                         end)
                                                                  else 'OFF'
                                                                  end) + ']'
                                                          end ,
'driveMountStatus [numMount | numBackup | numRestore]'=case
                                                                                                 when LT.LibraryTypeName ='Magnetic' then ''
                                                                                                 else
                                                                                                         case D.MountStatus
                                                                                                         when 0 then 'Empty'
                                                                                                         when 1 then 'Mounted'
                                                                                                         when 2 then 'Mounting'
                                                                                                         when 3 then 'Unmounting'
                                                                                                         when 4 then 'Stuck'
			                                                                 else ''
                                                                                                         end
                                                                                                          + ' [' + cast(D.NumMountsLifeTime as varchar(2048)) + ' | ' + cast(D.NumBackupsLifeTime / 2 as varchar(2048)) + ' | ' + cast(D.NumRestoresLifeTime as varchar(2048)) + ']'
			                                                       end ,
'barcode | type' =(select M.BarCode from MMMedia M where D.MediaId = M.MediaId) + ' | ' +
                            (select MT.MediaTypeName from MMMedia M, MMMediaType MT where D.MediaID = M.MediaID and M.MediaTypeID = MT.MediaTypeID) ,
 elapsed =isnull(
                       ((select cast(datepart(hh, getDate() - (select dbo.UTCToLocalTime(dbo.GetDateTime(JIT.attemptStartTime), 'Eastern Standard Time'))) as varchar(2048)) from  MMResource R,
				MMResourceToJob RTJ, MMMedia M, MMVolume V where R.ReservationID = RTJ.ReservationID and RTJ.JobId_l = JIT.jobId and R.VolumeID = V.VolumeID and
		V.MediaID = D.MediaID and M.MediaID = V.MediaID and M.LibraryID = L.LibraryID) + ':' +
                        (select cast(datepart(mi, getDate() - (select dbo.UTCToLocalTime(dbo.GetDateTime (JIT.attemptStartTime), 'Eastern Standard Time'))) as varchar(2048)) from MMResource R,
				 MMResourceToJob RTJ, MMMedia M, MMVolume V where
	           R.ReservationID = RTJ.ReservationID and RTJ.JobId_l = JIT.jobId and R.VolumeID = V.VolumeID and V.MediaID = D.MediaID and M.MediaID = V.MediaID and M.LibraryID = L.LibraryID) + ':' +
                        (select cast(datepart(ss, getDate() - (select dbo.UTCToLocalTime(dbo.GetDateTime(JIT.attemptStartTime), 'Eastern Standard Time'))) as varchar(2048)) from  MMResource R,
				MMResourceToJob RTJ, MMMedia M, MMVolume V where R.ReservationID = RTJ.ReservationID and RTJ.JobId_l = JIT.jobId and R.VolumeID = V.VolumeID and
	              V.MediaID = D.MediaID and M.MediaID = V.MediaID and M.LibraryID = L.LibraryID))
                 ,'')
from 		JMJobInfo JIT,
		APP_Client C,
		MMDrive D,
		MMHost H,
		MMDrivePool HTDP,
		MMLibrary L,
		MMLibraryType LT,
		MMMasterPool MP
where 		MP.LibraryId = L.LibraryId
		and MP.MasterPoolId = D.MasterPoolId
		and LT.LibraryTypeId = L.LibraryTypeID
		and C.id = H.ClientId
		and H.ClientId = HTDP.ClientId
		and MP.MasterPoolId = HTDP.MasterPoolId
                and C.id != 1
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellLibraryReservInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellLibraryReservInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellLicense.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellLicense"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellLicense]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellLicense]
GO

delete from GXDBVersions where name = 'CommCellLicense' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellLicense', '1.12', 'CommCellLicense', '')
GO
 ---Copyright (c) 1998  CommVault Systems, Inc.
 --- Display CommCell License Info
CREATE VIEW CommCellLicense AS
SELECT distinct
licenseid = SL.id,
license = SL.short_name,
permanentLicenseUsed = (select count(*) from
				   	   (select distinct L.LicType as lid, C.id as cid
			            from licUsage L JOIN APP_Client C ON L.CId = C.id
			            where  L.LicType < 16777216 and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0
					    and L.Eval = 0 and L.LicType = LU.LicType) as T),
evaluationLicenseUsed = (select count(*) from
						(select distinct L.LicType as lid, C.id as cid
						 from licUsage L JOIN APP_Client C ON L.CId = C.id
						 where  L.LicType < 16777216 and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0
						 and L.Eval = 1 and L.LicType = LU.LicType) as T),
clientGroup = isnull(G.name, 'N/A'),
client = isnull(C.name, 'N/A'),
installTime = isnull(convert(varchar, dbo.GetDateTime(MT.maxTime), 0), 'N/A'),
expiryTime = (case LU.Eval when 1 then convert(varchar, dbo.GetDateTime(expTime), 0) else 'N/A' end),
OSName = dbo.getClientOSName(C.id, NULL)--isnull(OS.name,'N/A')
FROM  (SELECT	LicType, cid, appType, eval, expTime=dbo.getUnixTime(expiryDateUTC)
       FROM		licUsage L JOIN APP_Client C ON L.CId = C.id
       WHERE	L.LicType < 16777216 AND LicType not in (10, 26, 71) and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0) LU
      JOIN APP_Client C ON LU.CId = C.id
      JOIN SimLicApptypeV2 SL ON SL.id = LU.LicType
	  LEFT OUTER JOIN dbo.APP_ClientGroupAssoc A ON  A.clientId = C.id
      LEFT OUTER JOIN dbo.APP_ClientGroup G ON A.clientGroupId = G.id ,
--    SimSystemOS	S,
--	  SimOS	OS,
	  (SELECT	LicType , CId, appType, Max(dbo.getUnixTime(opTimeUTC)) as maxTime
	   FROM	    licUsage
       WHERE	opType = 'Install' AND installFlag = 0
       GROUP BY  LicType, CId, appType) AS MT
WHERE  --C.simSystemOSId	= S.id AND S.simOSId = OS.id
	   MT.LicType = LU.LicType AND MT.CId = LU.CId AND MT.appType = LU.appType
UNION ALL
SELECT distinct
licenseid = ML.LibraryLicenseType,
license = SLT.short_name + '(' + ML.Libraryname + ')',
permanentLicenseUsed = (select count(*) from
				   	   (select distinct L.LicType as lid, C.id as cid
			            from licUsage L JOIN APP_Client C ON L.CId = C.id
			            where  L.LicType < 16777216 and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0
					    and L.Eval = 0 and L.LicType = LU.LicType) as T),
evaluationLicenseUsed = (select count(*) from
						(select distinct L.LicType as lid, C.id as cid
						 from licUsage L JOIN APP_Client C ON L.CId = C.id
						 where  L.LicType < 16777216 and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0
						 and L.Eval = 1 and L.LicType = LU.LicType) as T),
clientGroup = isnull(G.name, 'N/A'),
client = C.name,
installTime = isnull(convert(varchar, dbo.GetDateTime(MT.maxTime), 0), 'N/A'),
expiryTime = (case LU.Eval when 1 then convert(varchar, dbo.GetDateTime(expTime), 0) else 'N/A' end),
OSName = dbo.getClientOSName(C.id, NULL)--isnull(OS.name,'N/A')
FROM
   dbo.MMLibraryController MLC
   JOIN dbo.APP_Client  C ON MLC.clientid = C.id
   JOIN MMLibrary ML ON MLC.LibraryId=ML.LibraryId
   JOIN dbo.MMLibraryType MLT ON ML.LibraryTypeId=MLT.LibraryTypeId and MLT.LibraryTypeName != 'Magnetic'
   JOIN simLicAppTypeV2 SLT ON SLT.id=ML.LibraryLicenseType
   JOIN
   (SELECT	LicType, cid, appType, eval, expTime=dbo.getUnixTime(expiryDateUTC)
    FROM	licUsage L JOIN APP_Client C ON L.CId = C.id
    WHERE	L.LicType < 16777216 and L.releaseId > 6 and L.OpType = 'Install' and installFlag = 0) LU
   ON LU.CId = ML.LibraryId AND SLT.id = LU.LicType
   LEFT OUTER JOIN dbo.APP_ClientGroupAssoc A ON  A.clientId = C.id
   LEFT OUTER JOIN dbo.APP_ClientGroup G ON A.clientGroupId = G.id ,
--   SimSystemOS	S,
--   SimOS	OS,
  (SELECT	LicType , CId, appType, Max(dbo.getUnixTime(opTimeUTC))as maxTime
   FROM	    licUsage
   WHERE	opType = 'Install' AND installFlag = 0
   GROUP BY  LicType, CId, appType) AS MT
	WHERE --C.simSystemOSId	= S.id AND S.simOSId = OS.id
	      MT.LicType = LU.LicType AND MT.CId = LU.CId AND MT.appType = LU.appType AND
	      C.id != 1 and MLC.LibraryControllerSoftState!=0 and MLC.LibraryControllerActive!=0
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellLicense]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellLicense]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellMediaInDrives.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellMediaInDrives"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellMediaInDrives]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellMediaInDrives]
GO

delete from GXDBVersions where name = 'CommcellMediaInDrives' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellMediaInDrives', '1.6', 'CommcellMediaInDrives', '')
GO
---Copyright (c) 2007  CommVault Systems, Inc.
CREATE VIEW CommcellMediaInDrives
AS
SELECT
L.AliasName AS LibraryName,
D.AliasName AS DriveName,
C.name AS MediaAgent,
D.DriveOccupied,
CASE D.MountStatus
WHEN 0 THEN ''
WHEN 1 THEN 'Mounted'
WHEN 2 THEN 'Mounting'
WHEN 3 THEN 'Unmounting'
WHEN 4 THEN 'Unusable'
ELSE 'Undefined' END AS MountStatus,
(case when M.MediaId > 0 then M.BarCode else '' end) AS BarCode,
(dbo.MMS2FUNC_GetGUIMediaAttributeString(dbo.MMS2FUNC_GetGUIMediaAttribute(M.MediaId))) AS MediaAttributes,
(case when MS.SpareGroupId > 0 then MS.SpareGroupName else '' end) as SpareGroupName,
isnull(AG.name, '') as StoragePolicyName,
isnull(AGC.name, '') as CopyName,
dbo.MMS2FUNC_DecodeRetentionFlag(AGC.id, M.RetentionFlags) as RetentionInfo,
dbo.MMS2FUNC_GetJobsForDrive (D.DriveId) AS RunningJobs
FROM
MMDrive D
INNER JOIN
MMMasterPool MP ON MP.MasterPoolId = D.MasterPoolId
INNER JOIN
MMLibrary L ON L.LibraryId = MP.LibraryId
LEFT OUTER JOIN MMDriveController DC1 ON D.DriveId = DC1.DriveId AND DC1.DriveControllerActive = 1
LEFT OUTER JOIN
                (
                SELECT DriveId, Min(DriveControllerId) minDriveCOntrollerId FROM MMDriveController WHERE DriveControllerActive = 0 GROUP BY DriveId
                ) MinDC ON MinDC.DriveId = D.DriveId
LEFT OUTER JOIN MMDriveController DC2 ON DC2.DriveControllerId = MinDC.minDriveControllerId
INNER JOIN APP_Client C ON C.id = ISNULL(DC1.clientId, DC2.clientId)
INNER JOIN
MMMedia M ON M.MediaId = D.MediaId
INNER JOIN
MMHost MH ON MH.ClientId = ISNULL(DC1.clientId, DC2.clientId)
INNER JOIN
MMSpareGroup MS ON MS.SpareGroupId = M.SpareGroupId
LEFT OUTER JOIN
MMVolume V ON V.MediaId = M.MediaId AND V.RecordingFormatId <> 10001
LEFT OUTER JOIN
ArchStream ASt ON ASt.MediaGroupId = V.MediaGroupId
LEFT OUTER JOIN
ArchGroup AG ON AG.id = ASt.archGroupId
LEFT OUTER JOIN
ArchGroupCopy AGC ON AGC.id = ASt.archGroupCopyId
WHERE     (D.DriveId > 0) AND (MH.MmHostEnabled = 1) AND (L.LibraryEnabled = 1) AND
                      (MH.MmHostSoftState = 1)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommcellMediaInDrives]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellMediaInDrives]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellDriveInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellDriveInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellDriveInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellDriveInfo]
GO

delete from GXDBVersions where name = 'CommCellDriveInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellDriveInfo', '1.5', 'CommCellDriveInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Library Info
CREATE VIEW dbo.CommCellDriveInfo
AS
SELECT     AP.name AS MAname, ML.LibraryName AS LibName, MD.DriveName, MD.AliasName AS DriveAliasName,
                      CASE md.DriveBroken WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' END AS DriveBroken,
                      CASE md.CleaningRequired WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' END AS CleaningReqd,
                      CASE MD.DriveSoftState WHEN 1 THEN (CASE MD.DriveEnabled WHEN 1 THEN (case WHEN (MD.Attributes & 128 > 0) THEN 'Drive in Read Only Mode' WHEN (MD.Attributes & 256 = 256) THEN 'Drive in Maintenance' ELSE 'Enable' END) WHEN 0 THEN 'Disable' END) ELSE 'OFF' END AS DriveStatus,
                      CASE MD.OfflineReason WHEN 0 THEN (CASE MD.DriveEnabled WHEN 1 THEN 'Ready' ELSE 'Drive Marked as Offline' END) WHEN 1 THEN 'The drive has been marked as broken.' WHEN 2 THEN 'There is a media stuck in the drive.'
                       WHEN 3 THEN 'Drive indicates that cleaning is required.' WHEN 4 THEN 'Cannot communicate with Media Mount Manager Service.' WHEN 5 THEN 'The drive is not accessible from the Operating System.'
                       WHEN 6 THEN 'Initialization in progress.' WHEN 7 THEN 'The drive has been enabled ' WHEN 8 THEN 'The drive has been disabled ' WHEN 9 THEN 'The drive is accessible from the Operating System.'
                       WHEN 10 THEN 'The drive is not accessible from the Operating System.' ELSE 'N/A' END AS DriveOfflineReason, MD.OfflineTimeStamp
FROM         dbo.APP_Client AS AP INNER JOIN
                      dbo.MMHost AS H ON AP.id = H.ClientId INNER JOIN
                      dbo.MMDrivePool AS MDP ON H.ClientId = MDP.ClientId INNER JOIN
                      dbo.MMMasterPool AS MP ON MDP.MasterPoolId = MP.MasterPoolId INNER JOIN
                      dbo.MMDrive AS MD ON MP.MasterPoolId = MD.MasterPoolId INNER JOIN
                      dbo.MMLibrary AS ML ON MP.LibraryId = ML.LibraryId
WHERE     (AP.id <> 1)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellDriveInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellDriveInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellLibraryInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellLibraryInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellLibraryInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellLibraryInfo]
GO

delete from GXDBVersions where name = 'CommCellLibraryInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellLibraryInfo', '1.4', 'CommCellLibraryInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Library Info
CREATE VIEW dbo.CommCellLibraryInfo
AS
SELECT     ML.LibraryName AS LibName, ML.AliasName AS LibAliasName,
                      CASE ML.LibrarySoftState WHEN 1 THEN (CASE ML.LibraryEnabled WHEN 1 THEN 'Enable' ELSE 'Disable' END) ELSE 'OFF' END AS LibStatus,
                      CASE ml.LibraryBroken 	WHEN 0 THEN 'NO'
								WHEN 1 THEN 'YES' END AS LibBroken,
                      CASE LibraryStatusReason 	WHEN 46000 THEN 'Library Management service reset by user '
								WHEN 46001 THEN 'Library has been marked as Disabled'
				                        WHEN 46002 THEN ' The library has been marked as broken.'
								WHEN 46003 THEN 'Ready'
								WHEN 46004 THEN 'Library Management service is ready'
								WHEN 46005 THEN 'Library Management service is offline'
								WHEN 46006 THEN 'Library is marked offline as it is being used for an administrative activity '
								ELSE 'N/A' END AS LibStatusReason,
			ML.OfflineTimeStamp
FROM         dbo.MMMasterPool AS MP INNER JOIN
                      dbo.MMLibrary AS ML ON MP.LibraryId = ML.LibraryId INNER JOIN
                      dbo.MMDrivePool AS MDP ON MP.MasterPoolId = MDP.MasterPoolId INNER JOIN
                      dbo.APP_Client AS C INNER JOIN
                      dbo.MMHost AS H ON C.id = H.ClientId ON MDP.ClientId = H.ClientId
WHERE     (C.id <> 1)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellLibraryInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellLibraryInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMediaAgentInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMediaAgentInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMediaAgentInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMediaAgentInfo]
GO

delete from GXDBVersions where name = 'CommCellMediaAgentInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMediaAgentInfo', '1.4', 'CommCellMediaAgentInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Media Agent Info
CREATE VIEW dbo.CommCellMediaAgentInfo
AS
SELECT     C.name AS MAname, CASE H.MmHostSoftState WHEN 1 THEN (CASE H.MmHostEnabled WHEN 1 THEN 'Enable' ELSE 'Disable' END)
                      ELSE 'OFF' END AS MAStatus,
                      CASE H.offlineReason WHEN 0 THEN 'Ready' WHEN 1 THEN 'Communication Error ' WHEN 2 THEN 'Version Mismatch' WHEN 3 THEN 'disabled ' WHEN
                       4 THEN ' disabled on GracePeriod expiry' WHEN 5 THEN 'Initializing' ELSE 'N/A' END AS OfflineReason, H.OfflineTimeStamp
FROM         dbo.APP_Client AS C INNER JOIN
                      dbo.MMHost AS H ON C.id = H.ClientId
WHERE     (C.id <> 1)
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellMediaAgentInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMediaAgentInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMediaSubClient.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMediaSubClient"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMediaSubClient]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMediaSubClient]
GO

delete from GXDBVersions where name = 'CommCellMediaSubClient' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMediaSubClient', '1.4', 'CommCellMediaSubClient', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Media Sub Client Info
CREATE VIEW CommCellMediaSubClient
AS
SELECT DISTINCT
      mediaid           = M.MediaId,
      mediabarcode      = M.Barcode,
      mediagroupid      = V.MediaGroupId,
      volumeid          = V.VolumeId,
      appid             = APP.id,
      clientname        = C.name,
      idataagent        = IDA.name,
      instance          = I.name,
      backupset         = B.name,
      subclient         = APP.subclientName
FROM  archChunk   AC
JOIN  archChunkMapping ACM    ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
JOIN  archFile    AF          ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
JOIN  MMVolume    V           ON V.volumeId = AC.volumeId
JOIN  MMMedia M               ON V.MediaId = M.MediaId
JOIN  APP_Application APP     ON APP.id = AF.appId
JOIN  APP_Client C            ON C.id = APP.clientid
JOIN  APP_iDAType IDA         ON IDA.type = APP.appTypeId
JOIN  APP_InstanceName I      ON I.id = APP.instance
JOIN  APP_BackupSetName B     ON B.id = APP.backupset
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellMediaSubClient]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMediaSubClient]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellSnapInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellSnapInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellSnapInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellSnapInfo]
GO

delete from GXDBVersions where name = 'CommCellSnapInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellSnapInfo', '1.2', 'CommCellSnapInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Snap info
CREATE VIEW CommCellSnapInfo
AS
SELECT	C.id AS ClientId,
		C.name AS ClientName,
		V.JobId AS JobId,
		SN.SMSnapId AS SnapId,
		SN.UniqueIdentifier AS SnapUniqueId,
		(CASE
			WHEN V.MountStatus < 38 THEN 'Creating'
			WHEN V.MountStatus = 38 THEN 'Create Failed'
			WHEN V.MountStatus = 39 THEN 'Created'
			WHEN V.MountStatus < 58 THEN 'Mounting'
			WHEN V.MountStatus = 58 THEN 'Mount Failed'
			WHEN V.MountStatus = 59 THEN 'Mounted'
			WHEN V.MountStatus < 78 THEN 'Unmounting'
			WHEN V.MountStatus = 78 THEN 'Unmount Failed'
			WHEN V.MountStatus = 79 THEN 'Unmounted'
			WHEN V.MountStatus < 88 THEN 'Reverting'
			WHEN V.MountStatus = 88 THEN 'Revert Failed'
			WHEN V.MountStatus = 89 THEN 'Reverted'
			WHEN V.MountStatus < 98 THEN 'Deleting'
			WHEN V.MountStatus = 98 THEN 'Delete Failed'
			WHEN V.MountStatus = 99 THEN 'Deleted'
			ELSE 'Unknown'
		END) AS 'Mount Status',
		CH.ControlHostId AS FilerId,
		(CASE
			WHEN(LEN(CH.SMArrayId) > 0) THEN CH.SMArrayId
			WHEN(LEN(CH.SMHostName) > 0) THEN CH.SMHostName
			ELSE SMHostIP
		END) AS FilerName,
		SE.SnapEngineName AS EngineName,
		SN.ReserveFieldStr AS SourcePath,
		AG.id AS StoragePolicyId,
		AG.name AS StoragePolicyName,
		AGC.id AS CopyId,
		AGC.name AS CopyName,
		(CASE WHEN (AG.defaultSnapCopy = AGC.id) THEN 'Snap Primary' WHEN AGC.isMirrorCopy = 1 THEN 'Snap Mirror' ELSE 'Snap Vault' END) AS CopyType
FROM	SMSnap SN, SMVolSnapMap VSM, SMVolume V, archGroupCopy AGC, archGroup AG, APP_Client C, SMControlHost CH, SMSnapShotEngine SE
WHERE	SN.UniqueIdentifier IS NOT NULL
		AND LEN(SN.UniqueIdentifier) > 0
		AND SN.SMSnapId = VSM.SMSnapId
		AND VSM.SMVolumeId = V.SMVolumeId
		AND V.CopyId = AGC.id
		AND AGC.archGroupId = AG.id
		AND V.SourceClientId = C.id
		AND SN.ControlHostId = CH.ControlHostId
		AND SN.SnapShotEngineId = SE.SnapShotEngineId
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommCellSnapInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellSnapInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellDFMSnapJobInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellDFMSnapJobInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellDFMSnapJobInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellDFMSnapJobInfo]
GO

delete from GXDBVersions where name = 'CommcellDFMSnapJobInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellDFMSnapJobInfo', '1.3', 'CommcellDFMSnapJobInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Snap info
CREATE VIEW CommcellDFMSnapJobInfo
AS
SELECT	AuxCopyJobId = JAI.jobId,
		AuxCopyJobStatusInt = JAI.status,
		AuxCopyJobStatus =
		(CASE JAI.status
			 WHEN 1	THEN 'Running'
			 WHEN 2	THEN 'Pending'
			 WHEN 3	THEN 'Waiting'
			 WHEN 4	THEN 'Completed'
			 WHEN 5	THEN 'Suspended'
			 WHEN 6	THEN 'Kill Pending'
			 WHEN 7	THEN 'Suspend Pending'
			 WHEN 8	THEN 'Interrupt Pending'
			 WHEN 9	THEN 'Completed'
			 WHEN 10	THEN 'Failed'
			 WHEN 11	THEN 'Killed'
			 WHEN 12	THEN 'Completed w/ one or more errors'
			 WHEN 13	THEN 'System Kill Pending'
			 WHEN 14	THEN 'Suspended'
			 WHEN 15	THEN 'Queued'
			 WHEN 16	THEN 'Queued'
			 WHEN 17	THEN 'Running (Cannot be verified)'
			 WHEN 18	THEN 'Abnormal Termination'
			 WHEN 19	THEN 'Completed w/ one or more warnings'
			 ELSE ''
		END),
		--AuxCopyJobStartDateUnixSec =  JAI.servStart,
		--AuxCopyJobEndDateUnixSec = JAI.servEnd,
		AuxCopyJobStartDate = dbo.GetDateTime(JAI.servStart),
		AuxCopyJobEndDate =dbo.GetDateTime(JAI.servEnd),
		StoragePolicyId = JAI.archGrpId,
		StoragePolicyName = (SELECT TOP 1 name FROM archGroup WHERE id = JAI.archGrpID),
		StoragePolicyCopyId = SH.ArchGroupCopyId,
		StoragePolicyCopyName = (SELECT TOP 1 name FROM archGroupCopy WHERE id = SH.ArchGroupCopyId),
		DataSetId = SD.ExtDataSetId,
		DataSetName = SD.ExtDataSetName,
		DFMJobId = SH.ExtJobId,
		DFMJobStatusInt = SH.Status,
		DFMJobStatus =
			 CASE SH.status
			 WHEN 0 THEN 'Queued'
			 WHEN 1 THEN 'Canceling'
			 WHEN 2 THEN 'Cancelled'
			 WHEN 3 THEN 'Running'
			 WHEN 4 THEN 'Running With Failures'
			 WHEN 5 THEN 'Partially Failed'
			 WHEN 6 THEN 'Failed'
			 WHEN 7 THEN 'Succeded'
			 ELSE 'Unknown'
			 END,
		DFMJobFailureReason = SH.FailureReason,
		DFMJobBytesTranseffered = SH.BytesTransfered
FROM	JMAdminJobInfoTable JAI, SMExternalJobMapHist SH LEFT OUTER JOIN SMDataSet SD WITH (NOLOCK) ON SH.DataSetId = SD.DataSetId
WHERE	opType = 13
		AND JAI.jobId = SH.AuxCopyJobId
		AND SH.ExtJobID <> 0
UNION
SELECT	AuxCopyJobId = JAS.jobId,
		AuxCopyJobStatusInt = JAS.status,
		AuxCopyJobStatus =
			 CASE JAS.status
			 WHEN 1 THEN 'Success'
			 WHEN 2 THEN 'Failed'
			 WHEN 3 THEN 'PartialSuccess'
			 WHEN 4 THEN 'Killed'
			 WHEN 5 THEN 'Stopped'
			 WHEN 6 THEN 'Interrupted'
			 WHEN 9 THEN 'Failed to Start'
			 ELSE 'Unknown'
			 END,
		--AuxCopyJobStartDateUnixSec =  JAS.servStart,
		--AuxCopyJobEndDateUnixSec = JAS.servEnd,
		AuxCopyJobStartDate = dbo.GetDateTime(JAS.servStart),
		AuxCopyJobEndDate =dbo.GetDateTime(JAS.servEnd),
		StoragePolicyId = JAS.archGrpId,
		StoragePolicyName = (SELECT TOP 1 name FROM archGroup WHERE id = JAS.archGrpID),
		StoragePolicyCopyId = SH.ArchGroupCopyId,
		StoragePolicyCopyName = (SELECT TOP 1 name FROM archGroupCopy WHERE id = SH.ArchGroupCopyId),
		DataSetId = SD.ExtDataSetId,
		DataSetName = SD.ExtDataSetName,
		DFMJobId = SH.ExtJobId,
		DFMJobStatusInt = SH.Status,
		DFMJobStatus =
			 CASE SH.status
			 WHEN 0 THEN 'Queued'
			 WHEN 1 THEN 'Canceling'
			 WHEN 2 THEN 'Cancelled'
			 WHEN 3 THEN 'Running'
			 WHEN 4 THEN 'Running With Failures'
			 WHEN 5 THEN 'Partially Failed'
			 WHEN 6 THEN 'Failed'
			 WHEN 7 THEN 'Succeded'
			 ELSE 'Unknown'
			 END,
		DFMJobFailureReason = SH.FailureReason,
		DFMJobBytesTranseffered = SH.BytesTransfered
FROM	JMAdminJobStatsTable JAS, SMExternalJobMapHist SH LEFT OUTER JOIN SMDataSet SD WITH (NOLOCK) ON SH.DataSetId = SD.DataSetId
WHERE	opType = 13
		AND JAS.jobId = SH.AuxCopyJobId
		AND SH.ExtJobID <> 0
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommcellDFMSnapJobInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellDFMSnapJobInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommcellDFMSnapConfigurationInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommcellDFMSnapConfigurationInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommcellDFMSnapConfigurationInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommcellDFMSnapConfigurationInfo]
GO

delete from GXDBVersions where name = 'CommcellDFMSnapConfigurationInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommcellDFMSnapConfigurationInfo', '1.3', 'CommcellDFMSnapConfigurationInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Snap info
CREATE VIEW CommcellDFMSnapConfigurationInfo
AS
SELECT	ClientId = A.clientId,
		ClientName = (SELECT name FROM APP_Client WHERE id = A.clientId),
		ApptypeId = A.appTypeId,
		AppType = (SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
		InstanceId = A.instance,
		InstanceName = (SELECT name FROM APP_InstanceName WHERE id = A.instance),
		BackupSetId = A.backupSet,
		BackupSetName = (SELECT name FROM APP_BackupSetName WHERE id = A.backupSet),
		SubClientId = A.id,
		subclientName = A.subclientName,
		-- StorageService = 'CV_StoragePolicy' + CAST(C.archGroupId AS NVARCHAR(4)) + '_Copy' + CAST((SELECT MIN(ArchGroupCopyId) FROM SMCopyToRelationMap WHERE SMRelationID = SMD.SMRelationId) AS NVARCHAR(4)),
		StorageService = (SELECT ExtRelationName FROM SMRelation WHERE SMRelationId = SMD.SMRelationId),
		DataSetId = SD.ExtDataSetId,
		DataSetName = SD.ExtDataSetName,
		StoragePolicyId = C.archGroupId,
		StoragePolicyName = (SELECT name FROM ArchGroup WHERE id = C.archGroupId),
		CopyId = C.id,
		CopyName = C.name,
		SourceCopyId = C.sourceCopyId,
		SourceCopyName = (SELECT ISNULL(name, '') FROM ArchGroupCopy WHERE id = C.sourceCopyId),
		CopyType = (CASE WHEN isMirrorCopy = 1 THEN 'Snap Mirror'
						 ELSE 'Snap Vault'
					END)
FROM	SMDataSetToSubClientMap SMD INNER JOIN SMDataSet SD WITH (NOLOCK) ON SMD.DataSetId = SD.DataSetId,
		SMCopyToRelationMap SMC,
		APP_Application		A,
		archGroupCopy		C
WHERE	SMD.AppId = A.id
		AND SMD.SMRelationId = SMC.SMRelationId
		AND SMC.ArchGroupCopyId = C.id
UNION
SELECT	ClientId = A.clientId,
		ClientName = (SELECT name FROM APP_Client WHERE id = A.clientId),
		ApptypeId = A.appTypeId,
		AppType = (SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
		InstanceId = A.instance,
		InstanceName = (SELECT name FROM APP_InstanceName WHERE id = A.instance),
		BackupSetId = A.backupSet,
		BackupSetName = (SELECT name FROM APP_BackupSetName WHERE id = A.backupSet),
		SubClientId = A.id,
		subclientName = A.subclientName,
		-- StorageService = 'CV_StoragePolicy' + CAST(C.archGroupId AS NVARCHAR(4)) + '_Copy' + CAST((SELECT MIN(ArchGroupCopyId) FROM SMCopyToRelationMap WHERE SMRelationID = SMD.SMRelationId) AS NVARCHAR(4)),
		StorageService = (SELECT ExtRelationName FROM SMRelation WHERE SMRelationId = SMD.SMRelationId),
		DataSetId = SD.ExtDataSetId,
		DataSetName = SD.ExtDataSetName,
		StoragePolicyId = AG.id,
		StoragePolicyName = AG.name,
		CopyId = PC.id,
		CopyName = PC.name,
		SourceCopyId = 0,
		SourceCopyName = '',
		CopyType = 'Snap Primary'
FROM	SMDataSetToSubClientMap SMD INNER JOIN SMDataSet SD WITH (NOLOCK) ON SMD.DataSetId = SD.DataSetId,
		SMCopyToRelationMap SMC,
		APP_Application		A,
		archGroupCopy		C,
		archGroupCopy		PC,
		ArchGroup			AG
WHERE	SMD.AppId = A.id
		AND SMD.SMRelationId = SMC.SMRelationId
		AND SMC.ArchGroupCopyId = C.id
		AND C.sourceCopyId = PC.id
		AND AG.defaultSnapCopy = PC.id
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [CommcellDFMSnapConfigurationInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommcellDFMSnapConfigurationInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CommCellMediaRetentionInfo.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CommCellMediaRetentionInfo"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellMediaRetentionInfo]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CommCellMediaRetentionInfo]
GO

delete from GXDBVersions where name = 'CommCellMediaRetentionInfo' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CommCellMediaRetentionInfo', '1.2', 'CommCellMediaRetentionInfo', '')
GO
--- Copyright (c) 1998  CommVault Systems, Inc.
--- Display Library Info
CREATE VIEW dbo.CommCellMediaRetentionInfo
AS
	SELECT distinct				CM.MediaId As MediaID,
								CM.MediaBarcode As BarCode,
								L.AliasName As LibraryName,
								SG.spareGroupName As ScratchPool,
								M.isInMediaGroup As IsAssignedMedia,
								CM.Type As MediaType,
								CM.MediaStatus As MediaStatus,
								(CASE CM.Location
								WHEN 'In Slot' THEN 'In Library'
								WHEN 'In Drive' THEN 'In Library'
								ELSE
									(CASE CM.ExportLocation
									WHEN '' THEN CM.Location
									WHEN NULL THEN CM.Location
									ELSE CM.Location + '(' + CM.ExportLocation + ')'
									END)
								END) As "MediaLocation(ExportLocation)",
								ISNULL(CM.StoragePolicy, 'N/A') As StoragePolicy,
								ISNULL(CM.StoragePolicyCopy, 'N/A') As StoragePolicyCopy,
								(CASE
								WHEN M.IsAged = 1 THEN 'Data Aged'
								WHEN M.RetentionExpireTime = 0 THEN 'N/A'
								WHEN M.RetentionExpireTime = -1 THEN 'Infinite'
								ELSE
									(CASE M.RetentionFlags
									WHEN 0 THEN CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.getDateTime(M.RetentionExpireTime), 2)) + '(BASIC)'
									ELSE
									CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.getDateTime(M.RetentionExpireTime), 2)) + '(EXTENDED)'
									END)
								END) As "RetentionDate(RetentionType)",
								(CASE
								WHEN CM.retentionDays IS NULL THEN 'N/A'
								WHEN CM.retentionDays = 'Unlimited' THEN 'Infinite'
								ELSE CM.retentionDays
								END) As BasicRetentionDays,
								(CASE
								WHEN CM.fullcycles IS NULL THEN 'N/A'
								WHEN CM.fullcycles = 'Unlimited' THEN 'Infinite'
								ELSE CM.fullcycles
								END) As BasicRetentionCycles
	FROM MMMedia M JOIN MMLibrary L
		ON M.LibraryId = L.LibraryId
	JOIN MMSpareGroup SG
		ON M.SpareGroupId = SG.SpareGroupId
	JOIN CommCellMediaInfo CM
		ON M.MediaId = CM.MediaId
	WHERE M.MediaTypeId <> 10001
GO
declare @retCode integer        -- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
    set @retCode = @@error;
    print "RETVAL: 10 View [CommCellDriveInfo]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CommCellMediaRetentionInfo]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/SRMVDataCenterView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SRMVDataCenterView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SRMVDataCenterView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SRMVDataCenterView]
GO

delete from GXDBVersions where name = 'SRMVDataCenterView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SRMVDataCenterView', '1.6', 'SRMVDataCenterView', '')
GO
CREATE VIEW SRMVDataCenterView
AS
	SELECT
		dcm.instanceId AS instanceId,
		dc.vCenter,
		dc.id,
		dc.name,
		dc.vxml,
		dc.timeStamp,
		dc.addTimeStamp,
		dc.removalTimeStamp
	FROM
		App_VMDataCenter AS dc
		INNER JOIN App_VMDataCenterMap AS dcm ON
			dcm.vDataCenterId = dc.id
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SRMVDataCenterView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/WR_LocaleStringsView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: WR_LocaleStringsView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_LocaleStringsView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[WR_LocaleStringsView]
GO

delete from GXDBVersions where name = 'WR_LocaleStringsView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'WR_LocaleStringsView', '1.2', 'WR_LocaleStringsView', '')
GO
SET QUOTED_IDENTIFIER ON
GO
declare @usingnulls bit
set @usingnulls = 0
SELECT  @usingnulls =  uses_ansi_nulls
    FROM   sys.tables
    WHERE  object_id = object_id('dbo.EvLocaleMsgs')
if (@usingnulls = 0)
begin
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	declare @constraintName nvarchar(100)
	SELECT  @constraintName = name
          FROM    sys.foreign_keys
          WHERE   type = 'F' AND referenced_object_id in (select  id FROM sysobjects WHERE name = 'EvLocaleMsgs')
          and parent_object_id in (select  id FROM sysobjects WHERE name = 'EvLocaleMsgArgInfo')
	declare @execString nvarchar(150)
        SET @execString = 'ALTER TABLE [dbo].[EvLocaleMsgArgInfo] DROP CONSTRAINT ' + @constraintName
        EXEC sp_executesql @execString
	create table dbo.EvLocaleMsgsNew (
		SubsystemID             integer                         not null,
		SubsystemName				varchar(255)not null,
		LocaleID                integer                         not null,
		MessageID               bigint                          not null,
		MessageNum              integer                         not null,
		Message				nvarchar(1024)not null,
		ArgCount                integer	NOT NULL,
		hasKBArticle            integer                         not null default (1)         	-- if 1 than this message has knowlege base article
	)
	ALTER TABLE dbo.EvLocaleMsgsNew ADD CONSTRAINT EvLocaleMsgsNew_LocaleID_MessageID_PK 		primary key (LocaleID, MessageID)
	insert into dbo.EvLocaleMsgsNew select * from dbo.EvLocaleMsgs
	DROP TABLE dbo.EvLocaleMsgs;
    	EXECUTE sp_rename N'dbo.EvLocaleMsgsNew', N'EvLocaleMsgs','OBJECT';
	ALTER TABLE [dbo].[EvLocaleMsgArgInfo]  WITH CHECK ADD FOREIGN KEY([LocaleID], [MessageID])
		REFERENCES [dbo].[EvLocaleMsgs] ([LocaleID], [MessageID])
end
GO
CREATE VIEW dbo.WR_LocaleStringsView WITH SCHEMABINDING
AS
	SELECT	LocaleID AS LocaleID, MessageID AS MessageID, Message AS Message
	FROM	dbo.EvLocaleMsgs
	WHERE	SubsystemID = 144 /*WEBREPORT_STRINGS_SSID*/
GO
IF EXISTS (SELECT * FROM sysindexes WHERE name = 'WR_LocaleStringsView_Idx1')
	DROP INDEX WR_LocaleStringsView.WR_LocaleStringsView_Idx1
CREATE UNIQUE CLUSTERED INDEX WR_LocaleStringsView_Idx1 ON WR_LocaleStringsView(LocaleID, MessageID)
IF EXISTS (SELECT * FROM sysindexes WHERE name = 'WR_LocaleStringsView_Idx2')
	DROP INDEX WR_LocaleStringsView.WR_LocaleStringsView_Idx2
CREATE INDEX WR_LocaleStringsView_Idx2 ON WR_LocaleStringsView(LocaleID, Message)
GO
SET QUOTED_IDENTIFIER OFF
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [WR_LocaleStringsView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ClientGroupsStringView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ClientGroupsStringView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientGroupsStringView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ClientGroupsStringView]
GO

delete from GXDBVersions where name = 'ClientGroupsStringView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ClientGroupsStringView', '1.1', 'ClientGroupsStringView', '')
GO
CREATE VIEW
	ClientGroupsStringView
WITH ENCRYPTION
AS
	SELECT * FROM dbo.ClientGroupsString(0)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ClientGroupsStringView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DiskBackupView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DiskBackupView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DiskBackupView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DiskBackupView]
GO

delete from GXDBVersions where name = 'DiskBackupView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DiskBackupView', '1.1', 'DiskBackupView', '')
GO
CREATE VIEW dbo.DiskBackupView
AS
SELECT	B.jobId AS JobID,
		A5.name AS Client,
		A4.name As Agent,
		dbo.FixInstanceName(A3.name, A1.appTypeId ) AS Instance,
		A2.name AS Backupset,
		A1.subclientName AS Subclient,
		X.policyName AS StoragePolicy,
		dbo.GetJobStatusName(B.status) AS JobStatus,
		dbo.GetJobBackupTypeDisplay(B.bkpLevel) AS BackupType,
		dbo.UTCToCellLocalTime(dbo.GetDateTime(B.servStartDate), 2) AS JobStartTime,
		dbo.UTCToCellLocalTime(dbo.GetDateTime(B.servEndDate), 2) AS JobEndTime,
		B.totalUncompBytes AS ApplicationSize
FROM	JMBkpStats B
		INNER JOIN APP_Application A1 ON A1.id = B.appId
		INNER JOIN APP_BackupSetName A2 ON A2.id = A1.backupSet
		INNER JOIN APP_InstanceName A3 ON A3.id = A1.instance
		INNER JOIN APP_iDAType A4 ON A4.type = A1.appTypeId
		INNER JOIN APP_Client A5 ON A5.id = B.appId
		INNER JOIN
		(SELECT	DISTINCT R.jobId, R.commCellId, AG.id AS policyId, AG.name AS policyName
		FROM	JMJobResourceHistory R
				INNER JOIN MMMedia M ON M.MediaId = R.MediaId
				INNER JOIN archGroup AG ON AG.defaultCopy = R.copyId
		WHERE	M.MediaTypeId = 10001 AND R.commCellId = 2) X
			ON X.jobId = B.jobId AND X.commCellId = B.commCellId
		INNER JOIN
		(SELECT	jobId, commCellId, archGrpId
		FROM	JMJobDataStats
		WHERE	(disabled & 256) = 0 AND commCellId = 2
		GROUP BY jobId, commCellId, archGrpId
		HAVING COUNT(DISTINCT archGrpCopyId) = 1) Y
			ON Y.jobId = X.jobId AND Y.commCellId = X.commCellId AND Y.archGrpId = X.policyId
WHERE	B.status IN (1, 3, 14) AND B.opType IN (4, 14, 76)
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DiskBackupView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DataWrittenInPreviousDayView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DataWrittenInPreviousDayView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataWrittenInPreviousDayView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DataWrittenInPreviousDayView]
GO

delete from GXDBVersions where name = 'DataWrittenInPreviousDayView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DataWrittenInPreviousDayView', '1.2', 'DataWrittenInPreviousDayView', '')
GO
CREATE VIEW DataWrittenInPreviousDayView
AS
SELECT	CASE WHEN U.vmClientId > 0 THEN U.vmClientId ELSE CL.id END AS ClientID,
		CASE WHEN U.vmClientId > 0 THEN (SELECT name FROM APP_Client WHERE id = U.vmClientId) ELSE CL.name END AS ClientName,
		IT.type AS AgentTypeID,
		IT.name + CASE WHEN U.vmClientId > 0 THEN ('in virtual server ' + CL.name) ELSE '' END AS AgentTypeName,
		INS.id AS InstanceID,
		dbo.FixInstanceName(INS.name, A.appTypeId) AS InstanceName,
		BS.id AS BackupsetID,
		BS.name AS BackupsetName,
		A.id AS SubclientID,
		A.SubclientName,
		U.DataProtected,
		U.DataWritten
FROM	(SELECT appId, vmClientId, SUM(dataProtected) AS dataProtected, SUM(dataWritten) AS dataWritten
		FROM	RptStorageUsage
		WHERE	startDT = (SELECT MAX(startDT) FROM RptStorageUsage WHERE type = 1)
			AND type = 1
		GROUP BY appId, vmClientId) U
		INNER JOIN APP_Application A ON U.appId = A.id
		INNER JOIN APP_Client CL ON A.clientId = CL.id
		INNER JOIN APP_iDAType IT ON A.appTypeId = IT.type
		INNER JOIN APP_InstanceName INS ON A.instance = INS.id
		INNER JOIN APP_BackupSetName BS ON A.backupSet = BS.id
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DataWrittenInPreviousDayView]'
END
GO



--  ------------  Generated from [../../../Source/CommServer/Db/CSView/DCPackages.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: DCPackages"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DCPackages]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[DCPackages]
GO

delete from GXDBVersions where name = 'DCPackages' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'DCPackages', '1.11', 'DCPackages', '')
GO
 ---Copyright (c) 1998  CommVault Systems, Inc.
 --- Display CommCell License Info
CREATE VIEW DCPackages AS
SELECT PP.PackagePlatformMappingId packageplatformmappingid,
a.PackageId as packageid,
a.packagename AS packagename,
pp.location as packagelocation,
pp.packagesize as packagesize,
a.Description as packagedescription,
pp.ReadMeLocation AS readmelocation,
a.BOLLink as bollink,
dbo.GetSolrDateString(a.StartDate) validfrom,
ISNULL(dbo.GetSolrDateString(a.EndDate), '2038-01-19T03:14:07Z') as validto,
ISNULL((dbo.DCGetPackageUsers(a.PackageId, 1, ';')), '') AS visibleto,
ISNULL((dbo.DCGetPackageUsers(a.PackageId, 2, ';')), '') AS notvisibleto,
ISNULL((dbo.DCGetPackageUsers(a.PackageId, 4,';')), '') AS earlypreviewusers,
ISNULL((dbo.DCGetPackageUsers(a.PackageId, 8,';')), '') AS notificationusers,
B.CategoryName as categoryname,
C.SubCategoryName as subcategoryname,
pl.platformname,
pl.PlatformId as platformid,
e.DownloadType AS downloadtype,
F.Name AS productversionname,
ISNULL(G.RecutName, '') as recutnumber,
ISNULL(VendorID, 0) AS vendor,
ISNULL(A.IconImage, '') AS softwareicon,
PP.DownloadAction AS installpreference,
ISNULL(A.Notification, '') AS notificationcontent,
A.PackageStatus as packagestatus,
'' as bolcontent,
'' as readmecontent,
dbo.GetSolrDateString(a.CreateTime) as createtime,
ISNULL(dbo.GetSolrDateString(a.ModifiedTime), '2038-01-19T03:14:07Z') as modifiedtime,
PP.PackageRepositoryId AS serverid,
a.PackageRank  AS itemrank,
ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@description)[1]', 'nvarchar(max)'), '') AS reportdescription,
ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@format)[1]', 'nvarchar(max)'), '') AS reportformat,
ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@guid)[1]', 'nvarchar(max)'), '') AS reportguid,
CASE WHEN ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@includeChart)[1]', 'VARCHAR(10)'), 'False') IN ('1', 'True') THEN 1 ELSE 0 END AS includeChart,
CASE WHEN ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@includeTable)[1]', 'VARCHAR(10)'), 'False') IN ('1', 'True') THEN 1 ELSE 0 END AS includeTable,
ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@reportName)[1]', 'nvarchar(max)'), '')  AS reportname,
ISNULL(PackageXML.value('(/extraPropContainer/customScriptDescription/@revision)[1]', 'nvarchar(max)'), '') AS reportrevision,
a.PriceWeightage AS priceweightage
FROM DCPackage a
JOIN DCCategory B on a.CategoryId = b.CategoryId
JOIN DCSubCategory C ON A.SubCategoryId = C.SubCategoryId
JOIN DCProductVersion F ON A.ProductVersionId = F.ProductVersionId
JOIN DCPackagePlatform PP ON PP.PackageId = A.PackageId AND PP.Attribute & 4 = 0
JOIN DCPlatform PL ON PP.PlatformId = PL.PlatformId
JOIN DCDownloadType E ON PP.DownloadTypeId = E.DownloadTypeId
LEFT JOIN DCRecutNumber G ON A.RecutNumberId = G.RecutName
GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print "RETVAL: 10 View [DCPackages]"
END
GO
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [DCPackages]'
END
GO

