

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMVTHistoryView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMVTHistoryView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMVTHistoryView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMVTHistoryView]
GO

delete from GXDBVersions where name = 'CNMMVTHistoryView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMVTHistoryView', '1.2.210.3', 'CNMMVTHistoryView', '')
GO
CREATE VIEW
	CNMMVTHistoryView
-- WITH ENCRYPTION
AS
SELECT	VH.HistoryID AS HistoryID,
		VH.ActionID AS ActionID,
		ISNULL(VP.PolicyID, 0) AS PolicyID,
		ISNULL(VP.PolicyName, '') AS PolicyName,
		VH.JobID_L AS JobID,
		VH.UserId AS UserID,
		ISNULL(VH.UserName,'') AS UserName,
		VH.MediaId AS MediaID,
		VH.BarCode AS BarCode,
		ISNULL(S.LocType, 0) AS SrcLocType,
		ISNULL(S.Value, 0) AS SrcLocationID,
		ISNULL(S.LocationName,'') AS SrcLocation,
		ISNULL(T.LocType, 0) AS TransLocType,
		ISNULL(T.Value, 0) AS TransLocationID,
		ISNULL(T.LocationName,'') AS Transit,
		ISNULL(D.LocType, 0) AS DestLocType,
		ISNULL(D.Value, 0) AS DestLocationID,
		ISNULL(D.LocationName,'') AS DestLocation,
		VH.State AS State,
		VH.StartTime AS StartTime,
		VH.EndTime AS EndTime,
		VH.ExportError AS ExportError,
		VH.DueBackTime AS DueBackTime,
		VH.ActionType AS ActionType
FROM	VTHistory VH
		LEFT OUTER JOIN VTPolicy VP ON VH.PolicyId = VP.PolicyId
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) S ON VH.SourceId = S.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) T ON VH.InTransitId = T.LocationID
		LEFT OUTER JOIN
				(SELECT	VT.LocationID, VT.Type AS LocType, L.AliasName AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMLibrary L ON VT.Value = L.LibraryID
				WHERE	VT.Type = 1 OR VT.Type = 4
				UNION
				SELECT	VT.LocationID, VT.Type AS LocType, EL.ExportLocation AS LocationName, VT.Value
				FROM	VTLocation VT LEFT OUTER JOIN MMExportLocation EL ON VT.Value = EL.ExportLocationId
				WHERE	VT.Type = 2) D ON VH.DestinationId = D.LocationID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMVTHistoryView]'
END
GO

