

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMMediaInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMMediaInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMMediaInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMMediaInfoView]
GO

delete from GXDBVersions where name = 'CNMMMediaInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMMediaInfoView', '1.7.188.3', 'CNMMMediaInfoView', '')
GO
CREATE VIEW
	CNMMMediaInfoView
-- WITH ENCRYPTION
AS
SELECT	M.MediaID, M.BarCode, M.MediaTypeID, dbo.GetDateTime(M.CreationTime) AS CreationTime,
		(CASE WHEN ISNULL(MT.IsCleaningMedia, 0) = 1 THEN MS.TotalNumberOfMounts ELSE M.NumberOfReUses END) AS NumberOfReUses,
		dbo.GetDateTime(M.LastExportTime) AS LastExportTime,
		M.MediaLocation AS MediaLocationType,
		ISNULL((CASE M.MediaLocation WHEN 1 THEN (SELECT TOP 1 SlotName FROM MMSlot S WHERE S.MediaId = M.MediaID)
							  WHEN 2 THEN (SELECT TOP 1 AliasName FROM MMDrive D WHERE D.MediaId = M.MediaID)
							  WHEN 3 THEN EL.ExportLocation
							  ELSE '' END), '') AS MediaLocation,
		M.retentionFlags, dbo.GetDateTimeBig(M.retentionExpireTime) AS retentionExpireTime,
		M.MediaFlags, M.MediaStatusReason, M.Attributes, M.IsAged,
		L.LibraryID, L.AliasName AS LibraryName,
		MSG.SpareGroupId, MSG.SpareGroupName AS SpareGroupName,
		EL.Type AS ExportLocationType, EL.ExportLocationId, EL.ExportLocation AS ExportLocation,
		MC.ContainerId, MC.ContainerName AS ContainerName,
		dbo.GetDateTime(MS.LastRestoreTime) AS LastRestoreTime,
		dbo.GetDateTime(MS.LastBackupTime) AS LastBackupTime,
		dbo.GetDateTime(M.PinMediaExpireTime) AS PinMediaExpireTime,
		MS.TotalSpaceMB AS TotalSpaceMB,
		MS.TotalFreeSpaceMB AS TotalFreeSpaceMB,
		(MS.TotalSpaceMB - MS.TotalFreeSpaceMB) AS TotalCVDataSizeMB,
		ISNULL(AR.ArchGroupID, 1) AS ArchGroupID, ISNULL(AR.ArchGroupCopyId, 0) AS ArchGroupCopyId,
		(CASE --WHEN (LastWriteLibraryId > 0 AND M.LibraryID <> M.LastWriteLibraryId) THEN -1
			  WHEN (M.SpareGroupID > 0 AND M.IsInMediaGroup = 0) THEN MSG.SpareGroupType
		      ELSE 0 END) AS GroupType,
		ISNULL(V.MediaStatus, 0) AS MediaStatus,
		ISNULL(M.LastWriteLibraryID, 0) AS LastWriteLibraryID,
		ISNULL(M.IsInMediaGroup, 0) AS IsInMediaGroup,
		ISNULL(MS.TotalNumberOfSoftErrors, 0) AS TotalNumberOfSoftErrors,
		ISNULL(MS.TotalNumberOfHardErrors, 0) AS TotalNumberOfHardErrors,
		ISNULL(M.Descript, '' ) AS [Description],
		ISNULL(M.origCCCommCellId, 2) AS origCCCommCellId
FROM	MMMedia M LEFT OUTER JOIN MMLibrary L ON M.LibraryID = L.LibraryID
				  LEFT OUTER JOIN MMMediaType MT ON M.MediaTypeId = MT.MediaTypeId
				  LEFT OUTER JOIN MMSpareGroup MSG ON M.SpareGroupId = MSG.SpareGroupId
				  LEFT OUTER JOIN MMExportLocation EL ON M.ExportLocationId = EL.ExportLocationId
				  LEFT OUTER JOIN MMContainer MC ON M.ContainerId = MC.ContainerId
				  LEFT OUTER JOIN (SELECT	MediaID,
											MAX(LastRestoreTime) AS LastRestoreTime,
											MAX(LastBackupTime) AS LastBackupTime,
											SUM(TotalSpaceMB) AS TotalSpaceMB,
											SUM(FreeBytesMB) AS TotalFreeSpaceMB,
											SUM(NumberOfMounts) AS TotalNumberOfMounts,
											SUM(NumberOfSoftErrors) AS TotalNumberOfSoftErrors,
											SUM(NumberOfHardErrors) AS TotalNumberOfHardErrors
									FROM	MMMediaSide
									GROUP BY MediaID) MS ON M.MediaID = MS.MediaID
				  LEFT OUTER JOIN ( SELECT	DISTINCT MV.MediaID, MV.MediaGroupID, ArchGroupID, ArchGroupCopyId
									FROM	(SELECT	MediaID, MAX(MediaGroupID) AS MediaGroupID
											FROM MMVolume
											WHERE MediaGroupID > 0
											GROUP BY MediaID) MV, ArchStream A
									WHERE	MV.MediaGroupID = A.MediaGroupID) AR ON M.MediaID = AR.MediaID
				  LEFT OUTER JOIN ( SELECT	MediaID,
				  					MIN(case VolumeFlags when 4 then 1 when 3 then 2 when 1 then 3 when 7 then 4
				  						when 2 then 5 when 5 then 6 else 0 end) AS MediaStatus
				  					FROM	MMVolume
				  					WHERE	RecordingFormatId <> 10001
				  					GROUP BY MediaID
				  					UNION
				  					SELECT	MediaID, (CASE isOffline WHEN 1 THEN 5 ELSE 3 END)
				  					FROM	MMMountPath MP, MMMediaSide MS
				  					WHERE	MP.MediaSideID = MS.MediaSideID) V	ON M.MediaID = V.MediaID
WHERE	M.MediaID > 0
		AND M.MediaTypeID <> 10001
UNION
SELECT	M.MediaID, 'Magnetic', M.MediaTypeID, dbo.GetDateTime(M.CreationTime) AS CreationTime,
		M.NumberOfReUses AS NumberOfReUses,
		dbo.GetDateTime(M.LastExportTime) AS LastExportTime,
		M.MediaLocation AS MediaLocationType,
		ISNULL((CASE MP.MountPathTypeId				--MR# 54340
			WHEN 1 THEN								--An EDC discovered library exist for which no mount path is associated.
				(SELECT	FriendlyName
				 FROM	MMCenteraInfo CI, MMMountPathToStorageDevice SD
				 WHERE CI.CenteraId=SD.CenteraId and SD.MountPathId=MP.MountPathId)
			ELSE MP.MountPathName END), '') AS MediaLocation,
		M.retentionFlags, dbo.GetDateTimeBig(M.retentionExpireTime) AS retentionExpireTime,
		M.MediaFlags, M.MediaStatusReason, M.Attributes, M.IsAged,
		L.LibraryID, L.AliasName AS LibraryName,
		0 AS SpareGroupId, 'N/A' AS SpareGroupName,
		1 AS ExportLocationType, 0 AS ExportLocationId, 'Not Available' AS ExportLocation,
		0 AS ContainerId, 'Dummy' AS ContainerName,
		dbo.GetDateTime(MS.LastRestoreTime) AS LastRestoreTime,
		dbo.GetDateTime(MS.LastBackupTime) AS LastBackupTime,
		dbo.GetDateTime(M.PinMediaExpireTime) AS PinMediaExpireTime,
		MS.TotalSpaceMB AS TotalSpaceMB,
		MS.FreeBytesMB  AS TotalFreeSpaceMB,
		ISNULL(AR.CVDataSizeMB, 0) AS TotalCVDataSizeMB,
		ISNULL(AR.ArchGroupID, 1) AS ArchGroupID, ISNULL(AR.ArchGroupCopyId, 0) AS ArchGroupCopyId,
		0 AS GroupType,
		ISNULL((CASE MP.isOffline WHEN 1 THEN 5 ELSE 3 END), 0) AS MediaStatus,
		ISNULL(M.LastWriteLibraryID, 0) AS LastWriteLibraryID,
		ISNULL(M.IsInMediaGroup, 0) AS IsInMediaGroup,
		ISNULL(MS.NumberOfSoftErrors, 0) AS TotalNumberOfSoftErrors,
		ISNULL(MS.NumberOfHardErrors, 0) AS TotalNumberOfHardErrors,
		ISNULL(M.Descript, '' ) AS [Description],
		ISNULL(M.origCCCommCellId, 2) AS origCCCommCellId
FROM	MMMedia M
		INNER JOIN MMLibrary L ON M.LibraryID = L.LibraryID
		INNER JOIN MMMediaSide MS ON M.MediaID = MS.MediaID
		INNER JOIN MMMountPath MP ON MS.MediaSideID = MP.MediaSideID
		LEFT OUTER JOIN (SELECT	DISTINCT MV.MediaID, MV.MediaGroupID, ArchGroupID, ArchGroupCopyId, MV.CVDataSizeMB
						FROM	(SELECT	MediaID, MAX(MediaGroupID) AS MediaGroupID, SUM(PhysicalBytesMB) AS CVDataSizeMB
								FROM MMVolume
								WHERE MediaGroupID > 0
								GROUP BY MediaID) MV, ArchStream A
						WHERE	MV.MediaGroupID = A.MediaGroupID ) AR ON M.MediaID = AR.MediaID
WHERE	M.MediaID > 0
		AND M.MediaTypeID = 10001
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMMediaInfoView]'
END
GO

