

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNMMLibraryDrivesView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNMMLibraryDrivesView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryDrivesView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNMMLibraryDrivesView]
GO

delete from GXDBVersions where name = 'CNMMLibraryDrivesView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNMMLibraryDrivesView', '1.2.276.3', 'CNMMLibraryDrivesView', '')
GO
CREATE VIEW
	CNMMLibraryDrivesView
-- WITH ENCRYPTION
AS
SELECT	DISTINCT
	L.LibraryId		as LibraryID,
	MP.MasterPoolID		as MasterPoolID,
	MP.MasterPoolName	as MasterPoolName,
	D.DriveId		as DriveID,
	D.DriveName		as DriveName,
	D.AliasName		as DriveAliasName,
	DT.DriveTypeName	as DriveTypeName,
	D.DriveVendor		as Vendor,
	D.DriveModel		as Model,
	D.FirmwareRevision	as FirmwareRevision,
	D.SerialNumber		as SerialNumber,
	D.DriveEnabled		as DriveEnabled,
	1 - (D.DriveSoftState & D.DriveEnabled & ~D.CleaningRequired & ~D.DriveBroken)
				as Offline,
	(CASE WHEN (1 - (D.DriveSoftState & D.DriveEnabled & ~D.CleaningRequired & ~D.DriveBroken) ) = 0
			THEN	0
			ELSE D.OfflineReason
		END)	as OfflineReason,
	D.OfflineTimeStamp	as OfflineTime,
	isnull(MountP.MountPathID, 0) as MountPathID,
	DT.RatedThroughputInMBPerSec as RatedThroughputInMBPerSec,
	D.DriveOfflineReasonEventID		as OfflineReasonEventID,
	D.origCCID				as		CommCellID
FROM
	MMLibrary L,
	MMDrive D,
	MMMasterPool MP,
	MMDriveType DT,
	MMMediaSide MS
		LEFT OUTER JOIN MMMountPath MountP
		ON MountP.MediaSideID = MS.MediaSideID
WHERE
	    D.MasterPoolId = MP.MasterPoolId
	AND MP.LibraryId = L.LibraryId
	AND D.DriveTypeID = DT.DriveTypeID
	AND L.LibraryId > 0
	AND L.LibraryTypeId != 8
	AND D.MediaID = MS.MediaID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNMMLibraryDrivesView]'
END
GO

