

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNIDAInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNIDAInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNIDAInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNIDAInfoView]
GO

delete from GXDBVersions where name = 'CNIDAInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNIDAInfoView', '1.4.200.3', 'CNIDAInfoView', '')
GO
CREATE VIEW
	CNIDAInfoView
-- WITH ENCRYPTION
AS
SELECT
	2	 	as CommCellID,
	IDA.clientId 	as ClientID,
	IDA.appTypeId	as AppTypeID,
	(select name from APP_IDAType where type = IDA.appTypeId)
			as AppTypeName,
	(CASE WHEN ((IDA.status & 0x2000) > 0) THEN 0 ELSE		-- 0x2000(8192) - this is a special flag that says that this is external IDA
	    CASE WHEN ((IDA.status & 0x6) > 0) THEN 1 ELSE 0 END
     END) as LogDeleted,
	IDA.Status 		as Status
FROM 	APP_IDAName IDA, CNClientInfoView CL
WHERE 	IDA.clientId = CL.id and IDA.appTypeId < 1000
		AND	(IDA.AppTypeID NOT BETWEEN 600 AND 700)
        AND IDA.appTypeId <> 122 -- filter out commnet agent data type
UNION ALL
SELECT	TOP 1
	2,
	clientId,
	appTypeId,
	(select name from APP_IDAType where type = APP.appTypeId),
	0,
	0
FROM 	APP_Application APP
WHERE 	appTypeId = 1030	-- Subclient Policy
	AND subclientStatus & (2 + 4) = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNIDAInfoView]'
END
GO

