

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/CNClientInfoView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CNClientInfoView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNClientInfoView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CNClientInfoView]
GO

delete from GXDBVersions where name = 'CNClientInfoView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CNClientInfoView', '1.28.76.5', 'CNClientInfoView', '')
GO
CREATE VIEW
	CNClientInfoView
-- WITH ENCRYPTION
AS
SELECT
	C.origCCID		as CommCellID,
	C.id			as ID,
	CLP.GUID		as GUID,
	C.name	        as ClientName,
	C.net_hostName		as InterfaceName,
	isnull(dbo.GetClientOSName(C.id,NULL), 'N/A')
		as OSName,
	isnull(CLAPPS.RelAndBuild, isnull((SELECT TOP 1 AttrVal FROM APP_ClientProp CPROP WHERE ComponentNameId = C.id and attrName='Foreign Client Version'), 'N/A'))
				as SWVersion,
	isnull((SELECT TOP 1 CPV.ServicePack FROM CNClientPatchInfoView CPV WHERE CPV.ClientID = C.id ORDER BY CPV.ServicePack DESC), '')
				as ServicePack,
	isnull(CLAPPS.InstTime, 0)
				as InstallTime,
	-- on CommNet side we are going to consider VSDC clients as always reachable
	(CASE WHEN CCR.Flag = 0
		  THEN
		      -- client is offline. however we are going to check if client is VSDC client
		      -- check if it is a VSDC client
			  (CASE WHEN ISNULL(CLP.VirtualServerDiscoveredClients, 0) = '1'
			        -- it is a VSDC client. make it reachable i.e NOT offline
			        THEN 0
			        -- it is a real client. it IS offline
			        ELSE 1
			   END)
		  -- CCR.Flag != 0. client is reachable i.e NOT offline
		  ELSE 0
	END) As Offline,
	CAST(isnull(CCR.lastOfflineTime, 0) AS INTEGER) AS OfflineTime,
	0			as OffLineReason,
	CAST(isnull(CLP.JMPriority, 6) AS INTEGER)
				as Priority,
	CAST(isnull((select TOP 1 action from JMJobAction J where J.clientId=C.id and appType=0 and mediaAgentId=1 and opType=4),0) AS INTEGER)
				as DataProtActivity,
    (CASE WHEN ACC.type > = 100 THEN 0
          ELSE (CASE WHEN ISNULL(CLP.Platformdeleted4, '0') = '1' THEN 1 ELSE 0 END)
     END) as LogDeleted,
	C.modified 		as Modified,
	C.Status 		as Status,
	REPLACE(REPLACE(REPLACE(ISNULL(C.clientDescription, ''), CHAR(10), ' '), CHAR(13), ' '), ',', ';') AS Description,
	(ISNULL(SA.SecStorageClient, 0) + ISNULL(PA.PriStorageClient, 0)) AS ClientType,
	CAST(ISNULL(CLP.CommcellTimezoneId, 0) AS INTEGER) AS CCTimeZoneID,
	CAST(ISNULL(CLP.VirtualClient, 0) AS INTEGER) AS IsVirtualClient,
	CAST(ISNULL(CLP.ContentIndexingEnabled, 0) AS INTEGER) AS IsCIEnabled,
	CAST(ISNULL(CLP.SnapBackupsEnabled, 0) AS INTEGER) AS IsSBEnabled,
	-- StdTimeZoneName
	SUBSTRING(CLP.Timezone, LEN(CLP.Timezone) - CHARINDEX(':',REVERSE(CLP.Timezone)) + 2, CHARINDEX(':',REVERSE(CLP.Timezone)) )
					as StdTimeZoneName,	-- Special Client Flags
	replace(ISNULL(TZ.TimeZoneName, ''), ',', ';') AS TimeZoneName, ISNULL(TZ.Bias, 0) AS TimeZoneBias,
	-- Special Client Flags
	C.specialClientFlags	as SpecialClientFlags,
	-- VSDC
	CAST(ISNULL(CLP.VirtualServerDiscoveredClients, 0) AS INTEGER) AS IsVSDC,
	C.displayName	as DisplayName
FROM
	((((APP_Client	C
		INNER JOIN APP_CommCell ACC ON ACC.id = C.origCCId
		LEFT OUTER JOIN
		(SELECT	componentNameID,
				MAX(CASE WHEN attrName = 'Commcell timezone Id' THEN attrVal ELSE '' END) AS CommcellTimezoneId,
				MAX(CASE WHEN attrName = 'Content Indexing Enabled' THEN attrVal ELSE '' END) AS ContentIndexingEnabled,
				MAX(CASE WHEN attrName = 'Foreign Client Version' THEN attrVal ELSE '' END) AS ForeignClientVersion,
				MAX(CASE WHEN attrName = 'GUID' THEN attrVal ELSE '' END) AS GUID,
				MAX(CASE WHEN attrName = 'JMPriority' THEN attrVal ELSE '' END) AS JMPriority,
				MAX(CASE WHEN attrName = 'platformdeleted 4' THEN attrVal ELSE '' END) AS Platformdeleted4,
				MAX(CASE WHEN attrName = 'Virtual Client' THEN attrVal ELSE '' END) AS VirtualClient,
				MAX(CASE WHEN attrName = 'Virtual Server Discovered Clients' THEN attrVal ELSE '' END) AS VirtualServerDiscoveredClients,
				MAX(CASE WHEN attrName = 'Snap Backups Enabled' THEN attrVal ELSE '' END) AS SnapBackupsEnabled,
				MAX(CASE WHEN attrName = 'timezone' THEN attrVal ELSE '' END) AS Timezone
		FROM	App_ClientProp
		WHERE	attrName IN ('Commcell timezone Id', 'Content Indexing Enabled', 'Foreign Client Version', 'GUID', 'JMPriority',
				'platformdeleted 4', 'Virtual Client', 'Virtual Server Discovered Clients', 'Snap Backups Enabled', 'timezone')
			AND modified = 0
		GROUP BY componentNameID) AS CLP
		ON CLP.componentNameID = C.ID
		LEFT OUTER JOIN SchedTimeZone TZ
			ON TZ.TimeZoneStdName = SUBSTRING(CLP.Timezone, LEN(CLP.Timezone) - CHARINDEX(':',REVERSE(CLP.Timezone)) + 2, CHARINDEX(':',REVERSE(CLP.Timezone)))
				-- This makes sure that we always have a row for every client, even though
				-- we don't have a BASE_CLIENT entry on the SIM tables (CLAPPS)
		LEFT OUTER JOIN
			(SELECT	LU.CID AS ClientID, (SR.Release + '.' + LU.Build) as RelAndBuild, dbo.GetUnixTime(LU.OpTimeUTC) as InstTime
			 FROM	LicUsage LU, SimAllGalaxyRel SR,(	SELECT	T2.CID AS ClientID, MAX(ID) AS LID
														FROM	(SELECT	CID, MAX(OpTimeUTC) AS 'MaxOpTimeUTC'
																FROM	LicUsage
																WHERE	OpType='Install'
																		AND InstallFlag = 0
																		AND LicType NOT IN (10,26,71)
																GROUP BY CID) T, LicUSage T2
														WHERE	T.CID = T2.CID
																AND T.MaxOpTimeUTC = T2.OpTimeUTC
														GROUP BY T2.CID
													 ) LUI
			WHERE	LU.id = LUI.LID AND SR.id = LU.Releaseid
		) as CLAPPS
		ON C.id = CLAPPS.ClientID)
		LEFT OUTER JOIN
		(SELECT * FROM CCRClientToClient
			WHERE FromClientID = (SELECT ClientID From APP_CommCell
								WHERE id = 2)
				  AND ToClientID IN (SELECT DISTINCT ClientID FROM CCRToSubClient)
				  AND isDip = 0 AND serviceType = 0) AS CCR
		ON C.ID = CCR.ToClientID)
		LEFT OUTER JOIN
		(SELECT	ClientID, (CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END) AS SecStorageClient
		FROM	APP_IDAName
		WHERE	AppTypeID BETWEEN 1 AND 599
		GROUP BY ClientID) AS SA
		ON C.ID = SA.ClientID)
		LEFT OUTER JOIN
		(SELECT	ClientID, (CASE WHEN COUNT(*) > 0 THEN 2 ELSE 0 END) AS PriStorageClient
		FROM	APP_IDAName
		WHERE	AppTypeID BETWEEN 600 AND 699
		GROUP BY ClientID
						UNION
		--List of all SRM Enabled Agents
		SELECT agents.clientId, (CASE WHEN COUNT(*) > 0 THEN 2 ELSE 0 END) AS PriStorageClient
		FROM APP_Client AS client
		INNER JOIN APP_IDAName AS agents ON
			client.id = agents.clientId
			AND (agents.status & 2) <> 2		--NOT Uninstalled
			AND (agents.status & 16) <> 16		--NOT DUMMY
		INNER JOIN APP_IDAProp AS props ON
			props.componentNameId = agents.id
			AND props.attrName LIKE 'SRM Data Collection Enabled'
			AND props.attrVal = 1
			AND props.modified = 0
		GROUP BY ClientID) AS PA
		ON C.ID = PA.ClientID),
	APP_Platform	P
WHERE
	    C.id > 1
    	and C.id		= P.clientId
    	and (C.Status & 0x4000)	<> 0x4000
	and P.platformType	= 4
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CNClientInfoView]'
END
GO

