

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/AuxCopyBehindView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: AuxCopyBehindView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AuxCopyBehindView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[AuxCopyBehindView]
GO

delete from GXDBVersions where name = 'AuxCopyBehindView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'AuxCopyBehindView', '1.2.178.2', 'AuxCopyBehindView', '')
GO
CREATE VIEW AuxCopyBehindView
-- WITH ENCRYPTION
AS
SELECT	AG.name AS PolicyName,
		AGC.name AS CopyName,
		CASE WHEN AGC.isMirrorCopy = 1 THEN 'Snap Mirror'
			WHEN AGC.isSnapCopy = 1 THEN 'Snap Vault'
			WHEN AGC.type = 1 THEN 'Synchronous'
			WHEN AGC.type = 2 THEN 'Selective'
		END AS CopyType,
		CASE WHEN (AGC.dedupeFlags & (524288|8388608)) > 0 THEN 'Y' ELSE 'N' END AS IsDashCopy,
		ISNULL(NumOfJobsBehind, 0) AS NumOfJobsBehind,
		ISNULL(OldestJobToCopy, 0) AS OldestJobToCopy
FROM	archGroupCopy AGC
		INNER JOIN archGroup AG
	ON	AGC.archGroupId = AG.id
		AND AG.id > 1 AND AG.type IN (1, 2)
		AND AGC.isActive > 0 AND AGC.type IN (1, 2) AND (AGC.flags & 524288) = 0
		AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
		LEFT JOIN (SELECT	archGrpCopyId, COUNT(DISTINCT jobId) AS NumOfJobsBehind, MIN(jobId) AS OldestJobToCopy
					FROM	JMJobDataStats
					WHERE	status IN (101, 102, 103) AND (disabled & (1|256)) = 0
					GROUP BY archGrpCopyId) J
	ON	AGC.id = J.archGrpCopyId
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [AuxCopyBehindView]'
END
GO

