

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/AppEdgeDriveWebserverAssociation.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: AppEdgeDriveWebserverAssociation"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppEdgeDriveWebserverAssociation]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[AppEdgeDriveWebserverAssociation]
GO

delete from GXDBVersions where name = 'AppEdgeDriveWebserverAssociation' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'AppEdgeDriveWebserverAssociation', '1.1.4.4', 'AppEdgeDriveWebserverAssociation', '')
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW dbo.AppEdgeDriveWebserverAssociation
AS
    --gets webserver(s) associated to edge drive client(s)
	SELECT
		AE.clientid as edgeClientId,
		C.id as webserverId,
		ISNULL((SCP2.attrVal),'') as webserverUrl,
		AE.entityId as indexServerId,
		ISNULL(TRY_CAST(CP.attrVal AS int),0) as systemDriveType
	FROM App_Edgedriveassociation (nolock) AE
	INNER JOIN App_Application (nolock) SC ON AE.entityid = SC.backupset
	INNER JOIN App_Subclientprop SCP1 (nolock) ON SCP1.componentNameId = SC.ID
	INNER JOIN App_Subclientprop SCP2 (nolock) ON SCP2.componentNameId = SC.ID
	INNER JOIN APP_Client C ON C.id = TRY_CAST(SCP1.attrVal AS int)
	LEFT OUTER JOIN App_Clientprop CP (nolock) ON CP.componentNameId = AE.clientid AND CP.attrname = N'System Drive Type' AND CP.modified = 0
	WHERE AE.entitytype = 65 /**SUBCLIENT_POLICY_ENTITY **/ AND
	SCP1.attrname = N'Edge Web Server' AND SCP1.cs_attrname = checksum(N'Edge Web Server') AND SCP1.modified = 0 AND
	SCP2.attrname = N'Edge Web Server URL' and SCP2.cs_attrname = checksum(N'Edge Web Server URL') AND SCP2.modified = 0
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [AppEdgeDriveWebserverAssociation]'
END
GO

