

--  ------------  Generated from [../../../Source/CommServer/Db/CSView/ActiveStreams.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: ActiveStreams"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ActiveStreams]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[ActiveStreams]
GO

delete from GXDBVersions where name = 'ActiveStreams' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'ActiveStreams', '1.30.2.8', 'ActiveStreams', '')
GO
  ---  Copyright (c) 1998  CommVault Systems, Inc.
  ---  Display the active streams
CREATE VIEW dbo.ActiveStreams
AS
        SELECT jobID = JS.jobId,
        JS.commCellId,
        JS.destRcId,
        JS.destReservationId,
        JS.srcRcId,
        JS.srcReservationId,
        JS.archGrpId,
        JS.destCopyId,
        JS.srcCopyId,
        JS.status,
        JS.streamNum,
		JS.destStreamNum,
        isPrimary,
        JS.guiAlertColorLevel,
        unCompBytes,
        compBytes,
        nwTransBytes,
        writeTime,
        committedUncompBytes,
        committedCompBytes,
        committedWriteTime,
        numFiles,
        numFolders,
        numFailures,
        numSkipped,
        phaseNumber,
        attemptNumber,
        throughput,
        totalToCopy = CASE WHEN JI.opType = 104 AND JS.status = 7/*Completed*/ THEN unCompBytes
						   WHEN JI.opType = 31 AND JI.subOpType = 106 AND JS.status = 7/*Completed*/ THEN compBytes
						   WHEN JI.opType = 104 THEN
						   ISNULL((Select SUM(AJS.TotalSizeToProcess) From ArchJobStreamStatus AJS(NOLOCK) Where JS.jobId = AJS.JobId AND JS.destRcId = AJS.DestRCId And JS.destReservationId = AJS.DestReservationId) ,JS.totalToCopy)
						   WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
						   ISNULL((Select SUM(AJS.TotalSizeToProcess) From ArchJobStreamStatus AJS(NOLOCK) Where JS.jobId = AJS.JobId AND JS.SrcRCId = AJS.srcRcId And JS.SrcReservationId = AJS.srcReservationId) ,JS.totalToCopy)
						   WHEN JI.opType = 80 AND JI.subOpType = 131 /*DEDUPDBSYNC_DASH*/ THEN
						   ISNULL((Select SUM(AJS.TotalSizeToProcess) From ArchJobStreamStatus AJS(NOLOCK) Where JS.jobId = AJS.JobId AND JS.SrcRCId = AJS.srcRcId And JS.SrcReservationId = AJS.srcReservationId) ,JS.totalToCopy)
						   ELSE JS.totalToCopy END,
        embeddedObjects,
		readBytes,
		readTime,
		physicalWriteBytes,
		physicalWriteTime,
		nwTransTime,
		sidbLookups,
		sidbLookupTime,
		readThroughput,
		writeThroughput,
		networkThroughput,
		calcSidbLookups,
        compScheme,
		destDriveName,
		srcDriveName = CASE WHEN JS.srcReservationId = 0 AND JI.opType = 104 THEN
							ISNULL((
									select TOP 1 list.MountPathName
									From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMMountPath path WITH (NOLOCK), MMS2getMountPathList list with (NOLOCK)
									Where stream.JobId = JS.JobId And stream.DestRCId = JS.destRcId And stream.DestReservationId = JS.destReservationId
									AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = side.MediaId AND side.MediaSideId = path.MediaSideId
									AND	stream.srcMAId = list.ClientId AND path.MountPathId = list.MountPathId
									), '')
							WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
							ISNULL((
									select TOP 1 list.MountPathName
									From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMMountPath path WITH (NOLOCK), MMS2getMountPathList list with (NOLOCK)
									Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
									AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = side.MediaId AND side.MediaSideId = path.MediaSideId
									AND	stream.srcMAId = list.ClientId AND path.MountPathId = list.MountPathId
									), '')
							WHEN JI.opType = 80 AND JI.subOpType = 131 /*DEDUPDBSYNC_DASH*/ THEN
							ISNULL((
									select TOP 1 list.MountPathName
									From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMMountPath path WITH (NOLOCK), MMS2getMountPathList list with (NOLOCK)
									Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
									AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = side.MediaId AND side.MediaSideId = path.MediaSideId
									AND	stream.srcMAId = list.ClientId AND path.MountPathId = list.MountPathId
									), '')
						ELSE srcDriveName END,
        archGrpName = CASE JS.archGrpId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroup WHERE id = JS.archGrpId),'Unavailable') END,
        destCopyName = CASE JS.destCopyId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroupCopy WHERE id = JS.destCopyId),'Unavailable') END,
        srcCopyName = CASE JS.srcCopyId WHEN 0 THEN '' ELSE ISNULL((SELECT name FROM archGroupCopy WHERE id = JS.srcCopyId),'Unavailable') END,
		(CASE
			WHEN JI.opType = 104 THEN
				ISNULL((SELECT	TOP 1 CAST(R.backupJobId AS varchar(1024))
						FROM	ArchJobStreamStatus AJS WITH(NOLOCK), ArchChunkToReplicate R WITH(NOLOCK)
						WHERE	AJS.JobId = R.AdminJobId AND AJS.SegmentId = R.segmentId
								AND JS.jobId = AJS.JobId AND JS.destRcId = AJS.DestRCId
								ORDER BY R.Modified DESC), '')
			WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
				ISNULL((SELECT	TOP 1 CAST(V.backupJobId AS varchar(1024))
						FROM	ArchJobStreamStatus AJS WITH(NOLOCK), ArchChunkToVerify2 V WITH(NOLOCK)
						WHERE	AJS.JobId = V.AdminJobId AND AJS.SegmentId = V.segmentId
								AND JS.jobId = AJS.JobId AND JS.srcRcId = AJS.srcRcId
								ORDER BY V.Modified DESC), '')
			WHEN JI.opType = 80 AND JI.subOpType = 131 THEN
				ISNULL((SELECT	TOP 1 CAST(V.backupJobId AS varchar(1024))
						FROM	ArchJobStreamStatus AJS WITH(NOLOCK), ArchChunkToVerify2 V WITH(NOLOCK)
						WHERE	AJS.JobId = V.AdminJobId AND AJS.SegmentId = V.segmentId
								AND JS.jobId = AJS.JobId AND JS.srcRcId = AJS.srcRcId
								ORDER BY V.Modified DESC), '')
			ELSE ''
		END)AS BackupJobId,
        destMedAgent,
        srcClient,
        JS.restartString,
        JS.activeFile,
        JS.failureReason,
		srcBarCode = CASE WHEN len(JS.srcBarCode) = 0 AND JS.srcReservationId = 0 AND JI.opType = 104 THEN
						ISNULL((select TOP 1 media.Barcode
								From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMedia media WITH (NOLOCK)
								Where stream.JobId = JS.JobId And stream.DestRCId = JS.destRcId And stream.DestReservationId = JS.destReservationId
								AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = media.MediaId
								), '')
						WHEN JI.opType = 31 AND JI.subOpType = 106 THEN
						ISNULL((select TOP 1 media.Barcode
								From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMedia media WITH (NOLOCK)
								Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
								AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = media.MediaId
								), '')
						WHEN JI.opType = 80 AND JI.subOpType = 131 THEN
						ISNULL((select TOP 1 media.Barcode
								From ArchJobStreamStatus stream WITH (NOLOCK), MMVolume volume WITH (NOLOCK), MMMedia media WITH (NOLOCK)
								Where stream.JobId = JS.JobId And stream.SrcRCId = JS.srcRcId And stream.SrcReservationId = JS.srcReservationId
								AND	stream.FirstVolumeId > 0 AND stream.FirstVolumeId = volume.VolumeId AND volume.MediaId = media.MediaId
								), '')
						ELSE srcBarCode END,
        destBarCode,
        dbo.JMGetLocalizedMessageFunc(0,JS.failureReason) AS [DelayReason],
        dbo.JMGetKBArticlesForFailures(JS.failureReason, 0) AS failureKBArticle
        FROM JMJobStreams JS INNER JOIN JMJobInfo(NOLOCK) JI
        ON JS.JobId = JI.JobId And JS.commCellId = JI.commCellId
		WHERE ( ( JI.opType != 104 AND JI.subOpType != 106) OR
				(( JI.opType = 104 OR JI.subOpType = 106) AND JS.status != 2/*STREAMFAIL*/) OR
				(JI.opType = 104 AND EXISTS(SELECT 1 FROM ArchJobStreamStatus(NOLOCK) WHERE JobID = JS.jobid AND destRcId = JS.destRcId AND destReservationId = JS.destReservationId AND ModifiedTime > dbo.GetUnixTime(GetUTCDate()) - 5*60
					  						UNION
											SELECT 1 FROM ArchJobStreamStatusHistory(NOLOCK) WHERE JobID = JS.jobid AND destRcId = JS.destRcId AND destReservationId = JS.destReservationId AND ModifiedTime > dbo.GetUnixTime(GetUTCDate()) - 5*60)
											) OR
				(JI.subOpType = 106 AND EXISTS(SELECT 1 FROM ArchJobStreamStatus(NOLOCK) WHERE JobID = JS.jobid AND srcRcid = JS.srcRcId AND srcReservationId = JS.srcReservationId AND ModifiedTime > dbo.GetUnixTime(GetUTCDate()) - 5*60
											   UNION
											   SELECT 1 FROM ArchJobStreamStatusHistory(NOLOCK) WHERE JobID = JS.jobid AND srcRcId = JS.srcRcId AND srcReservationId = JS.srcReservationId AND ModifiedTime > dbo.GetUnixTime(GetUTCDate()) - 5*60)
											   ) )
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [ActiveStreams]'
END
GO

