

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFile_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFile_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFile_AfterDel]
  delete from GXDBVersions where name = 'archFile_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFile_AfterDel
 	ON archFile
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN

		declare		@fromProcessId		integer
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())

		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archFilePruningLogs (archFileId, commCellId, archGroupId, isValid, flags,	appId, fileType, backupLevel, JobId, cTime, pruneTime, processId)
		SELECT D.id, D.commCellId, D.archGroupId, D.isValid, D.flags, D.appId, D.fileType, D.backupLevel, D.JobId, D.cTime, @currentTime, @fromProcessId
		FROM Deleted D
 	--
		INSERT INTO archFileCloudPaaS (archFileId, commCellId, jobId, appId, flags)
		SELECT D.id, D.commCellId, D.JobId, D.appId, D.flags
		FROM Deleted D
 	WHERE D.flags & 134217728 /* CVA_AF_CLOUD_PAAS_FLAG */ > 0
 	--
 	--
		INSERT INTO archContentIndexingAged([archFileId], [commCellId], [cloudId], [appId], [pruneType], [agedFlag], [jobId])
		SELECT
			D.id, D.commCellId, D.cloudId, D.appId,
			PruneType = case a.appTypeId
				when 67 /*CV_APPTYPE_MS_EXCHANGE_ARCHIVER*/ then 1 /*CVA_AGEDCI_PRUNETYPE_AFILE_ONLY*/
				when 106 /*CV_APPTYPE_VIRTUAL_SERVER*/ then 7 /*CVA_AGEDCI_PRUNETYPE_VSA*/
				else 3  /*CVA_AGEDCI_PRUNETYPE_AFILE_AGEDOUT*/
			end,
			0,
			D.jobId

		FROM
			Deleted D
		inner join
			APP_Application a
		on
			a.id = D.appId
		WHERE
			D.cloudId > 0 AND (D.flags & 240 /* CVA_AF_CI_BITMAP */) > 0
 	--
 	--
 	--
 	DELETE A FROM archIndexingAgedTemp A, Deleted D
 	WHERE  A.archFileId = D.id AND	A.commCellId = D.commCellId
 	--
		INSERT INTO archIndexingAgedTemp([archFileId], [commCellId], [appId], [pruneTime])
		SELECT
			D.id, D.commCellId, D.appId, @currentTime
		FROM
			Deleted D
		WHERE
			D.fileType <> 2
 	--
 	-- FLA ageing
		insert into archFLAIndexingAged(archFileId, commCellId, cloudId, appId, pruneType, agedFlag)
 	select
			e.archFileId, e.commCellId, e.cloudId, d.appId, 6 /*CVA_AGEDCI_PRUNETYPE_FLA_AFILE_AGEDOUT*/, 0
		from
 		Deleted d
 	inner join
 		archFLAIndexingInfo e
 	on
 		e.archFileId = d.id
 		and e.commCellId = d.commCellId
		--
		delete archFLAIndexingInfo
		from
			archFLAIndexingInfo e
		inner join
			Deleted d
 	on
 		e.archFileId = d.id
 		and e.commCellId = d.commCellId
		--
		delete archContentIndexingSecondary from archContentIndexingSecondary s
		inner join Deleted d on d.id = s.ArchFileId and d.commCellId = s.CommCellId
 	--
 	INSERT INTO archFileEdgeDrive (archFileId, commCellId, fileType, flags, jobId, appId, clientId, WebServerId, CloudId, AFDeleteTime, analyticsEngineType)
 	SELECT	D.id, D.CommCellId, D.FileType, D.Flags, D.JobId, D.appId, ISNULL(A.ClientId, 0), ISNULL(EWA.webserverId, 0), 0, @currentTime,
 	CASE WHEN EWA.systemDriveType = 0 /*enum EdgeSystemDriveTypes - DEFAULT_EDGE_DRIVE*/ THEN 7 /*enum AnalyticsEngineType - Edge_Drive*/
 		 WHEN EWA.systemDriveType = 4 /*enum EdgeSystemDriveTypes - NFS_OBJECT_STORE*/ THEN 13 /*enum AnalyticsEngineType - NFS_Index*/
 		ELSE 0 END
 	FROM	Deleted D
 			LEFT OUTER JOIN APP_Application A WITH (NOLOCK) ON D.appId = A.id
 			LEFT OUTER JOIN AppEdgeDriveWebserverAssociation EWA WITH (NOLOCK) ON A.ClientId = EWA.edgeClientId
 	WHERE D.flags & 32768 /*CVA_AF_EDGE_DRIVE_FLAG*/ > 0
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFile_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFile_AfterDel' AND revision = '1.15.2.9')

  insert into GXDBVersions values(6, 'archFile_AfterDel',  '1.15.2.9', 'archFile_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

