

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFileCopy_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFileCopy_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFileCopy_AfterDel]
  delete from GXDBVersions where name = 'archFileCopy_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFileCopy_AfterDel
 	ON archFileCopy
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archFileCopyPruningLogs (archFileId, commCellId, archCopyId, isValid, flags, modifiedTime, pruneTime, processId, AgedBy)
		SELECT D.archFileId, D.commCellId, D.archCopyId, D.isValid, D.flags, D.modifiedTime, @currentTime, @fromProcessId, D.AgedBy
		FROM Deleted D
 	--
		IF EXISTS (SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY' AND value = 1)
		BEGIN
			INSERT INTO archContentIndexingAged([archFileId], [commCellId], [cloudId], [appId], [pruneType], [agedFlag], [jobId])
			SELECT D.archFileId, D.commCellId, AF.cloudId, AF.appId,
						 (CASE A.appTypeId WHEN 67 	/*CV_APPTYPE_MS_EXCHANGE_ARCHIVER*/
															 THEN 1 	/*CVA_AGEDCI_PRUNETYPE_AFILE_ONLY*/
					 										 ELSE 3  	/*CVA_AGEDCI_PRUNETYPE_AFILE_AGEDOUT*/
						 END), 0, AF.jobId
			FROM Deleted D, archFile AF WITH (NOLOCK), APP_Application A WITH (NOLOCK), archContentIndexingRules CI WITH (NOLOCK)
			WHERE D.archFileId = AF.id
			AND		D.commCellId = AF.commCellId
			AND		AF.appId = A.id
			AND		AF.archGroupId = CI.archGroupId
			AND		D.archCopyId = CI.sourceCopyId
			AND		AF.cloudId > 0
			AND 	(AF.flags & 240 /* CVA_AF_CI_BITMAP */) > 0
 		--
			DELETE archContentIndexingSecondary
			FROM 	 archContentIndexingSecondary S, Deleted D, archFile AF WITH (NOLOCK), archContentIndexingRules CI WITH (NOLOCK)
			WHERE	 S.archFileId = D.archFileId
			AND		 S.commCellId = D.commCellId
			AND		 D.archFileId = AF.id
			AND		 D.commCellId = AF.commCellId
			AND		 AF.archGroupId = CI.archGroupId
			AND		 D.archCopyId = CI.sourceCopyId
		END
 	--
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFileCopy_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFileCopy_AfterDel' AND revision = '1.3.274.3')

  insert into GXDBVersions values(6, 'archFileCopy_AfterDel',  '1.3.274.3', 'archFileCopy_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

