

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archCopySIDBStoreUpdTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archCopySIDBStoreUpdTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archCopySIDBStoreUpdTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archCopySIDBStoreUpdTrigger]
  delete from GXDBVersions where name = 'archCopySIDBStoreUpdTrigger' and type = 6
END
GO

	CREATE TRIGGER archCopySIDBStoreUpdTrigger
	ON archCopySIDBStore
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
 	IF(UPDATE(flags)) AND EXISTS (SELECT 1
 		FROM archSubclientCopyDDBMap ASCM  INNER JOIN INSERTED ACS ON ACS.CopyId = ASCM.copyID AND ASCM.SIDBStoreId = ACS.SIDBStoreId
 		     	WHERE  ACS.flags & 4 = 0 )		-- IDX_COPY_DDB_ACTIVE
 	BEGIN
 	    RAISERROR ('Cannot seal the store as there are SubClients that are still associated to it' ,10,1)
 	    ROLLBACK TRANSACTION
 	END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archCopySIDBStoreUpdTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archCopySIDBStoreUpdTrigger' AND revision = '1.1.2.1')

  insert into GXDBVersions values(6, 'archCopySIDBStoreUpdTrigger',  '1.1.2.1', 'archCopySIDBStoreUpdTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

