

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunk_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunk_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunk_AfterDel]
  delete from GXDBVersions where name = 'archChunk_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunk_AfterDel
 	ON archChunk
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archChunkPruningLogs (chunkId, commCellId, flags, volumeId, mediaId, version, createTime, writeTime, modifiedTime, pruneTime, processId, AgedBy, physicalSize, logicalSize)
		SELECT D.id, D.commCellId, D.flags, D.VolumeId, isnull(V.MediaId, 0), D.version, D.createTime, D.writeTime, D.modifiedTime, @currentTime, @fromProcessId, D.AgedBy, D.physicalSize, D.logicalSize
		FROM Deleted D LEFT OUTER JOIN MMVolume V WITH (NOLOCK) ON V.VolumeId = D.VolumeId

		UPDATE archChunkToSilo
		SET flags = (archChunkToSilo.flags | 1)
		FROM Deleted D
		WHERE archChunkToSilo.archChunkId = D.id AND archChunkToSilo.commCellId = D.commCellId
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunk_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunk_AfterDel' AND revision = '1.6.210.2')

  insert into GXDBVersions values(6, 'archChunk_AfterDel',  '1.6.210.2', 'archChunk_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

