

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunkToVerify_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunkToVerify_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunkToVerify_AfterDel]
  delete from GXDBVersions where name = 'archChunkToVerify_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunkToVerify_AfterDel
 	ON archChunkToVerify
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO archChunkToVerifyHistory(
			adminJobId, appId, backupJobId, archChunkId, archFileId, commCellId,
			archCopyId, streamNum, fileType, archFileCopyFlags, lastChunkNumber, chunkNumber,
			physicalOffset, logicalOffset, physicalSize, logicalSize, volumeId, mediaId, mediaGroupId,
			fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey,
			extraFlags, segmentId, unCompBytesSize, processId, modifiedTime, reservedStr, srcMAId)
		SELECT	D.adminJobId, D.appId, D.backupJobId, D.archChunkId, D.archFileId, D.commCellId,
			D.archCopyId, D.streamNum, D.fileType, D.archFileCopyFlags, D.lastChunkNumber, D.chunkNumber,
			D.physicalOffset, D.logicalOffset, D.physicalSize, D.logicalSize, D.volumeId, D.mediaId, D.mediaGroupId,
			D.fileMarkerNo, D.chunkCreateTime, D.chunkVersion, D.chunkPhysicalSize, D.chunkLogicalSize, D.chunkHwEncKey,
			0 /*D.extraFlags*/, D.segmentId, D.unCompBytesSize, @fromProcessId, @currentTime, N'', D.srcMAId
		FROM	Deleted D LEFT OUTER JOIN archChunkToVerifyHistory H
					ON	D.adminJobId = H.adminJobId
						AND D.archCopyId = H.archCopyId
						AND D.archFileId = H.archFileId
						AND D.commCellId = H.commCellId
						AND D.archChunkId = H.archChunkId
		WHERE H.adminJobId IS NULL
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunkToVerify_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunkToVerify_AfterDel' AND revision = '1.3.50.2')

  insert into GXDBVersions values(6, 'archChunkToVerify_AfterDel',  '1.3.50.2', 'archChunkToVerify_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

