

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMUsersTrigger_Upd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMUsersTrigger_Upd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMUsersTrigger_Upd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMUsersTrigger_Upd]
  delete from GXDBVersions where name = 'UMUsersTrigger_Upd' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER UMUsersTrigger_Upd
ON  dbo.UMUsers
AFTER UPDATE
AS
BEGIN
	SET NOCOUNT ON
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
	-- When we resurrect deleted users, we should tag them with respective company.
	-- There are too many code paths, so adding a trigger to do the job.
	IF OBJECT_ID('tempdb.dbo.#RecreatedUsersTbl_UpdateUsers') IS NOT NULL
		DROP TABLE #RecreatedUsersTbl_UpdateUsers
	CREATE TABLE #RecreatedUsersTbl_UpdateUsers
	(
		userId INT PRIMARY KEY,
		umdsProviderId INT
	)
	INSERT INTO #RecreatedUsersTbl_UpdateUsers
		SELECT DISTINCT
			I.id,
			I.umDSproviderId
		FROM deleted D
			INNER JOIN inserted I
				ON D.id = I.id AND D.flags = 0 AND (I.flags & 1 = 1)
		WHERE I.umdsProviderId > 0
	IF @@ROWCOUNT > 0
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#CompanyUser_UsersTrigger') IS NOT NULL
			DROP TABLE #CompanyUser_UsersTrigger
		CREATE TABLE #CompanyUser_UsersTrigger
		(
			companyId INT,
			userId INT PRIMARY KEY
		)
		INSERT INTO #CompanyUser_UsersTrigger
			SELECT DISTINCT					-- Logic taken from AppGetOrganizationForUser.func
						CASE UD.serviceType
							 WHEN 5 /*UMDS_PROVIDER_ORGANIZATIONS*/ THEN UD.id
							 WHEN 2 /*UMDS_PROVIDER_ACTIVE_DIR*/ THEN UD.ownerCompany
							 WHEN 12 /*UMDS_PROVIDER_DUMMY*/ THEN UD.ownerCompany
							 ELSE 0
					 END,
					I.userId
				FROM #RecreatedUsersTbl_UpdateUsers I
					INNER JOIN UMDSProviders UD (NOLOCK)
						ON UD.id = I.umdsProviderId
				WHERE
					I.umdsProviderID > 0
		IF @@ROWCOUNT <> 0
		BEGIN
			-- Update entry, if it is already present.
			UPDATE ACE
			SET companyId = T.companyId
			FROM APP_CompanyEntities ACE
				INNER JOIN #CompanyUser_UsersTrigger T
					ON ACE.entityType = 13 /*USER_ENTITY*/ AND ACE.entityId = T.userId
			WHERE ACE.companyId <> T.companyId
			-- Insert entry, if it is not already present.
			INSERT INTO APP_CompanyEntities (companyId, entityType, entityId, created)
				SELECT T.companyId, 13 /*USER_ENTITY*/, T.userId, @currentTime
				FROM #CompanyUser_UsersTrigger T
					LEFT JOIN APP_CompanyEntities ACE (NOLOCK)
						ON T.companyId = ACE.companyId AND ACE.entityType = 13 /*USER_ENTITY*/ AND ACE.entityId = T.userID
				WHERE (T.companyId > 0) AND (ACE.entityId IS NULL)
		END
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMUsersTrigger_Upd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMUsersTrigger_Upd' AND revision = '')

  insert into GXDBVersions values(6, 'UMUsersTrigger_Upd',  '', 'UMUsersTrigger_Upd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

