

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMUsersTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMUsersTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMUsersTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMUsersTrigger]
  delete from GXDBVersions where name = 'UMUsersTrigger' and type = 6
END
GO

		CREATE TRIGGER UMUsersTrigger
		ON  dbo.UMUsers
		AFTER INSERT
		AS
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		DECLARE @sParam XML
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())


		DECLARE @addedUpdatedList TABLE(userId INTEGER,providerId INTEGER,PRIMARY KEY(userId,providerId))
		INSERT INTO @addedUpdatedList
		SELECT id,umDSproviderId FROM inserted WHERE umDSproviderId <> 0
		--Remove provider for which additional settings is not set
		DELETE FROM @addedUpdatedList
		WHERE providerId <> 0 AND NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE entityType = 61 and entityId = providerId)


		IF EXISTS( SELECT 1 FROM @addedUpdatedList)
		BEGIN
			SET @sParam = ( SELECT 13 as 'entity/@_type_',userId as 'entity/@userId',
							(SELECT
							61 as '@_type_',
							providerId as '@providerId'
							FROM @addedUpdatedList
							WHERE userId = addedUpdated.userId
							FOR XML PATH('addedList'),TYPE
							)
						FROM (SELECT DISTINCT userId FROM @addedUpdatedList) addedUpdated
						FOR XML PATH('assocChangeInfoList'),ROOT('App_UserAndUserGroupAssocWorkQueueParam')
					  )

			IF @sParam IS NOT NULL
			BEGIN
				--WORK_TOKEN_REFRESH_USER_ADDITIONAL_SETTINGS
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT 2, 24, CONVERT(NVARCHAR(MAX),@sParam), @currentTime, 0, 0, 0, -1
			END
		END
		-- Tagging all of them correctly with the company. There are lot of code points, from where we Insert into UMUsers.
		-- (New AD user login, Discovery protocol, System created user accounts, etc.) So adding in trigger to do the job.
		IF OBJECT_ID('tempdb.dbo.#CompanyUser_UsersTrigger') IS NOT NULL
			DROP TABLE #CompanyUser_UsersTrigger
		CREATE TABLE #CompanyUser_UsersTrigger
		(
			companyId INT,
			userId INT PRIMARY KEY
		)
		INSERT INTO #CompanyUser_UsersTrigger (companyId, userId)
			SELECT DISTINCT				-- Logic taken from AppGetOrganizationForUser.func
					CASE UD.serviceType
                         WHEN 5 /*UMDS_PROVIDER_ORGANIZATIONS*/ THEN UD.id
                         WHEN 2 /*UMDS_PROVIDER_ACTIVE_DIR*/ THEN UD.ownerCompany
                         WHEN 12 /*UMDS_PROVIDER_DUMMY*/ THEN UD.ownerCompany
                         ELSE 0
                 END,
					I.id
			FROM inserted I
				INNER JOIN UMDSProviders UD (NOLOCK)
					ON UD.id = I.umdsProviderId
			WHERE
				I.umdsProviderID > 0
		IF @@ROWCOUNT <> 0
			INSERT INTO APP_CompanyEntities (companyId, entityType, entityId, created)
				SELECT T.companyId, 13 /*USER_ENTITY*/, T.userId, @currentTime
				FROM #CompanyUser_UsersTrigger T
					LEFT JOIN APP_CompanyEntities ACE (NOLOCK)
						ON T.companyId = ACE.companyId AND ACE.entityType = 13 /*USER_ENTITY*/ AND ACE.entityId = T.userID
				WHERE (T.companyId > 0) AND (ACE.entityId IS NULL)

		SET NOCOUNT OFF;
		END
		GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMUsersTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMUsersTrigger' AND revision = '')

  insert into GXDBVersions values(6, 'UMUsersTrigger',  '', 'UMUsersTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

