

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMUserGroupTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMUserGroupTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMUserGroupTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMUserGroupTrigger]
  delete from GXDBVersions where name = 'UMUserGroupTrigger' and type = 6
END
GO

		CREATE TRIGGER UMUserGroupTrigger
		ON  dbo.UMUserGroup
		AFTER INSERT,DELETE
		AS
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		DECLARE @sParam XML
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())


		DECLARE @addedDeletedList TABLE(userId INTEGER, userGroupId INTEGER, ops INTEGER,PRIMARY KEY(userId, userGroupId, ops) )
		INSERT INTO @addedDeletedList
		SELECT userId,groupId,0 as ops FROM inserted ins INNER JOIN UMGroups WITH(NOLOCK)  ON ins.groupId = UMGroups.id
			UNION
		SELECT userId,umGroupId, 0 as ops FROM UMDSGroupMaps WITH(NOLOCK) INNER JOIN inserted ins ON UMDSGroupMaps.umDSgroupId = ins.groupId
			UNION
		SELECT userId,groupId,1 as ops FROM deleted del INNER JOIN UMGroups WITH(NOLOCK)  ON del.groupId = UMGroups.id
			UNION
		SELECT userId,umGroupId,1 as ops FROM UMDSGroupMaps WITH(NOLOCK) INNER JOIN deleted del ON UMDSGroupMaps.umDSgroupId = del.groupId

		IF EXISTS(SELECT 1 FROM @addedDeletedList)
		BEGIN
			SET @sParam = ( SELECT 13 as 'entity/@_type_',userId as 'entity/@userId',
							(SELECT
							15 as '@_type_',
							userGroupId as '@userGroupId'
							FROM @addedDeletedList
							WHERE ops = 0 AND userId = addedDeleted.userId
							FOR XML PATH('addedList'),TYPE
							),
							(SELECT
							15 as '@_type_',
							userGroupId as '@userGroupId'
							FROM @addedDeletedList
							WHERE ops = 1 AND userId = addedDeleted.userId
							FOR XML PATH('deletedList'),TYPE
							)
						FROM (SELECT DISTINCT userId FROM @addedDeletedList) addedDeleted
						FOR XML PATH('assocChangeInfoList'),ROOT('App_UserAndUserGroupAssocWorkQueueParam')
					  )

			IF @sParam IS NOT NULL
			BEGIN
				--WORK_TOKEN_REFRESH_USER_ADDITIONAL_SETTINGS
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT id, 24, CONVERT(NVARCHAR(MAX),@sParam), @currentTime, 0, 0, 0, -1 FROM APP_Client WHERE id = 2
			END
			INSERT INTO UMUserGroupAssocTriggerRows (userGroupId, userId, createdTime, operationType)
			select 	userGroupId, userId , @currentTime,case when ops=0 then 2 else 3 end
			from @addedDeletedList
		END

		SET NOCOUNT OFF;
		END
		GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMUserGroupTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMUserGroupTrigger' AND revision = '')

  insert into GXDBVersions values(6, 'UMUserGroupTrigger',  '', 'UMUserGroupTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

