

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMSecurityAssociations_AfterInsUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMSecurityAssociations_AfterInsUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMSecurityAssociations_AfterInsUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMSecurityAssociations_AfterInsUpd]
  delete from GXDBVersions where name = 'UMSecurityAssociations_AfterInsUpd' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER UMSecurityAssociations_AfterInsUpd
ON dbo.UMSecurityAssociations
AFTER INSERT,UPDATE
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- Updating the company ID when new entry gets added
	-- Rewriting this trigger on SP18, as there was a deadlock issue that happened when multiple sessions
	-- were trying to Insert / Update entries into Security associations table.
	-- Using a table variable is itself enough. Most of the Insert / Update statements have only one entry.
	DECLARE @UGCompanyIdTbl TABLE
	(
		securityId INT PRIMARY KEY,			-- Id corresponding to PK of Security associations table.
		isUser INT,
		userOrgroupId INT,
		companyId INT
	)
	INSERT INTO @UGCompanyIdTbl
		SELECT securityId,
				isUser,
				userOrGroupId,
				CASE WHEN P.serviceType = 5 THEN P.id
					WHEN P.ownerCompany <> 0 THEN P.ownerCompany
					ELSE 0
				END
		FROM inserted I
			INNER JOIN UMUsers U (NOLOCK)
				ON I.isUser = 1 AND I.userOrGroupId = U.id
			INNER JOIN UMDSProviders P (NOLOCK)
				ON U.umdsProviderId = P.id
		WHERE
			I.companyId = 0	AND (P.serviceType = 5 OR P.ownerCompany <> 0)
		UNION ALL
		SELECT securityId,
				isUser,
				userOrGroupId,
				CASE WHEN P.serviceType = 5 THEN P.id
					WHEN P.ownerCompany <> 0 THEN P.ownerCompany
					ELSE 0
				END
		FROM inserted I
			INNER JOIN UMGroups G (NOLOCK)
				ON I.isUser = 0 AND I.userOrGroupId = G.id
			INNER JOIN UMDSProviders P (NOLOCK)
				ON G.umdsProviderId = P.id
		WHERE
			I.companyId = 0	AND (P.serviceType = 5 OR P.ownerCompany <> 0)
	-- The Update statement uses the PK directly to identify the rows that are modified and to be updated with correct company Id.
	-- This is very faster compared to previous version, which was using all the individual columns to compare and identify
	-- the rows to be updated.
	-- Adding isUser and userOrgroupId also to the JOIN condition, so that the clustered index is used.
	-- Without that on precert machine, the statement was doing a CI scan resulting in ~7100 rows to process.
	-- With that, the statement is fast and does a CI seek.
	IF EXISTS (SELECT TOP 1 1 FROM @UGCompanyIdTbl)
	UPDATE Sec
	SET companyID = UGCT.companyId
	FROM UMSecurityAssociations Sec
		INNER JOIN @UGCompanyIdTbl UGCT
			ON UGCT.securityId = Sec.securityId
			AND UGCT.isUser = Sec.isUser
			AND UGCT.userOrGroupId = Sec.userOrGroupId
	WHERE
		UGCT.companyId <> Sec.companyId				-- Update only those rows if needed. Reduces the no. of Write operations.
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMSecurityAssociations_AfterInsUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMSecurityAssociations_AfterInsUpd' AND revision = '')

  insert into GXDBVersions values(6, 'UMSecurityAssociations_AfterInsUpd',  '', 'UMSecurityAssociations_AfterInsUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

