

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMRolesCapabilityBitMask.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMRolesCapabilityBitMask'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMRolesCapabilityBitMask]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMRolesCapabilityBitMask]
  delete from GXDBVersions where name = 'UMRolesCapabilityBitMask' and type = 6
END
GO

 GO
 SET QUOTED_IDENTIFIER ON
 GO
	CREATE TRIGGER UMRolesCapabilityBitMask
 	ON UMRolesWithPermissionsExpanded
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN

		SET NOCOUNT ON

		UPDATE UMRoles
		SET capabilitiesBitMask =
										(
											SELECT ISNULL(CAST(SUM(POWER(2.0,permissionId-1)) AS BIGINT),0)
											FROM UMRolesWithPermissionsExpanded (NOLOCK) R1
											WHERE
												R1.roleID = R.id AND R1.permissionId < 64
										)
		FROM
		(
			SELECT roleId AS id
			FROM inserted
			UNION
			SELECT roleID AS id
			FROM deleted
		) R
		WHERE UMRoles.id = R.id
		DECLARE @permissionsSeed VARCHAR(512) = REPLICATE('0',512)			-- PERMISSIONS_BIT_MASK_LENGTH
		UPDATE UMRoles
		SET permissionsString =
									(
										SELECT dbo.bitwiseOrString(STUFF(@permissionsSeed,permissionId,1,'1'))
										FROM UMRolesWithPermissionsExpanded (NOLOCK) R1
										WHERE
											R1.roleID = R.id
									)
		FROM
		(
			SELECT roleId AS id
			FROM inserted
			UNION
			SELECT roleID AS id
			FROM deleted
		) R
		WHERE UMRoles.id = R.id
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMRolesCapabilityBitMask]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMRolesCapabilityBitMask' AND revision = '')

  insert into GXDBVersions values(6, 'UMRolesCapabilityBitMask',  '', 'UMRolesCapabilityBitMask', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

