

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMGroupsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMGroupsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMGroupsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMGroupsTrigger]
  delete from GXDBVersions where name = 'UMGroupsTrigger' and type = 6
END
GO

		CREATE TRIGGER UMGroupsTrigger
		ON  dbo.UMGroups
		AFTER INSERT, UPDATE
		AS
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		DECLARE @canNotSeePeers INT = 1
		SELECT TOP 1 @canNotSeePeers = CAST(value AS INT)
		FROM GXGlobalParam (NOLOCK)
		WHERE name = 'CanNotSeePeers' AND modified = 0
		IF @canNotSeePeers = 0
		BEGIN
			DECLARE @viewroleId INT = (SELECT id FROM UMROles (NOLOCK) WHERE name = 'View' AND flags & (1 | 2) <> 0)
			IF @viewroleid <> 0
			BEGIN
				--for new user groups(local and AD), we need to add the user group - view - user group association always
				INSERT INTO UMSecurityAssociations (roleId, userOrGroupId, isUser, entityTYpe1, entityId1, authorId)
					SELECT @viewroleId, id, 0, 15 /*USERGROUP_ENTITY*/, id, 1
					FROM inserted I
					WHERE id NOT IN (SELECT id FROM deleted)
					AND NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE userOrGroupid = I.id AND isUser = 0 AND roleId = @viewRoleId AND entityTYpe1 = 15/*USERGROUP_ENTITY*/ AND entityID1 = I.id)
				--for AD user groups that are re-created, we need to add the user group - view - user group associations
				INSERT INTO UMSecurityAssociations (roleId, userOrGroupId, isUser, entityType1, entityId1, authorId)
					SELECT @viewRoleId, id, 0, 15/*USERGROUP_ENTITY*/, id, 1
					FROM inserted I
					WHERE id IN (SELECT id FROM deleted WHERE groupFlags & 0x001/*GF_GROUP_ENABLED*/ = 0)
					AND groupFlags & 0x001/*GF_GROUP_ENABLED*/ <> 0
					AND umdsProviderId <> 0
					AND NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE userOrGroupid = I.id AND isUser = 0 AND roleId = @viewRoleId AND entityTYpe1 = 15/*USERGROUP_ENTITY*/ AND entityID1 = I.id)
			END
		END

		IF EXISTS(SELECT * FROM inserted) AND  NOT EXISTS(SELECT * FROM deleted) -- Push work queue token for only "INSERT" operation.
		BEGIN
			DECLARE @sParam XML
			DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())

			DECLARE @addedUpdatedList TABLE(userGroupId INTEGER,companyId INTEGER,PRIMARY KEY(userGroupId,companyId))
			INSERT INTO @addedUpdatedList
			SELECT I.id,I.umdsProviderId FROM inserted I
			INNER JOIN UMDSProviders UMDSP ON UMDSP.id = I.umdsProviderId AND UMDSP.serviceType = 5
			WHERE I.umdsProviderId <> 0
			--Remove company for which additional settings is not set
			DELETE FROM @addedUpdatedList
			WHERE companyId <> 0 AND NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE entityType = 189 and entityId = companyId)

			IF EXISTS( SELECT 1 FROM @addedUpdatedList)
			BEGIN
				SET @sParam = ( SELECT 15 as 'entity/@_type_',userGroupId as 'entity/@userGroupId',
					            (SELECT
						        189 as '@_type_',
							    companyId as '@companyId'
								FROM @addedUpdatedList
								WHERE userGroupId = addedUpdated.userGroupId
								FOR XML PATH('addedList'),TYPE
								)
							FROM (SELECT DISTINCT userGroupId FROM @addedUpdatedList) addedUpdated
							FOR XML PATH('assocChangeInfoList'),ROOT('App_UserAndUserGroupAssocWorkQueueParam')
						)

			    IF @sParam IS NOT NULL
				BEGIN
					--WORK_TOKEN_REFRESH_USER_ADDITIONAL_SETTINGS
					INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
					SELECT 2, 62, CONVERT(NVARCHAR(MAX),@sParam), @currentTime, 0, 0, 0, -1
				END
			END
		END

		SET NOCOUNT OFF;

		END
		GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMGroupsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMGroupsTrigger' AND revision = '')

  insert into GXDBVersions values(6, 'UMGroupsTrigger',  '', 'UMGroupsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

