SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_Client_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_Client_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_Client_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_Client_AfterUpd]
  delete from GXDBVersions where name = 'APP_Client_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER APP_Client_AfterUpd
	ON APP_Client AFTER UPDATE
	AS
	SET NOCOUNT ON
	BEGIN
	IF @@ROWCOUNT > 0 AND UPDATE(net_hostname)
	BEGIN
		UPDATE edcClientNameMap
			SET gxMachineHostName = I.net_hostname
			FROM edcClientNameMap e, inserted I, deleted D
		WHERE
			e.gxMachineHostName = D.net_hostname AND D.id = I.id
	END

	--Insert client upgrade Time
	IF UPDATE(releaseId)
	BEGIN
		DECLARE @currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
		BEGIN
			MERGE APP_CLIENTPROP P
			USING
			(
				SELECT i.id
				FROM
				INSERTED i JOIN DELETED d
				ON i.id = d.id and i.releaseId <> d.releaseId

			) AS T ON T.id = P.componentnameId AND P.attrName = 'Client Upgrade Time'
			WHEN MATCHED  THEN
				UPDATE SET attrval = @currentTime
			WHEN NOT MATCHED  THEN
				INSERT (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
				VALUES (T.id,'Client Upgrade Time',2,@currentTime,@currentTime,0,0);
		END
	END
	SET NOCOUNT OFF
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_Client_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_Client_AfterUpd' AND revision = '1.5')

  insert into GXDBVersions values(6, 'APP_Client_AfterUpd',  '1.5', 'APP_Client_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMSecurityAssociationsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMSecurityAssociationsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMSecurityAssociationsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMSecurityAssociationsTrigger]
  delete from GXDBVersions where name = 'UMSecurityAssociationsTrigger' and type = 6
END
GO

		CREATE TRIGGER UMSecurityAssociationsTrigger
		ON  dbo.UMSecurityAssociations
		AFTER INSERT, UPDATE
		AS
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		-- Insert statements for trigger here
		IF EXISTS (SELECT 1
			      		FROM UMSecurityAssociations Sec
					  GROUP BY Sec.roleId, Sec.permissionId, Sec.userOrGroupId, Sec.isUser, Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityID3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityID5, Sec.isCreator
					  HAVING COUNT(*) > 1)
		BEGIN
			RAISERROR('Cannot insert duplicate entity - role - user / group', 16, 7)
			ROLLBACK TRAN
		END
		SET NOCOUNT OFF;
		END
		GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMSecurityAssociationsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMSecurityAssociationsTrigger' AND revision = '')

  insert into GXDBVersions values(6, 'UMSecurityAssociationsTrigger',  '', 'UMSecurityAssociationsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientOnDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientOnDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientOnDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientOnDelete]
  delete from GXDBVersions where name = 'APP_ClientOnDelete' and type = 6
END
GO

	CREATE TRIGGER App_ClientOnDelete
	ON APP_Client
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		SET NOCOUNT ON
		DECLARE @nowTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
		INSERT INTO APP_ClientHistory (id, name, simOperatingSystemId, net_hostname, clientDescription, releaseId, origCCId, GUID, displayName, deletedTime)
		SELECT id, name, simOperatingSystemId, net_hostname, clientDescription, releaseId, origCCId, GUID, displayName, @nowTime
		FROM DELETED
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientOnDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientOnDelete' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_ClientOnDelete',  '1.1', 'APP_ClientOnDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNMMDriveHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNMMDriveHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMDriveHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNMMDriveHistoryTrigger]
  delete from GXDBVersions where name = 'CNMMDriveHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER	CNMMDriveHistoryTrigger
	ON 		MMDriveHistory
	INSTEAD OF INSERT
	AS
	BEGIN
		DECLARE @CurrentUTCDate	datetime
		DECLARE @DiffSeconds	int
		DECLARE @DriveID  int
		DECLARE @ClientID  int
		DECLARE @TimeStart  datetime
		DECLARE @DataWritten int
		DECLARE @DataRead    int
		DECLARE @NumberOfMounts	int
		DECLARE @NumberOfCleans	int
		DECLARE @NumberOfSoftErrors	int
		DECLARE @NumberOfHardErrors	int
		DECLARE @DataWriteDurationSec int
		DECLARE @DataReadDurationSec	int
		DECLARE @NumberOfBackups	int
		DECLARE @NumberOfRestores	int
		DECLARE @KeepMagInfoHourlyOnly	int
		SET NOCOUNT ON
       SELECT    @CurrentUTCDate = (CASE ClientID WHEN  0 THEN TimeStart ELSE GetUTCDate() END )
       FROM Inserted
		SELECT @DriveID = DriveID,
		       @ClientID = ClientID,
		       @TimeStart = CASE WHEN I.DataWriteDurationSec > 0 THEN dbo.GetHourStart(dateadd(second, -I.DataWriteDurationSec, @CurrentUTCDate))
									WHEN I.DataReadDurationSec > 0 THEN dbo.GetHourStart(dateadd(second, -I.DataReadDurationSec, @CurrentUTCDate))
									ELSE dbo.GetHourStart(@CurrentUTCDate)
								  END,
		       @DataWritten = DataWritten,
		       @DataRead = DataRead,
		       @NumberOfMounts 	= NumberOfMounts,
		       @NumberOfCleans	= NumberOfCleans,
		       @NumberOfSoftErrors	= NumberOfSoftErrors,
		       @NumberOfHardErrors	= NumberOfHardErrors,
		       @DataWriteDurationSec	= DataWriteDurationSec,
		       @DataReadDurationSec	= DataReadDurationSec,
		       @NumberOfBackups	= NumberOfBackups,
		       @NumberOfRestores	= NumberOfRestores,
		       @KeepMagInfoHourlyOnly = KeepMagInfoHourlyOnly
		FROM Inserted I
		IF EXISTS
			(SELECT *
	 		 FROM MMDriveHistory DH
			 WHERE DH.DriveID 		= @DriveID
				and DH.ClientId		= @ClientId
				and DH.HistoryType 	= 1
				and DH.TimeStart 	   = @TimeStart)
		BEGIN
			UPDATE 	MMDriveHistory
			SET	NumberOfMounts		= MMDriveHistory.NumberOfMounts + @NumberOfMounts,
				NumberOfCleans		= MMDriveHistory.NumberOfCleans + @NumberOfCleans,
				NumberOfSoftErrors	= MMDriveHistory.NumberOfSoftErrors + @NumberOfSoftErrors,
				NumberOfHardErrors	= MMDriveHistory.NumberOfHardErrors + @NumberOfHardErrors,
				DataWritten		= MMDriveHistory.DataWritten + @DataWritten,
				DataRead		= MMDriveHistory.DataRead + @DataRead,
				DataWriteDurationSec	= MMDriveHistory.DataWriteDurationSec + @DataWriteDurationSec,
				DataReadDurationSec	= MMDriveHistory.DataReadDurationSec + @DataReadDurationSec,
				NumberOfBackups		= MMDriveHistory.NumberOfBackups + @NumberOfBackups,
				NumberOfRestores	= MMDriveHistory.NumberOfRestores + @NumberOfRestores,
				Modified		= GetUTCDate()
			WHERE 	    MMDriveHistory.DriveID 		= @DriveID
				and MMDriveHistory.ClientId 		= @ClientId
				and MMDriveHistory.HistoryType	= 1
				and MMDriveHistory.TimeStart 		= @TimeStart
		END
		ELSE
		BEGIN
			INSERT INTO MMDriveHistory
			SELECT	@DriveID, @ClientId,
				1, HourStartDate = @TimeStart,
				@NumberOfMounts, @NumberOfCleans, @NumberOfSoftErrors, @NumberOfHardErrors,
				@DataWritten, @DataRead, @NumberOfBackups, @NumberOfRestores,
				Modified = GetUTCDate(), @DataWriteDurationSec, @DataReadDurationSec,
				15, @KeepMagInfoHourlyOnly
		END
		INSERT INTO MMDriveHistory
		SELECT	@DriveID, @ClientId,
			2, @CurrentUTCDate,
			0, 0, 0, 0,
			@DataWritten, @DataRead, 0, 0,
			Modified = GetUTCDate(), @DataWriteDurationSec, @DataReadDurationSec,
			15, @KeepMagInfoHourlyOnly
		WHERE	(@DataWritten > 0 OR @Dataread > 0)
		AND 	NOT EXISTS
			(SELECT *
	 		 FROM MMDriveHistory DH
			 WHERE 	    DH.DriveID 		= @DriveID
				and DH.ClientId		= @ClientId
				and DH.HistoryType 	= 2
				and DH.TimeStart 	= @CurrentUTCDate)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNMMDriveHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNMMDriveHistoryTrigger' AND revision = '1.23')

  insert into GXDBVersions values(6, 'CNMMDriveHistoryTrigger',  '1.23', 'CNMMDriveHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNMMLibraryHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNMMLibraryHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNMMLibraryHistoryTrigger]
  delete from GXDBVersions where name = 'CNMMLibraryHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER	CNMMLibraryHistoryTrigger
	ON 		MMLibraryHistory
	INSTEAD OF INSERT
	AS
	BEGIN
		DECLARE @HourStartDate	datetime
		DECLARE @DiffSeconds	int
		DECLARE @LibraryID		int
		DECLARE @NumberOfSoftErrors	int
		DECLARE @NumberOfHardErrors	int
		DECLARE @NumberOfMediaUsed	int
		DECLARE @NumberOfMediaFreed	int
		DECLARE @DataWritten		bigint
		DECLARE @DataRead		bigint
		DECLARE @NumberOfBackups	int
		DECLARE @NumberOfRestores	int
		DECLARE @CapacityFreedMB	bigint
		DECLARE @TimeStart	datetime
		DECLARE @HistoryType	int
		SELECT
			@LibraryID		= I.LibraryID,
			@NumberOfSoftErrors	= I.NumberOfSoftErrors,
			@NumberOfHardErrors	= I.NumberOfHardErrors,
			@NumberOfMediaUsed	= I.NumberOfMediaUsed,
			@NumberOfMediaFreed	= I.NumberOfMediaFreed,
			@DataWritten		= I.DataWritten,
			@DataRead		= I.DataRead,
			@NumberOfBackups	= I.NumberOfBackups,
			@NumberOfRestores	= I.NumberOfRestores,
			@CapacityFreedMB	= I.CapacityFreedMB
		FROM 	Inserted I
		SET NOCOUNT ON
		SELECT @HistoryType=HistoryType, @TimeStart=TimeStart FROM Inserted
		IF @HistoryType = 10
		BEGIN
		  SET @HourStartDate = @TimeStart
		END
	    ELSE
		BEGIN
		SET @HourStartDate  = GetUTCDate()
		END
		SET @HourStartDate = dbo.GetHourStart(@HourStartDate)
		IF 	EXISTS
			(SELECT *
	 		 FROM MMLibraryHistory   MH
			 WHERE 	    MH.LibraryID 	= @LibraryID
				and HistoryType 	= 1
				and TimeStart 		= @HourStartDate)
		BEGIN
			UPDATE 	MMLibraryHistory
			SET	NumberOfSoftErrors	= MMLibraryHistory  .NumberOfSoftErrors + @NumberOfSoftErrors,
				NumberOfHardErrors	= MMLibraryHistory  .NumberOfHardErrors + @NumberOfHardErrors,
				NumberOfMediaUsed	= MMLibraryHistory  .NumberOfMediaUsed + @NumberOfMediaUsed,
				NumberOfMediaFreed	= MMLibraryHistory  .NumberOfMediaFreed + @NumberOfMediaFreed,
				DataWritten		= MMLibraryHistory  .DataWritten + @DataWritten,
				DataRead		= MMLibraryHistory  .DataRead + @DataRead,
				NumberOfBackups		= MMLibraryHistory  .NumberOfBackups + @NumberOfBackups,
				NumberOfRestores	= MMLibraryHistory  .NumberOfRestores + @NumberOfRestores,
				CapacityFreedMB	= MMLibraryHistory  .CapacityFreedMB + @CapacityFreedMB,
				Modified		= GetUTCDate()
			WHERE 	    MMLibraryHistory  .LibraryID 	= @LibraryID
				and MMLibraryHistory  .HistoryType	= 1
				and MMLibraryHistory  .TimeStart 	= @HourStartDate
		END
		ELSE
		BEGIN
			INSERT INTO MMLibraryHistory
			SELECT	@LibraryID,
				1, @HourStartDate,
				@NumberOfSoftErrors, @NumberOfHardErrors,
				@NumberOfMediaUsed, @NumberOfMediaFreed, @DataWritten, @DataRead,
				@NumberOfBackups, @NumberOfRestores, @CapacityFreedMB,
				Modified = GetUTCDate(),
				15
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNMMLibraryHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNMMLibraryHistoryTrigger' AND revision = '1.20')

  insert into GXDBVersions values(6, 'CNMMLibraryHistoryTrigger',  '1.20', 'CNMMLibraryHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNApplicationHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNApplicationHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNApplicationHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNApplicationHistoryTrigger]
  delete from GXDBVersions where name = 'CNApplicationHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER CNApplicationHistoryTrigger
	ON APP_Application
	FOR DELETE
	AS
	BEGIN
		DECLARE @DeletionTime		int
		SET NOCOUNT ON
		DELETE APP_Application
		FROM Deleted AS D
		WHERE APP_Application.ID = D.ID
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNApplicationHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNApplicationHistoryTrigger' AND revision = '1.21')

  insert into GXDBVersions values(6, 'CNApplicationHistoryTrigger',  '1.21', 'CNApplicationHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCopyCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCopyCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCopyCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCopyCoreTrigger]
  delete from GXDBVersions where name = 'ArchGroupCopyCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCopyCoreTrigger
 ON archGroupCopy
	AFTER UPDATE
	AS
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
	IF UPDATE (name)
	BEGIN
	      INSERT INTO ArchGroupCopyCoreHistory
	         (ArchGroupCopyId,
	         ArchGroupCopyName,
	         Modified)
		 SELECT
	            ins.id,
	            ins.name,
	            @CurrentUTCDate
	         FROM INSERTED ins
		 WHERE NOT EXISTS
			(SELECT * FROM ArchGroupCopyCoreHistory ACH
			 WHERE ins.id = ACH.ArchGroupCopyID AND @CurrentUTCDate = ACH.Modified)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCopyCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCopyCoreTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'ArchGroupCopyCoreTrigger',  '1.1', 'ArchGroupCopyCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCoreTrigger]
  delete from GXDBVersions where name = 'ArchGroupCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCoreTrigger
 ON archGroup
	AFTER UPDATE
	AS
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
	IF UPDATE (name)
	BEGIN
	      INSERT INTO ArchGroupCoreHistory
	         (ArchGroupId,
	         ArchGroupName,
	         Modified)
		 SELECT
	            ins.id,
	            ins.name,
	            @CurrentUTCDate
	         FROM INSERTED ins
		 WHERE NOT EXISTS
			(SELECT * FROM ArchGroupCoreHistory AH
			 WHERE ins.id = AH.ArchGroupID AND @CurrentUTCDate = AH.Modified)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCoreTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'ArchGroupCoreTrigger',  '1.1', 'ArchGroupCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCopyCoreInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCopyCoreInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCopyCoreInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCopyCoreInsTrigger]
  delete from GXDBVersions where name = 'ArchGroupCopyCoreInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCopyCoreInsTrigger
 ON archGroupCopy
	AFTER INSERT
	AS
	BEGIN
	      INSERT INTO ArchGroupCopyCoreHistory
	         (ArchGroupCopyId,
	         ArchGroupCopyName,
	         Modified)
		 SELECT
	            ins.id,
	            ins.name,
	            GetUTCDate()
	         FROM INSERTED ins
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCopyCoreInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCopyCoreInsTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'ArchGroupCopyCoreInsTrigger',  '1.1', 'ArchGroupCopyCoreInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCoreInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCoreInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCoreInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCoreInsTrigger]
  delete from GXDBVersions where name = 'ArchGroupCoreInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCoreInsTrigger
 ON archGroup
	AFTER INSERT
	AS
	BEGIN
	      INSERT INTO ArchGroupCoreHistory
	         (ArchGroupId,
	         ArchGroupName,
	         Modified)
		 SELECT
	            ins.id,
	            ins.name,
	            GetUTCDate()
	         FROM INSERTED ins
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCoreInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCoreInsTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'ArchGroupCoreInsTrigger',  '1.1', 'ArchGroupCoreInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntityMembersInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntityMembersInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntityMembersInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntityMembersInsTrigger]
  delete from GXDBVersions where name = 'BLEntityMembersInsTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntityMembersInsTrigger
	ON BLEntityMembers
	INSTEAD OF INSERT
	AS
	BEGIN
		SET NOCOUNT ON

		DECLARE @CreatedTime datetime
		DECLARE @DeletedTime datetime

		SET @CreatedTime = GetUTCDate()
		SET @DeletedTime = dbo.GetDateTime(0)

		UPDATE BLEntityMembersHistory
		SET DeletedTime = @CreatedTime,
			ModifiedTime = @CreatedTime,
			LogDeleted = 1
		FROM INSERTED AS I, BLEntityMembersHistory AS B1
		WHERE EntityGUID = B1.EntityGUID
			AND (B1.ClientID IN (I.ClientID, 0)
				OR I.ClientID = 0)
			AND (B1.AppTypeID IN (I.AppTypeID, 0)
				OR I.AppTypeID = 0)
			AND (B1.InstanceID IN (I.InstanceID, 0)
				OR I.InstanceID = 0)
			AND (B1.BackupSetID IN (I.BackupSetID, 0)
				OR I.BackupSetID = 0)
			AND (B1.AppID IN (I.AppID, 0)
				OR I.AppID = 0)
			AND B1.LogDeleted = 0
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)

		DELETE BLEntityMembers
		FROM INSERTED AS I, BLEntityMembers AS B1
		WHERE (B1.ClientID IN (I.ClientID, 0)
				OR I.ClientID = 0)
			AND (B1.AppTypeID IN (I.AppTypeID, 0)
				OR I.AppTypeID = 0)
			AND (B1.InstanceID IN (I.InstanceID, 0)
				OR I.InstanceID = 0)
			AND (B1.BackupSetID IN (I.BackupSetID, 0)
				OR I.BackupSetID = 0)
			AND (B1.AppID IN (I.AppID, 0)
				OR I.AppID = 0)
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)

		-- EntityID = 0 is invalid association, EntityID 1 is NoAssociation
		-- If it is one of these two then just the logical deletion above is sufficient.
		-- Add new Association into the table.
		INSERT INTO BLEntityMembers
		SELECT I.EntityID, I.AssocType, I.ClientID, I.AppTypeID,
			I.InstanceID, I.BackupSetID, I.AppID
		FROM INSERTED AS I
		WHERE I.EntityID NOT IN (0, 1)
		AND NOT EXISTS
		(
			SELECT *
			FROM INSERTED AS I1, BLEntityMembersHistory AS B2
			WHERE 	B2.EntityID = I1.EntityID
				AND B2.ClientID = I1.ClientID
				AND B2.AppTypeID = I1.AppTypeID
				AND B2.InstanceID = I1.InstanceID
				AND B2.BackupSetID = I1.BackupSetID
				AND B2.AppID = I1.AppID
				AND B2.LogDeleted = 0
		)

		-- Add new Association into the table.
		INSERT INTO BLEntityMembersHistory
		SELECT I.EntityID, BLE.EntityGUID, I.AssocType, I.ClientID, I.AppTypeID,
			I.InstanceID, I.BackupSetID,
			0, -- Log Deleted
			GetUTCDate(),
			dbo.GetDateTime(0),
			GetUTCDate(), I.AppID
		FROM INSERTED AS I, BLEntity AS BLE
		WHERE I.EntityID NOT IN (0, 1)
			AND BLE.EntityID = I.EntityID
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntityMembersInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntityMembersInsTrigger' AND revision = '1.10')

  insert into GXDBVersions values(6, 'BLEntityMembersInsTrigger',  '1.10', 'BLEntityMembersInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntityMembersDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntityMembersDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntityMembersDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntityMembersDelTrigger]
  delete from GXDBVersions where name = 'BLEntityMembersDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntityMembersDelTrigger
	ON BLEntityMembers
 INSTEAD OF DELETE
 AS
	BEGIN
		SET NOCOUNT ON
		UPDATE BLEntityMembersHistory
		SET BLEntityMembersHistory.DeletedTime = GetUTCDate(),
			BLEntityMembersHistory.ModifiedTime = GetUTCDate(),
			BLEntityMembersHistory.LogDeleted = 1
		FROM Deleted D
			INNER JOIN BLEntity as BLE
				ON BLE.EntityID = D.EntityID
		WHERE BLEntityMembersHistory.EntityGUID = BLE.EntityGUID
			AND BLEntityMembersHistory.ClientID IN (D.ClientID, 0)
			AND BLEntityMembersHistory.AppTypeID IN (D.AppTypeID, 0)
			AND BLEntityMembersHistory.InstanceID IN (D.InstanceID, 0)
			AND BLEntityMembersHistory.BackupSetID IN (D.BackupSetID, 0)
			AND BLEntityMembersHistory.AppID IN (D.AppID, 0)
			AND BLEntityMembersHistory.LogDeleted = 0
		DELETE BLEntityMembers
		FROM DELETED D
		WHERE	BLEntityMembers.EntityID = D.EntityID
			AND BLEntityMembers.ClientID = D.ClientID
			AND BLEntityMembers.AppTypeID = D.AppTypeID
			AND BLEntityMembers.InstanceID = D.InstanceID
			AND BLEntityMembers.BackupSetID = D.BackupSetID
			AND BLEntityMembers.AppID = D.AppID
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntityMembersDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntityMembersDelTrigger' AND revision = '1.7')

  insert into GXDBVersions values(6, 'BLEntityMembersDelTrigger',  '1.7', 'BLEntityMembersDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntityDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntityDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntityDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntityDelTrigger]
  delete from GXDBVersions where name = 'BLEntityDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntityDelTrigger ON BLEntity
	INSTEAD OF DELETE
	AS
	BEGIN
			DELETE BLEntityMembers
			FROM DELETED D
			WHERE	BLEntityMembers.EntityID	= D.EntityID
			DELETE BLEntity
			FROM DELETED D
			WHERE	BLEntity.EntityID	= D.EntityID
				AND	BLEntity.EntityGUID	= D.EntityGUID
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntityDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntityDelTrigger' AND revision = '1.3')

  insert into GXDBVersions values(6, 'BLEntityDelTrigger',  '1.3', 'BLEntityDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntitySRMInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntitySRMInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntitySRMInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntitySRMInsTrigger]
  delete from GXDBVersions where name = 'BLEntitySRMInsTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntitySRMInsTrigger ON BLEntity
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		IF EXISTS (SELECT * FROM [sys].[sysdatabases] WHERE name = N'SRM')
		BEGIN
			IF NOT EXISTS(select * from SRM.dbo.CSStubBillableEntities,INSERTED I where guid = (I.EntityGUID COLLATE SQL_Latin1_General_CP1_CS_AS))
			BEGIN
				INSERT INTO SRM.dbo.CSStubBillableEntities (csBLEntityId,guid,addTimeStamp,removalTimeStamp,scmOldId)
				SELECT	EntityID,		-->csBillableEntity
						EntityGUID,		-->guid
						GETUTCDATE(),	-->CreatedTime
						NULL,			-->RemovalTime
						0
					FROM INSERTED
			END
			ELSE
			BEGIN
				UPDATE SRM.dbo.CSStubBillableEntities
				SET	csBLEntityId	= I.EntityID,
					removalTimeStamp  = NULL
				FROM INSERTED AS I
				WHERE guid		= (I.EntityGUID COLLATE SQL_Latin1_General_CP1_CS_AS)
			END
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntitySRMInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntitySRMInsTrigger' AND revision = '1.4')

  insert into GXDBVersions values(6, 'BLEntitySRMInsTrigger',  '1.4', 'BLEntitySRMInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntitySRMDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntitySRMDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntitySRMDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntitySRMDelTrigger]
  delete from GXDBVersions where name = 'BLEntitySRMDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntitySRMDelTrigger ON BLEntity
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		IF EXISTS (SELECT * FROM [sys].[sysdatabases] WHERE name = N'SRM')
		BEGIN
			DELETE SRM.dbo.CSStubBillableEntities
			FROM DELETED AS D
			WHERE guid	= (D.EntityGUID COLLATE SQL_Latin1_General_CP1_CS_AS)
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntitySRMDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntitySRMDelTrigger' AND revision = '1.3')

  insert into GXDBVersions values(6, 'BLEntitySRMDelTrigger',  '1.3', 'BLEntitySRMDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLCostCategorySRMInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLCostCategorySRMInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLCostCategorySRMInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLCostCategorySRMInsTrigger]
  delete from GXDBVersions where name = 'BLCostCategorySRMInsTrigger' and type = 6
END
GO

	CREATE TRIGGER BLCostCategorySRMInsTrigger ON BLCostCategory
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		IF EXISTS (SELECT * FROM [sys].[sysdatabases] WHERE name = N'SRM')
		BEGIN
			IF NOT EXISTS(select * from SRM.dbo.CSStubCostCategories,INSERTED I where guid = (I.CatGUID COLLATE SQL_Latin1_General_CP1_CS_AS))
			BEGIN
				INSERT INTO SRM.dbo.CSStubCostCategories (csBLCostCategoryId,guid,addTimeStamp,removalTimeStamp,scmOldId)
				SELECT	CostCategoryID, -->csBLcostCategoryID
						CatGUID,	    -->guid
						GetUTCDate(),   -->AddTimeStamp
						NULL,		    -->RemovalTimeStamp
						0
				FROM INSERTED
			END
			ELSE
			BEGIN
				UPDATE SRM.dbo.CSStubCostCategories
				SET	csBLCostCategoryId = I.CostCategoryID,
					removalTimeStamp   = NULL
				FROM INSERTED AS I
				WHERE guid		= (I.CatGUID COLLATE SQL_Latin1_General_CP1_CS_AS)
			END
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLCostCategorySRMInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLCostCategorySRMInsTrigger' AND revision = '1.5')

  insert into GXDBVersions values(6, 'BLCostCategorySRMInsTrigger',  '1.5', 'BLCostCategorySRMInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLCostCategorySRMDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLCostCategorySRMDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLCostCategorySRMDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLCostCategorySRMDelTrigger]
  delete from GXDBVersions where name = 'BLCostCategorySRMDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLCostCategorySRMDelTrigger ON BLCostCategory
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		IF EXISTS (SELECT * FROM [sys].[sysdatabases] WHERE name = N'SRM')
		BEGIN
			DELETE SRM.dbo.CSStubCostCategories
			FROM DELETED AS D
			WHERE	guid	= (D.CatGUID COLLATE SQL_Latin1_General_CP1_CS_AS)
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLCostCategorySRMDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLCostCategorySRMDelTrigger' AND revision = '1.3')

  insert into GXDBVersions values(6, 'BLCostCategorySRMDelTrigger',  '1.3', 'BLCostCategorySRMDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLCostCategoryDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLCostCategoryDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLCostCategoryDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLCostCategoryDelTrigger]
  delete from GXDBVersions where name = 'BLCostCategoryDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLCostCategoryDelTrigger ON BLCostCategory
	AFTER DELETE
	AS
	BEGIN
			UPDATE QRPhysicalVolume
			SET CostCategoryID = (SELECT BCC.CostCategoryID
									FROM BLCostCategory AS BCC
									WHERE BCC.CatGUID = 'F3BE811D-4ACC-49FF-B670-486268D2EFEC')
			FROM QRPhysicalVolume AS QR
			WHERE NOT EXISTS
				(SELECT *
				 FROM BLCostCategory AS B1
				 WHERE QR.CostCategoryID = B1.CostCategoryID)
			UPDATE MMDrivePool
			SET CostCategoryID = (SELECT BCC.CostCategoryID
									FROM BLCostCategory AS BCC
									WHERE BCC.CatGUID = 'F3BE811D-4ACC-49FF-B670-486268D2EFEC')
			FROM MMDrivePool AS DP
			WHERE NOT EXISTS
				(SELECT *
				 FROM BLCostCategory AS B1
				 WHERE DP.CostCategoryID = B1.CostCategoryID)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLCostCategoryDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLCostCategoryDelTrigger' AND revision = '1.8')

  insert into GXDBVersions values(6, 'BLCostCategoryDelTrigger',  '1.8', 'BLCostCategoryDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobStreamsDeleteTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobStreamsDeleteTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobStreamsDeleteTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobStreamsDeleteTrigger]
  delete from GXDBVersions where name = 'JMJobStreamsDeleteTrigger' and type = 6
END
GO

	CREATE TRIGGER JMJobStreamsDeleteTrigger
	ON JMJobStreams
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @messages	varchar(256)
		DECLARE @msgId		integer
		DECLARE @endIndex	integer
		DECLARE @startIndex integer
		SET @startIndex = 0
		SELECT @messages = Deleted.failureReason FROM Deleted
		SET @endIndex = CHARINDEX(',', @messages, @startIndex)
		WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
		BEGIN
			SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
			DELETE JMFailureReasonMsg WHERE id = @msgId
			SET @startIndex = @endIndex + 1
			SET @endIndex = CHARINDEX(',', @messages, @startIndex)
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobStreamsDeleteTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobStreamsDeleteTrigger' AND revision = '1.3')

  insert into GXDBVersions values(6, 'JMJobStreamsDeleteTrigger',  '1.3', 'JMJobStreamsDeleteTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobStreamsInsertTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobStreamsInsertTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobStreamsInsertTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobStreamsInsertTrigger]
  delete from GXDBVersions where name = 'JMJobStreamsInsertTrigger' and type = 6
END
GO

	CREATE TRIGGER JMJobStreamsInsertTrigger
	ON JMJobStreams
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		IF EXISTS (select * from JMJobStreamsTemp a, inserted b
				where a.jobId = b.jobId
				and a.streamNum = b.streamNum
				AND a.destStreamNum = b.destStreamNum)

		BEGIN
			UPDATE JMJobStream
			SET unCompBytes = a.unCompBytes,
			    compBytes = a.compBytes,
			    committedUncompBytes = a.committedUncompBytes,
			    committedCompBytes = a.committedCompBytes,
			    throughput = a.throughput,
			    totalToCopy = a.totalToCopy,
			    nwTransBytes = a.nwTransBytes
			FROM JMJobStreamsTemp a, inserted b, JMJobStream c
			WHERE a.jobId = b.jobId and a.streamNum = b.streamNum and a.destStreamNum = b.destStreamNum
			and a.jobId = c.jobId and a.streamNum = c.streamNum and a.destStreamNum = c.destStreamNum
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobStreamsInsertTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobStreamsInsertTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'JMJobStreamsInsertTrigger',  '1.1', 'JMJobStreamsInsertTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMDepTrigUpdDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMDepTrigUpdDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMDepTrigUpdDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMDepTrigUpdDelTrigger]
  delete from GXDBVersions where name = 'JMDepTrigUpdDelTrigger' and type = 6
END
GO

	CREATE TRIGGER JMDepTrigUpdDelTrigger
	ON JMDependencyTriggerTable
	FOR UPDATE, DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		UPDATE JMDependencyTable
		SET		dirtyFlag		= 1
		FROM Deleted AS D
		WHERE JMDependencyTable.triggerId = D.id
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMDepTrigUpdDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMDepTrigUpdDelTrigger' AND revision = '1.2')

  insert into GXDBVersions values(6, 'JMDepTrigUpdDelTrigger',  '1.2', 'JMDepTrigUpdDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistInsertTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistInsertTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistInsertTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistInsertTrig]
  delete from GXDBVersions where name = 'LicUsageHistInsertTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistInsertTrig ON LicUsage
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, D.OpType, D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Inserted AS D
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistInsertTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistInsertTrig' AND revision = '1.5')

  insert into GXDBVersions values(6, 'LicUsageHistInsertTrig',  '1.5', 'LicUsageHistInsertTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistUpdateTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistUpdateTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistUpdateTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistUpdateTrig]
  delete from GXDBVersions where name = 'LicUsageHistUpdateTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistUpdateTrig ON LicUsage
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT DISTINCT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, D.OpType, D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Inserted AS D
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistUpdateTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistUpdateTrig' AND revision = '1.5')

  insert into GXDBVersions values(6, 'LicUsageHistUpdateTrig',  '1.5', 'LicUsageHistUpdateTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistDeleteTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistDeleteTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistDeleteTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistDeleteTrig]
  delete from GXDBVersions where name = 'LicUsageHistDeleteTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistDeleteTrig ON LicUsage
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT DISTINCT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, OpType='Deleted', D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Deleted AS D
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistDeleteTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistDeleteTrig' AND revision = '1.8')

  insert into GXDBVersions values(6, 'LicUsageHistDeleteTrig',  '1.8', 'LicUsageHistDeleteTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SIMInstalledPackageHistAfterDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SIMInstalledPackageHistAfterDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SIMInstalledPackageHistAfterDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SIMInstalledPackageHistAfterDelete]
  delete from GXDBVersions where name = 'SIMInstalledPackageHistAfterDelete' and type = 6
END
GO

	CREATE TRIGGER SIMInstalledPackageHistAfterDelete ON simInstalledPackages
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @clientID	   integer
		DECLARE @releaseID integer
		SET @clientID = (select TOP 1 clientID from Deleted)
		SET @releaseID = (SELECT releaseID from app_client where id = @clientID)
		INSERT INTO simInstalledPackagesHistory
		SELECT DISTINCT D.ID, D.simPackageID, @clientID,
			0, 'DELETED', 0, @releaseID, GETUTCDATE(), 0, 0, 0
		FROM Deleted AS D
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SIMInstalledPackageHistAfterDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SIMInstalledPackageHistAfterDelete' AND revision = '1.4')

  insert into GXDBVersions values(6, 'SIMInstalledPackageHistAfterDelete',  '1.4', 'SIMInstalledPackageHistAfterDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SIMInstalledPackageHistAfterAdd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SIMInstalledPackageHistAfterAdd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SIMInstalledPackageHistAfterAdd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SIMInstalledPackageHistAfterAdd]
  delete from GXDBVersions where name = 'SIMInstalledPackageHistAfterAdd' and type = 6
END
GO

	CREATE TRIGGER SIMInstalledPackageHistAfterAdd ON simInstalledPackages
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @releaseID integer
		SET @releaseID = (SELECT MAX(C.releaseID) from app_client C, Inserted I where C.id = I.clientId)
		INSERT INTO simInstalledPackagesHistory
		SELECT DISTINCT I.ID, I.simPackageID, I.ClientId,
			1, I.OpType, 0, @releaseID, GETUTCDATE(), 0, 0, 0
		FROM Inserted AS I
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SIMInstalledPackageHistAfterAdd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SIMInstalledPackageHistAfterAdd' AND revision = '1.5')

  insert into GXDBVersions values(6, 'SIMInstalledPackageHistAfterAdd',  '1.5', 'SIMInstalledPackageHistAfterAdd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/simVmToPmMapInsert.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: simVmToPmMapInsert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[simVmToPmMapInsert]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[simVmToPmMapInsert]
  delete from GXDBVersions where name = 'simVmToPmMapInsert' and type = 6
END
GO

	CREATE TRIGGER simVmToPmMapInsert
	ON simVMToPMMap
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN	--If no rows inserted
		IF EXISTS (SELECT * FROM APP_Client C, INSERTED WHERE C.id IN (VMClientID, PMClientID) AND C.releaseID > 13)
			RETURN			--If any client is 9.0 or above
		INSERT	APP_VMToPMMap
		SELECT	DISTINCT VMClientId, PMClientId
		FROM	INSERTED I
		WHERE	NOT EXISTS (SELECT * FROM APP_VMToPMMap A where A.VMClientId = I.VMClientId AND A.PMClientId = I.PMClientId)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [simVmToPmMapInsert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'simVmToPmMapInsert' AND revision = '1.1')

  insert into GXDBVersions values(6, 'simVmToPmMapInsert',  '1.1', 'simVmToPmMapInsert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/simVmToPmMapDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: simVmToPmMapDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[simVmToPmMapDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[simVmToPmMapDelete]
  delete from GXDBVersions where name = 'simVmToPmMapDelete' and type = 6
END
GO

	CREATE TRIGGER simVmToPmMapDelete
	ON simVMToPMMap
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN	--If no rows deleted
		IF EXISTS (SELECT * FROM APP_Client C, Deleted WHERE C.id IN (VMClientID, PMClientID) AND C.releaseID > 13)
			RETURN			--If any client is 9.0 or above
		DELETE	APP_VMToPMMap
		FROM	APP_VMToPMMap M, Deleted AS D
		WHERE	M.VMClientID = D.VMClientID AND M.PMClientID = D.PMClientID AND
			NOT EXISTS (SELECT * FROM simVMToPMMap S WHERE M.VMClientID = S.VMClientID AND M.PMClientID = S.PMClientID)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [simVmToPmMapDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'simVmToPmMapDelete' AND revision = '1.1')

  insert into GXDBVersions values(6, 'simVmToPmMapDelete',  '1.1', 'simVmToPmMapDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/PatchinfoAfterAdd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: PatchinfoAfterAdd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PatchinfoAfterAdd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[PatchinfoAfterAdd]
  delete from GXDBVersions where name = 'PatchinfoAfterAdd' and type = 6
END
GO

	CREATE TRIGGER PatchinfoAfterAdd ON patchinfo
	INSTEAD OF INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @releaseID integer
		DECLARE @osID	   integer
		DECLARE @clientID  integer
		DECLARE @packageID integer
		DECLARE @apptypeID integer
		SET @clientID = (select TOP 1 clientID from Inserted)
		SET @releaseID = (SELECT releaseID from app_client where id = @clientID)
		SET @osID = (SELECT simOperatingSystemid from app_client where id = @clientID)
		SET @apptypeID = (select TOP 1 AppTypeId from Inserted)
		SET @packageID = (SELECT dbo.GetPackageID(@apptypeID, @osID))
		IF(@releaseID < 14 AND @packageID > 0)
		BEGIN
			DELETE simInstalledPackages WHERE clientid = @clientID AND simpackageID = @packageID
			INSERT INTO simInstalledPackages
				SELECT @clientID, @packageID,
				GETUTCDATE(), 'Install', 0, I.HighestSP, I.AdditionalPatches,
				I.MissingPatches, I.Node, I.IsActive, I.SpMinorVersion, I.StatusFlag,
				I.BaselineDeltaSP, I.BaselineDeltaUpdate
			FROM Inserted AS I
		END
		INSERT INTO patchinfo
		SELECT I.clientId, I.ReleaseId, I.ApptypeId, I.BuildIdString, I.HighestSP,
			I.AdditionalPatches, I.MissingPatches, I.Node, I.IsActive, I.SpMinorVersion,
			I.StatusFlag, I.BaselineDeltaSP, I.BaselineDeltaUpdate
		FROM Inserted I
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [PatchinfoAfterAdd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'PatchinfoAfterAdd' AND revision = '1.3')

  insert into GXDBVersions values(6, 'PatchinfoAfterAdd',  '1.3', 'PatchinfoAfterAdd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/PatchinfoAfterDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: PatchinfoAfterDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PatchinfoAfterDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[PatchinfoAfterDelete]
  delete from GXDBVersions where name = 'PatchinfoAfterDelete' and type = 6
END
GO

	CREATE TRIGGER PatchinfoAfterDelete ON patchinfo
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @releaseID integer
		DECLARE @osID	   integer
		DECLARE @clientID	   integer
		SET @clientID = (select TOP 1 clientID from Deleted)
		SET @releaseID = (SELECT releaseID from app_client where id = @clientID)
		SET @osID = (SELECT simOperatingSystemid from app_client where id = @clientID)
		IF(@releaseID < 14)
		BEGIN
			DECLARE @rowCount integer
			SET @rowCount = (select count(*) from deleted)
			IF(@rowCount = 1)
			BEGIN
				DELETE simInstalledPackages where id in
				(select SIP.id from simInstalledPackages SIP, Deleted D where SIP.clientid = D.clientID AND SIP.simpackageID in ((dbo.GetPackageID(D.AppTypeId, @osID))))
			END
			ELSE
			BEGIN
				DELETE simInstalledPackages WHERE ID in
				(select SIP.id from simInstalledPackages SIP, Deleted D where SIP.clientid = @clientID)
			END
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [PatchinfoAfterDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'PatchinfoAfterDelete' AND revision = '1.2')

  insert into GXDBVersions values(6, 'PatchinfoAfterDelete',  '1.2', 'PatchinfoAfterDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/UMGroupsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: UMGroupsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UMGroupsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[UMGroupsTrigger]
  delete from GXDBVersions where name = 'UMGroupsTrigger' and type = 6
END
GO

		CREATE TRIGGER UMGroupsTrigger
		ON  dbo.UMGroups
		AFTER INSERT
		AS
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		IF NOT EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'CanNotSeePeers' AND modified = 0 AND value = '1')
		BEGIN
			DECLARE @viewroleId INT = (SELECT id FROM UMROles WHERE name = 'View' AND flags & (1 | 2) <> 0)
			IF @viewroleid <> 0
			INSERT INTO UMSecurityAssociations
					 SELECT @viewroleId, 0, id, 0, 1, 1, 0, 0, 0, CASE WHEN umdsProviderId <> 0 THEN 62 ELSE 15 END, id, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
					 FROM inserted
		END
		SET NOCOUNT OFF;
		END
		GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [UMGroupsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'UMGroupsTrigger' AND revision = '')

  insert into GXDBVersions values(6, 'UMGroupsTrigger',  '', 'UMGroupsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNDriveCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNDriveCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNDriveCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNDriveCoreTrigger]
  delete from GXDBVersions where name = 'CNDriveCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER CNDriveCoreTrigger
 ON MMDrive
	AFTER UPDATE
	AS
 IF @@ROWCOUNT = 0 RETURN
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
 IF UPDATE(drivenumber)
 BEGIN


 		INSERT INTO MMDriveUpdateTracker
 		select I.DriveId,
 		D.drivenumber, I.drivenumber,
 		@CurrentUTCDate
 		FROM Deleted D, Inserted I
 		WHERE D.driveid = I.driveid
 		AND (D.drivenumber <> I.drivenumber)

 		IF (@@ROWCOUNT > 0)
 		BEGIN
 			UPDATE MMDrive
 			SET DriveNumber = D.DriveNumber
 			FROM Deleted D
 			WHERE D.DriveId = MMDrive.DriveId
 		END
 END
 IF UPDATE(DriveSoftState) OR UPDATE(DriveEnabled) OR UPDATE(DriveBroken) OR UPDATE(CleaningRequired)
 BEGIN

 		INSERT INTO MMDriveStateHistory
 		SELECT I.DriveId, 0,
 		State = (I.DriveSoftState & I.DriveEnabled & ~I.CleaningRequired & ~I.DriveBroken),
 		@CurrentUTCDate,
 		I.OfflineReason
 		FROM Inserted I, Deleted D
 		WHERE	(I.DriveID = D.DriveID)
 				AND (I.DriveSoftState <> D.DriveSoftState OR I.DriveEnabled <> D.DriveEnabled OR I.CleaningRequired <> D.CleaningRequired OR I.DriveBroken <> D.DriveBroken)

 END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNDriveCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNDriveCoreTrigger' AND revision = '1.21')

  insert into GXDBVersions values(6, 'CNDriveCoreTrigger',  '1.21', 'CNDriveCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNLibraryCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNLibraryCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNLibraryCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNLibraryCoreTrigger]
  delete from GXDBVersions where name = 'CNLibraryCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER CNLibraryCoreTrigger
 	ON MMLibrary
	AFTER UPDATE
	AS
 IF @@ROWCOUNT = 0 RETURN
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
 IF UPDATE(LibrarySoftState) OR UPDATE(LibraryEnabled) OR UPDATE(LibraryBroken)
 BEGIN

 		INSERT INTO MMLibraryStateHistory
 		SELECT I.LibraryId, 0,
 		State = (I.LibrarySoftState & I.LibraryEnabled & ~I.LibraryBroken),
 		@CurrentUTCDate,
 		I.LibraryStatusReason
 		FROM Inserted I

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNLibraryCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNLibraryCoreTrigger' AND revision = '1.16')

  insert into GXDBVersions values(6, 'CNLibraryCoreTrigger',  '1.16', 'CNLibraryCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDriveController_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDriveController_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDriveController_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDriveController_AfterUpd]
  delete from GXDBVersions where name = 'MMDriveController_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMDriveController_AfterUpd
 	ON MMDriveController
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()

 --  resource manager related code follows
 -- Commenting out RM code since this is not needed..
 -- IF UPDATE(DriveControllerSoftState) OR UPDATE(DriveControllerEnabled)
 -- BEGIN

 --	UPDATE MMDriveController
 --	SET RMStatus = (MMDriveController.RMStatus & ~128)
 --									| ( CASE WHEN I.DriveControllerSoftState = 1 AND I.DriveControllerEnabled = 1 THEN 0 ELSE 128 END )
 --	FROM Inserted I, Deleted D WHERE I.DriveControllerId = MMDriveController.DriveControllerId AND I.DriveControllerId = D.DriveControllerId AND
 -- 				( I.DriveControllerSoftState <> D.DriveControllerSoftState OR I.DriveControllerEnabled <> D.DriveControllerEnabled )
 --
 --
 -- END

 --  MM Drive State History

 IF UPDATE(DriveControllerSoftState) OR UPDATE(DriveControllerEnabled) OR UPDATE(DriveAccessible)
 BEGIN

 		INSERT INTO MMDriveStateHistory
 		SELECT I.DriveId, I.ClientId,
 		State = (I.DriveControllerSoftState & I.DriveControllerEnabled & I.DriveAccessible),
 		@CurrentUTCDate,
 		I.DriveControllerOfflineReason
 		FROM Inserted I, Deleted D
 		WHERE	I.DriveControllerId = D.DriveControllerId
 				AND (I.DriveControllerSoftState <> D.DriveControllerSoftState OR I.DriveControllerEnabled <> D.DriveControllerEnabled OR I.DriveAccessible <> D.DriveAccessible)

 END

 END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDriveController_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDriveController_AfterUpd' AND revision = '1.7')

  insert into GXDBVersions values(6, 'MMDriveController_AfterUpd',  '1.7', 'MMDriveController_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMHost_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMHost_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMHost_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMHost_AfterUpd]
  delete from GXDBVersions where name = 'MMHost_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMHost_AfterUpd
 	ON MMHost
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()

 --  resource manager related code follows
 -- Jai - taking out RM code
 -- DECLARE @l_needToUpdate INTEGER
 -- SET @l_needToUpdate = 0
 --
 -- IF UPDATE(MmHostSoftState) OR UPDATE(MmHostEnabled)
 -- BEGIN

 -- 	UPDATE MMHost
 --	SET RMStatus = (MMHost.RMStatus & ~1)
 -- 									| ( CASE WHEN I.MmHostSoftState = 1 AND I.MmHostEnabled = 1 THEN 0 ELSE 1 END )
 --	FROM Inserted I, Deleted D WHERE I.ClientId = MMHost.ClientId AND I.ClientId = D.ClientId AND
 -- 				( I.MmHostSoftState <> D.MmHostSoftState OR I.MmHostEnabled <> D.MmHostEnabled )
 --
 -- 	SET @l_needToUpdate = @@ROWCOUNT
 --
 -- END

 -- IF ((@l_needToUpdate > 0) OR (UPDATE(RmStatus)))
 -- BEGIN
 --
 --	UPDATE MMDrivePool
 --	SET RMStatus = (MMDrivePool.RMStatus & ~(1 | 32))
 -- 								| MH.RMStatus & (1 | 32 | 1073741824)
 --	FROM INSERTED I, MMHOST MH
 --	WHERE MMDrivePool.ClientId = I.ClientId AND MH.ClientId = I.ClientId
 --	UPDATE MMDeviceController
 -- 	SET RMStatus = (MMDeviceController.RMStatus & ~(1 | 32))
 --								| MH.RMStatus & (1 | 32 | 1073741824)
 --	FROM INSERTED I, MMHOST MH
 --	WHERE MMDeviceController.ClientId = I.ClientId AND MH.ClientId = I.ClientId
 -- END

 --  MM MA State History

 IF UPDATE(MmHostSoftState) OR UPDATE(MmHostEnabled)
 BEGIN

 		INSERT INTO MMMAStateHistory
 		SELECT I.ClientId,
 		State = (I.MmHostSoftState & I.MmHostEnabled),
 		@CurrentUTCDate,
 		OfflineReason
 		FROM Inserted I

 END


 END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMHost_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMHost_AfterUpd' AND revision = '1.4')

  insert into GXDBVersions values(6, 'MMHost_AfterUpd',  '1.4', 'MMHost_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMRstJobInfoAfterDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMRstJobInfoAfterDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMRstJobInfoAfterDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMRstJobInfoAfterDelete]
  delete from GXDBVersions where name = 'JMRstJobInfoAfterDelete' and type = 6
END
GO

	CREATE TRIGGER JMRstJobInfoAfterDelete
	ON JMRstJobInfo
	AFTER DELETE
	AS

	BEGIN

		SET NOCOUNT ON
     declare @reservationIds table (reservationid int, jobid int)
		insert into @reservationIds
		select reservationid, a.jobid_l
		from mmresourcetojob as a, Deleted as D
     where a.jobid_l = D.jobId

		delete from mmresourcetojob where jobid_l in (select jobid from @reservationIds)

		delete from mmresource
		where reservationid in (select reservationid from @reservationIds)
		and reservationid not in (select reservationid from mmresourcetojob)
		and IntrJobId_l = 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMRstJobInfoAfterDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMRstJobInfoAfterDelete' AND revision = '1.1')

  insert into GXDBVersions values(6, 'JMRstJobInfoAfterDelete',  '1.1', 'JMRstJobInfoAfterDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMLibraryController_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMLibraryController_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMLibraryController_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMLibraryController_AfterUpd]
  delete from GXDBVersions where name = 'MMLibraryController_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMLibraryController_AfterUpd
 	ON MMLibraryController
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()

 --  MM Library State History

 IF UPDATE(LibraryControllerSoftState) OR UPDATE(LibraryControllerEnabled)
 BEGIN

 		INSERT INTO MMLibraryStateHistory
 		SELECT I.LibraryId, I.ClientId,
 		State = (I.LibraryControllerSoftState & I.LibraryControllerEnabled),
 		@CurrentUTCDate,
 		0
 		FROM Inserted I


 END

 END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMLibraryController_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMLibraryController_AfterUpd' AND revision = '1.1')

  insert into GXDBVersions values(6, 'MMLibraryController_AfterUpd',  '1.1', 'MMLibraryController_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMMountPath_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMMountPath_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMMountPath_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMMountPath_AfterUpd]
  delete from GXDBVersions where name = 'MMMountPath_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMMountPath_AfterUpd
 	ON MMMountPath
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()

 --  MM MountPath State History

 IF UPDATE(IsEnabled) OR UPDATE(IsOffline)
 BEGIN

 		INSERT INTO MMMountPathStateHistory
 		SELECT MS.MediaID, 0, I.MountPathId,
 		State = (I.IsEnabled & ~I.IsOffline),
 		@CurrentUTCDate,
 		I.OfflineReason
 		FROM Inserted I, MMMediaSide MS
 		WHERE	I.MediaSideID = MS.MediaSideId
 END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMMountPath_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMMountPath_AfterUpd' AND revision = '1.3')

  insert into GXDBVersions values(6, 'MMMountPath_AfterUpd',  '1.3', 'MMMountPath_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDrive_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDrive_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDrive_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDrive_AfterUpd]
  delete from GXDBVersions where name = 'MMDrive_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMDrive_AfterUpd
 	ON MMDrive
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON

 IF UPDATE(DriveSoftState)
 BEGIN

	UPDATE MMDrive
	SET DriveSoftState = 0 FROM Inserted I, Deleted D
	WHERE MMDrive.DriveSoftState = 1 AND MMDrive.DriveId = D.DriveId AND
	D.DriveId = I.DriveId AND D.DriveSoftState = 0 AND I.DriveSoftState = 1
	AND (D.OfflineReason = 16 OR D.offlineReason = 17)
 END


 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDrive_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDrive_AfterUpd' AND revision = '1.3')

  insert into GXDBVersions values(6, 'MMDrive_AfterUpd',  '1.3', 'MMDrive_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMSharedDriveAllocation_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMSharedDriveAllocation_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMSharedDriveAllocation_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMSharedDriveAllocation_AfterDel]
  delete from GXDBVersions where name = 'MMSharedDriveAllocation_AfterDel' and type = 6
END
GO

	CREATE TRIGGER MMSharedDriveAllocation_AfterDel ON MMSharedDriveAllocation
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO MMSharedDriveAllocationHistory
		SELECT * FROM DELETED
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMSharedDriveAllocation_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMSharedDriveAllocation_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'MMSharedDriveAllocation_AfterDel',  '1.3', 'MMSharedDriveAllocation_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFile_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFile_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFile_AfterDel]
  delete from GXDBVersions where name = 'archFile_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFile_AfterDel
 	ON archFile
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN

		declare		@fromProcessId		integer
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())

		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archFilePruningLogs (archFileId, commCellId, archGroupId, isValid, flags,	appId, fileType, backupLevel, JobId, cTime, pruneTime, processId)
		SELECT D.id, D.commCellId, D.archGroupId, D.isValid, D.flags, D.appId, D.fileType, D.backupLevel, D.JobId, D.cTime, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
		FROM Deleted D
 	--
		INSERT INTO archContentIndexingAged([archFileId], [commCellId], [cloudId], [appId], [pruneType], [agedFlag])
		SELECT
			D.id, D.commCellId, D.cloudId, D.appId,
			PruneType = case a.appTypeId
				when 67 /*CV_APPTYPE_MS_EXCHANGE_ARCHIVER*/ then 1 /*CVA_AGEDCI_PRUNETYPE_AFILE_ONLY*/
				else 3  /*CVA_AGEDCI_PRUNETYPE_AFILE_AGEDOUT*/
			end,
			0
		FROM
			Deleted D
		inner join
			APP_Application a
		on
			a.id = D.appId
		WHERE
			D.cloudId > 0 AND (D.flags & 240 /* CVA_AF_CI_BITMAP */) > 0
 	--
 	--
 	--
		INSERT INTO archIndexingAgedTemp([archFileId], [commCellId], [appId], [pruneTime])
		SELECT
			D.id, D.commCellId, D.appId, @currentTime
		FROM
			Deleted D
		WHERE
			D.fileType <> 2
 	--
 	-- FLA ageing
		insert into archFLAIndexingAged(archFileId, commCellId, cloudId, appId, pruneType, agedFlag)
 	select
			e.archFileId, e.commCellId, e.cloudId, d.appId, 6 /*CVA_AGEDCI_PRUNETYPE_FLA_AFILE_AGEDOUT*/, 0
		from
 		Deleted d
 	inner join
 		archFLAIndexingInfo e
 	on
 		e.archFileId = d.id
 		and e.commCellId = d.commCellId
		--
		delete archFLAIndexingInfo
		from
			archFLAIndexingInfo e
		inner join
			Deleted d
 	on
 		e.archFileId = d.id
 		and e.commCellId = d.commCellId
		--
		delete archContentIndexingSecondary from archContentIndexingSecondary s
		inner join Deleted d on d.id = s.ArchFileId and d.commCellId = s.CommCellId
 	--
 	INSERT INTO archFileEdgeDrive (archFileId, commCellId, fileType, flags, jobId, appId, clientId, WebServerId, CloudId, AFDeleteTime)
 	SELECT	D.id, D.CommCellId, D.FileType, D.Flags, D.JobId, D.appId, ISNULL(A.ClientId, 0), ISNULL(E.EntityId, 0), 0, @currentTime
 	FROM	Deleted D
 			LEFT OUTER JOIN APP_Application A WITH (NOLOCK) ON D.appId = A.id
 			LEFT OUTER JOIN App_EdgeDriveAssociation E WITH (NOLOCK) ON A.ClientId = E.ClientId AND E.EntityType = 11
 	WHERE D.flags & 32768 /*CVA_AF_EDGE_DRIVE_FLAG*/ > 0
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFile_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFile_AfterDel' AND revision = '1.15')

  insert into GXDBVersions values(6, 'archFile_AfterDel',  '1.15', 'archFile_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFileCopy_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFileCopy_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFileCopy_AfterDel]
  delete from GXDBVersions where name = 'archFileCopy_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFileCopy_AfterDel
 	ON archFileCopy
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archFileCopyPruningLogs (archFileId, commCellId, archCopyId, isValid, flags, modifiedTime, pruneTime, processId, AgedBy)
		SELECT D.archFileId, D.commCellId, D.archCopyId, D.isValid, D.flags, D.modifiedTime, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId, D.AgedBy
		FROM Deleted D
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFileCopy_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFileCopy_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'archFileCopy_AfterDel',  '1.3', 'archFileCopy_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunk_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunk_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunk_AfterDel]
  delete from GXDBVersions where name = 'archChunk_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunk_AfterDel
 	ON archChunk
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archChunkPruningLogs (chunkId, commCellId, flags, volumeId, mediaId, version, createTime, writeTime, modifiedTime, pruneTime, processId, AgedBy, physicalSize, logicalSize)
		SELECT D.id, D.commCellId, D.flags, D.VolumeId, isnull(V.MediaId, 0), D.version, D.createTime, D.writeTime, D.modifiedTime, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId, D.AgedBy, D.physicalSize, D.logicalSize
		FROM Deleted D LEFT OUTER JOIN MMVolume V ON V.VolumeId = D.VolumeId

		UPDATE archChunkToSilo
		SET flags = (archChunkToSilo.flags | 1)
		FROM Deleted D
		WHERE archChunkToSilo.archChunkId = D.id AND archChunkToSilo.commCellId = D.commCellId
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunk_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunk_AfterDel' AND revision = '1.6')

  insert into GXDBVersions values(6, 'archChunk_AfterDel',  '1.6', 'archChunk_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunkMapping_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunkMapping_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunkMapping_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunkMapping_AfterDel]
  delete from GXDBVersions where name = 'archChunkMapping_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunkMapping_AfterDel
 	ON archChunkMapping
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archChunkMappingPruningLogs (archChunkId, archFileId, archCopyId, commCellId, flags, modifiedTime, pruneTime, processId, AgedBy  , chunkCommCellId)
		SELECT D.archChunkId, D.archFileId, D.archCopyId, D.commCellId, D.flags, D.modifiedTime, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId, D.AgedBy , D.chunkCommCellId
		FROM Deleted D
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunkMapping_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunkMapping_AfterDel' AND revision = '1.4')

  insert into GXDBVersions values(6, 'archChunkMapping_AfterDel',  '1.4', 'archChunkMapping_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFileSIDBKeys_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFileSIDBKeys_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFileSIDBKeys_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFileSIDBKeys_AfterDel]
  delete from GXDBVersions where name = 'archFileSIDBKeys_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFileSIDBKeys_AfterDel
 	ON archFileSIDBKeys
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archFileSIDBKeysPruningLogs (archFileId, commCellId, archCopyId, encKeyType, encKey, pruneTime, processId, SIDBStoreId, encRSA)
		SELECT D.archFileId, D.commCellId, D.archCopyId, D.encKeyType, D.encKey, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId, D.SIDBStoreId, D.encRSA
		FROM Deleted D
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFileSIDBKeys_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFileSIDBKeys_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'archFileSIDBKeys_AfterDel',  '1.3', 'archFileSIDBKeys_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupInsTrigger]
  delete from GXDBVersions where name = 'ArchGroupInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupInsTrigger
	ON ArchGroup
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		IF EXISTS (SELECT id FROM Inserted WHERE type = 1)
		BEGIN
			INSERT INTO archGroupMiningProp (archGroupId, enabled, type, flags, startTime, deferredDays, numPeriod, dayNumber, calendarId,
						prevPeriodBegin, currPeriodBegin, currPeriodEnd, nextPeriodEnd)
			SELECT	id, 1, 8, 0, -dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 1, 0, 0, 0, 0
			FROM	Inserted
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupInsTrigger' AND revision = '1.2')

  insert into GXDBVersions values(6, 'ArchGroupInsTrigger',  '1.2', 'ArchGroupInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupUpgTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupUpgTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupUpgTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupUpgTrigger]
  delete from GXDBVersions where name = 'ArchGroupUpgTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupUpgTrigger
	ON ArchGroup
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		IF (UPDATE(defaultSnapCopy))
		BEGIN
			UPDATE	archAgingRule
			SET		retentionDays = T.retentionDays, fullCycles = T.fullCycles, flags = T.flags,
					weekStart = T.weekStart, monthStart = T.monthStart, yearStart = T.yearStart,
					archiverRetDays = T.archiverRetDays, retentionJobs  = T.retentionJobs
			FROM	(SELECT	AGC.id, AR.retentionDays, AR.fullCycles, AR.flags,
							AR.weekStart, AR.monthStart, AR.yearStart, AR.archiverRetDays, AR.retentionJobs
					FROM	archGroupCopy AS AGC, archAgingRule AS AR, INSERTED AS I
					WHERE	AGC.archGroupId = I.id AND AGC.id <> I.defaultSnapCopy
						AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
						AND AR.copyId = AGC.sourceCopyId) T
			WHERE	archAgingRule.copyId = T.id
			DELETE	archAgingRuleExtended
			FROM	archGroupCopy AS AGC, INSERTED AS I
			WHERE	archAgingRuleExtended.copyId = AGC.id
				AND AGC.archGroupId = I.id AND AGC.id <> I.defaultSnapCopy
				AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
			INSERT	INTO archAgingRuleExtended
			SELECT	AGC.id,	AR.retentionDays, AR.retentionRule, AR.currPeriodBegin, AR.currPeriodEnd,
					AR.prevPeriodBegin, AR.nextPeriodEnd, AR.GraceDays ,AR.EveryXHours
			FROM	archGroupCopy AS AGC, archAgingRuleExtended AS AR, INSERTED AS I
			WHERE	AGC.archGroupId = I.id AND AGC.id <> I.defaultSnapCopy
				AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
				AND AR.copyId = AGC.sourceCopyId
		END
		IF (UPDATE(maxStreams))
		BEGIN
			UPDATE AGC
			SET AGC.maxStreamNum = I.maxStreams
			FROM archGroupCopy AGC, INSERTED I
			WHERE AGC.destMediaCopyId = I.defaultCopy
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupUpgTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupUpgTrigger' AND revision = '1.11')

  insert into GXDBVersions values(6, 'ArchGroupUpgTrigger',  '1.11', 'ArchGroupUpgTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCopyInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCopyInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCopyInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCopyInsTrigger]
  delete from GXDBVersions where name = 'ArchGroupCopyInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCopyInsTrigger
	ON ArchGroupCopy
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO archAgingRule (copyId, retentionDays, fullCycles, flags, weekStart, monthStart,	yearStart, archiverRetDays, retentionJobs,minutesSinceDayStarts)
		SELECT	I.id, A.retentionDays, A.fullCycles, A.flags, A.weekStart, A.monthStart, A.yearStart, A.archiverRetDays, A.retentionJobs , A.minutesSinceDayStarts
		FROM	archAgingRule AS A, Inserted AS I
		WHERE	A.copyId = I.sourceCopyId AND I.isSnapCopy = 1 AND I.isMirrorCopy = 1
		INSERT INTO archAgingRuleExtended (copyId, retentionDays, retentionRule, currPeriodBegin, currPeriodEnd, prevPeriodBegin, nextPeriodEnd, GraceDays,EveryXHours)
		SELECT	I.id, A.retentionDays, A.retentionRule, A.currPeriodBegin, A.currPeriodEnd, A.prevPeriodBegin, A.nextPeriodEnd, A.GraceDays , A.EveryXHours
		FROM	archAgingRuleExtended AS A, Inserted AS I
		WHERE	A.copyId = I.sourceCopyId AND I.isSnapCopy = 1 AND I.isMirrorCopy = 1

		INSERT	INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, created, modified)
		SELECT	I.id, 2, 'retentionJobs', 1, M.intVal, dbo.getunixtime(GETUTCDATE()), dbo.getunixtime(GETUTCDATE())
		FROM	MMEntityProp AS M WITH (NOLOCK), Inserted AS I
		WHERE	M.EntityId = I.sourceCopyId AND M.EntityType = 2 AND M.propertyName = 'retentionJobs' AND M.propDataType = 1 AND I.isSnapCopy = 1 AND I.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCopyInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCopyInsTrigger' AND revision = '1.6')

  insert into GXDBVersions values(6, 'ArchGroupCopyInsTrigger',  '1.6', 'ArchGroupCopyInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCopyUpgTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCopyUpgTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCopyUpgTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCopyUpgTrigger]
  delete from GXDBVersions where name = 'ArchGroupCopyUpgTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCopyUpgTrigger
	ON ArchGroupCopy
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		IF (UPDATE(flags))
		BEGIN
			UPDATE	archGroupCopy
			SET		flags = (I.flags | 16777216)
			FROM	Inserted AS I, Deleted AS D
			WHERE	archGroupCopy.id = I.id AND D.id = I.id AND (I.flags & 16777216) = 0 AND (D.flags & 16777216) <> 0
		END
		IF (UPDATE(flags) OR UPDATE(waitForIfOffline) OR UPDATE(waitForIfBusy) OR UPDATE(maxStreamNum))
		BEGIN
			UPDATE	archGroupCopy
			SET		flags = (archGroupCopy.flags & ~(512 + 16 + 8)) | (I.flags & (512 + 16 + 8)), waitForIfOffline = I.waitForIfOffline, waitForIfBusy = I.waitForIfBusy, maxStreamNum = I.maxStreamNum
			FROM	Inserted AS I, Deleted AS D
			WHERE	archGroupCopy.sourceCopyId = I.id AND archGroupCopy.Type = 5
		END
		IF  (UPDATE(dedupeFlags) OR UPDATE(sealStoreTaskId) OR UPDATE(siloAppId) OR UPDATE(nDataInstance) OR
			UPDATE(silosInCache) OR UPDATE(siloRestoreMAClientId) OR UPDATE(siloRestoreClientId) OR UPDATE(SIDBSnapIntervalHours))
		AND EXISTS (SELECT * FROM INSERTED WHERE (dedupeFlags & 268435456) <> 0 AND SIDBStoreId > 0)
		BEGIN
			DECLARE	@COPY_DEDUP_FLAGS	INT
			SET	@COPY_DEDUP_FLAGS = (2 | 4 | 8 | 2097152 | 4194304 | 16777216 | 33554432 | 67108864)
			UPDATE	archGroupCopy
			SET		dedupeFlags			= ((archGroupCopy.dedupeFlags & ~@COPY_DEDUP_FLAGS) | (I.dedupeFlags & @COPY_DEDUP_FLAGS)),
					sealStoreTaskId		= I.sealStoreTaskId,
					siloAppId			= I.siloAppId,
					nDataInstance		= I.nDataInstance,
					silosInCache		= I.silosInCache,
					siloRestoreMAClientId	= I.siloRestoreMAClientId,
					siloRestoreClientId		= I.siloRestoreClientId,
					SIDBSnapIntervalHours	= I.SIDBSnapIntervalHours
			FROM	INSERTED AS I
			WHERE	(I.dedupeFlags & 268435456) <> 0 AND I.SIDBStoreId > 0
			AND		archGroupCopy.SIDBStoreId = I.SIDBStoreId
			AND		archGroupCopy.id <> I.id
			AND		((archGroupCopy.dedupeFlags & @COPY_DEDUP_FLAGS) <> (I.dedupeFlags & @COPY_DEDUP_FLAGS)
				OR	archGroupCopy.sealStoreTaskId	<> I.sealStoreTaskId
				OR	archGroupCopy.siloAppId			<> I.siloAppId
				OR	archGroupCopy.nDataInstance		<> I.nDataInstance
				OR	archGroupCopy.silosInCache		<> I.silosInCache
				OR	archGroupCopy.siloRestoreMAClientId	<> I.siloRestoreMAClientId
				OR	archGroupCopy.siloRestoreClientId	<> I.siloRestoreClientId
				OR	archGroupCopy.SIDBSnapIntervalHours	<> I.SIDBSnapIntervalHours)
		END
		IF UPDATE(dedupeFlags)
		BEGIN
			IF EXISTS (SELECT 1 FROM INSERTED I WHERE (I.dedupeFlags & 16) > 0)
			BEGIN
				UPDATE AGCSecondary
				SET AGCSecondary.dedupeFlags = (AGCSecondary.dedupeFlags & ~(8388608)) | 524288
				FROM INSERTED I, archGroupCopy AGCSecondary, archGroup AG, archGroupCopy AGC
				WHERE I.SIDBStoreId = AGC.SIDBStoreId
				AND AGC.id = AG.defaultCopy
				AND AGCSecondary.archGroupId = AGC.archGroupId
				AND AGCSecondary.sourceCopyId = 0
				AND (AGCSecondary.dedupeFlags & 262144) > 0
				AND (AGCSecondary.dedupeFlags & 8388608) > 0
			END
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCopyUpgTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCopyUpgTrigger' AND revision = '1.18')

  insert into GXDBVersions values(6, 'ArchGroupCopyUpgTrigger',  '1.18', 'ArchGroupCopyUpgTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleUpdTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleUpdTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleUpdTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleUpdTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleUpdTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleUpdTrigger
	ON ArchAgingRule
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		UPDATE	archAgingRule
		SET		retentionDays = D.retentionDays, fullCycles = D.fullCycles, archiverRetDays = D.archiverRetDays, retentionJobs = D.retentionJobs
		FROM	archGroupCopy AS AGC WITH(NOLOCK), Deleted AS D
		WHERE	archAgingRule.copyId = D.copyId AND AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
			AND (archAgingRule.retentionDays <> -1 AND (archAgingRule.retentionDays < D.retentionDays OR D.retentionDays = -1)
			  OR archAgingRule.fullCycles <> -1 AND (archAgingRule.fullCycles < D.fullCycles OR D.fullCycles = -1)
			  OR archAgingRule.retentionJobs <> -1 AND (archAgingRule.retentionJobs < D.retentionJobs OR D.retentionJobs = -1)
			  OR archAgingRule.archiverRetDays <> -1 AND (archAgingRule.archiverRetDays < D.archiverRetDays OR D.archiverRetDays = -1))
		UPDATE	archAgingRule
		SET		retentionDays = I.retentionDays, fullCycles = I.fullCycles, flags = I.flags,
				weekStart = I.weekStart, monthStart = I.monthStart, yearStart = I.yearStart, archiverRetDays = I.archiverRetDays , minutesSinceDayStarts = I.minutesSinceDayStarts ,
				retentionJobs = I.retentionJobs
		FROM	archGroupCopy AS AGC WITH(NOLOCK), INSERTED AS I
		WHERE	archAgingRule.copyId = AGC.id
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WITH(NOLOCK) WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleUpdTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleUpdTrigger' AND revision = '1.15')

  insert into GXDBVersions values(6, 'ArchAgingRuleUpdTrigger',  '1.15', 'ArchAgingRuleUpdTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedInsTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedInsTrigger
	ON ArchAgingRuleExtended
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		DELETE	ArchAgingRuleExtended
		FROM	INSERTED AS I,
				(SELECT	copyId, COUNT(DISTINCT retentionRule) AS nRules
				FROM	ArchAgingRuleExtended
				WHERE	copyId IN (SELECT DISTINCT copyId FROM INSERTED)
				GROUP BY copyId) AS T
		WHERE	I.copyId = T.copyId AND T.nRules > 3
			AND ArchAgingRuleExtended.copyId = I.copyId AND ArchAgingRuleExtended.retentionRule = I.retentionRule
		DELETE	ArchAgingRuleExtended
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = I.retentionRule
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
		INSERT	INTO ArchAgingRuleExtended
		SELECT	AGC.id,	I.retentionDays, I.retentionRule, I.currPeriodBegin,
						I.currPeriodEnd, I.prevPeriodBegin, I.nextPeriodEnd, I.GraceDays , I.EveryXHours
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	(AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedInsTrigger' AND revision = '1.8')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedInsTrigger',  '1.8', 'ArchAgingRuleExtendedInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedUpdTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedUpdTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedUpdTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedUpdTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedUpdTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedUpdTrigger
	ON ArchAgingRuleExtended
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		UPDATE	ArchAgingRuleExtended
		SET		retentionDays = D.retentionDays
		FROM	archGroupCopy AS AGC, Deleted AS D
		WHERE	ArchAgingRuleExtended.copyId = D.copyId AND ArchAgingRuleExtended.retentionRule = D.retentionRule
			AND AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
			AND ArchAgingRuleExtended.retentionDays <> -1 AND (ArchAgingRuleExtended.retentionDays < D.retentionDays OR D.retentionDays = -1)
		UPDATE	ArchAgingRuleExtended
		SET		retentionDays = I.retentionDays, currPeriodBegin = I.currPeriodBegin,
					currPeriodEnd = I.currPeriodEnd, prevPeriodBegin = I.prevPeriodBegin,
					nextPeriodEnd = I.nextPeriodEnd, GraceDays = I.GraceDays , EveryXHours = I.EveryXHours
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = I.retentionRule
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedUpdTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedUpdTrigger' AND revision = '1.9')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedUpdTrigger',  '1.9', 'ArchAgingRuleExtendedUpdTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedDelTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedDelTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedDelTrigger
	ON ArchAgingRuleExtended
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		INSERT	INTO ArchAgingRuleExtended
		SELECT	D.*
		FROM	archGroupCopy AS AGC, Deleted AS D
		WHERE	AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
		DELETE	ArchAgingRuleExtended
		FROM	archGroupCopy AS AGC, DELETED AS D
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = D.retentionRule
			AND (AGC.sourceCopyId = D.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = D.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedDelTrigger' AND revision = '1.5')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedDelTrigger',  '1.5', 'ArchAgingRuleExtendedDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archContentIndexingAged_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archContentIndexingAged_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAged_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archContentIndexingAged_AfterDel]
  delete from GXDBVersions where name = 'archContentIndexingAged_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archContentIndexingAged_AfterDel
 	ON archContentIndexingAged
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO archContentIndexingAgedPruningLogs (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, pruneTime, processId)
		SELECT D.archFileId, D.commCellId, D.cloudId, D.appId, D.pruneType, D.agedFlag, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
		FROM Deleted D

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archContentIndexingAged_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archContentIndexingAged_AfterDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'archContentIndexingAged_AfterDel',  '1.1', 'archContentIndexingAged_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunkToCopy_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunkToCopy_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunkToCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunkToCopy_AfterDel]
  delete from GXDBVersions where name = 'archChunkToCopy_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunkToCopy_AfterDel
 	ON archChunkToCopy
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO archChunkToCopyHistory(
			destCopyId, destStream, adminJobId, appId, backupJobId, archChunkId, archFileId, commCellId,
			archCopyId, streamNum, fileType, archFileCopyFlags, encKeyType, lastChunkNumber, chunkNumber,
			physicalOffset, logicalOffset, physicalSize, logicalSize, volumeId, mediaId, mediaGroupId,
			fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey,
			archFileEncKey, extraFlags, segmentId, unCompBytesSize, processId, modifiedTime, reservedStr)
		SELECT	D.destCopyId, D.destStream, D.adminJobId, D.appId, D.backupJobId, D.archChunkId, D.archFileId, D.commCellId,
			D.archCopyId, D.streamNum, D.fileType, D.archFileCopyFlags, D.encKeyType, D.lastChunkNumber, D.chunkNumber,
			D.physicalOffset, D.logicalOffset, D.physicalSize, D.logicalSize, D.volumeId, D.mediaId, D.mediaGroupId,
			D.fileMarkerNo, D.chunkCreateTime, D.chunkVersion, D.chunkPhysicalSize, D.chunkLogicalSize, D.chunkHwEncKey,
			D.archFileEncKey, D.extraFlags, D.segmentId, D.unCompBytesSize, @fromProcessId, @currentTime, N''
		FROM	Deleted D LEFT OUTER JOIN archChunkToCopyHistory H
					ON	D.adminJobId = H.adminJobId
						AND D.destCopyId = H.destCopyId
						AND D.archFileId = H.archFileId
						AND D.commCellId = H.commCellId
						AND D.archChunkId = H.archChunkId
		WHERE H.adminJobId IS NULL
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunkToCopy_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunkToCopy_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'archChunkToCopy_AfterDel',  '1.3', 'archChunkToCopy_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunkToVerify_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunkToVerify_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunkToVerify_AfterDel]
  delete from GXDBVersions where name = 'archChunkToVerify_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunkToVerify_AfterDel
 	ON archChunkToVerify
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO archChunkToVerifyHistory(
			adminJobId, appId, backupJobId, archChunkId, archFileId, commCellId,
			archCopyId, streamNum, fileType, archFileCopyFlags, lastChunkNumber, chunkNumber,
			physicalOffset, logicalOffset, physicalSize, logicalSize, volumeId, mediaId, mediaGroupId,
			fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey,
			extraFlags, segmentId, unCompBytesSize, processId, modifiedTime, reservedStr)
		SELECT	D.adminJobId, D.appId, D.backupJobId, D.archChunkId, D.archFileId, D.commCellId,
			D.archCopyId, D.streamNum, D.fileType, D.archFileCopyFlags, D.lastChunkNumber, D.chunkNumber,
			D.physicalOffset, D.logicalOffset, D.physicalSize, D.logicalSize, D.volumeId, D.mediaId, D.mediaGroupId,
			D.fileMarkerNo, D.chunkCreateTime, D.chunkVersion, D.chunkPhysicalSize, D.chunkLogicalSize, D.chunkHwEncKey,
			D.extraFlags, D.segmentId, D.unCompBytesSize, @fromProcessId, @currentTime, N''
		FROM	Deleted D LEFT OUTER JOIN archChunkToVerifyHistory H
					ON	D.adminJobId = H.adminJobId
						AND D.archCopyId = H.archCopyId
						AND D.archFileId = H.archFileId
						AND D.commCellId = H.commCellId
						AND D.archChunkId = H.archChunkId
		WHERE H.adminJobId IS NULL
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunkToVerify_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunkToVerify_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'archChunkToVerify_AfterDel',  '1.3', 'archChunkToVerify_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archChunkToSyncDDB_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archChunkToSyncDDB_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archChunkToSyncDDB_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archChunkToSyncDDB_AfterDel]
  delete from GXDBVersions where name = 'archChunkToSyncDDB_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archChunkToSyncDDB_AfterDel
 	ON archChunkToSyncDDB
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO archChunkToSyncDDBHistory(
			adminJobId, appId, 	backupJobId, archChunkId, archFileId, commCellId, archCopyId, streamNum,
			fileType, archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
			volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
			chunkHwEncKey, extraFlags, segmentId, unCompBytesSize, processId, modifiedTime, reservedStr)
		SELECT	D.adminJobId, D.appId, D.backupJobId, D.archChunkId, D.archFileId, D.commCellId,
			D.archCopyId, D.streamNum, D.fileType, D.archFileCopyFlags, D.lastChunkNumber, D.chunkNumber,
			D.physicalOffset, D.logicalOffset, D.physicalSize, D.logicalSize, D.volumeId, D.mediaId, D.mediaGroupId,
			D.fileMarkerNo, D.chunkCreateTime, D.chunkVersion, D.chunkPhysicalSize, D.chunkLogicalSize, D.chunkHwEncKey,
			D.extraFlags, D.segmentId, D.unCompBytesSize, @fromProcessId, @currentTime, N''
		FROM	Deleted D LEFT OUTER JOIN archChunkToSyncDDBHistory H
					ON	D.adminJobId = H.adminJobId
						AND D.archCopyId = H.archCopyId
						AND D.archFileId = H.archFileId
						AND D.commCellId = H.commCellId
						AND D.archChunkId = H.archChunkId
		WHERE H.adminJobId IS NULL
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archChunkToSyncDDB_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archChunkToSyncDDB_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'archChunkToSyncDDB_AfterDel',  '1.3', 'archChunkToSyncDDB_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archContentIndexingAF_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archContentIndexingAF_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archContentIndexingAF_AfterDel]
  delete from GXDBVersions where name = 'archContentIndexingAF_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archContentIndexingAF_AfterDel
 	ON archContentIndexingAF
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO archContentIndexingAFHistory(
			archGroupId, clientId, appType, appId, fullCycleNum, backupJobId, backupStartTime, backupEndTime,
			archChunkId, archFileId, commCellId, archCopyId, streamNum, encKeyType, archFileCopyFlags, lastChunkNumber, chunkNumber,
			physicalOffset, logicalOffset, physicalSize, logicalSize, volumeId, mediaId, mediaGroupId,
			fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize, chunkHwEncKey,
			extraFlags, segmentId, processId, modifiedTime, reservedStr)
		SELECT	D.archGroupId, D.clientId, D.appType, D.appId, D.fullCycleNum, D.backupJobId, D.backupStartTime, D.backupEndTime,
			D.archChunkId, D.archFileId, D.commCellId, D.archCopyId, D.streamNum, D.encKeyType, D.archFileCopyFlags, D.lastChunkNumber, chunkNumber,
			D.physicalOffset, D.logicalOffset, D.physicalSize, D.logicalSize, D.volumeId, D.mediaId, D.mediaGroupId,
			D.fileMarkerNo, D.chunkCreateTime, D.chunkVersion, D.chunkPhysicalSize, D.chunkLogicalSize, D.chunkHwEncKey,
			D.extraFlags, D.segmentId, @fromProcessId, @currentTime, N''
		FROM	Deleted D
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archContentIndexingAF_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archContentIndexingAF_AfterDel' AND revision = '1.2')

  insert into GXDBVersions values(6, 'archContentIndexingAF_AfterDel',  '1.2', 'archContentIndexingAF_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/archFLAIndexingAF_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: archFLAIndexingAF_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archFLAIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[archFLAIndexingAF_AfterDel]
  delete from GXDBVersions where name = 'archFLAIndexingAF_AfterDel' and type = 6
END
GO

	CREATE TRIGGER archFLAIndexingAF_AfterDel ON archFLAIndexingAF AFTER DELETE
	AS
	BEGIN
 if @@ROWCOUNT = 0 return
	--
 declare @fromProcessId integer
 declare @currentTime integer
	--
 select @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID), 0), @currentTime = dbo.GetUnixTime(GETUTCDATE())
	--
 INSERT INTO archFLAIndexingAFHistory(archGroupId, clientId, appType, appId, fullCycleNum, backupJobId, backupStartTime, backupEndTime, archChunkId,
 archFileId, commCellId, archCopyId, streamNum, encKeyType, archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset,
 physicalSize, logicalSize, volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
 chunkHwEncKey, extraFlags, segmentId, adminJobId, chunkCommCellId, processId, modifiedTime, reservedStr)
 SELECT
		archGroupId, clientId, appType, appId, fullCycleNum, backupJobId, backupStartTime, backupEndTime, archChunkId,
		archFileId, commCellId, archCopyId, streamNum, encKeyType, archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset,
		physicalSize, logicalSize, volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
		chunkHwEncKey, extraFlags, segmentId, adminJobId, chunkCommCellId, @fromProcessId, @currentTime,  N''
 FROM
    	Deleted D
 --
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [archFLAIndexingAF_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'archFLAIndexingAF_AfterDel' AND revision = '1.2')

  insert into GXDBVersions values(6, 'archFLAIndexingAF_AfterDel',  '1.2', 'archFLAIndexingAF_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobDataStats_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobDataStats_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobDataStats_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobDataStats_AfterUpd]
  delete from GXDBVersions where name = 'JMJobDataStats_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER JMJobDataStats_AfterUpd
	ON JMJobDataStats
	AFTER UPDATE
	AS
	BEGIN
 	IF @@ROWCOUNT = 0 RETURN
 	IF UPDATE(RetentionFlags) OR UPDATE(manualRetentionEndTime) OR UPDATE(Disabled) OR UPDATE(Status)
			AND OBJECT_ID('tempdb.dbo.#GRCDoNotTrackJMJobDataStats') IS NULL
 	BEGIN
 		INSERT INTO JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType)
 		SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType
 		FROM Inserted I INNER JOIN Deleted D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
 			AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
 		WHERE 	(I.Status = 100 OR D.Status = 100)
			AND
			(
				I.RetentionFlags <> D.RetentionFlags
				OR I.manualRetentionEndTime <> D.manualRetentionEndTime
 				OR I.Status <> D.Status
				OR (I.Disabled & 256) <> (D.Disabled & 256)
			)
     /*
 		INSERT INTO GRC2JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType, currStatus, oldStatus, currDisabled, oldDisabled, modifiedTime)
 		SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType, I.status, D.status, I.disabled, D.disabled, GetUTCDate()
 		FROM Inserted I INNER JOIN Deleted D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
 			AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
 		WHERE  I.Status <> D.Status OR ((I.Disabled & 256) <> (D.Disabled & 256))
     */
			IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value = 1) --Ability to disable tracking completely
			BEGIN
				IF object_id('GRCJMJobDataStatsTracking') is not null
				BEGIN
 	  		IF UPDATE(Disabled) OR UPDATE(Status)
						INSERT INTO GRCJMJobDataStatsTracking (commcellId, jobId, copyId, dataType, statusChange, createdTime)
						SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType,
						CASE WHEN I.status = 100 AND D.status <> 100 THEN 1 /*GRC_JOB_STATUS_CHANGE_AVAILABLE*/
						WHEN I.status = 101 AND D.status in (100,102,103,1000) THEN 2 /*GRC_JOB_STATUS_CHANGE_MARKED_RECOPY*/
						WHEN I.status in (102,103) AND D.status = 101 THEN 3 /*GRC_JOB_STATUS_CHANGE_PARTIAL*/ --Is there is a possibiliby of 100 -> partial?
						WHEN I.disabled & 256 > 0 AND I.status <> 1000 THEN 4 /*GRC_JOB_STATUS_CHANGE_MARKED_AGED*/
						WHEN I.status = 1000 THEN 5 /*GRC_JOB_STATUS_CHANGE_MEDIADELETED*/
						ELSE 0 /*GRC_JOB_STATUS_CHANGE_UNKNOWN*/		END,
					  dbo.GetUnixTime(GetUTCDate())
					  FROM INSERTED I INNER JOIN DELETED D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
						AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
						AND
						(
						I.Status <> D.Status
						OR (I.Disabled & 256) <> (D.Disabled & 256)
						)
					  WHERE ISNULL((select intVal FROM MMEntityProp where propertyName =  'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND EntityType = 2 AND EntityId = I.archGrpCopyId),0) = 0
					--Ability to disable tracking at copy level
			  IF UPDATE(RetentionFlags) OR UPDATE(manualRetentionEndTime) OR UPDATE(disabled)
					INSERT INTO GRCJMJobDataStatsTracking (commcellId, jobId, copyId, dataType, statusChange, createdTime)
					SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType, 6 /*GRC_JOB_STATUS_CHANGE_MISC*/, dbo.GetUnixTime(GetUTCDate())
					FROM INSERTED I INNER JOIN DELETED D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
						AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
						AND
						(
						I.RetentionFlags <> D.RetentionFlags
						OR ( ((I.Disabled & 256) = (D.Disabled & 256)) AND (I.disabled <> D.disabled) ) --If the change is aged flag it would have been tracked above, do not track again here
						OR I.manualRetentionEndTime <> D.manualRetentionEndTime
						)
					WHERE ISNULL((select intVal FROM MMEntityProp where propertyName =  'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND EntityType = 2 AND EntityId = I.archGrpCopyId),0) = 0
					--Ability to disable tracking at copy level
				END
			END
 	END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobDataStats_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobDataStats_AfterUpd' AND revision = '1.6')

  insert into GXDBVersions values(6, 'JMJobDataStats_AfterUpd',  '1.6', 'JMJobDataStats_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobDataStats_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobDataStats_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobDataStats_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobDataStats_AfterIns]
  delete from GXDBVersions where name = 'JMJobDataStats_AfterIns' and type = 6
END
GO

	CREATE TRIGGER JMJobDataStats_AfterIns
	ON JMJobDataStats
	AFTER INSERT
	AS
	BEGIN
 	IF @@ROWCOUNT = 0 RETURN
 	INSERT INTO JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType)
 	SELECT commCellId, jobId, archGrpCopyId, dataType
 	FROM Inserted WHERE Status = 100
   /*
 	INSERT INTO GRC2JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType, currStatus, oldStatus, currDisabled, oldDisabled, modifiedTime)
 	SELECT commCellId, jobId, archGrpCopyId, dataType, status, -1, disabled, -1, GetUTCDate()
 	FROM Inserted
   */
 	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value = 1) --Ability to disable tracking completely
			AND OBJECT_ID('tempdb.dbo.#GRCDoNotTrackJMJobDataStats') IS NULL
 	BEGIN
 			IF object_id('GRCJMJobDataStatsTracking') is not null
 			BEGIN
 				INSERT INTO GRCJMJobDataStatsTracking (commcellId, jobId, copyId, dataType, statusChange, createdTime)
 				SELECT commcellId, jobId, archGrpCopyId, dataType, 1/*GRC_JOB_STATUS_CHANGE_AVAILABLE*/, dbo.GetUnixTime(GETUTCDATE())
 				FROM INSERTED WHERE status = 100
					AND ISNULL((select intVal FROM MMEntityProp where propertyName =  'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND EntityType = 2 AND EntityId = archGrpCopyId),0) = 0
					--Ability to disable tracking at copy level
 			END
 	END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobDataStats_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobDataStats_AfterIns' AND revision = '1.5')

  insert into GXDBVersions values(6, 'JMJobDataStats_AfterIns',  '1.5', 'JMJobDataStats_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMBkpStats_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMBkpStats_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMBkpStats_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMBkpStats_AfterIns]
  delete from GXDBVersions where name = 'JMBkpStats_AfterIns' and type = 6
END
GO

	CREATE TRIGGER JMBkpStats_AfterIns
	ON JMBkpStats
	AFTER INSERT
	AS
	BEGIN

 	IF @@ROWCOUNT = 0 RETURN

		SET NOCOUNT ON

 	INSERT INTO archFailedKilledJobInfo (jobId, commCellId, servStartDate, servEndDate, appId, appType, archGrpId, archGrpCopyId, bkpLevel, opType, retentionFlags, flags)
 	SELECT a.jobId, a.commCellId, a.servStartDate, a.servEndDate, a.appId, a.appType, a.dataArchGrpId, a.copyID, a.bkpLevel, a.opType, 0, 0
 	FROM Inserted a LEFT OUTER JOIN archFailedKilledJobInfo b
 		ON a.jobId = b.jobId AND a.commCellId = b.commCellId AND a.copyID = b.archGrpCopyId
 	WHERE a.status IN (2, 4, 9) -- Failed / Killed / Failed To Start
 	AND		a.bkpLevel IN (1, 64, 128, 1024, 32768)
 	AND		a.dataArchGrpId > 1		-- Do not populate DUMMY dataArchGrpId
 	AND		b.jobId IS NULL

		SET NOCOUNT OFF

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMBkpStats_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMBkpStats_AfterIns' AND revision = '1.4')

  insert into GXDBVersions values(6, 'JMBkpStats_AfterIns',  '1.4', 'JMBkpStats_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDataPath_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDataPath_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDataPath_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDataPath_AfterIns]
  delete from GXDBVersions where name = 'MMDataPath_AfterIns' and type = 6
END
GO

	CREATE TRIGGER MMDataPath_AfterIns
 	ON MMDataPath
	AFTER INSERT
	AS
 BEGIN
 	IF @@ROWCOUNT = 0 RETURN
		SET NOCOUNT ON
 	IF EXISTS(SELECT 1 FROM Inserted WHERE (Flag & 32) > 0)
		BEGIN
			UPDATE MMDataPath SET Flag = (I.Flag & ~32)
			FROM MMDataPath DP INNER JOIN Inserted I ON DP.DataPathId = I.DataPathId
			RETURN
		END
		DECLARE @l_SIDBStoreId INTEGER
		DECLARE @l_dedupeFlags INTEGER
		DECLARE @l_dataPathFlags INTEGER
		SELECT @l_SIDBStoreId = C.SIDBStoreId, @l_dedupeFlags = C.dedupeFlags, @l_dataPathFlags = I.Flag
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		WHERE  (I.Flag & 8) = 0 AND (C.dedupeFlags & 268435456) <> 0
		IF  @l_SIDBStoreId IS NOT NULL AND @l_SIDBStoreId > 0
		AND @l_dedupeFlags IS NOT NULL AND (@l_dedupeFlags & 268435456) <> 0
		AND @l_dataPathFlags IS NOT NULL AND (@l_dataPathFlags & 8) = 0
		BEGIN
			INSERT INTO MMDataPath
			SELECT	C.id, I.DrivePoolId, I.HostClientId, I.Flag, I.SpareGroupId,
					I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
					I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM	Inserted I
					INNER JOIN archGroupCopy C_GDSP ON I.CopyId = C_GDSP.id
					INNER JOIN archGroupCopy C	ON C.SIDBStoreId = C_GDSP.SIDBStoreId
					LEFT OUTER JOIN MMDataPath D ON D.CopyId = C.id AND D.DrivePoolId = I.DrivePoolId AND D.HostClientId = I.HostClientId AND D.SpareGroupId = I.SpareGroupId
			WHERE	C.SIDBStoreId = @l_SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
			AND D.CopyId IS NULL
		END
		DECLARE @l_extendedFlags BIGINT
		SELECT @l_extendedFlags = C.extendedFlags
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0
		BEGIN
			INSERT INTO MMDataPath
			SELECT C.id, I.DrivePoolId, I.HostClientId, I.Flag, I.SpareGroupId,
				I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
				I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM Inserted I
			INNER JOIN archGroupCopy C ON C.destMediaCopyId = I.CopyId
			LEFT OUTER JOIN MMDataPath D ON D.CopyId = C.id AND D.DrivePoolId = I.DrivePoolId AND D.HostClientId = I.HostClientId AND D.SpareGroupId = I.SpareGroupId
			WHERE (C.extendedFlags & 2) > 0
			AND D.CopyId IS NULL
		END
		DECLARE @l_targetCopyTable TABLE ( copyId INT, targetCopyId INT)

		INSERT @l_targetCopyTable
		SELECT R.copyId, R.targetCopyId
		FROM Inserted I
		INNER JOIN archCopyMediaRefreshProp R
		ON I.CopyId = R.CopyId

		IF EXISTS ( SELECT * FROM @l_targetCopyTable)
		BEGIN
			INSERT INTO MMDataPath
			SELECT	T.targetCopyId, I.DrivePoolId, I.HostClientId, (I.Flag & 7), I.SpareGroupId,
					I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
					I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM	Inserted I
					INNER JOIN @l_targetCopyTable T
					ON I.CopyId = T.copyId
					LEFT OUTER JOIN
					(	SELECT DrivePoolId, HostClientId, SpareGroupId
						FROM MMDataPath M, @l_targetCopyTable TT
						WHERE  M.CopyId = TT.targetCopyId ) R
					ON  R.DrivePoolId = I.DrivePoolId AND R.HostClientId = I.HostClientId AND R.SpareGroupId = I.SpareGroupId
			WHERE	R.DrivePoolId IS NULL
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDataPath_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDataPath_AfterIns' AND revision = '1.10')

  insert into GXDBVersions values(6, 'MMDataPath_AfterIns',  '1.10', 'MMDataPath_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDataPath_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDataPath_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDataPath_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDataPath_AfterUpd]
  delete from GXDBVersions where name = 'MMDataPath_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER MMDataPath_AfterUpd
 	ON MMDataPath
	AFTER UPDATE
	AS
 BEGIN
 	IF @@ROWCOUNT = 0 RETURN
 	IF @@ROWCOUNT > 1 RETURN
		SET NOCOUNT ON
		DECLARE @l_SIDBStoreId INTEGER
		DECLARE @l_dedupeFlags INTEGER
		DECLARE @l_dataPathFlags INTEGER
		SELECT @l_SIDBStoreId = C.SIDBStoreId, @l_dedupeFlags = C.dedupeFlags, @l_dataPathFlags = I.Flag
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		WHERE  (I.Flag & 8) = 0 AND (C.dedupeFlags & 268435456) <> 0
		IF  @l_SIDBStoreId IS NOT NULL AND @l_SIDBStoreId > 0
		AND @l_dedupeFlags IS NOT NULL AND (@l_dedupeFlags & 268435456) <> 0
		AND @l_dataPathFlags IS NOT NULL AND (@l_dataPathFlags & 8) = 0
		BEGIN
			UPDATE	MMDataPath
			SET		ReadinessFlag = I.ReadinessFlag, Priority = I.Priority, IsHardwareCompressed = I.IsHardwareCompressed,
					UseHardwareEncryption = I.UseHardwareEncryption
			FROM	Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN archGroupCopy GAGC ON I.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
			WHERE	(I.Flag & 8) = 0
			IF UPDATE(ChunkSizeMB)
			BEGIN
				UPDATE	MMDataPath
				SET ChunkSizeMB = I.ChunkSizeMB
				FROM Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN archGroupCopy GAGC ON I.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
				WHERE	(I.Flag & 8) = 0
			END
			IF UPDATE(FlushBlockSizeKB)
			BEGIN
				UPDATE	MMDataPath
				SET FlushBlockSizeKB = I.FlushBlockSizeKB
				FROM Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN archGroupCopy GAGC ON I.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
				WHERE	(I.Flag & 8) = 0
			END
			IF UPDATE(Flag)
			BEGIN
				UPDATE	MMDataPath
				SET Flag = I.Flag
				FROM Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN archGroupCopy GAGC ON I.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
				WHERE	(I.Flag & 8) = 0
			END
		END
		DECLARE @l_extendedFlags BIGINT
		SELECT @l_extendedFlags = C.extendedFlags
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0
		BEGIN
			UPDATE MMDataPath
			SET		ReadinessFlag = I.ReadinessFlag, Priority = I.Priority, IsHardwareCompressed = I.IsHardwareCompressed,
					ChunkSizeMB = I.ChunkSizeMB, FlushBlockSizeKB = I.FlushBlockSizeKB, UseHardwareEncryption = I.UseHardwareEncryption
			FROM	Inserted I
				INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
				INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
				INNER JOIN archGroupCopy C ON P.CopyId = C.id AND D.CopyId = C.destMediaCopyId AND (C.extendedFlags & 2) <> 0
			IF UPDATE(Flag)
			BEGIN
				UPDATE MMDataPath
				SET		Flag = I.Flag
				FROM	Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND D.CopyId = C.destMediaCopyId AND (C.extendedFlags & 2) <> 0
			END
			IF UPDATE(SpareGroupId)
			BEGIN
				UPDATE MMDataPath
				SET SpareGroupId = I.SpareGroupId
				FROM Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND D.CopyId = C.destMediaCopyId AND (C.extendedFlags & 2) <> 0
			END
		END
		DECLARE @l_targetCopyId INTEGER
		SET @l_targetCopyId  = 0
		SELECT @l_targetCopyId = R.targetCopyId
		FROM Inserted I INNER JOIN archCopyMediaRefreshProp R ON I.CopyId = R.CopyId
		IF @l_targetCopyId > 0
		BEGIN
			UPDATE	MMDataPath
			SET		Flag = (I.Flag & 7), ReadinessFlag = I.ReadinessFlag, Priority = I.Priority, IsHardwareCompressed = I.IsHardwareCompressed,
					ChunkSizeMB = I.ChunkSizeMB, FlushBlockSizeKB = I.FlushBlockSizeKB, UseHardwareEncryption = I.UseHardwareEncryption,
					SpareGroupId = I.SpareGroupId
			FROM	Inserted I
					INNER JOIN Deleted D ON D.DataPathId = I.DataPathId
					INNER JOIN archCopyMediaRefreshProp R ON I.CopyId = R.CopyId
					INNER JOIN MMDataPath P ON P.CopyId = R.targetCopyId AND P.DrivePoolId  = D.DrivePoolId
						AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDataPath_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDataPath_AfterUpd' AND revision = '1.9')

  insert into GXDBVersions values(6, 'MMDataPath_AfterUpd',  '1.9', 'MMDataPath_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDataPath_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDataPath_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDataPath_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDataPath_AfterDel]
  delete from GXDBVersions where name = 'MMDataPath_AfterDel' and type = 6
END
GO

	CREATE TRIGGER MMDataPath_AfterDel
 	ON MMDataPath
	AFTER DELETE
	AS
 BEGIN
 	IF @@ROWCOUNT = 0 RETURN
		SET NOCOUNT ON
		DECLARE @l_SIDBStoreId INTEGER
		DECLARE @l_dedupeFlags INTEGER
		DECLARE @l_dataPathFlags INTEGER
		SELECT @l_SIDBStoreId = C.SIDBStoreId, @l_dedupeFlags = C.dedupeFlags, @l_dataPathFlags = D.Flag
		FROM Deleted D INNER JOIN archGroupCopy C ON D.CopyId = C.id
		WHERE  (D.Flag & 8) = 0 AND (C.dedupeFlags & 268435456) <> 0
		IF  @l_SIDBStoreId IS NOT NULL AND @l_SIDBStoreId > 0
		AND @l_dedupeFlags IS NOT NULL AND (@l_dedupeFlags & 268435456) <> 0
		AND @l_dataPathFlags IS NOT NULL AND (@l_dataPathFlags & 8) = 0
		BEGIN
			UPDATE	MMMediaGroup
			SET 	DrivePoolId 		= DC.DrivePoolId,
					SpareGroupId 		= DC.SpareGroupId,
					DesiredMediaTypeId 	= DT.DefaultMediaTypeId,
					RecordingFormatId 	= RFMT.RecordingFormatId,
					DataPathId 			= DC.DataPathId
			FROM	MMMediaGroup MG
					INNER JOIN archStream S ON MG.MediaGroupId = S.mediaGroupId
					INNER JOIN (SELECT P.CopyId, P.DataPathId
								FROM	Deleted D
										INNER JOIN archGroupCopy GAGC ON D.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
										INNER JOIN MMDataPath P
												ON P.DrivePoolId  = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
										INNER JOIN archGroupCopy C
												ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
								WHERE	(D.Flag & 8) = 0
								) T ON S.archGroupCopyId = T.CopyId AND MG.DataPathId = T.DataPathId
					INNER JOIN MMDataPath DC ON T.CopyId = DC.CopyId AND (DC.Flag & 7) = 7,
					MMDriveType DT,
					MMRecFmtMedTyp RFMT
			WHERE	DT.DefaultMediaTypeId = RFMT.MediaTypeId
					AND DT.DriveTypeId IN  (SELECT  DR.DriveTypeId
										FROM 	MMDrive DR INNER JOIN MMDrivePool DP ON DR.MasterPoolId = DP.MasterPoolId
										WHERE	DP.DrivePoolId = DC.DrivePoolId)

			DELETE	MMDataPath
			FROM	Deleted D
					INNER JOIN archGroupCopy GAGC ON D.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId  = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND C.SIDBStoreId = GAGC.SIDBStoreId AND (C.dedupeFlags & 134217728) <> 0
			WHERE	(D.Flag & 8) = 0
		END
		DECLARE @l_extendedFlags BIGINT
		SELECT @l_extendedFlags = C.extendedFlags
		FROM Deleted D INNER JOIN archGroupCopy C ON D.CopyId = C.id
		IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0
		BEGIN
			DELETE MMDataPath
			FROM Deleted D
				INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id AND D.CopyId = C.destMediaCopyId AND (C.extendedFlags & 2) <> 0
			-- UPDATE MMDataPath
			-- For copies where default DP is deleted, Default to what GACP has defined
			UPDATE MMDP
			SET MMDP.Flag = MMDP.Flag | 2 | 1 -- MMS2_DEFAULT_FAILOVER = 1, MMS2_ACTIVE_FAILOVER = 2
			FROM MMDataPath MMDP,
			(SELECT DISTINCT M.DataPathId
				FROM MMDataPath M,
				 MMDataPath DP_GACP,
				 (SELECT M.CopyId, MAX(M.Flag & 1) as HasDefault, MIN(D.CopyId) as GACPId
					FROM MMDataPath M, archGroupCopy C, Deleted D
					WHERE M.CopyId = C.id
					AND C.destMediaCopyId = D.CopyId
					AND (C.extendedFlags & 2) > 0
					GROUP BY M.CopyId
				  ) Sec_Copies
			WHERE DP_GACP.DrivePoolId = M.DrivePoolId AND DP_GACP.HostClientId = M.HostClientId AND DP_GACP.SpareGroupId = M.SpareGroupId
			AND DP_GACP.CopyId = Sec_Copies.GACPId
			AND Sec_Copies.CopyId = M.CopyId
			AND (DP_GACP.Flag & 1) > 0
			AND Sec_Copies.HasDefault = 0
			 ) T
			WHERE MMDP.DataPathId = T.DataPathId

			-- If we were unable to update some copies because they did not have default DP defined by GACP then pick any DP available.
			UPDATE MMDP
			SET MMDP.Flag = MMDP.Flag | 2 | 1 -- MMS2_DEFAULT_FAILOVER = 1, MMS2_ACTIVE_FAILOVER = 2
			FROM MMDataPath MMDP,
			(SELECT MIN(M.DataPathId) AS DPId
				FROM MMDataPath M,
				 (SELECT M.CopyId, MAX(M.Flag & 1) as HasDefault, MIN(D.CopyId) as GACPId
					FROM MMDataPath M, archGroupCopy C, Deleted D
					WHERE M.CopyId = C.id
					AND C.destMediaCopyId = D.CopyId
					AND (C.extendedFlags & 2) > 0
					GROUP BY M.CopyId
				  ) Sec_Copies
			WHERE Sec_Copies.CopyId = M.CopyId
			AND Sec_Copies.HasDefault = 0
			 ) T
			WHERE MMDP.DataPathId = T.DPId
		END
		DECLARE @l_targetCopyId INTEGER
		DECLARE @l_DataPathId	INTEGER
		SET		@l_targetCopyId	= 0
		SET		@l_DataPathId	= 0
		SELECT @l_targetCopyId = R.targetCopyId
		FROM Deleted D INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
		IF @l_targetCopyId > 0
		BEGIN
			UPDATE	MMMediaGroup
			SET 	DrivePoolId 		= DC.DrivePoolId,
					SpareGroupId 		= DC.SpareGroupId,
					DesiredMediaTypeId 	= DT.DefaultMediaTypeId,
					RecordingFormatId 	= RFMT.RecordingFormatId,
					DataPathId 			= DC.DataPathId
			FROM	MMMediaGroup MG
					INNER JOIN archStream S ON MG.MediaGroupId = S.mediaGroupId
					INNER JOIN (SELECT  DP.CopyId, DP.DataPathId
								FROM	Deleted D
										INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
										INNER JOIN MMDataPath DP ON DP.CopyId = R.targetCopyId AND DP.DrivePoolId = D.DrivePoolId
											AND DP.HostClientId = D.HostClientId AND DP.SpareGroupId = D.SpareGroupId
								)  T ON S.archGroupCopyId = T.CopyId AND MG.DataPathId = T.DataPathId
					INNER JOIN MMDataPath DC ON T.CopyId = DC.CopyId AND (DC.Flag & 7) = 7,
					MMDriveType DT,
					MMRecFmtMedTyp RFMT
			WHERE	DT.DefaultMediaTypeId = RFMT.MediaTypeId
					AND DT.DriveTypeId IN  (SELECT  DR.DriveTypeId
										FROM 	MMDrive DR INNER JOIN MMDrivePool DP ON DR.MasterPoolId = DP.MasterPoolId
										WHERE	DP.DrivePoolId = DC.DrivePoolId)
			DELETE	MMDataPath
			FROM	Deleted D INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
			WHERE	MMDataPath.CopyId = R.targetCopyId AND MMDataPath.DrivePoolId = D.DrivePoolId
														AND MMDataPath.HostClientId = D.HostClientId AND MMDataPath.SpareGroupId = D.SpareGroupId
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDataPath_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDataPath_AfterDel' AND revision = '1.8')

  insert into GXDBVersions values(6, 'MMDataPath_AfterDel',  '1.8', 'MMDataPath_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMErrorTracker_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMErrorTracker_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMErrorTracker_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMErrorTracker_AfterIns]
  delete from GXDBVersions where name = 'MMErrorTracker_AfterIns' and type = 6
END
GO

 CREATE TRIGGER MMErrorTracker_AfterIns
 	ON MMErrorTracker
 AFTER INSERT
 AS
 BEGIN

 SET NOCOUNT ON

 DECLARE @lt_DrivesToTakeOffline TABLE (DriveId INTEGER, MediaId INTEGER,
 									ErrorCode Integer, ErrorTrackerid Integer)

 INSERT INTO @lt_DrivesToTakeOffline
 SELECT I.DriveId, I.MediaId, I.ErrorCode, I.ErrorTrackerId
 FROM Inserted I INNER JOIN MMSCSIErrorsToTrack MS ON MS.MMErrorCode = I.ErrorCode AND
 				MS.MarkDriveDisabled = 1
 WHERE I.DriveId > 0 AND I.ErrorCode > 0

 IF (@@ROWCOUNT > 0)
 BEGIN

 	DECLARE @MM_MARKED_DRIVE_BAD	integer
 	set @MM_MARKED_DRIVE_BAD	=	1

 	DECLARE @actionTaken integer
 	SET @actionTaken =	0

 	DECLARE @CurrentUTCDate integer
 	SET @CurrentUTCDate = datediff(second, '01/01/1970', getdate())

 	UPDATE MMDrive
		SET DriveEnabled = 0, OfflineTimeStamp = @CurrentUTCDate, OfflineReason = 15
 	FROM @lt_DrivesToTakeOffline  tt
 	WHERE MMDrive.DriveId = tt.DriveId
 	-- Should we insert into drive state history?

 	SET @actionTaken =	@MM_MARKED_DRIVE_BAD


 	INSERT INTO MMErrorAction
 	SELECT DriveId, MediaId, ErrorCode, @CurrentUTCDate, ErrorTrackerId, @actionTaken
 	FROM @lt_DrivesToTakeOffline

 END


 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMErrorTracker_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMErrorTracker_AfterIns' AND revision = '1.1')

  insert into GXDBVersions values(6, 'MMErrorTracker_AfterIns',  '1.1', 'MMErrorTracker_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMConfigs_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMConfigs_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMConfigs_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMConfigs_AfterUpd]
  delete from GXDBVersions where name = 'MMConfigs_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER MMConfigs_AfterUpd
 	ON MMConfigs
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows updated
		IF (UPDATE(value))
 	BEGIN
			DECLARE	@isEnabled	integer
			SET 		@isEnabled = 0
			SELECT	@isEnabled = value
			FROM		Inserted
			WHERE		name = 'DA_ENABLE_DISABLE_TROUBLESHOOTING'
			--------------------------------------------------------------------
			-- Enable/Disable the troubleshooting triggers only if the value for
			-- DA_ENABLE_DISABLE_TROUBLESHOOTING is updated
			--------------------------------------------------------------------
			IF @@ROWCOUNT != 0
			BEGIN
				IF (@isEnabled = 0)
				BEGIN
					-- Disable trigger on archFile table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFile
						DISABLE TRIGGER archFile_AfterDel
					END

					-- Disable trigger on archFileCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFileCopy
						DISABLE TRIGGER archFileCopy_AfterDel
					END

					-- Disable trigger on archChunkMapping table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkMapping_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkMapping
						DISABLE TRIGGER archChunkMapping_AfterDel
					END

					-- Disable trigger on archChunk table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunk
						DISABLE TRIGGER archChunk_AfterDel
					END
				END
				ELSE
				BEGIN
					-- Enable trigger on archFile table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFile
						ENABLE TRIGGER archFile_AfterDel
					END

					-- Enable trigger on archFileCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFileCopy
						ENABLE TRIGGER archFileCopy_AfterDel
					END

					-- Enable trigger on archChunkMapping table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkMapping_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkMapping
						ENABLE TRIGGER archChunkMapping_AfterDel
					END

					-- Enable trigger on archChunk table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunk
						ENABLE TRIGGER archChunk_AfterDel
					END
				END
			END
			SET 		@isEnabled = 0
			SELECT	@isEnabled = value
			FROM		Inserted
			WHERE		name = 'AUXCOPY_ENABLE_DISABLE_TROUBLESHOOTING'
			--------------------------------------------------------------------
			-- Enable/Disable the troubleshooting triggers only if the value for
			-- AUXCOPY_ENABLE_DISABLE_TROUBLESHOOTING is updated
			--------------------------------------------------------------------
			IF @@ROWCOUNT != 0
			BEGIN
				IF (@isEnabled = 0)
				BEGIN
					-- Disable trigger on archChunkToCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToCopy
						DISABLE TRIGGER archChunkToCopy_AfterDel
					END

					-- Disable trigger on archChunkToSyncDDB table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToSyncDDB_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToSyncDDB
						DISABLE TRIGGER archChunkToSyncDDB_AfterDel
					END

					-- Disable trigger on archChunkToVerify table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToVerify
						DISABLE TRIGGER archChunkToVerify_AfterDel
					END

					-- Disable trigger on archContentIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archContentIndexingAF
						DISABLE TRIGGER archContentIndexingAF_AfterDel
					END

					-- Disable trigger on archFLAIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFLAIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFLAIndexingAF
						DISABLE TRIGGER archFLAIndexingAF_AfterDel
					END
				END
				ELSE
				BEGIN
					-- Enable trigger on archChunkToCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToCopy
						ENABLE TRIGGER archChunkToCopy_AfterDel
					END

					-- Enable trigger on archChunkToSyncDDB table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToSyncDDB_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToSyncDDB
						ENABLE TRIGGER archChunkToSyncDDB_AfterDel
					END

					-- Enable trigger on archChunkToVerify table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToVerify
						ENABLE TRIGGER archChunkToVerify_AfterDel
					END

					-- Enable trigger on archContentIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archContentIndexingAF
						ENABLE TRIGGER archContentIndexingAF_AfterDel
					END

					-- Enable trigger on archFLAIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFLAIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFLAIndexingAF
						ENABLE TRIGGER archFLAIndexingAF_AfterDel
					END
				END
			END
 	END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMConfigs_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMConfigs_AfterUpd' AND revision = '1.2')

  insert into GXDBVersions values(6, 'MMConfigs_AfterUpd',  '1.2', 'MMConfigs_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolAction_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolAction_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolAction_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolAction_AfterDel]
  delete from GXDBVersions where name = 'SMVolAction_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMVolAction_AfterDel
 	ON SMVolAction
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMVolActionHistory
		SELECT GETUTCDATE(), *
		FROM Deleted
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolAction_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolAction_AfterDel' AND revision = '1.2')

  insert into GXDBVersions values(6, 'SMVolAction_AfterDel',  '1.2', 'SMVolAction_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolume_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolume_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolume_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolume_AfterIns]
  delete from GXDBVersions where name = 'SMVolume_AfterIns' and type = 6
END
GO

	CREATE TRIGGER SMVolume_AfterIns
 	ON SMVolume
	AFTER INSERT
	AS
	BEGIN
			IF EXISTS (
			SELECT	A.SMVolumeId, A.CommCellId, A.CopyId
			FROM	INSERTED A, SMVolume B WITH (NOLOCK)
			WHERE	A.RecoveryPointId > 0 AND A.RecoveryPointId = B.RecoveryPointId AND A.VolumeFlags & 8192 = 8192 /* CVSM_VOLUMEFLAGS_SCG_VOLUMES */ AND
					A.SMVolumeId <> B.SMVolumeId AND A.CommCellId = B.CommCellId AND A.CopyId <> B.CopyId)
			BEGIN
				RAISERROR('Two different copies are used. Same copy should be used for shared snaps', 16, 1)
				ROLLBACK TRANSACTION
			END
	END
	BEGIN
			IF EXISTS (
			SELECT	A.ArchFileId, A.CommCellId, A.CopyId
			FROM	INSERTED A, ArchFileCopy B WITH (NOLOCK)
			WHERE	A.RecoveryPointId > 0 AND A.VolumeFlags & 8192 = 8192 /* CVSM_VOLUMEFLAGS_SCG_VOLUMES */ AND A.ArchFileId = B.ArchFileId AND A.CommCellId = B.CommCellId AND A.CopyId <> B.ArchCopyId )
			BEGIN
				RAISERROR('Two different copies are used. Same copy should be used for shared snaps', 16, 1)
				ROLLBACK TRANSACTION
			END
	END
	BEGIN
		IF NOT EXISTS (
		SELECT A.ArchFileId, A.CommCellId, A.CopyId
		FROM INSERTED A, ArchFileCopy B WITH (NOLOCK)
		WHERE A.ArchFileId = B.ArchFileId AND A.CommCellId = B.CommCellId AND A.CopyId = B.ArchCopyId )
		BEGIN
			RAISERROR('Invalid archive file inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	BEGIN
		IF NOT EXISTS (
		SELECT A.SourceClientId
		FROM INSERTED A, APP_Client B WITH (NOLOCK)
		WHERE A.SourceClientId = B.id AND A.SourceClientId > 0 )
		BEGIN
			RAISERROR('Invalid SourceClientId inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	BEGIN
		IF NOT EXISTS (
		SELECT A.AppId
		FROM INSERTED A, APP_Application B WITH (NOLOCK)
		WHERE A.AppId = B.id AND A.AppId > 0 )
		BEGIN
			RAISERROR('Invalid AppId inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolume_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolume_AfterIns' AND revision = '1.4')

  insert into GXDBVersions values(6, 'SMVolume_AfterIns',  '1.4', 'SMVolume_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolume_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolume_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolume_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolume_AfterUpd]
  delete from GXDBVersions where name = 'SMVolume_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER SMVolume_AfterUpd
 	ON SMVolume
	AFTER UPDATE
	AS
	/*IF UPDATE (ArchFileId)
	BEGIN
		IF EXISTS (
		SELECT A.*
		FROM INSERTED A, DELETED B
		WHERE A.SMVolumeId = B.SMVolumeId
		AND A.ArchFileId <> B.ArchFileId)
		BEGIN
			RAISERROR('ArchFileId cannot be changed', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	IF UPDATE (CopyId)
	BEGIN
		IF EXISTS (
		SELECT A.*
		FROM INSERTED A, DELETED B
		WHERE A.SMVolumeId = B.SMVolumeId
		AND A.CopyId <> B.CopyId)
		BEGIN
			RAISERROR('CopyId cannot be changed', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	IF UPDATE (SourceClientId)
	BEGIN
		IF EXISTS (
		SELECT A.*
		FROM INSERTED A, DELETED B
		WHERE A.SMVolumeId = B.SMVolumeId
		AND A.SourceClientId <> B.SourceClientId)
		BEGIN
			RAISERROR('SourceClientId cannot be changed', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	IF UPDATE (AppId)
	BEGIN
		IF EXISTS (
		SELECT A.*
		FROM INSERTED A, DELETED B
		WHERE A.SMVolumeId = B.SMVolumeId
		AND A.AppId <> B.AppId)
		BEGIN
			RAISERROR('AppId cannot be changed', 16, 1)
			ROLLBACK TRANSACTION
		END
 END*/
 IF UPDATE (MountStatus)
 BEGIN
		UPDATE SMVolume
			SET MountStatusUpdateTime = dbo.GetUnixTime(GetUTCDate())
		FROM SMVolume
		WHERE SMVolumeId IN
			(SELECT A.SMVolumeId FROM INSERTED A, DELETED B
			WHERE A.SMVolumeId = B.SMVolumeId)
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolume_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolume_AfterUpd' AND revision = '1.5')

  insert into GXDBVersions values(6, 'SMVolume_AfterUpd',  '1.5', 'SMVolume_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolume_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolume_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolume_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolume_AfterDel]
  delete from GXDBVersions where name = 'SMVolume_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMVolume_AfterDel
 	ON SMVolume
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMVolumeDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolume_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolume_AfterDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'SMVolume_AfterDel',  '1.1', 'SMVolume_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMSnap_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMSnap_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMSnap_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMSnap_AfterDel]
  delete from GXDBVersions where name = 'SMSnap_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMSnap_AfterDel
 	ON SMSnap
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMSnapDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMSnap_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMSnap_AfterDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'SMSnap_AfterDel',  '1.1', 'SMSnap_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolSnapMap_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolSnapMap_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolSnapMap_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolSnapMap_AfterDel]
  delete from GXDBVersions where name = 'SMVolSnapMap_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMVolSnapMap_AfterDel
 	ON SMVolSnapMap
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMVolSnapMapDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolSnapMap_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolSnapMap_AfterDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'SMVolSnapMap_AfterDel',  '1.1', 'SMVolSnapMap_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMetaData_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMetaData_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMetaData_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMetaData_AfterDel]
  delete from GXDBVersions where name = 'SMMetaData_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMMetaData_AfterDel
 	ON SMMetaData
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMMetaDataDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMetaData_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMetaData_AfterDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'SMMetaData_AfterDel',  '1.1', 'SMMetaData_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMetaData_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMetaData_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMetaData_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMetaData_AfterUpd]
  delete from GXDBVersions where name = 'SMMetaData_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER SMMetaData_AfterUpd
 	ON SMMetaData
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @Seperator			varchar(1)
		SET @Seperator = '|'
		DECLARE @Idx				integer
		DECLARE @VolumePath			nvarchar(max)
		DECLARE	@RefId				integer
		DECLARE	@RefType			integer
		DECLARE	@MetaDataType		integer
		DECLARE @MetaData			nvarchar(max)
		DECLARE @SnapShoEngineId	integer = 0


		IF UPDATE (MetaData)
		BEGIN
			SELECT	@RefId = RefId, @RefType = RefType,
					@MetaDataType = MetaDataType, @MetaData = CONVERT(NVARCHAR(max), MetaData),
					@SnapShoEngineId = SNAP.SnapShotEngineId
			FROM	INSERTED INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = RefId

			IF @RefType <> 2		-- SM_MRT_SNAP
				OR @MetaDataType <> 6	-- SM_MDT_SNAP_UUID
				OR @SnapShoEngineId <> 3  -- SM_SNAPSHOT_ENGINE_NETAPP
				RETURN

			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData)
			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData, (@Idx + 1))
			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData, (@Idx + 1))
			SET @Idx = @Idx + 1
			SET @VolumePath = SUBSTRING(@MetaData, @Idx, (LEN(@MetaData) - @Idx + 1))

			UPDATE	SMSnap
			SET		ReserveFieldStr = @VolumePath
			WHERE	SMSnapId = @RefId
					AND SnapShotEngineId = 3	-- SM_SNAPSHOT_ENGINE_NETAPP
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMetaData_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMetaData_AfterUpd' AND revision = '1.4')

  insert into GXDBVersions values(6, 'SMMetaData_AfterUpd',  '1.4', 'SMMetaData_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMTempDeletedAF_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMTempDeletedAF_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMTempDeletedAF_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMTempDeletedAF_AfterIns]
  delete from GXDBVersions where name = 'MMTempDeletedAF_AfterIns' and type = 6
END
GO

	CREATE TRIGGER MMTempDeletedAF_AfterIns
 	ON MMTempDeletedAF
	AFTER INSERT
	AS
	BEGIN
		DECLARE @CurrentTime INTEGER;
		SET @CurrentTime = dbo.GetUnixTime(GetUTCDate())

		UPDATE	MMTempDeletedAF
		SET		/* DeletedTime = @CurrentTime, */ CreatedTime = @CurrentTime
		FROM	INSERTED A, MMTempDeletedAF B WITH (READUNCOMMITTED)
		WHERE	A.archFileId = B.archFileId
				AND A.VolumeId = B.VolumeId
				AND A.ArchChunkId = B.ArchChunkId
				AND A.SIDBStoreId = B.SIDBStoreId
				AND A.CommCellId = B.CommCellId
				AND A.chunkCommCellId = B.chunkCommCellId
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMTempDeletedAF_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMTempDeletedAF_AfterIns' AND revision = '1.4')

  insert into GXDBVersions values(6, 'MMTempDeletedAF_AfterIns',  '1.4', 'MMTempDeletedAF_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMControlHost_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMControlHost_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMControlHost_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMControlHost_AfterDel]
  delete from GXDBVersions where name = 'SMControlHost_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMControlHost_AfterDel
 	ON SMControlHost
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		IF EXISTS (SELECT	MetaDataId
					FROM	SMMetaData
					WHERE	RefType = 5 -- MM_SM_METADATA_REFTYPE_ARRAY
							AND MetaDataType IN (32, 41) -- SM_MDT_ARRAY_ALIAS, SM_MDT_PHY_ARRAY
							AND RefId IN (SELECT ControlHostId FROM DELETED))
		BEGIN
			DELETE	FROM SMMetaData
			WHERE	RefType = 5 -- MM_SM_METADATA_REFTYPE_ARRAY
					AND MetaDataType IN (32, 41) -- SM_MDT_ARRAY_ALIAS, SM_MDT_PHY_ARRAY
					AND RefId IN (SELECT ControlHostId FROM DELETED)
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMControlHost_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMControlHost_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'SMControlHost_AfterDel',  '1.3', 'SMControlHost_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMTempDeletedAF_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMTempDeletedAF_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMTempDeletedAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMTempDeletedAF_AfterDel]
  delete from GXDBVersions where name = 'MMTempDeletedAF_AfterDel' and type = 6
END
GO

	CREATE TRIGGER MMTempDeletedAF_AfterDel
 	ON MMTempDeletedAF
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO MMTempDeletedAFPruningLogs (ArchFileId, VolumeId, Status, Retry, CopyId, cclip, CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, AdminJobId, PruneStatus, CreatedTime, PruneTime, processId, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt, chunkCommCellId)
		SELECT D.ArchFileId, D.VolumeId, D.Status, D.Retry, D.CopyId, D.cclip, D.CapacityFreedBytes, D.ArchChunkId, D.MountPathId, D.SIDBStoreId, D.CommCellId, D.DeletedTime, D.AdminJobId, D.PruneStatus, D.CreatedTime, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId, D.subStoreBitField, D.sidbPruningFlag, D.appSizeFreedBytes, D.reserveInt, D.chunkCommCellId
		FROM Deleted D
 	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMTempDeletedAF_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMTempDeletedAF_AfterDel' AND revision = '1.3')

  insert into GXDBVersions values(6, 'MMTempDeletedAF_AfterDel',  '1.3', 'MMTempDeletedAF_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMountVolume_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMountVolume_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMountVolume_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMountVolume_AfterDel]
  delete from GXDBVersions where name = 'SMMountVolume_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMMountVolume_AfterDel
 	ON SMMountVolume
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMMountVolumeDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMountVolume_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMountVolume_AfterDel' AND revision = '')

  insert into GXDBVersions values(6, 'SMMountVolume_AfterDel',  '', 'SMMountVolume_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMountSnap_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMountSnap_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMountSnap_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMountSnap_AfterDel]
  delete from GXDBVersions where name = 'SMMountSnap_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMMountSnap_AfterDel
 	ON SMMountSnap
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMMountSnapDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMountSnap_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMountSnap_AfterDel' AND revision = '')

  insert into GXDBVersions values(6, 'SMMountSnap_AfterDel',  '', 'SMMountSnap_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMountMap_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMountMap_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMountMap_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMountMap_AfterDel]
  delete from GXDBVersions where name = 'SMMountMap_AfterDel' and type = 6
END
GO

	CREATE TRIGGER SMMountMap_AfterDel
 	ON SMMountMap
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		INSERT INTO SMMountMapDeleted
		SELECT GETUTCDATE(), *
		FROM DELETED
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMountMap_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMountMap_AfterDel' AND revision = '')

  insert into GXDBVersions values(6, 'SMMountMap_AfterDel',  '', 'SMMountMap_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDeletedAF_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDeletedAF_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDeletedAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDeletedAF_AfterDel]
  delete from GXDBVersions where name = 'MMDeletedAF_AfterDel' and type = 6
END
GO

	CREATE TRIGGER MMDeletedAF_AfterDel
 	ON MMDeletedAF
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO MMDeletedAFPruningLogs (archFileId, VolumeId, Status, Retry, copyId, cclip, CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt, chunkCommCellId, PruneTime, ProcessId)
		SELECT D.archFileId, D.VolumeId, D.Status, D.Retry, D.copyId, D.cclip, D.CapacityFreedBytes, D.ArchChunkId, D.MountPathId, D.SIDBStoreId, D.CommCellId, D.DeletedTime, D.FailureErrorCode, D.subStoreBitField, D.sidbPruningFlag, D.appSizeFreedBytes, D.reserveInt, D.chunkCommCellId, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
		FROM DELETED D, MMVolume V WITH (NOLOCK)
		WHERE (D.VolumeId > 0 AND D.VolumeId = V.VolumeId AND V.RecordingFormatId = 10001) OR (D.SIDBstoreId > 0 AND D.VolumeId = 0 AND D.VolumeId = V.VolumeId) -- either match vol and recfmt or match store with vol=0 row
 	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDeletedAF_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDeletedAF_AfterDel' AND revision = '1.2')

  insert into GXDBVersions values(6, 'MMDeletedAF_AfterDel',  '1.2', 'MMDeletedAF_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CCMMediaTypeAnswers_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CCMMediaTypeAnswers_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCMMediaTypeAnswers_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CCMMediaTypeAnswers_AfterUpd]
  delete from GXDBVersions where name = 'CCMMediaTypeAnswers_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER CCMMediaTypeAnswers_AfterUpd
 	ON CCMMediaTypeAnswers
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		IF (UPDATE(libraryId))
 	        BEGIN
			UPDATE CCMMediaTypeAnswers
			SET DrivePoolId = 0, SparePoolGroupId = 0
			FROM CCMMediaTypeAnswers a, INSERTED I
			WHERE a.MediaTypeId = I.MediaTypeId
                       AND I.libraryId = 0
 	        END
		IF (UPDATE(mediaAgentId))
 	        BEGIN
			UPDATE CCMMediaTypeAnswers
			SET DrivePoolId = 0, SparePoolGroupId = 0, libraryId = 0
			FROM CCMMediaTypeAnswers a, INSERTED I
			WHERE a.MediaTypeId = I.MediaTypeId
                       AND I.mediaAgentId = 0
 	        END
     END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CCMMediaTypeAnswers_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CCMMediaTypeAnswers_AfterUpd' AND revision = '1.1')

  insert into GXDBVersions values(6, 'CCMMediaTypeAnswers_AfterUpd',  '1.1', 'CCMMediaTypeAnswers_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CCMMountPathAnswers_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CCMMountPathAnswers_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCMMountPathAnswers_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CCMMountPathAnswers_AfterUpd]
  delete from GXDBVersions where name = 'CCMMountPathAnswers_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER CCMMountPathAnswers_AfterUpd
 	ON CCMMountPathAnswers
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
     /*With the new changes to migrate library this will cause issue. so commenting out*/
		--IF (UPDATE(TargetLibraryId))
 	--        BEGIN
		--	UPDATE CCMMountPathAnswers
		--	SET allowEdit = 1, TargetMountPathName = '', TargetMountPathUserName = '', TargetMountPathPassword = ''
		--	FROM CCMMountPathAnswers a, INSERTED I
		--	WHERE a.SourceCommCellId = I.SourceCommCellId
     --                 AND a.SourceMountPathId = I.SourceMountPathId
     --                  AND I.TargetLibraryId = 0
 	--        END
     END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CCMMountPathAnswers_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CCMMountPathAnswers_AfterUpd' AND revision = '1.2')

  insert into GXDBVersions values(6, 'CCMMountPathAnswers_AfterUpd',  '1.2', 'CCMMountPathAnswers_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CCMSIDBPathAnswers_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CCMSIDBPathAnswers_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCMSIDBPathAnswers_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CCMSIDBPathAnswers_AfterUpd]
  delete from GXDBVersions where name = 'CCMSIDBPathAnswers_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER CCMSIDBPathAnswers_AfterUpd
 	ON CCMSIDBPathAnswers
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		IF (UPDATE(TargetMediaAgentId))
 	        BEGIN
			UPDATE CCMSIDBPathAnswers
			SET TargetPathName = '', TargetUserName = '', TargetPasword = ''
			FROM CCMSIDBPathAnswers a, INSERTED I
			WHERE a.SourceCommCellId = I.SourceCommCellId
                       AND a.SourceIdxAccessPathId = I.SourceIdxAccessPathId
                       AND I.TargetMediaAgentId = 0
 	        END
     END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CCMSIDBPathAnswers_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CCMSIDBPathAnswers_AfterUpd' AND revision = '1.1')

  insert into GXDBVersions values(6, 'CCMSIDBPathAnswers_AfterUpd',  '1.1', 'CCMSIDBPathAnswers_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBStore_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBStore_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBStore_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBStore_AfterDel]
  delete from GXDBVersions where name = 'IdxSIDBStore_AfterDel' and type = 6
END
GO

	CREATE TRIGGER IdxSIDBStore_AfterDel
 	ON IdxSIDBStore
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO IdxSIDBStorePruningLogs (SIDBStoreId, SIDBStoreName, SIDBStoreAliasName, commCellId, IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime, MinObjSizeKB, oldestEligibleObjArchiveTime,
					SignatureType, flags, TotalDataSizeBytes, InstancedDataSizeBytes, Status, LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId, Version,
					SIDBSnapPath, LastSnapTime, LastRecoveryTime, SealedReason, pruneTime, processId)
		SELECT D.SIDBStoreId, D.SIDBStoreName, D.SIDBStoreAliasName, D.commCellId, D.IdxCacheId, D.IdxAccessPathId, D.ClientId, D.FirstBackupTime, D.MinObjSizeKB, D.oldestEligibleObjArchiveTime,
					D.SignatureType, D.flags, D.TotalDataSizeBytes, D.InstancedDataSizeBytes, D.Status, D.LastAccessTime, D.CreatedTime, D.SealedTime, D.origCCSIDBStoreId, D.Version,
					D.SIDBSnapPath, D.LastSnapTime, D.LastRecoveryTime, D.SealedReason, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
		FROM Deleted D

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBStore_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBStore_AfterDel' AND revision = '1.4')

  insert into GXDBVersions values(6, 'IdxSIDBStore_AfterDel',  '1.4', 'IdxSIDBStore_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBSubStore_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBSubStore_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBSubStore_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBSubStore_AfterDel]
  delete from GXDBVersions where name = 'IdxSIDBSubStore_AfterDel' and type = 6
END
GO

	CREATE TRIGGER IdxSIDBSubStore_AfterDel
		ON IdxSIDBSubStore
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@l_mainStoreId INTEGER
		DECLARE	@l_mainStoreCCId INTEGER
		DECLARE	@l_minLastSnapTime INTEGER
		DECLARE	@l_lastSnapTime INTEGER
		SET NOCOUNT OFF
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBSubStore_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBSubStore_AfterDel' AND revision = '1.4')

  insert into GXDBVersions values(6, 'IdxSIDBSubStore_AfterDel',  '1.4', 'IdxSIDBSubStore_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBSubStore_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBSubStore_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBSubStore_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBSubStore_AfterUpd]
  delete from GXDBVersions where name = 'IdxSIDBSubStore_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER IdxSIDBSubStore_AfterUpd
		ON IdxSIDBSubStore
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@l_subStoreId INTEGER
		DECLARE	@l_mainStoreId INTEGER
		DECLARE	@l_mainStoreCCId INTEGER
		DECLARE	@l_minLastSnapTime INTEGER
		DECLARE	@l_lastSnapTime INTEGER
		DECLARE @l_reconSIDBs TABLE (SIDBStoreId INTEGER)

		IF UPDATE (FirstBackupTime)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		FirstBackupTime = INS.FirstBackupTime
			FROM	IdxSIDBStore MAIN INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					AND MAIN.FirstBackupTime = -1
		END


		IF UPDATE (Status)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		Status = (SELECT CASE
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) > AT.percentCorruptLimit AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 > 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1)
							THEN 1
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) >= 1 AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 = 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1) -- when resiliency is off check for first substore corruption
							THEN 1
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) > AT.percentCorruptLimit AND AGC.dedupeFlags & 33554432 = 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId) = 1) -- with only 1 substore
							THEN 1
							WHEN (AGC.dedupeFlags & 33554432 > 0 AND NOT EXISTS (SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = MAIN.SIDBStoreId AND status = 0))
							THEN 1
							ELSE 0
								END)
			FROM	IdxSIDBStore MAIN WITH (NOLOCK) INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.SIDBStoreId = MAIN.SIDBStoreId
					INNER JOIN archTask AT WITH (NOLOCK) ON AGC.sealStoreTaskId = AT.id
		END

		IF UPDATE (Version)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		Version = INS.Version
			FROM	IdxSIDBStore MAIN INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					AND MAIN.Version = -1
		END

		IF UPDATE (TotalDataSizeBytes)
		BEGIN
			SELECT	@l_mainStoreId = SIDBStoreId, @l_mainStoreCCId = CommCellId, @l_subStoreId = SubStoreId
			FROM	INSERTED
			DECLARE	@TotalDataSizeBytesSum BIGINT

			SELECT	@TotalDataSizeBytesSum = SUM(TotalDataSizeBytes)
			FROM	IdxSIDBSubStore WITH (NOLOCK)
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId

			UPDATE	IdxSIDBStore
			SET		TotalDataSizeBytes = @TotalDataSizeBytesSum
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId
		END

		IF UPDATE (InstancedDataSizeBytes)
		BEGIN
			SELECT	@l_mainStoreId = SIDBStoreId, @l_mainStoreCCId = CommCellId, @l_subStoreId = SubStoreId
			FROM	INSERTED
			DECLARE	@InstancedDataSizeBytesSum BIGINT

			SELECT	@InstancedDataSizeBytesSum = SUM(InstancedDataSizeBytes)
			FROM	IdxSIDBSubStore WITH (NOLOCK)
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId

			UPDATE	IdxSIDBStore
			SET		InstancedDataSizeBytes = @InstancedDataSizeBytesSum
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId
		END

		IF (EXISTS (SELECT * FROM
					inserted a left join deleted b on a.SubStoreId = b.SubStoreId
					where a.LastAccessTime <> b.LastAccessTime
				)
		)
		BEGIN
			if ((select top 1 program_name from master..sysprocesses where spid = @@SPID) <> 'MediaManager.exe')
			BEGIN

				IF object_id('tempdb.dbo.#IdxSIDBSubStore_Process_Details') is not null DROP TABLE #IdxSIDBSubStore_Process_Details
				Create Table #IdxSIDBSubStore_Process_Details
					(
						SPID smallint,
						Status varchar(100),
						Login  varchar(100),
						HostName varchar(100),
						BlkBy varchar(100),
						DBName   varchar(100),
						Command  varchar(8000),
						CPUTime int,
						DiskIO int,
						LastBatch varchar(50),
						ProgramName varchar(1000),
						SPIID int,
						RequestId int
					)


				insert
				into #IdxSIDBSubStore_Process_Details
				exec sp_who2 @@SPID

				 CREATE TABLE #inputbuffer
				 (
				  EventType nvarchar(30),
				  Parameters int,
				  EventInfo nvarchar(4000)
				 )
				 DECLARE @ExecStr varchar(50), @Qry nvarchar(4000)

				 SET @ExecStr = 'DBCC INPUTBUFFER(' + STR(@@SPID) + ')'

				 INSERT INTO #inputbuffer
				 EXEC (@ExecStr)

				 SET @Qry = (SELECT EventInfo FROM #inputbuffer)


				Update #IdxSIDBSubStore_Process_Details
				set Command = @Qry

				if exists (Select * from sys.objects where object_id = OBJECT_ID('MMTblUpdatesHistory'))
				insert into MMTblUpdatesHistory
					select p.SPID, p.Status, p.Login, p.HostName, p.BlkBy, p.DBName, p.Command, p.CPUTime, p.DiskIO, dbo.getUnixTime(GETUTCDATE()), p.ProgramName, p.SPIID, p.RequestId,c.*
					from #IdxSIDBSubStore_Process_Details p,
					(
					select a.SubStoreId as RowId, a.LastAccessTime as newIntValue, b.LastAccessTime as oldIntValue, '' as newStrValue, '' as oldStrValue, GETUTCDATE() as RunTime, 'IdxSIDBSubStore' as TableName
					from inserted a left join deleted b on a.SubStoreId = b.SubStoreId
						where a.LastAccessTime <> b.LastAccessTime
					) c

				drop table #IdxSIDBSubStore_Process_Details
				drop table #inputbuffer
			END
	END



		SET NOCOUNT OFF
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBSubStore_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBSubStore_AfterUpd' AND revision = '1.21')

  insert into GXDBVersions values(6, 'IdxSIDBSubStore_AfterUpd',  '1.21', 'IdxSIDBSubStore_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMEntityProp_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMEntityProp_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMEntityProp_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMEntityProp_AfterUpd]
  delete from GXDBVersions where name = 'MMEntityProp_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER MMEntityProp_AfterUpd
	ON MMEntityProp
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		IF NOT EXISTS (SELECT * FROM INSERTED WHERE EntityType = 2 AND propertyName = 'retentionJobs' AND propDataType = 1)	RETURN
		UPDATE	MMEntityProp
		SET		intVal = I.intVal
		FROM	archGroupCopy AS AGC WITH (NOLOCK), INSERTED AS I
		WHERE	I.EntityType = 2 AND I.propertyName = 'retentionJobs' and I.propDataType = 1
				AND MMEntityProp.EntityId = AGC.id
				AND MMEntityProp.EntityType = 2 AND MMEntityProp.propertyName = 'retentionJobs' and MMEntityProp.propDataType = 1
				AND (AGC.sourceCopyId = I.EntityId OR
					AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WITH (NOLOCK) WHERE sourceCopyId = I.EntityId AND isSnapCopy = 1 AND isMirrorCopy = 1))
				AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMEntityProp_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMEntityProp_AfterUpd' AND revision = '1.1')

  insert into GXDBVersions values(6, 'MMEntityProp_AfterUpd',  '1.1', 'MMEntityProp_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBSubStoreStateHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBSubStoreStateHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBSubStoreStateHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBSubStoreStateHistoryTrigger]
  delete from GXDBVersions where name = 'IdxSIDBSubStoreStateHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER	IdxSIDBSubStoreStateHistoryTrigger
	ON 		IdxSIDBSubStoreStateHistory
	INSTEAD OF INSERT
	AS
	BEGIN
		DECLARE @HourStartDate	int
		DECLARE @DiffSeconds	int
		declare @tblSubStore table
		(
		 SIDBStoreId		int,
		 SubStoreId		int,
		 CommCellId		int,
		 SubStoreStatus	int,
		 fallBackSubStoreId int,
		 OfflineEntity int,
		 OfflineReason int,
		 TimeStart	int
		 )

		INSERT INTO @tblSubStore
		SELECT I.SIDBStoreId,
				I.SubStoreId,
				I.CommCellId,
				I.Status,
				I.fallBackSubStoreId,
				I.OfflineEntity,
				I.OfflineReason,
				I.Time
		FROM 	Inserted I
		SET NOCOUNT ON

		SET @HourStartDate = dbo.getUnixTime(dbo.GetHourStart(GetUTCDate()))
		IF 	EXISTS
			(SELECT *
			 FROM IdxSIDBSubStoreStateHistory   IDX, @tblSubStore T
			 WHERE 	    IDX.SIDBStoreId 	= T.SIDBStoreId
				and IDX.SubStoreId 	= T.SubStoreId
				and IDX.CommCellId  = T.CommCellId
				and IDX.Time	 		> @HourStartDate)
		BEGIN
			UPDATE 	IdxSIDBSubStoreStateHistory
			SET	fallBackSubStoreId	= T.fallBackSubStoreId,
				OfflineEntity		= T.OfflineEntity,
				OfflineReason		= T.OfflineReason,
				Status				= T.SubStoreStatus,
				Time				= dbo.getUnixTime(GetUTCDate())
			FROM @tblSubStore T
			WHERE 	    IdxSIDBSubStoreStateHistory.SIDBStoreId 	= T.SIDBStoreId
				and IdxSIDBSubStoreStateHistory.SubStoreId	= T.SubStoreId
				and IdxSIDBSubStoreStateHistory.CommCellId 	= T.CommCellId

			DELETE @tblSubStore
			FROM @tblSubStore T, IdxSIDBSubStoreStateHistory IDX
			WHERE IDX.SIDBStoreId 	= T.SIDBStoreId
				and IDX.SubStoreId 	= T.SubStoreId
				and IDX.CommCellId  = T.CommCellId
				and Time	 		> @HourStartDate
		END


		INSERT INTO IdxSIDBSubStoreStateHistory
		SELECT	T.SIDBStoreId,
			T.SubStoreId, 0,
			T.CommCellId, T.fallBackSubStoreId,
			T.SubStoreStatus, dbo.getUnixTime(GetUTCDate()), T.OfflineEntity, T.OfflineReason, 0, 0
		FROM @tblSubStore T

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBSubStoreStateHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBSubStoreStateHistoryTrigger' AND revision = '1.2')

  insert into GXDBVersions values(6, 'IdxSIDBSubStoreStateHistoryTrigger',  '1.2', 'IdxSIDBSubStoreStateHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBUsageHistoryAftInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBUsageHistoryAftInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBUsageHistoryAftInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBUsageHistoryAftInsTrigger]
  delete from GXDBVersions where name = 'IdxSIDBUsageHistoryAftInsTrigger' and type = 6
END
GO

	CREATE TRIGGER	IdxSIDBUsageHistoryAftInsTrigger
	ON 		IdxSIDBUsageHistory
	AFTER INSERT
	AS
	BEGIN
		DECLARE @CurrentUTCDate	datetime
		DECLARE @DiffSeconds	int
		DECLARE @SIDBStoreId	int
		DECLARE @SubStoreId		int
		DECLARE @CommCellId		int
		DECLARE @DayStart		datetime
		DECLARE @DayStartInt	int
		DECLARE @PrimaryEntries		bigint
		DECLARE @SecondaryEntries   bigint
		DECLARE @AvgQITime		bigint
		DECLARE @AvgQITimeSampleCount	int
		DECLARE @NumOfConnections	int
		DECLARE @ZeroRefCount	int
		DECLARE @ReserveField1	int
		DECLARE @ReserveField2	bigint
		DECLARE @ReserveField3	bigint
		DECLARE @ReserveFieldStr	int
		DECLARE @DataSizeToPrune	bigint
		DECLARE @SizeOccupied		bigint
		DECLARE @DDBManagedSize		bigint
		DECLARE @DeleteChunkCount	int
		SET NOCOUNT ON
		SELECT @SIDBStoreId = SIDBStoreId,
		       @SubStoreId = SubStoreId,
		       @CommCellId = CommCellId,
		       @DayStartInt = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(dbo.GetDayStart(dbo.UTCToClientLocalTime(dbo.GetDateTime(ModifiedTime), 2), 0), 2)),
		       @PrimaryEntries = PrimaryEntries,
		       @SecondaryEntries = SecondaryEntries,
		       @AvgQITime 	= AvgQITime,
		       @AvgQITimeSampleCount	= AvgQITimeSampleCount,
		       @NumOfConnections	= NumOfConnections,
		       @ZeroRefCount	= ZeroRefCount,
		       @ReserveField1	= ReserveField1,
		       @ReserveField2	= ReserveField2,
		       @ReserveField3	= ReserveField3,
		       @ReserveFieldStr	= ReserveFieldStr,
		       @DataSizeToPrune	= DataSizeToPrune,
		       @SizeOccupied	= SizeOccupied,
		       @DDBManagedSize	= DDBManagedSize,
		       @DeleteChunkCount	= DeleteChunkCount
		FROM Inserted I
		WHERE HistoryType = 0
	 	IF ISNULL(@SIDBStoreId, 0) > 0
		BEGIN
			SELECT	TOP 1 @SizeOccupied = DiskUsageMB
			FROM	IdxSIDBSubStore SIDB WITH (NOLOCK), IdxCache IC WITH (NOLOCK)
			WHERE	SIDB.SIDBStoreId = @SIDBStoreId
					AND SIDB.SubStoreId = @SubStoreId
					AND SIDB.IdxCacheId = IC.IdxCacheId
			SELECT	@DeleteChunkCount = COUNT(*)
			FROM	MMDeletedAF  WITH (NOLOCK)
			WHERE	SIDBStoreId = @SIDBStoreId
			SELECT	@DDBManagedSize = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)), 0)
			FROM	MMVolume WITH (NOLOCK)
			WHERE	SIDBStoreId = @SIDBStoreId
			UPDATE	IdxSIDBUsageHistory
			SET		SizeOccupied	= @SizeOccupied,
					DeleteChunkCount	= @DeleteChunkCount,
					DDBManagedSize	= @DDBManagedSize
			FROM	Inserted I
			WHERE	IdxSIDBUsageHistory.SIDBStoreId 		= I.SIDBStoreId
					AND IdxSIDBUsageHistory.SubStoreId		= I.SubStoreId
					AND IdxSIDBUsageHistory.CommCellId		= I.CommCellId
					AND IdxSIDBUsageHistory.HistoryType 	= 0
					AND IdxSIDBUsageHistory.ModifiedTime	= I.ModifiedTime
			IF NOT EXISTS
				(SELECT *
	 		 	FROM IdxSIDBUsageHistory DH
			 	WHERE DH.SIDBStoreId 		= @SIDBStoreId
					and DH.SubStoreId		= @SubStoreId
					and DH.CommCellId		= @CommCellId
					and DH.HistoryType 		= 1
					and DH.ModifiedTime	    = @DayStartInt)
			BEGIN
			INSERT INTO IdxSIDBUsageHistory
			SELECT	@SIDBStoreId, @SubStoreId, @CommCellId,
				1, @DayStartInt,
				@PrimaryEntries, @SecondaryEntries, @AvgQITime, @AvgQITimeSampleCount,
				@NumOfConnections, @ZeroRefCount,
				@ReserveField1, @ReserveField2, @ReserveField3, @ReserveFieldStr,
				@DataSizeToPrune, @SizeOccupied, @DDBManagedSize, @DeleteChunkCount
		END
		ELSE
		BEGIN
			UPDATE IdxSIDBUsageHistory
			SET AvgQITime = @AvgQITime,
			AvgQITimeSampleCount = @AvgQITimeSampleCount
			WHERE SIDBStoreId = @SIDBStoreId
			AND SubStoreId = @SubStoreId
			AND CommCellId = @CommCellId
			AND HistoryType = 1
			AND ModifiedTime = @DayStartInt -- Update valid recorded with begin time of that day.
			AND AvgQITime = 0 -- Only update for AvgQITime = 0 row. If we have value then leave as is.
			AND @AvgQITime > 0 -- Only update it with a valid value. If zero then leave as is.
		END
		END /*IF ISNULL(@SIDBStoreId, 0) > 0*/
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBUsageHistoryAftInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBUsageHistoryAftInsTrigger' AND revision = '1.7')

  insert into GXDBVersions values(6, 'IdxSIDBUsageHistoryAftInsTrigger',  '1.7', 'IdxSIDBUsageHistoryAftInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientInstallHistoryInsert.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientInstallHistoryInsert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientInstallHistoryInsert]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientInstallHistoryInsert]
  delete from GXDBVersions where name = 'APP_ClientInstallHistoryInsert' and type = 6
END
GO

CREATE TRIGGER APP_ClientInstallHistoryInsert
ON APP_Client
AFTER INSERT
AS
BEGIN
insert into APP_ClientInstallHistory (clientId, installTime, uninstallTime)
select id, dbo.GetUnixTime(GetUTCDate()), 0 from INSERTED
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientInstallHistoryInsert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientInstallHistoryInsert' AND revision = '1.7')

  insert into GXDBVersions values(6, 'APP_ClientInstallHistoryInsert',  '1.7', 'APP_ClientInstallHistoryInsert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientInstallHistoryDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientInstallHistoryDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientInstallHistoryDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientInstallHistoryDelete]
  delete from GXDBVersions where name = 'APP_ClientInstallHistoryDelete' and type = 6
END
GO

	CREATE TRIGGER APP_ClientInstallHistoryDelete
 	ON APP_Client
	FOR delete
	AS
	BEGIN
	declare @clientId as integer
	select @clientId = id from deleted
	update APP_ClientInstallHistory
	set uninstallTime = dbo.GetUnixTime(GetUTCDate())
	where clientId = @clientId and uninstallTime = 0
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientInstallHistoryDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientInstallHistoryDelete' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_ClientInstallHistoryDelete',  '1.3', 'APP_ClientInstallHistoryDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_EntityDetailAfterInsUpdDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_EntityDetailAfterInsUpdDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_EntityDetailAfterInsUpdDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_EntityDetailAfterInsUpdDel]
  delete from GXDBVersions where name = 'App_EntityDetailAfterInsUpdDel' and type = 6
END
GO

	CREATE TRIGGER App_EntityDetailAfterInsUpdDel
 	ON App_EntityDetails
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
	DECLARE @insertCount INT = (SELECT COUNT(*) FROM INSERTED)
		DECLARE @entityType INT
		IF (@insertCount > 0)
		BEGIN
			SET @entityType = isnull((SELECT TOP 1 entityType FROM inserted),0)

		END

		DECLARE @deleteCount INT = (SELECT COUNT(*) FROM DELETED)

		IF (@deleteCount > 0)
		BEGIN
			SET @entityType = isnull((SELECT TOP 1 entityType FROM deleted)	,0)
		END

		EXEC AppGenEntityExtendedProp @i_entity = @entityType
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_EntityDetailAfterInsUpdDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_EntityDetailAfterInsUpdDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'App_EntityDetailAfterInsUpdDel',  '1.1', 'App_EntityDetailAfterInsUpdDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_EntityExtendedPropAfterInsUpdDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_EntityExtendedPropAfterInsUpdDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_EntityExtendedPropAfterInsUpdDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_EntityExtendedPropAfterInsUpdDel]
  delete from GXDBVersions where name = 'App_EntityExtendedPropAfterInsUpdDel' and type = 6
END
GO

	CREATE TRIGGER App_EntityExtendedPropAfterInsUpdDel
 	ON App_EntityExtendedprop
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
	DECLARE @insertCount INT = (SELECT COUNT(*) FROM INSERTED)
		DECLARE @entityType INT
		IF (@insertCount > 0)
		BEGIN
			SET @entityType = isnull((SELECT TOP 1 entityType FROM inserted),0)

		END

		DECLARE @deleteCount INT = (SELECT COUNT(*) FROM DELETED)

		IF (@deleteCount > 0)
		BEGIN
			SET @entityType = isnull((SELECT TOP 1 entityType FROM deleted)	,0)
		END

		EXEC AppGenEntityExtendedProp @i_entity = @entityType
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_EntityExtendedPropAfterInsUpdDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_EntityExtendedPropAfterInsUpdDel' AND revision = '1.1')

  insert into GXDBVersions values(6, 'App_EntityExtendedPropAfterInsUpdDel',  '1.1', 'App_EntityExtendedPropAfterInsUpdDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_WorkQueueClientGroupChanged.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_WorkQueueClientGroupChanged'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_WorkQueueClientGroupChanged]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_WorkQueueClientGroupChanged]
  delete from GXDBVersions where name = 'App_WorkQueueClientGroupChanged' and type = 6
END
GO

	CREATE TRIGGER App_WorkQueueClientGroupChanged
 	ON APP_ClientGroupAssoc
	AFTER INSERT,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @insertCount INT = (SELECT COUNT(*) FROM INSERTED)
		DECLARE @deleteCount INT = (SELECT COUNT(*) FROM DELETED)
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @pushFWClientList TABLE (clientId INT)
		DECLARE @ClientTable TABLE (clientId INT)

		IF @insertCount > 0
		BEGIN
			INSERT INTO @ClientTable
			SELECT clientId FROM INSERTED

			-- check if any VM in request then submit request to all Physical nodes
			IF EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientId FROM @ClientTable WHERE clientId <> 2))
			BEGIN
				INSERT INTO @ClientTable
				SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
				WHERE VMClientId IN (SELECT clientId FROM @ClientTable WHERE clientId <> 2)

				DELETE @ClientTable WHERE clientId IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
			END

			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT clientId, 1, '', @currentTime, 0, 0, 0, -1
				FROM @ClientTable

			DECLARE @insertedCGId INT = (SELECT TOP 1 clientGroupId FROM inserted)

			-- Start workqueue(WORK_TOKEN_DLP_PUSH_CONFIG) to push DLP properties on clients removed from client group.
			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT clientId, 11, '', @currentTime, 0, 0, 0, -1
				FROM @ClientTable

			INSERT INTO @pushFWClientList
			EXEC AppGetFWPushClientList	@insertedCGId

			IF EXISTS (SELECT * FROM @pushFWClientList)
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
					SELECT i.clientId, 5, '', @currentTime, 0, 0, 1, -1
					FROM INSERTED i
			END
		END

		IF @deleteCount > 0
		BEGIN

			INSERT INTO @ClientTable
			SELECT clientId FROM DELETED

			-- check if any VM in request then submit request to all Physical nodes
			IF EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientId FROM @ClientTable WHERE clientId <> 2))
			BEGIN
				INSERT INTO @ClientTable
				SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
				WHERE VMClientId IN (SELECT clientId FROM @ClientTable WHERE clientId <> 2)

				DELETE @ClientTable WHERE clientId IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
			END

			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT clientId, 1, '', @currentTime, 0, 0, 0, -1
				FROM @ClientTable

			-- Start workqueue(WORK_TOKEN_DLP_PUSH_CONFIG) to push DLP properties on clients removed from client group.
			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT clientId, 11, '', @currentTime, 0, 0, 0, -1
				FROM @ClientTable

			IF NOT EXISTS (SELECT * FROM @pushFWClientList)
			BEGIN
				DECLARE @deletedCGId INT = (SELECT TOP 1 clientGroupId FROM deleted)
				INSERT INTO @pushFWClientList
			EXEC AppGetFWPushClientList	@deletedCGId
			END
			IF EXISTS (SELECT * FROM @pushFWClientList)
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT d.clientId, 5, '', @currentTime, 0, 0, 1, -1
				FROM DELETED d
			END
		END
		IF EXISTS (SELECT * FROM @pushFWClientList)
		BEGIN
			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT clientId, 5, '', @currentTime, 0, 0, 1, -1
				FROM @pushFWClientList
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_WorkQueueClientGroupChanged]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_WorkQueueClientGroupChanged' AND revision = '1.15')

  insert into GXDBVersions values(6, 'App_WorkQueueClientGroupChanged',  '1.15', 'App_WorkQueueClientGroupChanged', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSCommCellTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSCommCellTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSCommCellTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSCommCellTableChange]
  delete from GXDBVersions where name = 'APP_CCSCommCellTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSCommCellTableChange
	ON APP_CommCell
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 18		-- APP_CommCell Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSCommCellTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSCommCellTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSCommCellTableChange',  '1.1', 'APP_CCSCommCellTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSClientTableChange
	ON APP_Client
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 1		-- APP_Client Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					i.id, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					i.id, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows

			-- On client delete cannot insert it into the the APP_WorkQueueRequest Table - so not processed

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientTableChange' AND revision = '1.5')

  insert into GXDBVersions values(6, 'APP_CCSClientTableChange',  '1.5', 'APP_CCSClientTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSClientPropTableChange
	ON APP_ClientProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 2		-- APP_ClientProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					i.componentNameId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					i.componentNameId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					d.componentNameId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientPropTableChange' AND revision = '1.5')

  insert into GXDBVersions values(6, 'APP_CCSClientPropTableChange',  '1.5', 'APP_CCSClientPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSApplicationTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSApplicationTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSApplicationTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSApplicationTableChange]
  delete from GXDBVersions where name = 'APP_CCSApplicationTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSApplicationTableChange
	ON APP_Application
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 4		-- APP_Application Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					i.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					i.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					d.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSApplicationTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSApplicationTableChange' AND revision = '1.5')

  insert into GXDBVersions values(6, 'APP_CCSApplicationTableChange',  '1.5', 'APP_CCSApplicationTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSSubClientPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSSubClientPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSSubClientPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSSubClientPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSSubClientPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSSubClientPropTableChange
	ON APP_SubClientProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 5		-- APP_SubClientProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = d.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSSubClientPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSSubClientPropTableChange' AND revision = '1.6')

  insert into GXDBVersions values(6, 'APP_CCSSubClientPropTableChange',  '1.6', 'APP_CCSSubClientPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSPlatformTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSPlatformTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSPlatformTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSPlatformTableChange]
  delete from GXDBVersions where name = 'APP_CCSPlatformTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSPlatformTableChange
	ON APP_Platform
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 3		-- APP_Platform Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
			SELECT
					i.clientId, @TableType, 0, @currentTime, i.clientId, i.platformType
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.platformType = d.platformType
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = i.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					d.clientId IS NULL	-- new rows inserted
			UNION
			SELECT
					i.clientId, @TableType, 1, @currentTime, i.clientId, i.platformType
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.platformType = d.platformType	-- updated rows
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = i.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
			UNION
			SELECT
					d.clientId, @TableType, 2, @currentTime, d.clientId, d.platformType
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON d.clientId = i.clientId
							AND d.platformType = i.platformType
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = d.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					i.clientId IS NULL	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSPlatformTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSPlatformTableChange' AND revision = '1.6')

  insert into GXDBVersions values(6, 'APP_CCSPlatformTableChange',  '1.6', 'APP_CCSPlatformTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSIDANameTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSIDANameTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSIDANameTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSIDANameTableChange]
  delete from GXDBVersions where name = 'APP_CCSIDANameTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSIDANameTableChange
	ON APP_IDAName
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 6		-- APP_IDAName Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					i.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					i.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					d.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSIDANameTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSIDANameTableChange' AND revision = '1.5')

  insert into GXDBVersions values(6, 'APP_CCSIDANameTableChange',  '1.5', 'APP_CCSIDANameTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSIDATypeTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSIDATypeTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSIDATypeTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSIDATypeTableChange]
  delete from GXDBVersions where name = 'APP_CCSIDATypeTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSIDATypeTableChange
	ON APP_IDAType
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 8		-- APP_IDAType Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.type
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = i.type
				WHERE
					i.type NOT IN (SELECT d.type FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.type
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = i.type
				WHERE
					i.type IN (SELECT d.type FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.type
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = d.type
				WHERE
					d.type NOT IN (SELECT i.type FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSIDATypeTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSIDATypeTableChange' AND revision = '1.6')

  insert into GXDBVersions values(6, 'APP_CCSIDATypeTableChange',  '1.6', 'APP_CCSIDATypeTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSIDAPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSIDAPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSIDAPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSIDAPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSIDAPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSIDAPropTableChange
	ON APP_IDAProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 10		-- APP_IDAProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_IDAName a WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_IDAName a  WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_IDAName a  WITH (NOLOCK)
						ON a.id = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSIDAPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSIDAPropTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSIDAPropTableChange',  '1.3', 'APP_CCSIDAPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSBackupSetNameTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSBackupSetNameTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSBackupSetNameTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSBackupSetNameTableChange]
  delete from GXDBVersions where name = 'APP_CCSBackupSetNameTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSBackupSetNameTableChange
	ON APP_BackupSetName
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 11		-- APP_BackupSetName Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.id
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.id
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = d.id
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSBackupSetNameTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSBackupSetNameTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSBackupSetNameTableChange',  '1.3', 'APP_CCSBackupSetNameTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSInstanceNameTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSInstanceNameTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSInstanceNameTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSInstanceNameTableChange]
  delete from GXDBVersions where name = 'APP_CCSInstanceNameTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSInstanceNameTableChange
	ON APP_InstanceName
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 13		-- APP_InstanceName Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.id
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted

			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.id
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = d.id
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSInstanceNameTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSInstanceNameTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSInstanceNameTableChange',  '1.3', 'APP_CCSInstanceNameTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSBackupSetPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSBackupSetPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSBackupSetPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSBackupSetPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSBackupSetPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSBackupSetPropTableChange
	ON APP_BackupSetProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 12		-- APP_BackupSetProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSBackupSetPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSBackupSetPropTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSBackupSetPropTableChange',  '1.3', 'APP_CCSBackupSetPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSInstancePropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSInstancePropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSInstancePropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSInstancePropTableChange]
  delete from GXDBVersions where name = 'APP_CCSInstancePropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSInstancePropTableChange
	ON APP_InstanceProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 14		-- APP_InstanceProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSInstancePropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSInstancePropTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSInstancePropTableChange',  '1.3', 'APP_CCSInstancePropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSBSFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSBSFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSBSFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSBSFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSBSFilterFileTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSBSFilterFileTableChange
	ON APP_BackupSetFilterFile
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 15		-- APP_BackupSetFilterFile Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.componentNameId
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.componentNameId
				WHERE
					i.componentNameId NOT IN (SELECT d.componentNameId FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.componentNameId
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = i.componentNameId
				WHERE
					i.componentNameId IN (SELECT d.componentNameId FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.componentNameId
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.backupSet = d.componentNameId
				WHERE
					d.componentNameId NOT IN (SELECT i.componentNameId FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSBSFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSBSFilterFileTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSBSFilterFileTableChange',  '1.3', 'APP_CCSBSFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSInstFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSInstFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSInstFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSInstFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSInstFilterFileTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSInstFilterFileTableChange
	ON APP_InstFilterFile
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 16		-- APP_InstFilterFile Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.instance = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSInstFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSInstFilterFileTableChange' AND revision = '1.4')

  insert into GXDBVersions values(6, 'APP_CCSInstFilterFileTableChange',  '1.4', 'APP_CCSInstFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSScFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSScFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSScFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSScFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSScFilterFileTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSScFilterFileTableChange
	ON APP_ScFilterFile
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 17		-- APP_ScFilterFile Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSScFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSScFilterFileTableChange' AND revision = '1.3')

  insert into GXDBVersions values(6, 'APP_CCSScFilterFileTableChange',  '1.3', 'APP_CCSScFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSFileTypeAndExtTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSFileTypeAndExtTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSFileTypeAndExtTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSFileTypeAndExtTableChange]
  delete from GXDBVersions where name = 'APP_CCSFileTypeAndExtTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSFileTypeAndExtTableChange
	ON App_FileTypeAndExtensions
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 19		-- App_FileTypeAndExtensions Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			SELECT
					@AllClients, @TableType, 0, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d ON
						i.typeName = d.typeName
						AND i.extension = d.extension
				WHERE
					d.typeName IS NULL					-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN DELETED d ON
						i.typeName = d.typeName
						AND i.extension = d.extension	-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						d.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						d.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					LEFT OUTER JOIN DELETED i ON
						i.typeName = d.typeName
						AND i.extension = d.extension
				WHERE
					i.typeName IS NULL					-- new rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSFileTypeAndExtTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSFileTypeAndExtTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSFileTypeAndExtTableChange',  '1.1', 'APP_CCSFileTypeAndExtTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSGXGlobalParamTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSGXGlobalParamTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSGXGlobalParamTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSGXGlobalParamTableChange]
  delete from GXDBVersions where name = 'APP_CCSGXGlobalParamTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSGXGlobalParamTableChange
	ON GXGlobalParam
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 7		-- GXGlobalParam Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSGXGlobalParamTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSGXGlobalParamTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSGXGlobalParamTableChange',  '1.1', 'APP_CCSGXGlobalParamTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSSchedTimeZoneTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSSchedTimeZoneTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSSchedTimeZoneTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSSchedTimeZoneTableChange]
  delete from GXDBVersions where name = 'APP_CCSSchedTimeZoneTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSSchedTimeZoneTableChange
	ON SchedTimeZone
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 9		-- SchedTimeZone Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.TimeZoneID
				FROM
					INSERTED i
				WHERE
					i.TimeZoneID NOT IN (SELECT d.TimeZoneID FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.TimeZoneID
				FROM
					INSERTED i
				WHERE
					i.TimeZoneID IN (SELECT d.TimeZoneID FROM DELETED d)		-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.TimeZoneID
				FROM
					DELETED d
				WHERE
					d.TimeZoneID NOT IN (SELECT i.TimeZoneID FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSSchedTimeZoneTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSSchedTimeZoneTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSSchedTimeZoneTableChange',  '1.1', 'APP_CCSSchedTimeZoneTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSComponentPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSComponentPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSComponentPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSComponentPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSComponentPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSComponentPropTableChange
	ON APP_ComponentProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 20		-- APP_ComponentProp Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			-- CommCell Type
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
					AND i.componentType = 1	--CommCell
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
					AND i.componentType = 1	--CommCell
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
					AND d.componentType = 1	--CommCell
			-- Client Type
			UNION
			SELECT
					i.componentId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
					AND i.componentType = 3	--Client
			UNION
			SELECT
					i.componentId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
					AND i.componentType = 3	--Client
			UNION
			SELECT
					d.componentId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
					AND d.componentType = 3	--Client
			-- IDA Type
			UNION
			SELECT
					n.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i,
					APP_IDAName n WITH(NOLOCK)
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
					AND i.componentType = 4	--IDA
					AND n.id = i.componentId
			UNION
			SELECT
					n.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i,
					APP_IDAName n WITH(NOLOCK)
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
					AND i.componentType = 4	--IDA
					AND n.id = i.componentId
			UNION
			SELECT
					n.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d,
					APP_IDAName n WITH(NOLOCK)
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
					AND d.componentType = 4	--IDA
					AND n.id = d.componentId
			-- BackupSet Type
			UNION
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i,
					APP_Application a WITH(NOLOCK)
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
					AND i.componentType = 5	--BackupSet
					AND a.backupSet = i.componentId
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i,
					APP_Application a WITH(NOLOCK)
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
					AND i.componentType = 5	--BackupSet
					AND a.backupSet = i.componentId
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d,
					APP_Application a WITH(NOLOCK)
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
					AND d.componentType = 5	--BackupSet
					AND a.backupSet = d.componentId
			-- SubClient Type
			UNION
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i,
					APP_Application a WITH (NOLOCK)
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
					AND i.componentType = 6	--SubClient
					AND a.id = i.componentId
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i,
					APP_Application a WITH (NOLOCK)
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
					AND i.componentType = 6	--SubClient
					AND a.id = i.componentId
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d,
					APP_Application a WITH (NOLOCK)
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
					AND d.componentType = 6	--SubClient
					AND a.id = d.componentId

		-- ComponentTypes Not processed ROOT(0), FASTINDEX_CLOUD(2), EXMB(7), CLIENTGROUP(8), LN_DOC(9)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSComponentPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSComponentPropTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSComponentPropTableChange',  '1.1', 'APP_CCSComponentPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSExtendedPropertiesTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSExtendedPropertiesTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSExtendedPropertiesTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSExtendedPropertiesTableChange]
  delete from GXDBVersions where name = 'APP_CCSExtendedPropertiesTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSExtendedPropertiesTableChange
	ON APP_ExtendedProperties
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 21		-- APP_ExtendedProperties Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			-- All Clients
			SELECT
					CASE
						WHEN i.clientId = 1 THEN @AllClients
						ELSE i.clientId
					END,
					@TableType, 0, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created
				WHERE
					d.clientId IS NULL	-- new rows inserted
			UNION
			SELECT
					CASE
						WHEN i.clientId = 1 THEN @AllClients
						ELSE i.clientId
					END,
					@TableType, 1, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created		-- updated rows
			UNION
			SELECT
					CASE
						WHEN d.clientId = 1 THEN @AllClients
						ELSE d.clientId
					END,
					@TableType, 2, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created
				WHERE
					i.clientId IS NULL	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSExtendedPropertiesTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSExtendedPropertiesTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSExtendedPropertiesTableChange',  '1.1', 'APP_CCSExtendedPropertiesTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSAppTypeGroupTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSAppTypeGroupTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSAppTypeGroupTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSAppTypeGroupTableChange]
  delete from GXDBVersions where name = 'APP_CCSAppTypeGroupTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSAppTypeGroupTableChange
	ON APP_AppTypeGroup
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 23		-- APP_AppTypeGroup Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.typeOfGroup, i.appTypeGroupId
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appTypeGroupId = d.appTypeGroupId
				WHERE
					d.typeOfGroup IS NULL	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.typeOfGroup, i.appTypeGroupId
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appTypeGroupId = d.appTypeGroupId	-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.typeOfGroup, d.appTypeGroupId
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON d.typeOfGroup = i.typeOfGroup
							AND d.appTypeGroupId = i.appTypeGroupId
				WHERE
					i.typeOfGroup IS NULL	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSAppTypeGroupTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSAppTypeGroupTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSAppTypeGroupTableChange',  '1.1', 'APP_CCSAppTypeGroupTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSAppTypeGroupAssocTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSAppTypeGroupAssocTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSAppTypeGroupAssocTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSAppTypeGroupAssocTableChange]
  delete from GXDBVersions where name = 'APP_CCSAppTypeGroupAssocTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSAppTypeGroupAssocTableChange
	ON APP_AppTypeGroupAssoc
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 24		-- APP_AppTypeGroupAssoc Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			SELECT
					@AllClients, @TableType, 0, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appGroupId = d.appGroupId
							AND i.appTypeId = d.appTypeId
				WHERE
					d.typeOfGroup IS NULL	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appGroupId = d.appGroupId	-- updated rows
							AND i.appTypeId = d.appTypeId
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON d.typeOfGroup = i.typeOfGroup
							AND d.appGroupId = i.appGroupId
							AND d.appTypeId = i.appTypeId
				WHERE
					i.typeOfGroup IS NULL	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSAppTypeGroupAssocTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSAppTypeGroupAssocTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSAppTypeGroupAssocTableChange',  '1.1', 'APP_CCSAppTypeGroupAssocTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientGroupAssocTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientGroupAssocTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientGroupAssocTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientGroupAssocTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientGroupAssocTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSClientGroupAssocTableChange
	ON APP_ClientGroupAssoc
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 26		-- APP_ClientGroupAssoc Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
			SELECT
					i.clientId, @TableType, 0, @currentTime, i.clientGroupId, i.clientId
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.clientGroupId = d.clientGroupId
				WHERE
					d.clientId IS NULL	-- new rows inserted
			UNION
			SELECT
					i.clientId, @TableType, 1, @currentTime, i.clientGroupId, i.clientId
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.clientGroupId = d.clientGroupId	-- updated rows
			UNION
			SELECT
					d.clientId, @TableType, 2, @currentTime, d.clientGroupId, d.clientId
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON d.clientId = i.clientId
							AND d.clientGroupId = i.clientGroupId
				WHERE
					i.clientId IS NULL	-- existing rows deleted


	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientGroupAssocTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientGroupAssocTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSClientGroupAssocTableChange',  '1.1', 'APP_CCSClientGroupAssocTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF



--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSJobErrorDecisionRuleTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSJobErrorDecisionRuleTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSJobErrorDecisionRuleTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSJobErrorDecisionRuleTableChange]
  delete from GXDBVersions where name = 'APP_CCSJobErrorDecisionRuleTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSJobErrorDecisionRuleTableChange
	ON APP_JobErrorDecisionRule
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 25		-- APP_JobErrorDecisionRule Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSJobErrorDecisionRuleTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSJobErrorDecisionRuleTableChange' AND revision = '1.1')

  insert into GXDBVersions values(6, 'APP_CCSJobErrorDecisionRuleTableChange',  '1.1', 'APP_CCSJobErrorDecisionRuleTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

