

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/TM_TaskDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: TM_TaskDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TM_TaskDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[TM_TaskDelTrigger]
  delete from GXDBVersions where name = 'TM_TaskDelTrigger' and type = 6
END
GO

	CREATE TRIGGER TM_TaskDelTrigger
	ON TM_Task
	FOR DELETE AS
	BEGIN
     SET NOCOUNT ON
		DECLARE @systemSchedulePoliciesBlockDelete BIGINT = -1
		SELECT @systemSchedulePoliciesBlockDelete = CAST(value AS BIGINT) FROM GXGlobalParam WITH (NOLOCK) WHERE name='systemSchedulePoliciesBlockDelete' AND modified=0
		IF EXISTS(SELECT 1 FROM DELETED WHERE taskType IN (2, 4) AND flags > 0 AND flags & @systemSchedulePoliciesBlockDelete = flags)
		BEGIN
			RAISERROR('Deleting System schedule policies is not allowed!', 16, 1)
			ROLLBACK
			RETURN
		END
		INSERT INTO TM_TaskHistory (taskId, taskName, taskType, flags, status, ownerId, initiatedFrom, deleted)
		SELECT T.taskId, T.taskName, T.taskType, T.flags, T.status, T.ownerId, T.initiatedFrom, T.deleted
		FROM DELETED T
		WHERE T.taskType IN (2, 4)	--TASK_TYPE_SCHEDULE,TASK_TYPE_SCHEDULE_POLICY
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [TM_TaskDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'TM_TaskDelTrigger' AND revision = '1.1.2.3')

  insert into GXDBVersions values(6, 'TM_TaskDelTrigger',  '1.1.2.3', 'TM_TaskDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

