

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMVolume_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMVolume_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMVolume_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMVolume_AfterIns]
  delete from GXDBVersions where name = 'SMVolume_AfterIns' and type = 6
END
GO

	CREATE TRIGGER SMVolume_AfterIns
 	ON SMVolume
	AFTER INSERT
	AS
	BEGIN
			IF EXISTS (
			SELECT	A.SMVolumeId, A.CommCellId, A.CopyId
			FROM	INSERTED A, SMVolume B WITH (NOLOCK)
			WHERE	A.RecoveryPointId > 0 AND A.RecoveryPointId = B.RecoveryPointId AND A.VolumeFlags & 8192 = 8192 /* CVSM_VOLUMEFLAGS_SCG_VOLUMES */ AND
					A.SMVolumeId <> B.SMVolumeId AND A.CommCellId = B.CommCellId AND A.CopyId <> B.CopyId)
			BEGIN
				RAISERROR('Two different copies are used. Same copy should be used for shared snaps', 16, 1)
				ROLLBACK TRANSACTION
			END
	END
	BEGIN
			IF EXISTS (
			SELECT	A.ArchFileId, A.CommCellId, A.CopyId
			FROM	INSERTED A, ArchFileCopy B WITH (NOLOCK)
			WHERE	A.RecoveryPointId > 0 AND A.VolumeFlags & 8192 = 8192 /* CVSM_VOLUMEFLAGS_SCG_VOLUMES */ AND A.ArchFileId = B.ArchFileId AND A.CommCellId = B.CommCellId AND A.CopyId <> B.ArchCopyId )
			BEGIN
				RAISERROR('Two different copies are used. Same copy should be used for shared snaps', 16, 1)
				ROLLBACK TRANSACTION
			END
	END
	BEGIN
		IF NOT EXISTS (
		SELECT A.ArchFileId, A.CommCellId, A.CopyId
		FROM INSERTED A, ArchFileCopy B WITH (NOLOCK)
		WHERE A.ArchFileId = B.ArchFileId AND A.CommCellId = B.CommCellId AND A.CopyId = B.ArchCopyId OR ( A.JobId = A.MasterJobId AND VolumeFlags & cast(4294967296 as bigint)/*CVSM_VOLUMEFLAGS_VSA_V2_SNAP_DB */ > 0 ))
		BEGIN
			RAISERROR('Invalid archive file inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	BEGIN
		IF NOT EXISTS (
		SELECT A.SourceClientId
		FROM INSERTED A, APP_Client B WITH (NOLOCK)
		WHERE A.SourceClientId = B.id AND A.SourceClientId > 0 )
		BEGIN
			RAISERROR('Invalid SourceClientId inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END
	BEGIN
		IF NOT EXISTS (
		SELECT A.AppId
		FROM INSERTED A, APP_Application B WITH (NOLOCK)
		WHERE A.AppId = B.id AND A.AppId > 0 )
		BEGIN
			RAISERROR('Invalid AppId inserted', 16, 1)
			ROLLBACK TRANSACTION
		END
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMVolume_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMVolume_AfterIns' AND revision = '1.4.198.1')

  insert into GXDBVersions values(6, 'SMVolume_AfterIns',  '1.4.198.1', 'SMVolume_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

