

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/SMMetaData_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: SMMetaData_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMMetaData_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[SMMetaData_AfterUpd]
  delete from GXDBVersions where name = 'SMMetaData_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER SMMetaData_AfterUpd
 	ON SMMetaData
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @Seperator			varchar(1)
		SET @Seperator = '|'
		DECLARE @Idx				integer
		DECLARE @VolumePath			nvarchar(max)
		DECLARE	@RefId				integer
		DECLARE	@RefType			integer
		DECLARE	@MetaDataType		integer
		DECLARE @MetaData			nvarchar(max)
		DECLARE @SnapShoEngineId	integer = 0


		IF UPDATE (MetaData)
		BEGIN
			SELECT	@RefId = RefId, @RefType = RefType,
					@MetaDataType = MetaDataType, @MetaData = CONVERT(NVARCHAR(max), MetaData),
					@SnapShoEngineId = SNAP.SnapShotEngineId
			FROM	INSERTED INNER JOIN SMSnap (NOLOCK) SNAP ON SNAP.SMSnapId = RefId

			IF @RefType <> 2		-- SM_MRT_SNAP
				OR @MetaDataType <> 6	-- SM_MDT_SNAP_UUID
				OR @SnapShoEngineId <> 3  -- SM_SNAPSHOT_ENGINE_NETAPP
				RETURN

			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData)
			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData, (@Idx + 1))
			SET @Idx = CHARINDEX(CONVERT(VARCHAR, @Seperator), @MetaData, (@Idx + 1))
			SET @Idx = @Idx + 1
			SET @VolumePath = SUBSTRING(@MetaData, @Idx, (LEN(@MetaData) - @Idx + 1))

			UPDATE	SMSnap
			SET		ReserveFieldStr = @VolumePath
			WHERE	SMSnapId = @RefId
					AND SnapShotEngineId = 3	-- SM_SNAPSHOT_ENGINE_NETAPP
		END
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [SMMetaData_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'SMMetaData_AfterUpd' AND revision = '1.4')

  insert into GXDBVersions values(6, 'SMMetaData_AfterUpd',  '1.4', 'SMMetaData_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

