

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/PatchinfoAfterDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: PatchinfoAfterDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PatchinfoAfterDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[PatchinfoAfterDelete]
  delete from GXDBVersions where name = 'PatchinfoAfterDelete' and type = 6
END
GO

	CREATE TRIGGER PatchinfoAfterDelete ON patchinfo
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @releaseID integer
		DECLARE @osID	   integer
		DECLARE @clientID	   integer
		SET @clientID = (select TOP 1 clientID from Deleted)
		SET @releaseID = (SELECT releaseID from app_client where id = @clientID)
		SET @osID = (SELECT simOperatingSystemid from app_client where id = @clientID)
		IF(@releaseID < 14)
		BEGIN
			DECLARE @rowCount integer
			SET @rowCount = (select count(*) from deleted)
			IF(@rowCount = 1)
			BEGIN
				DELETE simInstalledPackages where id in
				(select SIP.id from simInstalledPackages SIP, Deleted D where SIP.clientid = D.clientID AND SIP.simpackageID in ((dbo.GetPackageID(D.AppTypeId, @osID))))
			END
			ELSE
			BEGIN
				DELETE simInstalledPackages WHERE ID in
				(select SIP.id from simInstalledPackages SIP, Deleted D where SIP.clientid = @clientID)
			END
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [PatchinfoAfterDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'PatchinfoAfterDelete' AND revision = '1.2')

  insert into GXDBVersions values(6, 'PatchinfoAfterDelete',  '1.2', 'PatchinfoAfterDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

