

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/PatchinfoAfterAdd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: PatchinfoAfterAdd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PatchinfoAfterAdd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[PatchinfoAfterAdd]
  delete from GXDBVersions where name = 'PatchinfoAfterAdd' and type = 6
END
GO

	CREATE TRIGGER PatchinfoAfterAdd ON patchinfo
	INSTEAD OF INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE @releaseID integer
		DECLARE @osID	   integer
		DECLARE @clientID  integer
		DECLARE @packageID integer
		DECLARE @apptypeID integer
		SET @clientID = (select TOP 1 clientID from Inserted)
		SET @releaseID = (SELECT releaseID from app_client where id = @clientID)
		SET @osID = (SELECT simOperatingSystemid from app_client where id = @clientID)
		SET @apptypeID = (select TOP 1 AppTypeId from Inserted)
		SET @packageID = (SELECT dbo.GetPackageID(@apptypeID, @osID))
		IF(@releaseID < 14 AND @packageID > 0)
		BEGIN
			DELETE simInstalledPackages WHERE clientid = @clientID AND simpackageID = @packageID
			INSERT INTO simInstalledPackages
				SELECT @clientID, @packageID,
				GETUTCDATE(), 'Install', 0, I.HighestSP, I.AdditionalPatches,
				I.MissingPatches, I.Node, I.IsActive, I.SpMinorVersion, I.StatusFlag,
				I.BaselineDeltaSP, I.BaselineDeltaUpdate
			FROM Inserted AS I
		END
		INSERT INTO patchinfo
		SELECT I.clientId, I.ReleaseId, I.ApptypeId, I.BuildIdString, I.HighestSP,
			I.AdditionalPatches, I.MissingPatches, I.Node, I.IsActive, I.SpMinorVersion,
			I.StatusFlag, I.BaselineDeltaSP, I.BaselineDeltaUpdate
		FROM Inserted I
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [PatchinfoAfterAdd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'PatchinfoAfterAdd' AND revision = '1.3')

  insert into GXDBVersions values(6, 'PatchinfoAfterAdd',  '1.3', 'PatchinfoAfterAdd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

