

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMMountPath_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMMountPath_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMMountPath_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMMountPath_AfterUpd]
  delete from GXDBVersions where name = 'MMMountPath_AfterUpd' and type = 6
END
GO

 CREATE TRIGGER MMMountPath_AfterUpd
 	ON MMMountPath
 AFTER UPDATE
 AS
 BEGIN
 IF @@ROWCOUNT = 0 RETURN

 SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()

 --  MM MountPath State History

 IF UPDATE(IsEnabled) OR UPDATE(IsOffline)
 BEGIN

 		INSERT INTO MMMountPathStateHistory
 		SELECT MS.MediaID, 0, I.MountPathId,
 		State = (I.IsEnabled & ~I.IsOffline),
 		@CurrentUTCDate,
 		I.OfflineReason
 		FROM Inserted I, MMMediaSide MS
 		WHERE	I.MediaSideID = MS.MediaSideId
 END
 IF UPDATE(MaxConcurrentWriters) AND (SELECT TRIGGER_NESTLEVEL( OBJECT_ID('MMMountPath_AfterUpd') ) ) <= 1
 BEGIN
 		UPDATE  MP
 		SET MaxConcurrentWriters = 0
 		FROM MMMountPath MP, Deleted D
 		WHERE	MP.MountPathId = D.MountPathId AND D.Attribute & 4096 = 4096
 END
		IF UPDATE(Attribute)
		BEGIN
			IF EXISTS (SELECT 1 FROM MMLibrary L WITH (READUNCOMMITTED), Inserted I WHERE L.LibraryId = I.LibraryId
			AND ((L.ExtendedAttributes & 536870912) > 0)) --MMS2_LIBRARY_EXT_IMMUTABLE_STORAGE
			BEGIN
				IF EXISTS (SELECT 1 FROM Inserted WHERE MountPathTypeId = 7)
				BEGIN
					UPDATE MMMountPath
					SET     Attribute = (MMMountPath.Attribute & ~(32)) --MNTPTH_ATTRIB_ENABLE_CLOUD_PRUNING
					FROM Deleted D
					WHERE   MMMountPath.MountPathId = D.MountPathId
				END
				ELSE IF EXISTS (SELECT 1 FROM Inserted WHERE MountPathTypeId = 4)
				BEGIN
					UPDATE MMMountPath
					SET	Attribute = (MMMountPath.Attribute | 32768)	-- MNTPTH_ATTRIB_DISABLE_DISK_MICRO_PRUNING
					FROM Deleted D
					WHERE MMMountPath.MountPathId = D.MountPathId
				END
			END
		END
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMMountPath_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMMountPath_AfterUpd' AND revision = '1.3.294.5')

  insert into GXDBVersions values(6, 'MMMountPath_AfterUpd',  '1.3.294.5', 'MMMountPath_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

