

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMErrorTracker_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMErrorTracker_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMErrorTracker_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMErrorTracker_AfterIns]
  delete from GXDBVersions where name = 'MMErrorTracker_AfterIns' and type = 6
END
GO

 CREATE TRIGGER MMErrorTracker_AfterIns
 	ON MMErrorTracker
 AFTER INSERT
 AS
 BEGIN

 SET NOCOUNT ON

 DECLARE @lt_DrivesToTakeOffline TABLE (DriveId INTEGER, MediaId INTEGER,
 									ErrorCode Integer, ErrorTrackerid Integer)

 INSERT INTO @lt_DrivesToTakeOffline
 SELECT I.DriveId, I.MediaId, I.ErrorCode, I.ErrorTrackerId
 FROM Inserted I INNER JOIN MMSCSIErrorsToTrack MS ON MS.MMErrorCode = I.ErrorCode AND
 				MS.MarkDriveDisabled = 1
 WHERE I.DriveId > 0 AND I.ErrorCode > 0

 IF (@@ROWCOUNT > 0)
 BEGIN

 	DECLARE @MM_MARKED_DRIVE_BAD	integer
 	set @MM_MARKED_DRIVE_BAD	=	1

 	DECLARE @actionTaken integer
 	SET @actionTaken =	0

 	DECLARE @CurrentUTCDate integer
 	SET @CurrentUTCDate = datediff(second, '01/01/1970', getdate())

 	UPDATE MMDrive
		SET DriveEnabled = 0, OfflineTimeStamp = @CurrentUTCDate, OfflineReason = 15
 	FROM @lt_DrivesToTakeOffline  tt
 	WHERE MMDrive.DriveId = tt.DriveId
 	-- Should we insert into drive state history?

 	SET @actionTaken =	@MM_MARKED_DRIVE_BAD


 	INSERT INTO MMErrorAction
 	SELECT DriveId, MediaId, ErrorCode, @CurrentUTCDate, ErrorTrackerId, @actionTaken
 	FROM @lt_DrivesToTakeOffline

 END


 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMErrorTracker_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMErrorTracker_AfterIns' AND revision = '1.1')

  insert into GXDBVersions values(6, 'MMErrorTracker_AfterIns',  '1.1', 'MMErrorTracker_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

